import * as gcp from '@cdktf/provider-google';
import { Construct } from 'constructs';
import { DockerVolumes } from './gitlab-runner-interfaces';
export interface GitlabRunnerAutoscalingProps {
    /**
     * Google Cloud Provider.
    */
    readonly provider: gcp.provider.GoogleProvider;
    /**
     * Gitlab token.
     *
     * @example
     * new GitlabRunnerAutoscaling(stack, 'runner', { gitlabToken: 'GITLAB_TOKEN' });
     */
    readonly gitlabToken: string;
    /**
     * Runner default EC2 instance type.
     *
     * @example
     * new GitlabRunnerAutoscaling(stack, 'runner', { gitlabToken: 'GITLAB_TOKEN', instanceType: 't3.small' });
     *
     * @default -
     *
     */
    readonly machineType?: string;
    /**
     * VPC for the Gitlab Runner .
     *
     * @example
     * const computeNetwork = new gcp.ComputeNetwork(this, 'Network', {
     *   name: 'cdktf-gitlabrunner-network',
     * });
     *
     * new GitlabRunnerAutoscaling(stack, 'runner', { gitlabToken: 'GITLAB_TOKEN', computeNetwork: computeNetwork });
     *
     * @default - A new VPC will be created.
     *
     */
    readonly computeNetwork?: gcp.dataGoogleComputeNetwork.DataGoogleComputeNetwork;
    /**
     * Desired capacity limit for autoscaling group.
     *
     * @example
     * new GitlabRunnerAutoscaling(stack, 'runner', { gitlabToken: 'GITLAB_TOKEN', desiredCapacity: 2 });
     *
     * @default - minCapacity, and leave unchanged during deployment
     *
     */
    readonly desiredCapacity?: number;
    /**
     * tags for the runner
     *
     * @default - ['runner', 'gitlab', 'awscdk']
     */
    readonly tags?: string[];
    /**
     * Gitlab Runner register url .
     *
     * @example
     * const runner = new GitlabRunnerAutoscaling(stack, 'runner', { gitlabToken: 'GITLAB_TOKEN',gitlabUrl: 'https://gitlab.com/'});
     *
     * @default - https://gitlab.com/ , The trailing slash is mandatory.
     *
     */
    readonly gitlabUrl?: string;
    /**
     * add another Gitlab Container Runner Docker Volumes Path at job runner runtime.
     *
     * more detail see https://docs.gitlab.com/runner/configuration/advanced-configuration.html#the-runnersdocker-section
     *
     * @default - already mount "/var/run/docker.sock:/var/run/docker.sock"
     *
     * @example
     * dockerVolumes: [
     *   {
     *     hostPath: '/tmp/cache',
     *     containerPath: '/tmp/cache',
     *   },
     * ],
     */
    readonly dockerVolumes?: DockerVolumes[];
    /**
     * Gitlab Runner instance Disk size.
     *
     * @default - 60 GB.
    */
    readonly defaultDiskSizeGb?: number;
    /**
     * The Service Account to be used by the Gitlab Runner.
     */
    readonly serviceAccount?: gcp.computeInstanceTemplate.ComputeInstanceTemplateServiceAccount;
    /**
     * Firewall rules for the Gitlab Runner.
     */
    readonly networkTags?: string[];
    /**
     * If true, create preemptible VM instances intended to reduce cost.
     * Note, the MIG will recreate pre-empted instnaces.
     * See https://cloud.google.com/compute/docs/instances/preemptible
     *
     * @deafult - true
     */
    readonly preemptible?: boolean;
    /**
     *
     * If true, automatically restart instances on maintenance events.
     * See https://cloud.google.com/compute/docs/instances/live-migration#autorestart
     *
     * @default - false
     */
    readonly automaticRestart?: boolean;
    /**
     * gitlab runner run task concurrent at the same time.
     *
     * @default - 1
     */
    readonly concurrent?: number;
    /**
     * The source URL used to install the gitlab-runner onto the VM host os.
     * Passed to curl via cloud-config runcmd.
     *
     * @default - "https://gitlab-runner-downloads.s3.amazonaws.com/latest/binaries/gitlab-runner-linux-amd64"
     */
    readonly downloadGitlabRunnerBinaryUrl?: string;
}
export declare class GitlabRunnerAutoscaling extends Construct {
    constructor(scope: Construct, id: string, props: GitlabRunnerAutoscalingProps);
    private dockerVolumesList;
    /**
     * @param props
     * @returns Array.
     */
    createMetadataStartupScript(props: GitlabRunnerAutoscalingProps): string[];
    private createShutdwonScript;
}
