"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitlabRunnerAutoscaling = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const gcp = require("@cdktf/provider-google");
const cdktf = require("cdktf");
const constructs_1 = require("constructs");
class GitlabRunnerAutoscaling extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const defaultProps = {
            desiredCapacity: 1,
            machineType: 'e2-medium',
            tags: ['gitlab', 'cdktf', 'runner'],
            gitlabUrl: 'https://gitlab.com/',
            gitlabRunnerImage: 'public.ecr.aws/gitlab/gitlab-runner:alpine',
            preemptible: true,
            automaticRestart: false,
            concurrent: 1,
            downloadGitlabRunnerBinaryUrl: 'https://gitlab-runner-downloads.s3.amazonaws.com/latest/binaries/gitlab-runner-linux-amd64',
        };
        const runnerProps = { ...defaultProps, ...props };
        const network = runnerProps?.computeNetwork ?? new gcp.computeNetwork.ComputeNetwork(this, 'Network', {
            name: 'cdktf-gitlabrunner-network',
        });
        const serviceAccount = new gcp.serviceAccount.ServiceAccount(this, 'ServiceAccount', {
            accountId: 'gitlab-runner-sa',
            displayName: 'Gitlab Runner Servuce Account',
        });
        new gcp.computeFirewall.ComputeFirewall(this, 'GitlabRunnerFirewallRule', {
            priority: 900,
            name: 'allow-ingress-from-iap',
            sourceRanges: ['35.235.240.0/20'],
            network: network.id,
            allow: [{
                    protocol: 'tcp',
                    ports: ['22'],
                }],
            targetTags: ['runner-iap'],
            dependsOn: [network],
        });
        new gcp.projectIamBinding.ProjectIamBinding(this, 'ComputeIamBinding', {
            provider: runnerProps.provider,
            role: 'roles/compute.admin',
            members: [`serviceAccount:${serviceAccount.email}`],
            project: `${runnerProps.provider.project}`,
        });
        const networkTags = ['runner-iap'];
        if (runnerProps.networkTags) {
            networkTags.push(...runnerProps.networkTags);
        }
        const compute_template = new gcp.computeInstanceTemplate.ComputeInstanceTemplate(this, 'cdktf-gitlabrunner-instance-template', {
            machineType: runnerProps.machineType,
            disk: [
                {
                    autoDelete: true,
                    boot: true,
                    diskSizeGb: props.defaultDiskSizeGb ?? 60,
                    sourceImage: 'cos-cloud/cos-stable',
                },
            ],
            serviceAccount: runnerProps.serviceAccount ? runnerProps.serviceAccount : { email: serviceAccount.email, scopes: ['cloud-platform'] },
            canIpForward: true,
            description: 'cdktf-gitlabrunner-instance-template',
            name: 'cdktf-gitlabrunner-instance-template',
            metadata: {
                'user-data': this.createMetadataStartupScript(runnerProps).join('\n'),
                'shutdown-script': this.createShutdwonScript().join('\n'),
            },
            provider: runnerProps.provider,
            networkInterface: [
                {
                    network: network.id,
                    accessConfig: [{}],
                },
            ],
            tags: networkTags,
            lifecycle: {
                createBeforeDestroy: true,
            },
            scheduling: {
                preemptible: runnerProps.preemptible,
                automaticRestart: runnerProps.automaticRestart,
            },
        });
        new gcp.computeInstanceGroupManager.ComputeInstanceGroupManager(this, 'instance-group', {
            provider: runnerProps.provider,
            name: 'cdktf-gitlabrunner-instance-group',
            baseInstanceName: 'scaling-gitlab-runner',
            version: [{
                    instanceTemplate: compute_template.id,
                }],
            lifecycle: {
                createBeforeDestroy: true,
            },
            targetSize: runnerProps.desiredCapacity,
            dependsOn: [compute_template, serviceAccount],
        });
        new cdktf.TerraformOutput(this, 'ComputeNetworkName', {
            value: network.name,
        });
    }
    dockerVolumesList(dockerVolume) {
        let tempString = '--docker-volumes "/var/run/docker.sock:/var/run/docker.sock"';
        if (dockerVolume) {
            let tempList = [];
            dockerVolume.forEach(e => {
                tempList.push(`"${e.hostPath}:${e.containerPath}"`);
            });
            tempList.forEach(e => {
                tempString = `${tempString} --docker-volumes ${e}`;
            });
        }
        return tempString;
    }
    /**
     * @param props
     * @returns Array.
     */
    createMetadataStartupScript(props) {
        return [
            `Content-Type: multipart/mixed; boundary="MIMEBOUNDARY"
MIME-Version: 1.0

--MIMEBOUNDARY
Content-Disposition: attachment; filename="init.cfg"
Content-Transfer-Encoding: 7bit
Content-Type: text/cloud-config
Mime-Version: 1.0

`, `# cloud-config
users:
  - name: gitlab-runner
    shell: /bin/bash
    uid: 2000
    groups:
      - docker

write_files:
  - path: /etc/gitlab-runner/config.toml
    owner: root:root
    permissions: '0644'
    content: |
      # Prometheus metrics at /metrics, also used for health checks.
      listen_address = ":9252"
      concurrent = ${props.concurrent}
  - path: /var/lib/cloud/bin/firewall
    permissions: 0755
    owner: root
    content: |
      #! /bin/bash
      iptables -w -A INPUT -p tcp --dport 9252 -j ACCEPT
  - path: /etc/systemd/system/gitlab-runner-register.service
    permissions: 0644
    owner: root
    content: |
      [Unit]
      Description=GitLab Runner Registration/Unregistration
      ConditionFileIsExecutable=/var/lib/google/bin/gitlab-runner
      After=syslog.target network-online.target
      [Service]
      Type=oneshot
      RemainAfterExit=yes
      ExecStart=/var/lib/google/bin/gitlab-runner register --non-interactive --url "${props.gitlabUrl}" --executor "docker" --registration-token ${props.gitlabToken} --docker-image alpine:latest --tag-list "${props.tags?.join(',')}" --locked="false" --access-level="not_protected" ${this.dockerVolumesList(props?.dockerVolumes)} --description "A Runner on GCP GCE (${props.machineType})" --docker-privileged
      ExecStop=/var/lib/google/bin/gitlab-runner "unregister" "--config" "/etc/gitlab-runner/config.toml" "--all-runners"
      [Install]
      WantedBy=multi-user.target
  - path: /etc/systemd/system/gitlab-runner.service
    permissions: 0644
    owner: root
    content: |
      [Unit]
      Description=GitLab Runner
      ConditionFileIsExecutable=/var/lib/google/bin/gitlab-runner
      After=gitlab-runner-register.service syslog.target network-online.target
      Requires=gitlab-runner-register.service
      [Service]
      StartLimitInterval=5
      StartLimitBurst=10
      ExecStart=/var/lib/google/bin/gitlab-runner "run" "--working-directory" "/home/gitlab-runner" "--config" "/etc/gitlab-runner/config.toml" "--service" "gitlab-runner" "--syslog" "--user" "gitlab-runner"
      Restart=always
      RestartSec=120
      [Install]
      WantedBy=multi-user.target
  - path: /etc/systemd/system/firewall.service
    permissions: 0644
    owner: root
    content: |
      [Unit]
      Description=Host firewall configuration
      ConditionFileIsExecutable=/var/lib/cloud/bin/firewall
      After=network-online.target
      [Service]
      ExecStart=/var/lib/cloud/bin/firewall
      Type=oneshot
      [Install]
      WantedBy=multi-user.target

runcmd:
  - mkdir /var/lib/google/tmp
  - mkdir /var/lib/google/bin
  - curl -L --output /var/lib/google/tmp/gitlab-runner ${props.downloadGitlabRunnerBinaryUrl}
  - install -o 0 -g 0 -m 0755 /var/lib/google/tmp/gitlab-runner /var/lib/google/bin/gitlab-runner
  - systemctl daemon-reload
  - systemctl start firewall.service
  - systemctl start gitlab-runner-register.service
  - systemctl start gitlab-runner.service
  - chmod +x /var/run/docker.sock

--MIMEBOUNDARY--
`,
        ];
    }
    createShutdwonScript() {
        return ['#!/bin/bash', '/var/lib/google/bin/gitlab-runner unregister --all-runners'];
    }
}
exports.GitlabRunnerAutoscaling = GitlabRunnerAutoscaling;
_a = JSII_RTTI_SYMBOL_1;
GitlabRunnerAutoscaling[_a] = { fqn: "cdktf-gitlab-runner.GitlabRunnerAutoscaling", version: "0.0.881" };
//# sourceMappingURL=data:application/json;base64,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