"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegDefaultStack = void 0;
const gcp = require("@cdktf/provider-google");
const cdktf = require("cdktf");
const index_1 = require("./index");
class IntegDefaultStack extends cdktf.TerraformStack {
    constructor(scope, id) {
        super(scope, id);
        const local = 'asia-east1';
        const projectId = `${process.env.PROJECT_ID}`;
        const provider = new gcp.provider.GoogleProvider(this, 'GoogleAuth', {
            region: local,
            zone: local + '-c',
            project: projectId,
        });
        new index_1.GitlabRunnerAutoscaling(this, 'GitlabRunnerAutoscaling', {
            gitlabToken: `${process.env.GITLAB_TOKEN}`,
            provider,
        });
    }
}
exports.IntegDefaultStack = IntegDefaultStack;
const app = new cdktf.App();
new IntegDefaultStack(app, 'cloudrun-cdktf');
app.synth();
//# sourceMappingURL=data:application/json;base64,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