"""
Paleobiology_get_fossils

Get fossil records from Paleobiology Database
"""

from typing import Any, Optional, Callable
from ._shared_client import get_shared_client


def Paleobiology_get_fossils(
    taxon: str,
    limit: Optional[int] = 20,
    *,
    stream_callback: Optional[Callable[[str], None]] = None,
    use_cache: bool = False,
    validate: bool = True,
) -> dict[str, Any]:
    """
    Get fossil records from Paleobiology Database

    Parameters
    ----------
    taxon : str
        Taxon name
    limit : int
        Number of results
    stream_callback : Callable, optional
        Callback for streaming output
    use_cache : bool, default False
        Enable caching
    validate : bool, default True
        Validate parameters

    Returns
    -------
    dict[str, Any]
    """
    # Handle mutable defaults to avoid B006 linting error

    return get_shared_client().run_one_function(
        {
            "name": "Paleobiology_get_fossils",
            "arguments": {"taxon": taxon, "limit": limit},
        },
        stream_callback=stream_callback,
        use_cache=use_cache,
        validate=validate,
    )


__all__ = ["Paleobiology_get_fossils"]
