# Rust API client for tower-api

REST API to interact with Tower Services.

For more information, please visit [https://tower.dev](https://tower.dev)

## Overview

This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [openapi-spec](https://openapis.org) from a remote server, you can easily generate an API client.

- API version: v0.6.19
- Package version: 1.0.0
- Generator version: 7.13.0
- Build package: `org.openapitools.codegen.languages.RustClientCodegen`

## Installation

Put the package under your project folder in a directory named `tower-api` and add the following to `Cargo.toml` under `[dependencies]`:

```
tower-api = { path = "./tower-api" }
```

## Documentation for API Endpoints

All URIs are relative to *https://api.tower.dev/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**accept_invitation**](docs/DefaultApi.md#accept_invitation) | **POST** /accounts/invite | Accept an invitation code
*DefaultApi* | [**acknowledge_alert**](docs/DefaultApi.md#acknowledge_alert) | **POST** /alerts/{alert_seq}/acknowledge | Acknowledge alert
*DefaultApi* | [**acknowledge_all_alerts**](docs/DefaultApi.md#acknowledge_all_alerts) | **POST** /alerts/acknowledge-all | Acknowledge all alerts
*DefaultApi* | [**cancel_run**](docs/DefaultApi.md#cancel_run) | **POST** /apps/{slug}/runs/{seq} | Cancel run
*DefaultApi* | [**claim_device_login_ticket**](docs/DefaultApi.md#claim_device_login_ticket) | **POST** /login/device/claim | Claim a device login ticket
*DefaultApi* | [**create_account**](docs/DefaultApi.md#create_account) | **POST** /accounts | Create account
*DefaultApi* | [**create_api_key**](docs/DefaultApi.md#create_api_key) | **POST** /api-keys | Create API Key
*DefaultApi* | [**create_app**](docs/DefaultApi.md#create_app) | **POST** /apps | Create app
*DefaultApi* | [**create_authenticator**](docs/DefaultApi.md#create_authenticator) | **POST** /accounts/authenticator | Create authenticator
*DefaultApi* | [**create_catalog**](docs/DefaultApi.md#create_catalog) | **POST** /catalogs | Create catalog
*DefaultApi* | [**create_device_login_ticket**](docs/DefaultApi.md#create_device_login_ticket) | **GET** /login/device | Create device login ticket
*DefaultApi* | [**create_password_reset**](docs/DefaultApi.md#create_password_reset) | **POST** /accounts/password-reset | Create password reset
*DefaultApi* | [**create_schedule**](docs/DefaultApi.md#create_schedule) | **POST** /schedules | Create schedule
*DefaultApi* | [**create_secret**](docs/DefaultApi.md#create_secret) | **POST** /secrets | Create secret
*DefaultApi* | [**create_session**](docs/DefaultApi.md#create_session) | **POST** /session | Create session
*DefaultApi* | [**create_team**](docs/DefaultApi.md#create_team) | **POST** /teams | Create team
*DefaultApi* | [**delete_alert**](docs/DefaultApi.md#delete_alert) | **DELETE** /alerts/{alert_id} | Delete alert
*DefaultApi* | [**delete_api_key**](docs/DefaultApi.md#delete_api_key) | **DELETE** /api-keys | Delete API key
*DefaultApi* | [**delete_app**](docs/DefaultApi.md#delete_app) | **DELETE** /apps/{slug} | Delete app
*DefaultApi* | [**delete_authenticator**](docs/DefaultApi.md#delete_authenticator) | **DELETE** /accounts/authenticator | Delete authenticator
*DefaultApi* | [**delete_catalog**](docs/DefaultApi.md#delete_catalog) | **DELETE** /catalogs/{slug} | Delete catalog
*DefaultApi* | [**delete_schedule**](docs/DefaultApi.md#delete_schedule) | **DELETE** /schedules/{id} | Delete schedule
*DefaultApi* | [**delete_secret**](docs/DefaultApi.md#delete_secret) | **DELETE** /secrets/{name} | Delete secret
*DefaultApi* | [**delete_team**](docs/DefaultApi.md#delete_team) | **DELETE** /teams | Delete team
*DefaultApi* | [**delete_team_invitation**](docs/DefaultApi.md#delete_team_invitation) | **DELETE** /teams/{slug}/invites | Delete team invitation
*DefaultApi* | [**deploy_app**](docs/DefaultApi.md#deploy_app) | **POST** /apps/{slug}/deploy | Deploy app
*DefaultApi* | [**describe_app**](docs/DefaultApi.md#describe_app) | **GET** /apps/{slug} | Describe app
*DefaultApi* | [**describe_app_version**](docs/DefaultApi.md#describe_app_version) | **GET** /apps/{name}/versions/{num} | Describe app version
*DefaultApi* | [**describe_device_login_session**](docs/DefaultApi.md#describe_device_login_session) | **GET** /login/device/{device_code} | Describe device login session
*DefaultApi* | [**describe_run**](docs/DefaultApi.md#describe_run) | **GET** /apps/{slug}/runs/{seq} | Describe run
*DefaultApi* | [**describe_run_logs**](docs/DefaultApi.md#describe_run_logs) | **GET** /apps/{slug}/runs/{seq}/logs | Describe run logs
*DefaultApi* | [**describe_secrets_key**](docs/DefaultApi.md#describe_secrets_key) | **GET** /secrets/key | Describe encryption key
*DefaultApi* | [**describe_session**](docs/DefaultApi.md#describe_session) | **GET** /session | Describe session
*DefaultApi* | [**export_catalogs**](docs/DefaultApi.md#export_catalogs) | **POST** /catalogs/export | Export catalogs
*DefaultApi* | [**export_secrets**](docs/DefaultApi.md#export_secrets) | **POST** /secrets/export | Export secrets
*DefaultApi* | [**generate_app_statistics**](docs/DefaultApi.md#generate_app_statistics) | **GET** /stats/apps | Generate app statistics
*DefaultApi* | [**generate_authenticator**](docs/DefaultApi.md#generate_authenticator) | **POST** /accounts/authenticator/generate | Generate authenticator
*DefaultApi* | [**generate_run_statistics**](docs/DefaultApi.md#generate_run_statistics) | **GET** /stats/runs | Generate run statistics
*DefaultApi* | [**generate_runner_credentials**](docs/DefaultApi.md#generate_runner_credentials) | **POST** /runners/credentials | Generate runner credentials
*DefaultApi* | [**invite_team_member**](docs/DefaultApi.md#invite_team_member) | **POST** /teams/{slug}/invites | Invite team member
*DefaultApi* | [**leave_team**](docs/DefaultApi.md#leave_team) | **POST** /teams/{slug}/leave | Leave team
*DefaultApi* | [**list_alerts**](docs/DefaultApi.md#list_alerts) | **GET** /alerts | List alerts
*DefaultApi* | [**list_api_keys**](docs/DefaultApi.md#list_api_keys) | **GET** /api-keys | List API keys
*DefaultApi* | [**list_app_environments**](docs/DefaultApi.md#list_app_environments) | **GET** /apps/{slug}/environments | List app environments
*DefaultApi* | [**list_app_versions**](docs/DefaultApi.md#list_app_versions) | **GET** /apps/{name}/versions | List app versions
*DefaultApi* | [**list_apps**](docs/DefaultApi.md#list_apps) | **GET** /apps | List apps
*DefaultApi* | [**list_authenticators**](docs/DefaultApi.md#list_authenticators) | **GET** /accounts/authenticator | List authenticators
*DefaultApi* | [**list_catalogs**](docs/DefaultApi.md#list_catalogs) | **GET** /catalogs | List catalogs
*DefaultApi* | [**list_my_team_invitations**](docs/DefaultApi.md#list_my_team_invitations) | **GET** /team-invites | List my team invitations
*DefaultApi* | [**list_runs**](docs/DefaultApi.md#list_runs) | **GET** /apps/{slug}/runs | List runs
*DefaultApi* | [**list_schedules**](docs/DefaultApi.md#list_schedules) | **GET** /schedules | List schedules
*DefaultApi* | [**list_secret_environments**](docs/DefaultApi.md#list_secret_environments) | **GET** /secrets/environments | List secret environments
*DefaultApi* | [**list_secrets**](docs/DefaultApi.md#list_secrets) | **GET** /secrets | List secrets
*DefaultApi* | [**list_team_invitations**](docs/DefaultApi.md#list_team_invitations) | **GET** /teams/{slug}/invites | List team invitations
*DefaultApi* | [**list_team_members**](docs/DefaultApi.md#list_team_members) | **GET** /teams/{slug}/members | List team members
*DefaultApi* | [**list_teams**](docs/DefaultApi.md#list_teams) | **GET** /teams | List teams
*DefaultApi* | [**refresh_session**](docs/DefaultApi.md#refresh_session) | **POST** /session/refresh | Refresh session
*DefaultApi* | [**remove_team_member**](docs/DefaultApi.md#remove_team_member) | **DELETE** /teams/{slug}/members | Remove team member
*DefaultApi* | [**resend_team_invitation**](docs/DefaultApi.md#resend_team_invitation) | **POST** /teams/{slug}/invites/resend | Resend team invitation
*DefaultApi* | [**run_app**](docs/DefaultApi.md#run_app) | **POST** /apps/{slug}/runs | Run app
*DefaultApi* | [**search_runs**](docs/DefaultApi.md#search_runs) | **GET** /runs | Search runs
*DefaultApi* | [**stream_alerts**](docs/DefaultApi.md#stream_alerts) | **GET** /alerts/stream | Stream alert notifications
*DefaultApi* | [**stream_run_logs**](docs/DefaultApi.md#stream_run_logs) | **GET** /apps/{slug}/runs/{seq}/logs/stream | Stream run logs
*DefaultApi* | [**update_account_slug**](docs/DefaultApi.md#update_account_slug) | **PUT** /accounts/{slug} | Update account slug
*DefaultApi* | [**update_app**](docs/DefaultApi.md#update_app) | **PUT** /apps/{name} | Update app
*DefaultApi* | [**update_catalog**](docs/DefaultApi.md#update_catalog) | **PUT** /catalogs/{slug} | Update catalog
*DefaultApi* | [**update_my_team_invitation**](docs/DefaultApi.md#update_my_team_invitation) | **PUT** /team-invites | Update my team invitation
*DefaultApi* | [**update_password_reset**](docs/DefaultApi.md#update_password_reset) | **POST** /accounts/password-reset/{code} | Update password reset
*DefaultApi* | [**update_schedule**](docs/DefaultApi.md#update_schedule) | **PUT** /schedules/{id} | Update schedule
*DefaultApi* | [**update_secret**](docs/DefaultApi.md#update_secret) | **PUT** /secrets/{name} | Update secret
*DefaultApi* | [**update_team**](docs/DefaultApi.md#update_team) | **PUT** /teams/{slug} | Update team
*DefaultApi* | [**update_user**](docs/DefaultApi.md#update_user) | **PUT** /user | Update user profile


## Documentation For Models

 - [AcceptInvitationParams](docs/AcceptInvitationParams.md)
 - [AcceptInvitationResponse](docs/AcceptInvitationResponse.md)
 - [Account](docs/Account.md)
 - [AcknowledgeAlertResponse](docs/AcknowledgeAlertResponse.md)
 - [AcknowledgeAllAlertsResponse](docs/AcknowledgeAllAlertsResponse.md)
 - [Alert](docs/Alert.md)
 - [ApiKey](docs/ApiKey.md)
 - [App](docs/App.md)
 - [AppStatistics](docs/AppStatistics.md)
 - [AppSummary](docs/AppSummary.md)
 - [AppVersion](docs/AppVersion.md)
 - [CancelRunResponse](docs/CancelRunResponse.md)
 - [Catalog](docs/Catalog.md)
 - [CatalogProperty](docs/CatalogProperty.md)
 - [ClaimDeviceLoginTicketParams](docs/ClaimDeviceLoginTicketParams.md)
 - [ClaimDeviceLoginTicketResponse](docs/ClaimDeviceLoginTicketResponse.md)
 - [CreateAccountParams](docs/CreateAccountParams.md)
 - [CreateAccountParamsFlagsStruct](docs/CreateAccountParamsFlagsStruct.md)
 - [CreateAccountResponse](docs/CreateAccountResponse.md)
 - [CreateApiKeyParams](docs/CreateApiKeyParams.md)
 - [CreateApiKeyResponse](docs/CreateApiKeyResponse.md)
 - [CreateAppParams](docs/CreateAppParams.md)
 - [CreateAppResponse](docs/CreateAppResponse.md)
 - [CreateAuthenticatorParams](docs/CreateAuthenticatorParams.md)
 - [CreateAuthenticatorResponse](docs/CreateAuthenticatorResponse.md)
 - [CreateCatalogParams](docs/CreateCatalogParams.md)
 - [CreateCatalogResponse](docs/CreateCatalogResponse.md)
 - [CreateDeviceLoginTicketResponse](docs/CreateDeviceLoginTicketResponse.md)
 - [CreatePasswordResetParams](docs/CreatePasswordResetParams.md)
 - [CreatePasswordResetResponse](docs/CreatePasswordResetResponse.md)
 - [CreateScheduleParams](docs/CreateScheduleParams.md)
 - [CreateScheduleResponse](docs/CreateScheduleResponse.md)
 - [CreateSecretParams](docs/CreateSecretParams.md)
 - [CreateSecretResponse](docs/CreateSecretResponse.md)
 - [CreateSessionParams](docs/CreateSessionParams.md)
 - [CreateSessionResponse](docs/CreateSessionResponse.md)
 - [CreateTeamParams](docs/CreateTeamParams.md)
 - [CreateTeamResponse](docs/CreateTeamResponse.md)
 - [DeleteApiKeyParams](docs/DeleteApiKeyParams.md)
 - [DeleteApiKeyResponse](docs/DeleteApiKeyResponse.md)
 - [DeleteAppResponse](docs/DeleteAppResponse.md)
 - [DeleteAuthenticatorParams](docs/DeleteAuthenticatorParams.md)
 - [DeleteAuthenticatorResponse](docs/DeleteAuthenticatorResponse.md)
 - [DeleteCatalogResponse](docs/DeleteCatalogResponse.md)
 - [DeleteScheduleResponse](docs/DeleteScheduleResponse.md)
 - [DeleteSecretResponse](docs/DeleteSecretResponse.md)
 - [DeleteTeamInvitationParams](docs/DeleteTeamInvitationParams.md)
 - [DeleteTeamInvitationResponse](docs/DeleteTeamInvitationResponse.md)
 - [DeleteTeamParams](docs/DeleteTeamParams.md)
 - [DeleteTeamResponse](docs/DeleteTeamResponse.md)
 - [DeployAppResponse](docs/DeployAppResponse.md)
 - [DescribeAppResponse](docs/DescribeAppResponse.md)
 - [DescribeAppVersionResponse](docs/DescribeAppVersionResponse.md)
 - [DescribeDeviceLoginSessionResponse](docs/DescribeDeviceLoginSessionResponse.md)
 - [DescribeRunLogsResponse](docs/DescribeRunLogsResponse.md)
 - [DescribeRunResponse](docs/DescribeRunResponse.md)
 - [DescribeSecretsKeyResponse](docs/DescribeSecretsKeyResponse.md)
 - [DescribeSessionResponse](docs/DescribeSessionResponse.md)
 - [EncryptedCatalogProperty](docs/EncryptedCatalogProperty.md)
 - [ErrorDetail](docs/ErrorDetail.md)
 - [ErrorModel](docs/ErrorModel.md)
 - [ExportCatalogsParams](docs/ExportCatalogsParams.md)
 - [ExportCatalogsResponse](docs/ExportCatalogsResponse.md)
 - [ExportSecretsParams](docs/ExportSecretsParams.md)
 - [ExportSecretsResponse](docs/ExportSecretsResponse.md)
 - [ExportedCatalog](docs/ExportedCatalog.md)
 - [ExportedCatalogProperty](docs/ExportedCatalogProperty.md)
 - [ExportedSecret](docs/ExportedSecret.md)
 - [FeaturebaseIdentity](docs/FeaturebaseIdentity.md)
 - [GenerateAppStatisticsResponse](docs/GenerateAppStatisticsResponse.md)
 - [GenerateAuthenticatorResponse](docs/GenerateAuthenticatorResponse.md)
 - [GenerateRunStatisticsResponse](docs/GenerateRunStatisticsResponse.md)
 - [GenerateRunnerCredentialsResponse](docs/GenerateRunnerCredentialsResponse.md)
 - [InviteTeamMemberParams](docs/InviteTeamMemberParams.md)
 - [InviteTeamMemberResponse](docs/InviteTeamMemberResponse.md)
 - [LeaveTeamResponse](docs/LeaveTeamResponse.md)
 - [ListAlerts200Response](docs/ListAlerts200Response.md)
 - [ListAlertsResponse](docs/ListAlertsResponse.md)
 - [ListApiKeysResponse](docs/ListApiKeysResponse.md)
 - [ListAppEnvironmentsResponse](docs/ListAppEnvironmentsResponse.md)
 - [ListAppVersionsResponse](docs/ListAppVersionsResponse.md)
 - [ListAppsResponse](docs/ListAppsResponse.md)
 - [ListAuthenticatorsResponse](docs/ListAuthenticatorsResponse.md)
 - [ListCatalogsResponse](docs/ListCatalogsResponse.md)
 - [ListMyTeamInvitationsResponse](docs/ListMyTeamInvitationsResponse.md)
 - [ListRunsResponse](docs/ListRunsResponse.md)
 - [ListSchedulesResponse](docs/ListSchedulesResponse.md)
 - [ListSecretEnvironmentsResponse](docs/ListSecretEnvironmentsResponse.md)
 - [ListSecretsResponse](docs/ListSecretsResponse.md)
 - [ListTeamInvitationsResponse](docs/ListTeamInvitationsResponse.md)
 - [ListTeamMembersResponse](docs/ListTeamMembersResponse.md)
 - [ListTeamsResponse](docs/ListTeamsResponse.md)
 - [LogLine](docs/LogLine.md)
 - [Pagination](docs/Pagination.md)
 - [Parameter](docs/Parameter.md)
 - [RefreshSessionParams](docs/RefreshSessionParams.md)
 - [RefreshSessionResponse](docs/RefreshSessionResponse.md)
 - [RemoveTeamMemberParams](docs/RemoveTeamMemberParams.md)
 - [RemoveTeamMemberResponse](docs/RemoveTeamMemberResponse.md)
 - [ResendTeamInvitationParams](docs/ResendTeamInvitationParams.md)
 - [ResendTeamInvitationResponse](docs/ResendTeamInvitationResponse.md)
 - [Run](docs/Run.md)
 - [RunAppParams](docs/RunAppParams.md)
 - [RunAppResponse](docs/RunAppResponse.md)
 - [RunFailureAlert](docs/RunFailureAlert.md)
 - [RunLogLine](docs/RunLogLine.md)
 - [RunParameter](docs/RunParameter.md)
 - [RunResults](docs/RunResults.md)
 - [RunStatistics](docs/RunStatistics.md)
 - [RunTimeseriesPoint](docs/RunTimeseriesPoint.md)
 - [RunnerCredentials](docs/RunnerCredentials.md)
 - [Schedule](docs/Schedule.md)
 - [SearchRunsResponse](docs/SearchRunsResponse.md)
 - [Secret](docs/Secret.md)
 - [Session](docs/Session.md)
 - [SseWarning](docs/SseWarning.md)
 - [StatisticsSettings](docs/StatisticsSettings.md)
 - [StreamAlerts200ResponseInner](docs/StreamAlerts200ResponseInner.md)
 - [StreamRunLogs200ResponseInner](docs/StreamRunLogs200ResponseInner.md)
 - [Team](docs/Team.md)
 - [TeamInvitation](docs/TeamInvitation.md)
 - [Token](docs/Token.md)
 - [UnverifiedAuthenticator](docs/UnverifiedAuthenticator.md)
 - [UpdateAccountSlugParams](docs/UpdateAccountSlugParams.md)
 - [UpdateAccountSlugResponse](docs/UpdateAccountSlugResponse.md)
 - [UpdateAppParams](docs/UpdateAppParams.md)
 - [UpdateAppResponse](docs/UpdateAppResponse.md)
 - [UpdateCatalogParams](docs/UpdateCatalogParams.md)
 - [UpdateCatalogResponse](docs/UpdateCatalogResponse.md)
 - [UpdateMyTeamInvitationParams](docs/UpdateMyTeamInvitationParams.md)
 - [UpdateMyTeamInvitationResponse](docs/UpdateMyTeamInvitationResponse.md)
 - [UpdatePasswordResetParams](docs/UpdatePasswordResetParams.md)
 - [UpdatePasswordResetResponse](docs/UpdatePasswordResetResponse.md)
 - [UpdateScheduleParams](docs/UpdateScheduleParams.md)
 - [UpdateScheduleResponse](docs/UpdateScheduleResponse.md)
 - [UpdateSecretParams](docs/UpdateSecretParams.md)
 - [UpdateSecretResponse](docs/UpdateSecretResponse.md)
 - [UpdateTeamParams](docs/UpdateTeamParams.md)
 - [UpdateTeamResponse](docs/UpdateTeamResponse.md)
 - [UpdateUserParams](docs/UpdateUserParams.md)
 - [UpdateUserResponse](docs/UpdateUserResponse.md)
 - [User](docs/User.md)
 - [VerifiedAuthenticator](docs/VerifiedAuthenticator.md)


To get access to the crate's generated documentation, use:

```
cargo doc --open
```

## Author

hello@tower.dev

