/*
 * Tower API
 *
 * REST API to interact with Tower Services.
 *
 * The version of the OpenAPI document: v0.6.19
 * Contact: hello@tower.dev
 * Generated by: https://openapi-generator.tech
 */


use reqwest;
use serde::{Deserialize, Serialize, de::Error as _};
use crate::{apis::ResponseContent, models};
use super::{Error, configuration, ContentType};

const DEFAULT_TOWER_TRACE_ID: &str = "(none)";

/// struct for passing parameters to the method [`accept_invitation`]
#[derive(Clone, Debug)]
pub struct AcceptInvitationParams {
    pub accept_invitation_params: models::AcceptInvitationParams
}

/// struct for passing parameters to the method [`acknowledge_alert`]
#[derive(Clone, Debug)]
pub struct AcknowledgeAlertParams {
    /// Seq of the alert to acknowledge
    pub alert_seq: i64
}

/// struct for passing parameters to the method [`cancel_run`]
#[derive(Clone, Debug)]
pub struct CancelRunParams {
    /// The slug of the app to fetch runs for.
    pub slug: String,
    /// The number of the run to fetch.
    pub seq: i64
}

/// struct for passing parameters to the method [`claim_device_login_ticket`]
#[derive(Clone, Debug)]
pub struct ClaimDeviceLoginTicketParams {
    pub claim_device_login_ticket_params: models::ClaimDeviceLoginTicketParams
}

/// struct for passing parameters to the method [`create_account`]
#[derive(Clone, Debug)]
pub struct CreateAccountParams {
    pub create_account_params: models::CreateAccountParams
}

/// struct for passing parameters to the method [`create_api_key`]
#[derive(Clone, Debug)]
pub struct CreateApiKeyParams {
    pub create_api_key_params: models::CreateApiKeyParams
}

/// struct for passing parameters to the method [`create_app`]
#[derive(Clone, Debug)]
pub struct CreateAppParams {
    pub create_app_params: models::CreateAppParams
}

/// struct for passing parameters to the method [`create_authenticator`]
#[derive(Clone, Debug)]
pub struct CreateAuthenticatorParams {
    pub create_authenticator_params: models::CreateAuthenticatorParams
}

/// struct for passing parameters to the method [`create_catalog`]
#[derive(Clone, Debug)]
pub struct CreateCatalogParams {
    pub create_catalog_params: models::CreateCatalogParams
}

/// struct for passing parameters to the method [`create_password_reset`]
#[derive(Clone, Debug)]
pub struct CreatePasswordResetParams {
    pub create_password_reset_params: models::CreatePasswordResetParams
}

/// struct for passing parameters to the method [`create_schedule`]
#[derive(Clone, Debug)]
pub struct CreateScheduleParams {
    pub create_schedule_params: models::CreateScheduleParams
}

/// struct for passing parameters to the method [`create_secret`]
#[derive(Clone, Debug)]
pub struct CreateSecretParams {
    pub create_secret_params: models::CreateSecretParams
}

/// struct for passing parameters to the method [`create_session`]
#[derive(Clone, Debug)]
pub struct CreateSessionParams {
    pub create_session_params: models::CreateSessionParams
}

/// struct for passing parameters to the method [`create_team`]
#[derive(Clone, Debug)]
pub struct CreateTeamParams {
    pub create_team_params: models::CreateTeamParams
}

/// struct for passing parameters to the method [`delete_alert`]
#[derive(Clone, Debug)]
pub struct DeleteAlertParams {
    /// ID of the alert to delete
    pub alert_id: String
}

/// struct for passing parameters to the method [`delete_api_key`]
#[derive(Clone, Debug)]
pub struct DeleteApiKeyParams {
    pub delete_api_key_params: models::DeleteApiKeyParams
}

/// struct for passing parameters to the method [`delete_app`]
#[derive(Clone, Debug)]
pub struct DeleteAppParams {
    /// The slug of the app to delete.
    pub slug: String
}

/// struct for passing parameters to the method [`delete_authenticator`]
#[derive(Clone, Debug)]
pub struct DeleteAuthenticatorParams {
    pub delete_authenticator_params: models::DeleteAuthenticatorParams
}

/// struct for passing parameters to the method [`delete_catalog`]
#[derive(Clone, Debug)]
pub struct DeleteCatalogParams {
    /// The slug of the catalog to update.
    pub slug: String
}

/// struct for passing parameters to the method [`delete_schedule`]
#[derive(Clone, Debug)]
pub struct DeleteScheduleParams {
    /// The ID of the schedule to delete.
    pub id: String
}

/// struct for passing parameters to the method [`delete_secret`]
#[derive(Clone, Debug)]
pub struct DeleteSecretParams {
    /// The name of the secret to delete.
    pub name: String,
    /// The environment of the secret to delete.
    pub environment: Option<String>
}

/// struct for passing parameters to the method [`delete_team`]
#[derive(Clone, Debug)]
pub struct DeleteTeamParams {
    pub delete_team_params: models::DeleteTeamParams
}

/// struct for passing parameters to the method [`delete_team_invitation`]
#[derive(Clone, Debug)]
pub struct DeleteTeamInvitationParams {
    /// The slug of the team to remove someone from
    pub slug: String,
    pub delete_team_invitation_params: models::DeleteTeamInvitationParams
}

/// struct for passing parameters to the method [`deploy_app`]
#[derive(Clone, Debug)]
pub struct DeployAppParams {
    /// The slug of the app to deploy.
    pub slug: String,
    /// The encoding of the content.
    pub content_encoding: Option<String>
}

/// struct for passing parameters to the method [`describe_app`]
#[derive(Clone, Debug)]
pub struct DescribeAppParams {
    /// The slug of the app to fetch.
    pub slug: String,
    /// The number of recent runs to fetch for the app.
    pub runs: Option<i64>,
    /// Filter runs scheduled after this datetime (inclusive). Provide timestamps in ISO-8601 format.
    pub start_at: Option<String>,
    /// Filter runs scheduled before or at this datetime (inclusive). Provide timestamps in ISO-8601 format.
    pub end_at: Option<String>,
    /// Timezone for the statistics (e.g., 'Europe/Berlin'). Defaults to UTC.
    pub timezone: Option<String>
}

/// struct for passing parameters to the method [`describe_app_version`]
#[derive(Clone, Debug)]
pub struct DescribeAppVersionParams {
    /// The name of the app to get the version for.
    pub name: String,
    /// The version string to get the version for.
    pub num: String
}

/// struct for passing parameters to the method [`describe_device_login_session`]
#[derive(Clone, Debug)]
pub struct DescribeDeviceLoginSessionParams {
    /// The device code to check.
    pub device_code: String
}

/// struct for passing parameters to the method [`describe_run`]
#[derive(Clone, Debug)]
pub struct DescribeRunParams {
    /// The slug of the app to fetch runs for.
    pub slug: String,
    /// The number of the run to fetch.
    pub seq: i64
}

/// struct for passing parameters to the method [`describe_run_logs`]
#[derive(Clone, Debug)]
pub struct DescribeRunLogsParams {
    /// The slug of the app to get logs for.
    pub slug: String,
    /// The sequence number of the run to get logs for.
    pub seq: i64
}

/// struct for passing parameters to the method [`describe_secrets_key`]
#[derive(Clone, Debug)]
pub struct DescribeSecretsKeyParams {
    /// The format to return the key in. Options are 'pkcs1' and 'spki'.
    pub format: Option<String>
}

/// struct for passing parameters to the method [`export_catalogs`]
#[derive(Clone, Debug)]
pub struct ExportCatalogsParams {
    pub export_catalogs_params: models::ExportCatalogsParams
}

/// struct for passing parameters to the method [`export_secrets`]
#[derive(Clone, Debug)]
pub struct ExportSecretsParams {
    pub export_secrets_params: models::ExportSecretsParams
}

/// struct for passing parameters to the method [`generate_run_statistics`]
#[derive(Clone, Debug)]
pub struct GenerateRunStatisticsParams {
    /// Start date and time for statistics (inclusive)
    pub start_at: String,
    /// End date and time for statistics (inclusive)
    pub end_at: String,
    /// Filter runs by status(es). Define multiple with a comma-separated list. Supplying none will return all statuses.
    pub status: Option<Vec<String>>,
    /// Timezone for the statistics (e.g., 'Europe/Berlin'). Defaults to UTC.
    pub timezone: Option<String>
}

/// struct for passing parameters to the method [`invite_team_member`]
#[derive(Clone, Debug)]
pub struct InviteTeamMemberParams {
    /// The slug of the team to invite someone to
    pub slug: String,
    pub invite_team_member_params: models::InviteTeamMemberParams
}

/// struct for passing parameters to the method [`leave_team`]
#[derive(Clone, Debug)]
pub struct LeaveTeamParams {
    /// The slug of the team to leave
    pub slug: String
}

/// struct for passing parameters to the method [`list_alerts`]
#[derive(Clone, Debug)]
pub struct ListAlertsParams {
    /// Filter alerts by alert type
    pub alert_type: Option<String>,
    /// Filter alerts created after or at this datetime (inclusive)
    pub start_at: Option<String>,
    /// Filter alerts created before or at this datetime (inclusive)
    pub end_at: Option<String>,
    /// The page number to fetch.
    pub page: Option<i64>,
    /// The number of records to fetch on each page.
    pub page_size: Option<i64>,
    /// Filter alerts by acknowledged status.
    pub acked: Option<String>
}

/// struct for passing parameters to the method [`list_app_environments`]
#[derive(Clone, Debug)]
pub struct ListAppEnvironmentsParams {
    /// The name of the app to get the version for.
    pub slug: String
}

/// struct for passing parameters to the method [`list_app_versions`]
#[derive(Clone, Debug)]
pub struct ListAppVersionsParams {
    /// The name of the app to list versions for.
    pub name: String
}

/// struct for passing parameters to the method [`list_apps`]
#[derive(Clone, Debug)]
pub struct ListAppsParams {
    /// The search query to filter apps by.
    pub query: Option<String>,
    /// The page number to fetch.
    pub page: Option<i64>,
    /// The number of records to fetch on each page.
    pub page_size: Option<i64>,
    /// Number of recent runs to fetch (-1 for all runs, defaults to 20)
    pub num_runs: Option<i64>,
    /// Sort order for the results.
    pub sort: Option<String>,
    /// Filter to see apps with certain statuses.
    pub filter: Option<String>
}

/// struct for passing parameters to the method [`list_catalogs`]
#[derive(Clone, Debug)]
pub struct ListCatalogsParams {
    /// The environment to filter by.
    pub environment: Option<String>,
    /// Whether to fetch all catalogs across all environments or only for the current environment.
    pub all: Option<bool>,
    /// The page number to fetch.
    pub page: Option<i64>,
    /// The number of records to fetch on each page.
    pub page_size: Option<i64>
}

/// struct for passing parameters to the method [`list_runs`]
#[derive(Clone, Debug)]
pub struct ListRunsParams {
    /// The slug of the app to fetch runs for.
    pub slug: String,
    /// The page number to fetch.
    pub page: Option<i64>,
    /// The number of records to fetch on each page.
    pub page_size: Option<i64>,
    /// Filter runs by status(es) (comma separated for multiple).
    pub status: Option<Vec<String>>,
    /// Filter runs scheduled after or at this datetime (inclusive)
    pub start_at: Option<String>,
    /// Filter runs scheduled before or at this datetime (inclusive)
    pub end_at: Option<String>
}

/// struct for passing parameters to the method [`list_schedules`]
#[derive(Clone, Debug)]
pub struct ListSchedulesParams {
    /// The page number to fetch.
    pub page: Option<i64>,
    /// The number of records to fetch on each page.
    pub page_size: Option<i64>
}

/// struct for passing parameters to the method [`list_secrets`]
#[derive(Clone, Debug)]
pub struct ListSecretsParams {
    /// The environment to filter by.
    pub environment: Option<String>,
    /// Whether to fetch all secrets or only the ones that are not marked as deleted.
    pub all: Option<bool>,
    /// The page number to fetch.
    pub page: Option<i64>,
    /// The number of records to fetch on each page.
    pub page_size: Option<i64>
}

/// struct for passing parameters to the method [`list_team_invitations`]
#[derive(Clone, Debug)]
pub struct ListTeamInvitationsParams {
    /// The slug of the team to list members for
    pub slug: String
}

/// struct for passing parameters to the method [`list_team_members`]
#[derive(Clone, Debug)]
pub struct ListTeamMembersParams {
    /// The slug of the team to list members for
    pub slug: String
}

/// struct for passing parameters to the method [`refresh_session`]
#[derive(Clone, Debug)]
pub struct RefreshSessionParams {
    pub refresh_session_params: models::RefreshSessionParams
}

/// struct for passing parameters to the method [`remove_team_member`]
#[derive(Clone, Debug)]
pub struct RemoveTeamMemberParams {
    /// The slug of the team to remove someone from
    pub slug: String,
    pub remove_team_member_params: models::RemoveTeamMemberParams
}

/// struct for passing parameters to the method [`resend_team_invitation`]
#[derive(Clone, Debug)]
pub struct ResendTeamInvitationParams {
    /// The slug of the team to invite someone to
    pub slug: String,
    pub resend_team_invitation_params: models::ResendTeamInvitationParams
}

/// struct for passing parameters to the method [`run_app`]
#[derive(Clone, Debug)]
pub struct RunAppParams {
    /// The slug of the app to fetch runs for.
    pub slug: String,
    pub run_app_params: models::RunAppParams
}

/// struct for passing parameters to the method [`search_runs`]
#[derive(Clone, Debug)]
pub struct SearchRunsParams {
    /// The page number to fetch.
    pub page: Option<i64>,
    /// The number of records to fetch on each page.
    pub page_size: Option<i64>,
    /// Filter runs by status(es). Define multiple with a comma-separated list. Supplying none will return all statuses.
    pub status: Option<Vec<String>>,
    /// Filter runs scheduled after this datetime (inclusive). Provide timestamps in ISO-8601 format.
    pub start_at: Option<String>,
    /// Filter runs scheduled before or at this datetime (inclusive). Provide timestamps in ISO-8601 format.
    pub end_at: Option<String>
}

/// struct for passing parameters to the method [`stream_run_logs`]
#[derive(Clone, Debug)]
pub struct StreamRunLogsParams {
    /// The slug of the app to get logs for.
    pub slug: String,
    /// The sequence number of the run to get logs for.
    pub seq: i64
}

/// struct for passing parameters to the method [`update_account_slug`]
#[derive(Clone, Debug)]
pub struct UpdateAccountSlugParams {
    /// The slug of the account to update
    pub slug: String,
    pub update_account_slug_params: models::UpdateAccountSlugParams
}

/// struct for passing parameters to the method [`update_app`]
#[derive(Clone, Debug)]
pub struct UpdateAppParams {
    /// The name of the App to update.
    pub name: String,
    pub update_app_params: models::UpdateAppParams
}

/// struct for passing parameters to the method [`update_catalog`]
#[derive(Clone, Debug)]
pub struct UpdateCatalogParams {
    /// The slug of the catalog to update.
    pub slug: String,
    pub update_catalog_params: models::UpdateCatalogParams
}

/// struct for passing parameters to the method [`update_my_team_invitation`]
#[derive(Clone, Debug)]
pub struct UpdateMyTeamInvitationParams {
    pub update_my_team_invitation_params: models::UpdateMyTeamInvitationParams
}

/// struct for passing parameters to the method [`update_password_reset`]
#[derive(Clone, Debug)]
pub struct UpdatePasswordResetParams {
    /// The password reset code that was sent to you
    pub code: String,
    pub update_password_reset_params: models::UpdatePasswordResetParams
}

/// struct for passing parameters to the method [`update_schedule`]
#[derive(Clone, Debug)]
pub struct UpdateScheduleParams {
    /// The ID of the schedule to update.
    pub id: String,
    pub update_schedule_params: models::UpdateScheduleParams
}

/// struct for passing parameters to the method [`update_secret`]
#[derive(Clone, Debug)]
pub struct UpdateSecretParams {
    pub name: String,
    pub update_secret_params: models::UpdateSecretParams
}

/// struct for passing parameters to the method [`update_team`]
#[derive(Clone, Debug)]
pub struct UpdateTeamParams {
    /// The slug of the team to update
    pub slug: String,
    pub update_team_params: models::UpdateTeamParams
}

/// struct for passing parameters to the method [`update_user`]
#[derive(Clone, Debug)]
pub struct UpdateUserParams {
    pub update_user_params: models::UpdateUserParams
}


/// struct for typed successes of method [`accept_invitation`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum AcceptInvitationSuccess {
    Status200(models::AcceptInvitationResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`acknowledge_alert`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum AcknowledgeAlertSuccess {
    Status200(models::AcknowledgeAlertResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`acknowledge_all_alerts`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum AcknowledgeAllAlertsSuccess {
    Status200(models::AcknowledgeAllAlertsResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`cancel_run`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CancelRunSuccess {
    Status200(models::CancelRunResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`claim_device_login_ticket`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ClaimDeviceLoginTicketSuccess {
    Status200(models::ClaimDeviceLoginTicketResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`create_account`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CreateAccountSuccess {
    Status200(models::CreateAccountResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`create_api_key`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CreateApiKeySuccess {
    Status200(models::CreateApiKeyResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`create_app`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CreateAppSuccess {
    Status200(models::CreateAppResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`create_authenticator`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CreateAuthenticatorSuccess {
    Status200(models::CreateAuthenticatorResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`create_catalog`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CreateCatalogSuccess {
    Status200(models::CreateCatalogResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`create_device_login_ticket`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CreateDeviceLoginTicketSuccess {
    Status200(models::CreateDeviceLoginTicketResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`create_password_reset`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CreatePasswordResetSuccess {
    Status200(models::CreatePasswordResetResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`create_schedule`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CreateScheduleSuccess {
    Status200(models::CreateScheduleResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`create_secret`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CreateSecretSuccess {
    Status200(models::CreateSecretResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`create_session`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CreateSessionSuccess {
    Status200(models::CreateSessionResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`create_team`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CreateTeamSuccess {
    Status200(models::CreateTeamResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`delete_alert`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DeleteAlertSuccess {
    Status204(),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`delete_api_key`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DeleteApiKeySuccess {
    Status200(models::DeleteApiKeyResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`delete_app`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DeleteAppSuccess {
    Status200(models::DeleteAppResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`delete_authenticator`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DeleteAuthenticatorSuccess {
    Status200(models::DeleteAuthenticatorResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`delete_catalog`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DeleteCatalogSuccess {
    Status200(models::DeleteCatalogResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`delete_schedule`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DeleteScheduleSuccess {
    Status200(models::DeleteScheduleResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`delete_secret`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DeleteSecretSuccess {
    Status200(models::DeleteSecretResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`delete_team`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DeleteTeamSuccess {
    Status200(models::DeleteTeamResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`delete_team_invitation`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DeleteTeamInvitationSuccess {
    Status200(models::DeleteTeamInvitationResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`deploy_app`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DeployAppSuccess {
    Status200(models::DeployAppResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`describe_app`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DescribeAppSuccess {
    Status200(models::DescribeAppResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`describe_app_version`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DescribeAppVersionSuccess {
    Status200(models::DescribeAppVersionResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`describe_device_login_session`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DescribeDeviceLoginSessionSuccess {
    Status200(models::DescribeDeviceLoginSessionResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`describe_run`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DescribeRunSuccess {
    Status200(models::DescribeRunResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`describe_run_logs`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DescribeRunLogsSuccess {
    Status200(models::DescribeRunLogsResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`describe_secrets_key`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DescribeSecretsKeySuccess {
    Status200(models::DescribeSecretsKeyResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`describe_session`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DescribeSessionSuccess {
    Status200(models::DescribeSessionResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`export_catalogs`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ExportCatalogsSuccess {
    Status200(models::ExportCatalogsResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`export_secrets`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ExportSecretsSuccess {
    Status200(models::ExportSecretsResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`generate_app_statistics`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GenerateAppStatisticsSuccess {
    Status200(models::GenerateAppStatisticsResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`generate_authenticator`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GenerateAuthenticatorSuccess {
    Status200(models::GenerateAuthenticatorResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`generate_run_statistics`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GenerateRunStatisticsSuccess {
    Status200(models::GenerateRunStatisticsResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`generate_runner_credentials`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GenerateRunnerCredentialsSuccess {
    Status200(models::GenerateRunnerCredentialsResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`invite_team_member`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum InviteTeamMemberSuccess {
    Status200(models::InviteTeamMemberResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`leave_team`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum LeaveTeamSuccess {
    Status200(models::LeaveTeamResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`list_alerts`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ListAlertsSuccess {
    Status200(models::ListAlerts200Response),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`list_api_keys`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ListApiKeysSuccess {
    Status200(models::ListApiKeysResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`list_app_environments`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ListAppEnvironmentsSuccess {
    Status200(models::ListAppEnvironmentsResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`list_app_versions`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ListAppVersionsSuccess {
    Status200(models::ListAppVersionsResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`list_apps`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ListAppsSuccess {
    Status200(models::ListAppsResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`list_authenticators`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ListAuthenticatorsSuccess {
    Status200(models::ListAuthenticatorsResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`list_catalogs`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ListCatalogsSuccess {
    Status200(models::ListCatalogsResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`list_my_team_invitations`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ListMyTeamInvitationsSuccess {
    Status200(models::ListMyTeamInvitationsResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`list_runs`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ListRunsSuccess {
    Status200(models::ListRunsResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`list_schedules`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ListSchedulesSuccess {
    Status200(models::ListSchedulesResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`list_secret_environments`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ListSecretEnvironmentsSuccess {
    Status200(models::ListSecretEnvironmentsResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`list_secrets`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ListSecretsSuccess {
    Status200(models::ListSecretsResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`list_team_invitations`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ListTeamInvitationsSuccess {
    Status200(models::ListTeamInvitationsResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`list_team_members`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ListTeamMembersSuccess {
    Status200(models::ListTeamMembersResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`list_teams`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ListTeamsSuccess {
    Status200(models::ListTeamsResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`refresh_session`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum RefreshSessionSuccess {
    Status200(models::RefreshSessionResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`remove_team_member`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum RemoveTeamMemberSuccess {
    Status200(models::RemoveTeamMemberResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`resend_team_invitation`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ResendTeamInvitationSuccess {
    Status200(models::ResendTeamInvitationResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`run_app`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum RunAppSuccess {
    Status200(models::RunAppResponse),
    Status201(models::RunAppResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`search_runs`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum SearchRunsSuccess {
    Status200(models::SearchRunsResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`stream_alerts`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum StreamAlertsSuccess {
    Status200(Vec<models::StreamAlerts200ResponseInner>),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`stream_run_logs`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum StreamRunLogsSuccess {
    Status200(Vec<models::StreamRunLogs200ResponseInner>),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`update_account_slug`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UpdateAccountSlugSuccess {
    Status200(models::UpdateAccountSlugResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`update_app`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UpdateAppSuccess {
    Status200(models::UpdateAppResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`update_catalog`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UpdateCatalogSuccess {
    Status200(models::UpdateCatalogResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`update_my_team_invitation`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UpdateMyTeamInvitationSuccess {
    Status200(models::UpdateMyTeamInvitationResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`update_password_reset`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UpdatePasswordResetSuccess {
    Status200(models::UpdatePasswordResetResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`update_schedule`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UpdateScheduleSuccess {
    Status200(models::UpdateScheduleResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`update_secret`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UpdateSecretSuccess {
    Status200(models::UpdateSecretResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`update_team`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UpdateTeamSuccess {
    Status200(models::UpdateTeamResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`update_user`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UpdateUserSuccess {
    Status200(models::UpdateUserResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`accept_invitation`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum AcceptInvitationError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`acknowledge_alert`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum AcknowledgeAlertError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`acknowledge_all_alerts`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum AcknowledgeAllAlertsError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`cancel_run`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CancelRunError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`claim_device_login_ticket`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ClaimDeviceLoginTicketError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`create_account`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CreateAccountError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`create_api_key`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CreateApiKeyError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`create_app`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CreateAppError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`create_authenticator`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CreateAuthenticatorError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`create_catalog`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CreateCatalogError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`create_device_login_ticket`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CreateDeviceLoginTicketError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`create_password_reset`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CreatePasswordResetError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`create_schedule`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CreateScheduleError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`create_secret`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CreateSecretError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`create_session`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CreateSessionError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`create_team`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CreateTeamError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`delete_alert`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DeleteAlertError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`delete_api_key`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DeleteApiKeyError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`delete_app`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DeleteAppError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`delete_authenticator`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DeleteAuthenticatorError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`delete_catalog`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DeleteCatalogError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`delete_schedule`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DeleteScheduleError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`delete_secret`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DeleteSecretError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`delete_team`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DeleteTeamError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`delete_team_invitation`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DeleteTeamInvitationError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`deploy_app`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DeployAppError {
    Status400(models::ErrorModel),
    Status422(models::ErrorModel),
    Status500(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`describe_app`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DescribeAppError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`describe_app_version`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DescribeAppVersionError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`describe_device_login_session`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DescribeDeviceLoginSessionError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`describe_run`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DescribeRunError {
    Status401(models::ErrorModel),
    Status404(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`describe_run_logs`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DescribeRunLogsError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`describe_secrets_key`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DescribeSecretsKeyError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`describe_session`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DescribeSessionError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`export_catalogs`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ExportCatalogsError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`export_secrets`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ExportSecretsError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`generate_app_statistics`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GenerateAppStatisticsError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`generate_authenticator`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GenerateAuthenticatorError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`generate_run_statistics`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GenerateRunStatisticsError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`generate_runner_credentials`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GenerateRunnerCredentialsError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`invite_team_member`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum InviteTeamMemberError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`leave_team`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum LeaveTeamError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`list_alerts`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ListAlertsError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`list_api_keys`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ListApiKeysError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`list_app_environments`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ListAppEnvironmentsError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`list_app_versions`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ListAppVersionsError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`list_apps`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ListAppsError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`list_authenticators`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ListAuthenticatorsError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`list_catalogs`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ListCatalogsError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`list_my_team_invitations`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ListMyTeamInvitationsError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`list_runs`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ListRunsError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`list_schedules`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ListSchedulesError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`list_secret_environments`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ListSecretEnvironmentsError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`list_secrets`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ListSecretsError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`list_team_invitations`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ListTeamInvitationsError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`list_team_members`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ListTeamMembersError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`list_teams`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ListTeamsError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`refresh_session`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum RefreshSessionError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`remove_team_member`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum RemoveTeamMemberError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`resend_team_invitation`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ResendTeamInvitationError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`run_app`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum RunAppError {
    Status401(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`search_runs`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum SearchRunsError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`stream_alerts`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum StreamAlertsError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`stream_run_logs`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum StreamRunLogsError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`update_account_slug`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UpdateAccountSlugError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`update_app`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UpdateAppError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`update_catalog`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UpdateCatalogError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`update_my_team_invitation`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UpdateMyTeamInvitationError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`update_password_reset`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UpdatePasswordResetError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`update_schedule`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UpdateScheduleError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`update_secret`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UpdateSecretError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`update_team`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UpdateTeamError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`update_user`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UpdateUserError {
    DefaultResponse(models::ErrorModel),
    UnknownValue(serde_json::Value),
}


/// Accept an invitation code to join an account
pub async fn accept_invitation(configuration: &configuration::Configuration, params: AcceptInvitationParams) -> Result<ResponseContent<AcceptInvitationSuccess>, Error<AcceptInvitationError>> {

    let uri_str = format!("{}/accounts/invite", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::POST, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };
    req_builder = req_builder.json(&params.accept_invitation_params);

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<AcceptInvitationSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<AcceptInvitationError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Mark an alert as acknowledged
pub async fn acknowledge_alert(configuration: &configuration::Configuration, params: AcknowledgeAlertParams) -> Result<ResponseContent<AcknowledgeAlertSuccess>, Error<AcknowledgeAlertError>> {

    let uri_str = format!("{}/alerts/{alert_seq}/acknowledge", configuration.base_path, alert_seq=params.alert_seq);
    let mut req_builder = configuration.client.request(reqwest::Method::POST, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<AcknowledgeAlertSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<AcknowledgeAlertError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Mark all unacknowledged alerts as acknowledged for the current user in the current account
pub async fn acknowledge_all_alerts(configuration: &configuration::Configuration) -> Result<ResponseContent<AcknowledgeAllAlertsSuccess>, Error<AcknowledgeAllAlertsError>> {

    let uri_str = format!("{}/alerts/acknowledge-all", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::POST, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<AcknowledgeAllAlertsSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<AcknowledgeAllAlertsError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Cancel a run
pub async fn cancel_run(configuration: &configuration::Configuration, params: CancelRunParams) -> Result<ResponseContent<CancelRunSuccess>, Error<CancelRunError>> {

    let uri_str = format!("{}/apps/{slug}/runs/{seq}", configuration.base_path, slug=crate::apis::urlencode(params.slug), seq=params.seq);
    let mut req_builder = configuration.client.request(reqwest::Method::POST, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<CancelRunSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<CancelRunError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Claims a device login ticket code for the authenticated user.
pub async fn claim_device_login_ticket(configuration: &configuration::Configuration, params: ClaimDeviceLoginTicketParams) -> Result<ResponseContent<ClaimDeviceLoginTicketSuccess>, Error<ClaimDeviceLoginTicketError>> {

    let uri_str = format!("{}/login/device/claim", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::POST, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };
    req_builder = req_builder.json(&params.claim_device_login_ticket_params);

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<ClaimDeviceLoginTicketSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<ClaimDeviceLoginTicketError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// This is the primary way that users register new accounts with Tower.
pub async fn create_account(configuration: &configuration::Configuration, params: CreateAccountParams) -> Result<ResponseContent<CreateAccountSuccess>, Error<CreateAccountError>> {

    let uri_str = format!("{}/accounts", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::POST, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    req_builder = req_builder.json(&params.create_account_params);

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<CreateAccountSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<CreateAccountError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

pub async fn create_api_key(configuration: &configuration::Configuration, params: CreateApiKeyParams) -> Result<ResponseContent<CreateApiKeySuccess>, Error<CreateApiKeyError>> {

    let uri_str = format!("{}/api-keys", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::POST, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };
    req_builder = req_builder.json(&params.create_api_key_params);

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<CreateApiKeySuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<CreateApiKeyError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Create a new app in the current account.
pub async fn create_app(configuration: &configuration::Configuration, params: CreateAppParams) -> Result<ResponseContent<CreateAppSuccess>, Error<CreateAppError>> {

    let uri_str = format!("{}/apps", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::POST, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };
    req_builder = req_builder.json(&params.create_app_params);

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<CreateAppSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<CreateAppError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Associates an authenticator with your account, where the authenticator is identified by the URL with an otpauth URI scheme.
pub async fn create_authenticator(configuration: &configuration::Configuration, params: CreateAuthenticatorParams) -> Result<ResponseContent<CreateAuthenticatorSuccess>, Error<CreateAuthenticatorError>> {

    let uri_str = format!("{}/accounts/authenticator", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::POST, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };
    req_builder = req_builder.json(&params.create_authenticator_params);

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<CreateAuthenticatorSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<CreateAuthenticatorError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Create a new catalog object in the currently authenticated account.
pub async fn create_catalog(configuration: &configuration::Configuration, params: CreateCatalogParams) -> Result<ResponseContent<CreateCatalogSuccess>, Error<CreateCatalogError>> {

    let uri_str = format!("{}/catalogs", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::POST, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };
    req_builder = req_builder.json(&params.create_catalog_params);

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<CreateCatalogSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<CreateCatalogError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Creates a new device login ticket and returns the codes and urls needed for authentication.
pub async fn create_device_login_ticket(configuration: &configuration::Configuration) -> Result<ResponseContent<CreateDeviceLoginTicketSuccess>, Error<CreateDeviceLoginTicketError>> {

    let uri_str = format!("{}/login/device", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::GET, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<CreateDeviceLoginTicketSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<CreateDeviceLoginTicketError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Starts the password reset process for an account. If an email address exists for the account supplied, you will get a reset password email.
pub async fn create_password_reset(configuration: &configuration::Configuration, params: CreatePasswordResetParams) -> Result<ResponseContent<CreatePasswordResetSuccess>, Error<CreatePasswordResetError>> {

    let uri_str = format!("{}/accounts/password-reset", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::POST, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    req_builder = req_builder.json(&params.create_password_reset_params);

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<CreatePasswordResetSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<CreatePasswordResetError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Create a new schedule for an app.
pub async fn create_schedule(configuration: &configuration::Configuration, params: CreateScheduleParams) -> Result<ResponseContent<CreateScheduleSuccess>, Error<CreateScheduleError>> {

    let uri_str = format!("{}/schedules", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::POST, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };
    req_builder = req_builder.json(&params.create_schedule_params);

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<CreateScheduleSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<CreateScheduleError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Creates a new secret and associates it with the current account.
pub async fn create_secret(configuration: &configuration::Configuration, params: CreateSecretParams) -> Result<ResponseContent<CreateSecretSuccess>, Error<CreateSecretError>> {

    let uri_str = format!("{}/secrets", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::POST, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };
    req_builder = req_builder.json(&params.create_secret_params);

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<CreateSecretSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<CreateSecretError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Create a new session and return it.
pub async fn create_session(configuration: &configuration::Configuration, params: CreateSessionParams) -> Result<ResponseContent<CreateSessionSuccess>, Error<CreateSessionError>> {

    let uri_str = format!("{}/session", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::POST, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    req_builder = req_builder.json(&params.create_session_params);

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<CreateSessionSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<CreateSessionError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Create a new team
pub async fn create_team(configuration: &configuration::Configuration, params: CreateTeamParams) -> Result<ResponseContent<CreateTeamSuccess>, Error<CreateTeamError>> {

    let uri_str = format!("{}/teams", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::POST, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };
    req_builder = req_builder.json(&params.create_team_params);

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<CreateTeamSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<CreateTeamError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Permanently delete an alert
pub async fn delete_alert(configuration: &configuration::Configuration, params: DeleteAlertParams) -> Result<ResponseContent<DeleteAlertSuccess>, Error<DeleteAlertError>> {

    let uri_str = format!("{}/alerts/{alert_id}", configuration.base_path, alert_id=crate::apis::urlencode(params.alert_id));
    let mut req_builder = configuration.client.request(reqwest::Method::DELETE, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<DeleteAlertSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<DeleteAlertError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

pub async fn delete_api_key(configuration: &configuration::Configuration, params: DeleteApiKeyParams) -> Result<ResponseContent<DeleteApiKeySuccess>, Error<DeleteApiKeyError>> {

    let uri_str = format!("{}/api-keys", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::DELETE, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };
    req_builder = req_builder.json(&params.delete_api_key_params);

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<DeleteApiKeySuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<DeleteApiKeyError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Delete one of your apps, the associated code, and all the runs as well.
pub async fn delete_app(configuration: &configuration::Configuration, params: DeleteAppParams) -> Result<ResponseContent<DeleteAppSuccess>, Error<DeleteAppError>> {

    let uri_str = format!("{}/apps/{slug}", configuration.base_path, slug=crate::apis::urlencode(params.slug));
    let mut req_builder = configuration.client.request(reqwest::Method::DELETE, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<DeleteAppSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<DeleteAppError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Removes an authenticator from your account so you're no longer required to provide it at login.
pub async fn delete_authenticator(configuration: &configuration::Configuration, params: DeleteAuthenticatorParams) -> Result<ResponseContent<DeleteAuthenticatorSuccess>, Error<DeleteAuthenticatorError>> {

    let uri_str = format!("{}/accounts/authenticator", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::DELETE, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };
    req_builder = req_builder.json(&params.delete_authenticator_params);

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<DeleteAuthenticatorSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<DeleteAuthenticatorError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Delete a new catalog object in the currently authenticated account.
pub async fn delete_catalog(configuration: &configuration::Configuration, params: DeleteCatalogParams) -> Result<ResponseContent<DeleteCatalogSuccess>, Error<DeleteCatalogError>> {

    let uri_str = format!("{}/catalogs/{slug}", configuration.base_path, slug=crate::apis::urlencode(params.slug));
    let mut req_builder = configuration.client.request(reqwest::Method::DELETE, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<DeleteCatalogSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<DeleteCatalogError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Delete an existing schedule for an app.
pub async fn delete_schedule(configuration: &configuration::Configuration, params: DeleteScheduleParams) -> Result<ResponseContent<DeleteScheduleSuccess>, Error<DeleteScheduleError>> {

    let uri_str = format!("{}/schedules/{id}", configuration.base_path, id=crate::apis::urlencode(params.id));
    let mut req_builder = configuration.client.request(reqwest::Method::DELETE, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<DeleteScheduleSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<DeleteScheduleError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Delete a secret by name.
pub async fn delete_secret(configuration: &configuration::Configuration, params: DeleteSecretParams) -> Result<ResponseContent<DeleteSecretSuccess>, Error<DeleteSecretError>> {

    let uri_str = format!("{}/secrets/{name}", configuration.base_path, name=crate::apis::urlencode(params.name));
    let mut req_builder = configuration.client.request(reqwest::Method::DELETE, &uri_str);

    if let Some(ref param_value) = params.environment {
        req_builder = req_builder.query(&[("environment", &param_value.to_string())]);
    }
    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<DeleteSecretSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<DeleteSecretError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Delete a new team
pub async fn delete_team(configuration: &configuration::Configuration, params: DeleteTeamParams) -> Result<ResponseContent<DeleteTeamSuccess>, Error<DeleteTeamError>> {

    let uri_str = format!("{}/teams", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::DELETE, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };
    req_builder = req_builder.json(&params.delete_team_params);

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<DeleteTeamSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<DeleteTeamError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Delete a pending team invitation that you have previously sent
pub async fn delete_team_invitation(configuration: &configuration::Configuration, params: DeleteTeamInvitationParams) -> Result<ResponseContent<DeleteTeamInvitationSuccess>, Error<DeleteTeamInvitationError>> {

    let uri_str = format!("{}/teams/{slug}/invites", configuration.base_path, slug=crate::apis::urlencode(params.slug));
    let mut req_builder = configuration.client.request(reqwest::Method::DELETE, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };
    req_builder = req_builder.json(&params.delete_team_invitation_params);

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<DeleteTeamInvitationSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<DeleteTeamInvitationError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Deploy a new version of an app. Reads the request body, which is a TAR file (or a GZipped TAR file) and creates a new deployment for an app based on that file.
pub async fn deploy_app(configuration: &configuration::Configuration, params: DeployAppParams) -> Result<ResponseContent<DeployAppSuccess>, Error<DeployAppError>> {

    let uri_str = format!("{}/apps/{slug}/deploy", configuration.base_path, slug=crate::apis::urlencode(params.slug));
    let mut req_builder = configuration.client.request(reqwest::Method::POST, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(param_value) = params.content_encoding {
        req_builder = req_builder.header("Content-Encoding", param_value.to_string());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<DeployAppSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<DeployAppError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Get all the runs for the current account.
pub async fn describe_app(configuration: &configuration::Configuration, params: DescribeAppParams) -> Result<ResponseContent<DescribeAppSuccess>, Error<DescribeAppError>> {

    let uri_str = format!("{}/apps/{slug}", configuration.base_path, slug=crate::apis::urlencode(params.slug));
    let mut req_builder = configuration.client.request(reqwest::Method::GET, &uri_str);

    if let Some(ref param_value) = params.runs {
        req_builder = req_builder.query(&[("runs", &param_value.to_string())]);
    }
    if let Some(ref param_value) = params.start_at {
        req_builder = req_builder.query(&[("start_at", &param_value.to_string())]);
    }
    if let Some(ref param_value) = params.end_at {
        req_builder = req_builder.query(&[("end_at", &param_value.to_string())]);
    }
    if let Some(ref param_value) = params.timezone {
        req_builder = req_builder.query(&[("timezone", &param_value.to_string())]);
    }
    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<DescribeAppSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<DescribeAppError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Describe an app version for an app in the current account.
pub async fn describe_app_version(configuration: &configuration::Configuration, params: DescribeAppVersionParams) -> Result<ResponseContent<DescribeAppVersionSuccess>, Error<DescribeAppVersionError>> {

    let uri_str = format!("{}/apps/{name}/versions/{num}", configuration.base_path, name=crate::apis::urlencode(params.name), num=crate::apis::urlencode(params.num));
    let mut req_builder = configuration.client.request(reqwest::Method::GET, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<DescribeAppVersionSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<DescribeAppVersionError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Checks if a device login code has been claimed and returns the user session if so.
pub async fn describe_device_login_session(configuration: &configuration::Configuration, params: DescribeDeviceLoginSessionParams) -> Result<ResponseContent<DescribeDeviceLoginSessionSuccess>, Error<DescribeDeviceLoginSessionError>> {

    let uri_str = format!("{}/login/device/{device_code}", configuration.base_path, device_code=crate::apis::urlencode(params.device_code));
    let mut req_builder = configuration.client.request(reqwest::Method::GET, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<DescribeDeviceLoginSessionSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<DescribeDeviceLoginSessionError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Describe a run of an app.
pub async fn describe_run(configuration: &configuration::Configuration, params: DescribeRunParams) -> Result<ResponseContent<DescribeRunSuccess>, Error<DescribeRunError>> {

    let uri_str = format!("{}/apps/{slug}/runs/{seq}", configuration.base_path, slug=crate::apis::urlencode(params.slug), seq=params.seq);
    let mut req_builder = configuration.client.request(reqwest::Method::GET, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref apikey) = configuration.api_key {
        let key = apikey.key.clone();
        let value = match apikey.prefix {
            Some(ref prefix) => format!("{} {}", prefix, key),
            None => key,
        };
        req_builder = req_builder.header("X-API-Key", value);
    };
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<DescribeRunSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<DescribeRunError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Retrieves the logs associated with a particular run of an app.
pub async fn describe_run_logs(configuration: &configuration::Configuration, params: DescribeRunLogsParams) -> Result<ResponseContent<DescribeRunLogsSuccess>, Error<DescribeRunLogsError>> {

    let uri_str = format!("{}/apps/{slug}/runs/{seq}/logs", configuration.base_path, slug=crate::apis::urlencode(params.slug), seq=params.seq);
    let mut req_builder = configuration.client.request(reqwest::Method::GET, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<DescribeRunLogsSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<DescribeRunLogsError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Gets the encryption key used for encrypting secrets that you want to create in Tower.
pub async fn describe_secrets_key(configuration: &configuration::Configuration, params: DescribeSecretsKeyParams) -> Result<ResponseContent<DescribeSecretsKeySuccess>, Error<DescribeSecretsKeyError>> {

    let uri_str = format!("{}/secrets/key", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::GET, &uri_str);

    if let Some(ref param_value) = params.format {
        req_builder = req_builder.query(&[("format", &param_value.to_string())]);
    }
    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<DescribeSecretsKeySuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<DescribeSecretsKeyError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Validate your current session and return the user information associated with the session.
pub async fn describe_session(configuration: &configuration::Configuration) -> Result<ResponseContent<DescribeSessionSuccess>, Error<DescribeSessionError>> {

    let uri_str = format!("{}/session", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::GET, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<DescribeSessionSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<DescribeSessionError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Lists all the catalogs in your current account and re-encrypt them with the public key you supplied.
pub async fn export_catalogs(configuration: &configuration::Configuration, params: ExportCatalogsParams) -> Result<ResponseContent<ExportCatalogsSuccess>, Error<ExportCatalogsError>> {

    let uri_str = format!("{}/catalogs/export", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::POST, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };
    req_builder = req_builder.json(&params.export_catalogs_params);

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<ExportCatalogsSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<ExportCatalogsError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Lists all the secrets in your current account and re-encrypt them with the public key you supplied.
pub async fn export_secrets(configuration: &configuration::Configuration, params: ExportSecretsParams) -> Result<ResponseContent<ExportSecretsSuccess>, Error<ExportSecretsError>> {

    let uri_str = format!("{}/secrets/export", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::POST, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };
    req_builder = req_builder.json(&params.export_secrets_params);

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<ExportSecretsSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<ExportSecretsError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Generates current statistics about apps
pub async fn generate_app_statistics(configuration: &configuration::Configuration) -> Result<ResponseContent<GenerateAppStatisticsSuccess>, Error<GenerateAppStatisticsError>> {

    let uri_str = format!("{}/stats/apps", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::GET, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<GenerateAppStatisticsSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<GenerateAppStatisticsError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Generates a new authenticator for the user. This is used to set up two-factor authentication.
pub async fn generate_authenticator(configuration: &configuration::Configuration) -> Result<ResponseContent<GenerateAuthenticatorSuccess>, Error<GenerateAuthenticatorError>> {

    let uri_str = format!("{}/accounts/authenticator/generate", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::POST, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<GenerateAuthenticatorSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<GenerateAuthenticatorError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Generates statistics about runs over a specified time period.
pub async fn generate_run_statistics(configuration: &configuration::Configuration, params: GenerateRunStatisticsParams) -> Result<ResponseContent<GenerateRunStatisticsSuccess>, Error<GenerateRunStatisticsError>> {

    let uri_str = format!("{}/stats/runs", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::GET, &uri_str);

    if let Some(ref param_value) = params.status {
        req_builder = match "csv" {
            "multi" => req_builder.query(&param_value.into_iter().map(|p| ("status".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => req_builder.query(&[("status", &param_value.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    req_builder = req_builder.query(&[("start_at", &params.start_at.to_string())]);
    req_builder = req_builder.query(&[("end_at", &params.end_at.to_string())]);
    if let Some(ref param_value) = params.timezone {
        req_builder = req_builder.query(&[("timezone", &param_value.to_string())]);
    }
    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<GenerateRunStatisticsSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<GenerateRunStatisticsError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Uses your current authentication context to generate runner credentials that are used for authenticating runner requests
pub async fn generate_runner_credentials(configuration: &configuration::Configuration) -> Result<ResponseContent<GenerateRunnerCredentialsSuccess>, Error<GenerateRunnerCredentialsError>> {

    let uri_str = format!("{}/runners/credentials", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::POST, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref apikey) = configuration.api_key {
        let key = apikey.key.clone();
        let value = match apikey.prefix {
            Some(ref prefix) => format!("{} {}", prefix, key),
            None => key,
        };
        req_builder = req_builder.header("X-API-Key", value);
    };
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<GenerateRunnerCredentialsSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<GenerateRunnerCredentialsError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Invite a new team
pub async fn invite_team_member(configuration: &configuration::Configuration, params: InviteTeamMemberParams) -> Result<ResponseContent<InviteTeamMemberSuccess>, Error<InviteTeamMemberError>> {

    let uri_str = format!("{}/teams/{slug}/invites", configuration.base_path, slug=crate::apis::urlencode(params.slug));
    let mut req_builder = configuration.client.request(reqwest::Method::POST, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };
    req_builder = req_builder.json(&params.invite_team_member_params);

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<InviteTeamMemberSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<InviteTeamMemberError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Remove yourself from a team, if that's something you'd like to do for whatever reason. If you're the last member of a team, you cannot remove yourself. You should delete the team instead.
pub async fn leave_team(configuration: &configuration::Configuration, params: LeaveTeamParams) -> Result<ResponseContent<LeaveTeamSuccess>, Error<LeaveTeamError>> {

    let uri_str = format!("{}/teams/{slug}/leave", configuration.base_path, slug=crate::apis::urlencode(params.slug));
    let mut req_builder = configuration.client.request(reqwest::Method::POST, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<LeaveTeamSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<LeaveTeamError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// List alerts for the current account with optional filtering
pub async fn list_alerts(configuration: &configuration::Configuration, params: ListAlertsParams) -> Result<ResponseContent<ListAlertsSuccess>, Error<ListAlertsError>> {

    let uri_str = format!("{}/alerts", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::GET, &uri_str);

    if let Some(ref param_value) = params.alert_type {
        req_builder = req_builder.query(&[("alert_type", &param_value.to_string())]);
    }
    if let Some(ref param_value) = params.start_at {
        req_builder = req_builder.query(&[("start_at", &param_value.to_string())]);
    }
    if let Some(ref param_value) = params.end_at {
        req_builder = req_builder.query(&[("end_at", &param_value.to_string())]);
    }
    if let Some(ref param_value) = params.page {
        req_builder = req_builder.query(&[("page", &param_value.to_string())]);
    }
    if let Some(ref param_value) = params.page_size {
        req_builder = req_builder.query(&[("page_size", &param_value.to_string())]);
    }
    if let Some(ref param_value) = params.acked {
        req_builder = req_builder.query(&[("acked", &param_value.to_string())]);
    }
    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<ListAlertsSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<ListAlertsError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// List all the API keys associated with your current account.
pub async fn list_api_keys(configuration: &configuration::Configuration) -> Result<ResponseContent<ListApiKeysSuccess>, Error<ListApiKeysError>> {

    let uri_str = format!("{}/api-keys", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::GET, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<ListApiKeysSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<ListApiKeysError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Generates a list of all the known environments for a given app in the current account.
pub async fn list_app_environments(configuration: &configuration::Configuration, params: ListAppEnvironmentsParams) -> Result<ResponseContent<ListAppEnvironmentsSuccess>, Error<ListAppEnvironmentsError>> {

    let uri_str = format!("{}/apps/{slug}/environments", configuration.base_path, slug=crate::apis::urlencode(params.slug));
    let mut req_builder = configuration.client.request(reqwest::Method::GET, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<ListAppEnvironmentsSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<ListAppEnvironmentsError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// List all versions of an app in the current account, sorted with the most recent first.
pub async fn list_app_versions(configuration: &configuration::Configuration, params: ListAppVersionsParams) -> Result<ResponseContent<ListAppVersionsSuccess>, Error<ListAppVersionsError>> {

    let uri_str = format!("{}/apps/{name}/versions", configuration.base_path, name=crate::apis::urlencode(params.name));
    let mut req_builder = configuration.client.request(reqwest::Method::GET, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<ListAppVersionsSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<ListAppVersionsError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Get all the apps for the current account.
pub async fn list_apps(configuration: &configuration::Configuration, params: ListAppsParams) -> Result<ResponseContent<ListAppsSuccess>, Error<ListAppsError>> {

    let uri_str = format!("{}/apps", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::GET, &uri_str);

    if let Some(ref param_value) = params.query {
        req_builder = req_builder.query(&[("query", &param_value.to_string())]);
    }
    if let Some(ref param_value) = params.page {
        req_builder = req_builder.query(&[("page", &param_value.to_string())]);
    }
    if let Some(ref param_value) = params.page_size {
        req_builder = req_builder.query(&[("page_size", &param_value.to_string())]);
    }
    if let Some(ref param_value) = params.num_runs {
        req_builder = req_builder.query(&[("num_runs", &param_value.to_string())]);
    }
    if let Some(ref param_value) = params.sort {
        req_builder = req_builder.query(&[("sort", &param_value.to_string())]);
    }
    if let Some(ref param_value) = params.filter {
        req_builder = req_builder.query(&[("filter", &param_value.to_string())]);
    }
    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref apikey) = configuration.api_key {
        let key = apikey.key.clone();
        let value = match apikey.prefix {
            Some(ref prefix) => format!("{} {}", prefix, key),
            None => key,
        };
        req_builder = req_builder.header("X-API-Key", value);
    };
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<ListAppsSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<ListAppsError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Enumerates the authenticators associated with the current users' account
pub async fn list_authenticators(configuration: &configuration::Configuration) -> Result<ResponseContent<ListAuthenticatorsSuccess>, Error<ListAuthenticatorsError>> {

    let uri_str = format!("{}/accounts/authenticator", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::GET, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<ListAuthenticatorsSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<ListAuthenticatorsError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Lists all the catalogs associated with your current account.
pub async fn list_catalogs(configuration: &configuration::Configuration, params: ListCatalogsParams) -> Result<ResponseContent<ListCatalogsSuccess>, Error<ListCatalogsError>> {

    let uri_str = format!("{}/catalogs", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::GET, &uri_str);

    if let Some(ref param_value) = params.environment {
        req_builder = req_builder.query(&[("environment", &param_value.to_string())]);
    }
    if let Some(ref param_value) = params.all {
        req_builder = req_builder.query(&[("all", &param_value.to_string())]);
    }
    if let Some(ref param_value) = params.page {
        req_builder = req_builder.query(&[("page", &param_value.to_string())]);
    }
    if let Some(ref param_value) = params.page_size {
        req_builder = req_builder.query(&[("page_size", &param_value.to_string())]);
    }
    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<ListCatalogsSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<ListCatalogsError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// List your pending invitations for teams
pub async fn list_my_team_invitations(configuration: &configuration::Configuration) -> Result<ResponseContent<ListMyTeamInvitationsSuccess>, Error<ListMyTeamInvitationsError>> {

    let uri_str = format!("{}/team-invites", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::GET, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<ListMyTeamInvitationsSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<ListMyTeamInvitationsError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Generates a list of all the runs for a given app. The list is paginated based on the query string parameters passed in.
pub async fn list_runs(configuration: &configuration::Configuration, params: ListRunsParams) -> Result<ResponseContent<ListRunsSuccess>, Error<ListRunsError>> {

    let uri_str = format!("{}/apps/{slug}/runs", configuration.base_path, slug=crate::apis::urlencode(params.slug));
    let mut req_builder = configuration.client.request(reqwest::Method::GET, &uri_str);

    if let Some(ref param_value) = params.page {
        req_builder = req_builder.query(&[("page", &param_value.to_string())]);
    }
    if let Some(ref param_value) = params.page_size {
        req_builder = req_builder.query(&[("page_size", &param_value.to_string())]);
    }
    if let Some(ref param_value) = params.status {
        req_builder = match "csv" {
            "multi" => req_builder.query(&param_value.into_iter().map(|p| ("status".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => req_builder.query(&[("status", &param_value.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref param_value) = params.start_at {
        req_builder = req_builder.query(&[("start_at", &param_value.to_string())]);
    }
    if let Some(ref param_value) = params.end_at {
        req_builder = req_builder.query(&[("end_at", &param_value.to_string())]);
    }
    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<ListRunsSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<ListRunsError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// List all schedules for an app.
pub async fn list_schedules(configuration: &configuration::Configuration, params: ListSchedulesParams) -> Result<ResponseContent<ListSchedulesSuccess>, Error<ListSchedulesError>> {

    let uri_str = format!("{}/schedules", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::GET, &uri_str);

    if let Some(ref param_value) = params.page {
        req_builder = req_builder.query(&[("page", &param_value.to_string())]);
    }
    if let Some(ref param_value) = params.page_size {
        req_builder = req_builder.query(&[("page_size", &param_value.to_string())]);
    }
    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<ListSchedulesSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<ListSchedulesError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Lists all the environments associated with secrets.
pub async fn list_secret_environments(configuration: &configuration::Configuration) -> Result<ResponseContent<ListSecretEnvironmentsSuccess>, Error<ListSecretEnvironmentsError>> {

    let uri_str = format!("{}/secrets/environments", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::GET, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<ListSecretEnvironmentsSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<ListSecretEnvironmentsError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Lists all the secrets associated with your current account.
pub async fn list_secrets(configuration: &configuration::Configuration, params: ListSecretsParams) -> Result<ResponseContent<ListSecretsSuccess>, Error<ListSecretsError>> {

    let uri_str = format!("{}/secrets", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::GET, &uri_str);

    if let Some(ref param_value) = params.environment {
        req_builder = req_builder.query(&[("environment", &param_value.to_string())]);
    }
    if let Some(ref param_value) = params.all {
        req_builder = req_builder.query(&[("all", &param_value.to_string())]);
    }
    if let Some(ref param_value) = params.page {
        req_builder = req_builder.query(&[("page", &param_value.to_string())]);
    }
    if let Some(ref param_value) = params.page_size {
        req_builder = req_builder.query(&[("page_size", &param_value.to_string())]);
    }
    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<ListSecretsSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<ListSecretsError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// List the pending invitations for a team
pub async fn list_team_invitations(configuration: &configuration::Configuration, params: ListTeamInvitationsParams) -> Result<ResponseContent<ListTeamInvitationsSuccess>, Error<ListTeamInvitationsError>> {

    let uri_str = format!("{}/teams/{slug}/invites", configuration.base_path, slug=crate::apis::urlencode(params.slug));
    let mut req_builder = configuration.client.request(reqwest::Method::GET, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<ListTeamInvitationsSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<ListTeamInvitationsError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// List the members of a team
pub async fn list_team_members(configuration: &configuration::Configuration, params: ListTeamMembersParams) -> Result<ResponseContent<ListTeamMembersSuccess>, Error<ListTeamMembersError>> {

    let uri_str = format!("{}/teams/{slug}/members", configuration.base_path, slug=crate::apis::urlencode(params.slug));
    let mut req_builder = configuration.client.request(reqwest::Method::GET, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<ListTeamMembersSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<ListTeamMembersError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// List all the teams that the user is a member of.
pub async fn list_teams(configuration: &configuration::Configuration) -> Result<ResponseContent<ListTeamsSuccess>, Error<ListTeamsError>> {

    let uri_str = format!("{}/teams", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::GET, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<ListTeamsSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<ListTeamsError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Returns a new session based on the supplied authentication context. This is helpful when clients want to use POST instead of GET to check session information.
pub async fn refresh_session(configuration: &configuration::Configuration, params: RefreshSessionParams) -> Result<ResponseContent<RefreshSessionSuccess>, Error<RefreshSessionError>> {

    let uri_str = format!("{}/session/refresh", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::POST, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };
    req_builder = req_builder.json(&params.refresh_session_params);

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<RefreshSessionSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<RefreshSessionError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Remove a new team
pub async fn remove_team_member(configuration: &configuration::Configuration, params: RemoveTeamMemberParams) -> Result<ResponseContent<RemoveTeamMemberSuccess>, Error<RemoveTeamMemberError>> {

    let uri_str = format!("{}/teams/{slug}/members", configuration.base_path, slug=crate::apis::urlencode(params.slug));
    let mut req_builder = configuration.client.request(reqwest::Method::DELETE, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };
    req_builder = req_builder.json(&params.remove_team_member_params);

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<RemoveTeamMemberSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<RemoveTeamMemberError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Resend a team invitation to a user if they need a reminder or if they lost it
pub async fn resend_team_invitation(configuration: &configuration::Configuration, params: ResendTeamInvitationParams) -> Result<ResponseContent<ResendTeamInvitationSuccess>, Error<ResendTeamInvitationError>> {

    let uri_str = format!("{}/teams/{slug}/invites/resend", configuration.base_path, slug=crate::apis::urlencode(params.slug));
    let mut req_builder = configuration.client.request(reqwest::Method::POST, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };
    req_builder = req_builder.json(&params.resend_team_invitation_params);

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<ResendTeamInvitationSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<ResendTeamInvitationError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Runs an app with the supplied parameters.
pub async fn run_app(configuration: &configuration::Configuration, params: RunAppParams) -> Result<ResponseContent<RunAppSuccess>, Error<RunAppError>> {

    let uri_str = format!("{}/apps/{slug}/runs", configuration.base_path, slug=crate::apis::urlencode(params.slug));
    let mut req_builder = configuration.client.request(reqwest::Method::POST, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref apikey) = configuration.api_key {
        let key = apikey.key.clone();
        let value = match apikey.prefix {
            Some(ref prefix) => format!("{} {}", prefix, key),
            None => key,
        };
        req_builder = req_builder.header("X-API-Key", value);
    };
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };
    req_builder = req_builder.json(&params.run_app_params);

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<RunAppSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<RunAppError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Search, filter, and list runs across all of the apps in your account.
pub async fn search_runs(configuration: &configuration::Configuration, params: SearchRunsParams) -> Result<ResponseContent<SearchRunsSuccess>, Error<SearchRunsError>> {

    let uri_str = format!("{}/runs", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::GET, &uri_str);

    if let Some(ref param_value) = params.page {
        req_builder = req_builder.query(&[("page", &param_value.to_string())]);
    }
    if let Some(ref param_value) = params.page_size {
        req_builder = req_builder.query(&[("page_size", &param_value.to_string())]);
    }
    if let Some(ref param_value) = params.status {
        req_builder = match "csv" {
            "multi" => req_builder.query(&param_value.into_iter().map(|p| ("status".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => req_builder.query(&[("status", &param_value.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref param_value) = params.start_at {
        req_builder = req_builder.query(&[("start_at", &param_value.to_string())]);
    }
    if let Some(ref param_value) = params.end_at {
        req_builder = req_builder.query(&[("end_at", &param_value.to_string())]);
    }
    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<SearchRunsSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<SearchRunsError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Streams alert notifications in real-time
pub async fn stream_alerts(configuration: &configuration::Configuration) -> Result<ResponseContent<StreamAlertsSuccess>, Error<StreamAlertsError>> {

    let uri_str = format!("{}/alerts/stream", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::GET, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<StreamAlertsSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<StreamAlertsError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Streams the logs associated with a particular run of an app in real-time.
pub async fn stream_run_logs(configuration: &configuration::Configuration, params: StreamRunLogsParams) -> Result<ResponseContent<StreamRunLogsSuccess>, Error<StreamRunLogsError>> {

    let uri_str = format!("{}/apps/{slug}/runs/{seq}/logs/stream", configuration.base_path, slug=crate::apis::urlencode(params.slug), seq=params.seq);
    let mut req_builder = configuration.client.request(reqwest::Method::GET, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<StreamRunLogsSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<StreamRunLogsError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Update the slug for an account
pub async fn update_account_slug(configuration: &configuration::Configuration, params: UpdateAccountSlugParams) -> Result<ResponseContent<UpdateAccountSlugSuccess>, Error<UpdateAccountSlugError>> {

    let uri_str = format!("{}/accounts/{slug}", configuration.base_path, slug=crate::apis::urlencode(params.slug));
    let mut req_builder = configuration.client.request(reqwest::Method::PUT, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };
    req_builder = req_builder.json(&params.update_account_slug_params);

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<UpdateAccountSlugSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<UpdateAccountSlugError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Update an app in the currently authenticated account.
pub async fn update_app(configuration: &configuration::Configuration, params: UpdateAppParams) -> Result<ResponseContent<UpdateAppSuccess>, Error<UpdateAppError>> {

    let uri_str = format!("{}/apps/{name}", configuration.base_path, name=crate::apis::urlencode(params.name));
    let mut req_builder = configuration.client.request(reqwest::Method::PUT, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };
    req_builder = req_builder.json(&params.update_app_params);

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<UpdateAppSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<UpdateAppError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Update a new catalog object in the currently authenticated account.
pub async fn update_catalog(configuration: &configuration::Configuration, params: UpdateCatalogParams) -> Result<ResponseContent<UpdateCatalogSuccess>, Error<UpdateCatalogError>> {

    let uri_str = format!("{}/catalogs/{slug}", configuration.base_path, slug=crate::apis::urlencode(params.slug));
    let mut req_builder = configuration.client.request(reqwest::Method::PUT, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };
    req_builder = req_builder.json(&params.update_catalog_params);

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<UpdateCatalogSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<UpdateCatalogError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Update a team invitation that you have pending
pub async fn update_my_team_invitation(configuration: &configuration::Configuration, params: UpdateMyTeamInvitationParams) -> Result<ResponseContent<UpdateMyTeamInvitationSuccess>, Error<UpdateMyTeamInvitationError>> {

    let uri_str = format!("{}/team-invites", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::PUT, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };
    req_builder = req_builder.json(&params.update_my_team_invitation_params);

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<UpdateMyTeamInvitationSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<UpdateMyTeamInvitationError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Updates the password reset code with the new password
pub async fn update_password_reset(configuration: &configuration::Configuration, params: UpdatePasswordResetParams) -> Result<ResponseContent<UpdatePasswordResetSuccess>, Error<UpdatePasswordResetError>> {

    let uri_str = format!("{}/accounts/password-reset/{code}", configuration.base_path, code=crate::apis::urlencode(params.code));
    let mut req_builder = configuration.client.request(reqwest::Method::POST, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    req_builder = req_builder.json(&params.update_password_reset_params);

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<UpdatePasswordResetSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<UpdatePasswordResetError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Update an existing schedule for an app.
pub async fn update_schedule(configuration: &configuration::Configuration, params: UpdateScheduleParams) -> Result<ResponseContent<UpdateScheduleSuccess>, Error<UpdateScheduleError>> {

    let uri_str = format!("{}/schedules/{id}", configuration.base_path, id=crate::apis::urlencode(params.id));
    let mut req_builder = configuration.client.request(reqwest::Method::PUT, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };
    req_builder = req_builder.json(&params.update_schedule_params);

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<UpdateScheduleSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<UpdateScheduleError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Updates a secret that has previously been created in your account
pub async fn update_secret(configuration: &configuration::Configuration, params: UpdateSecretParams) -> Result<ResponseContent<UpdateSecretSuccess>, Error<UpdateSecretError>> {

    let uri_str = format!("{}/secrets/{name}", configuration.base_path, name=crate::apis::urlencode(params.name));
    let mut req_builder = configuration.client.request(reqwest::Method::PUT, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };
    req_builder = req_builder.json(&params.update_secret_params);

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<UpdateSecretSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<UpdateSecretError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Update a team with a new name or slug. Note that updating the team with a new slug will cause all your URLs to change!
pub async fn update_team(configuration: &configuration::Configuration, params: UpdateTeamParams) -> Result<ResponseContent<UpdateTeamSuccess>, Error<UpdateTeamError>> {

    let uri_str = format!("{}/teams/{slug}", configuration.base_path, slug=crate::apis::urlencode(params.slug));
    let mut req_builder = configuration.client.request(reqwest::Method::PUT, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };
    req_builder = req_builder.json(&params.update_team_params);

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<UpdateTeamSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<UpdateTeamError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

/// Updates your current user profile.
pub async fn update_user(configuration: &configuration::Configuration, params: UpdateUserParams) -> Result<ResponseContent<UpdateUserSuccess>, Error<UpdateUserError>> {

    let uri_str = format!("{}/user", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::PUT, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    if let Some(ref token) = configuration.bearer_access_token {
        req_builder = req_builder.bearer_auth(token.to_owned());
    };
    req_builder = req_builder.json(&params.update_user_params);

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    let tower_trace_id = resp
        .headers()
        .get("x-tower-trace-id")
        .and_then(|v| v.to_str().ok())
        .map_or(String::from(DEFAULT_TOWER_TRACE_ID), String::from);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<UpdateUserSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { tower_trace_id, status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<UpdateUserError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { tower_trace_id, status, content, entity }))
    }
}

