/*
 * Tower API
 *
 * REST API to interact with Tower Services.
 *
 * The version of the OpenAPI document: v0.6.19
 * Contact: hello@tower.dev
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct App {
    /// The date and time this app was created.
    #[serde(rename = "created_at")]
    pub created_at: String,
    /// The health status of this app
    #[serde(rename = "health_status")]
    pub health_status: HealthStatus,
    /// The last run of this app, null if none.
    #[serde(rename = "last_run", skip_serializing_if = "Option::is_none")]
    pub last_run: Option<Box<models::Run>>,
    /// The name of the app.
    #[serde(rename = "name")]
    pub name: String,
    /// The next time this app will run as part of it's schedule, null if none.
    #[serde(rename = "next_run_at", deserialize_with = "Option::deserialize")]
    pub next_run_at: Option<String>,
    /// The account slug that owns this app
    #[serde(rename = "owner")]
    pub owner: String,
    /// The stats of all the runs of this app
    #[serde(rename = "run_results", skip_serializing_if = "Option::is_none")]
    pub run_results: Option<Box<models::RunResults>>,
    /// The schedule associated with this app, null if none.
    #[serde(rename = "schedule", deserialize_with = "Option::deserialize")]
    pub schedule: Option<String>,
    /// A short description of the app. Can be empty.
    #[serde(rename = "short_description")]
    pub short_description: String,
    /// The unique slug of the app.
    #[serde(rename = "slug")]
    pub slug: String,
    /// The status of the app
    #[serde(rename = "status", skip_serializing_if = "Option::is_none")]
    pub status: Option<Status>,
    /// The current version of this app, null if none.
    #[serde(rename = "version", deserialize_with = "Option::deserialize")]
    pub version: Option<String>,
}

impl App {
    pub fn new(created_at: String, health_status: HealthStatus, name: String, next_run_at: Option<String>, owner: String, schedule: Option<String>, short_description: String, slug: String, version: Option<String>) -> App {
        App {
            created_at,
            health_status,
            last_run: None,
            name,
            next_run_at,
            owner,
            run_results: None,
            schedule,
            short_description,
            slug,
            status: None,
            version,
        }
    }
}
/// The health status of this app
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum HealthStatus {
    #[serde(rename = "healthy")]
    Healthy,
    #[serde(rename = "warning")]
    Warning,
}

impl Default for HealthStatus {
    fn default() -> HealthStatus {
        Self::Healthy
    }
}
/// The status of the app
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Status {
    #[serde(rename = "active")]
    Active,
    #[serde(rename = "disabled")]
    Disabled,
}

impl Default for Status {
    fn default() -> Status {
        Self::Active
    }
}

