/*
 * Tower API
 *
 * REST API to interact with Tower Services.
 *
 * The version of the OpenAPI document: v0.6.19
 * Contact: hello@tower.dev
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct CreateAuthenticatorParams {
    /// A URL to the JSON Schema for this object.
    #[serde(rename = "$schema", skip_serializing_if = "Option::is_none")]
    pub schema: Option<String>,
    /// The authenticator URL with an otpauth scheme that identifies this authenticator
    #[serde(rename = "authenticator_url")]
    pub authenticator_url: String,
    /// A code taken from the authenticator as verification that it's correctly configured.
    #[serde(rename = "verification_code")]
    pub verification_code: String,
}

impl CreateAuthenticatorParams {
    pub fn new(authenticator_url: String, verification_code: String) -> CreateAuthenticatorParams {
        CreateAuthenticatorParams {
            schema: None,
            authenticator_url,
            verification_code,
        }
    }
}

