/*
 * Tower API
 *
 * REST API to interact with Tower Services.
 *
 * The version of the OpenAPI document: v0.6.19
 * Contact: hello@tower.dev
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct CreateDeviceLoginTicketResponse {
    /// A URL to the JSON Schema for this object.
    #[serde(rename = "$schema", skip_serializing_if = "Option::is_none")]
    pub schema: Option<String>,
    /// The unique code identifying this device login request.
    #[serde(rename = "device_code")]
    pub device_code: String,
    /// Number of seconds until this request expires.
    #[serde(rename = "expires_in")]
    pub expires_in: i64,
    /// When this device login request was created.
    #[serde(rename = "generated_at")]
    pub generated_at: String,
    /// Number of seconds to wait between polling attempts.
    #[serde(rename = "interval")]
    pub interval: i64,
    /// The URL where the user should go to enter the user code.
    #[serde(rename = "login_url")]
    pub login_url: String,
    /// The code that the user needs to enter to authenticate.
    #[serde(rename = "user_code")]
    pub user_code: String,
    /// The URL that the device should poll to check authentication status.
    #[serde(rename = "verification_url")]
    pub verification_url: String,
}

impl CreateDeviceLoginTicketResponse {
    pub fn new(device_code: String, expires_in: i64, generated_at: String, interval: i64, login_url: String, user_code: String, verification_url: String) -> CreateDeviceLoginTicketResponse {
        CreateDeviceLoginTicketResponse {
            schema: None,
            device_code,
            expires_in,
            generated_at,
            interval,
            login_url,
            user_code,
            verification_url,
        }
    }
}

