/*
 * Tower API
 *
 * REST API to interact with Tower Services.
 *
 * The version of the OpenAPI document: v0.6.19
 * Contact: hello@tower.dev
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct ErrorModel {
    /// A URL to the JSON Schema for this object.
    #[serde(rename = "$schema", skip_serializing_if = "Option::is_none")]
    pub schema: Option<String>,
    /// A human-readable explanation specific to this occurrence of the problem.
    #[serde(rename = "detail", skip_serializing_if = "Option::is_none")]
    pub detail: Option<String>,
    /// Optional list of individual error details
    #[serde(rename = "errors", skip_serializing_if = "Option::is_none")]
    pub errors: Option<Vec<models::ErrorDetail>>,
    /// A URI reference that identifies the specific occurrence of the problem.
    #[serde(rename = "instance", skip_serializing_if = "Option::is_none")]
    pub instance: Option<String>,
    /// HTTP status code
    #[serde(rename = "status", skip_serializing_if = "Option::is_none")]
    pub status: Option<i64>,
    /// A short, human-readable summary of the problem type. This value should not change between occurrences of the error.
    #[serde(rename = "title", skip_serializing_if = "Option::is_none")]
    pub title: Option<String>,
    /// A URI reference to human-readable documentation for the error.
    #[serde(rename = "type", skip_serializing_if = "Option::is_none")]
    pub r#type: Option<String>,
}

impl ErrorModel {
    pub fn new() -> ErrorModel {
        ErrorModel {
            schema: None,
            detail: None,
            errors: None,
            instance: None,
            status: None,
            title: None,
            r#type: None,
        }
    }
}

