/*
 * Tower API
 *
 * REST API to interact with Tower Services.
 *
 * The version of the OpenAPI document: v0.6.19
 * Contact: hello@tower.dev
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExportSecretsParams {
    /// A URL to the JSON Schema for this object.
    #[serde(rename = "$schema", skip_serializing_if = "Option::is_none")]
    pub schema: Option<String>,
    /// Whether to fetch all secrets or only the ones that are not marked as deleted.
    #[serde(rename = "all")]
    pub all: bool,
    /// The environment to filter by.
    #[serde(rename = "environment")]
    pub environment: String,
    /// The page number to fetch.
    #[serde(rename = "page")]
    pub page: i64,
    /// The number of records to fetch on each page.
    #[serde(rename = "page_size")]
    pub page_size: i64,
    /// The PEM-encoded public key you want to use to encrypt sensitive secret values.
    #[serde(rename = "public_key")]
    pub public_key: String,
}

impl ExportSecretsParams {
    pub fn new(all: bool, environment: String, page: i64, page_size: i64, public_key: String) -> ExportSecretsParams {
        ExportSecretsParams {
            schema: None,
            all,
            environment,
            page,
            page_size,
            public_key,
        }
    }
}

