/*
 * Tower API
 *
 * REST API to interact with Tower Services.
 *
 * The version of the OpenAPI document: v0.6.19
 * Contact: hello@tower.dev
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct GenerateRunStatisticsResponse {
    /// A URL to the JSON Schema for this object.
    #[serde(rename = "$schema", skip_serializing_if = "Option::is_none")]
    pub schema: Option<String>,
    #[serde(rename = "series")]
    pub series: Vec<models::RunTimeseriesPoint>,
    #[serde(rename = "settings")]
    pub settings: Box<models::StatisticsSettings>,
    #[serde(rename = "stats")]
    pub stats: Box<models::RunStatistics>,
}

impl GenerateRunStatisticsResponse {
    pub fn new(series: Vec<models::RunTimeseriesPoint>, settings: models::StatisticsSettings, stats: models::RunStatistics) -> GenerateRunStatisticsResponse {
        GenerateRunStatisticsResponse {
            schema: None,
            series,
            settings: Box::new(settings),
            stats: Box::new(stats),
        }
    }
}

