/*
 * Tower API
 *
 * REST API to interact with Tower Services.
 *
 * The version of the OpenAPI document: v0.6.19
 * Contact: hello@tower.dev
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct LogLine {
    /// The channel (either Program or Setup) this log line belongs to.
    #[serde(rename = "channel")]
    pub channel: Channel,
    /// Contents of the log message.
    #[serde(rename = "content")]
    pub content: String,
    /// Line number.
    #[serde(rename = "line_num")]
    pub line_num: i64,
    /// Timestamp of the log line.
    #[serde(rename = "reported_at")]
    pub reported_at: String,
    /// The uuid of the Run.
    #[serde(rename = "run_id")]
    pub run_id: String,
}

impl LogLine {
    pub fn new(channel: Channel, content: String, line_num: i64, reported_at: String, run_id: String) -> LogLine {
        LogLine {
            channel,
            content,
            line_num,
            reported_at,
            run_id,
        }
    }
}
/// The channel (either Program or Setup) this log line belongs to.
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Channel {
    #[serde(rename = "program")]
    Program,
    #[serde(rename = "setup")]
    Setup,
}

impl Default for Channel {
    fn default() -> Channel {
        Self::Program
    }
}

