/*
 * Tower API
 *
 * REST API to interact with Tower Services.
 *
 * The version of the OpenAPI document: v0.6.19
 * Contact: hello@tower.dev
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct RefreshSessionResponse {
    /// A URL to the JSON Schema for this object.
    #[serde(rename = "$schema", skip_serializing_if = "Option::is_none")]
    pub schema: Option<String>,
    /// A timestamp that indicates the last time the session data was refreshed.
    #[serde(rename = "refreshed_at")]
    pub refreshed_at: String,
    /// Refresh the current session and return the updated session information.
    #[serde(rename = "session")]
    pub session: Box<models::Session>,
}

impl RefreshSessionResponse {
    pub fn new(refreshed_at: String, session: models::Session) -> RefreshSessionResponse {
        RefreshSessionResponse {
            schema: None,
            refreshed_at,
            session: Box::new(session),
        }
    }
}

