/*
 * Tower API
 *
 * REST API to interact with Tower Services.
 *
 * The version of the OpenAPI document: v0.6.19
 * Contact: hello@tower.dev
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct Run {
    #[serde(rename = "app_name")]
    pub app_name: String,
    #[serde(rename = "app_slug")]
    pub app_slug: String,
    #[serde(rename = "app_version")]
    pub app_version: String,
    #[serde(rename = "cancelled_at", deserialize_with = "Option::deserialize")]
    pub cancelled_at: Option<String>,
    #[serde(rename = "created_at")]
    pub created_at: String,
    #[serde(rename = "ended_at", deserialize_with = "Option::deserialize")]
    pub ended_at: Option<String>,
    #[serde(rename = "environment")]
    pub environment: String,
    /// Exit code of the run, if the run is completed. Null if there is no exit code
    #[serde(rename = "exit_code", deserialize_with = "Option::deserialize")]
    pub exit_code: Option<i64>,
    #[serde(rename = "number")]
    pub number: i64,
    /// Parameters used to invoke this run.
    #[serde(rename = "parameters")]
    pub parameters: Vec<models::RunParameter>,
    #[serde(rename = "run_id")]
    pub run_id: String,
    #[serde(rename = "scheduled_at")]
    pub scheduled_at: String,
    #[serde(rename = "started_at", deserialize_with = "Option::deserialize")]
    pub started_at: Option<String>,
    #[serde(rename = "status")]
    pub status: Status,
    #[serde(rename = "status_group")]
    pub status_group: StatusGroup,
}

impl Run {
    pub fn new(app_name: String, app_slug: String, app_version: String, cancelled_at: Option<String>, created_at: String, ended_at: Option<String>, environment: String, exit_code: Option<i64>, number: i64, parameters: Vec<models::RunParameter>, run_id: String, scheduled_at: String, started_at: Option<String>, status: Status, status_group: StatusGroup) -> Run {
        Run {
            app_name,
            app_slug,
            app_version,
            cancelled_at,
            created_at,
            ended_at,
            environment,
            exit_code,
            number,
            parameters,
            run_id,
            scheduled_at,
            started_at,
            status,
            status_group,
        }
    }
}
/// 
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Status {
    #[serde(rename = "scheduled")]
    Scheduled,
    #[serde(rename = "pending")]
    Pending,
    #[serde(rename = "running")]
    Running,
    #[serde(rename = "crashed")]
    Crashed,
    #[serde(rename = "errored")]
    Errored,
    #[serde(rename = "exited")]
    Exited,
    #[serde(rename = "cancelled")]
    Cancelled,
}

impl Default for Status {
    fn default() -> Status {
        Self::Scheduled
    }
}
/// 
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum StatusGroup {
    #[serde(rename = "successful")]
    Successful,
    #[serde(rename = "failed")]
    Failed,
    #[serde(rename = "")]
    Empty,
}

impl Default for StatusGroup {
    fn default() -> StatusGroup {
        Self::Successful
    }
}

