/*
 * Tower API
 *
 * REST API to interact with Tower Services.
 *
 * The version of the OpenAPI document: v0.6.19
 * Contact: hello@tower.dev
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct Schedule {
    /// The slug of the app that will be executed
    #[serde(rename = "app_slug")]
    pub app_slug: String,
    /// The specific app version to run, or null for the default version
    #[serde(rename = "app_version", skip_serializing_if = "Option::is_none")]
    pub app_version: Option<String>,
    /// The cron expression defining when the app should run
    #[serde(rename = "cron")]
    pub cron: String,
    /// The environment to run the app in
    #[serde(rename = "environment")]
    pub environment: String,
    /// The unique identifier for the schedule
    #[serde(rename = "id")]
    pub id: String,
    /// The parameters to pass when running the app
    #[serde(rename = "parameters", skip_serializing_if = "Option::is_none")]
    pub parameters: Option<Vec<models::RunParameter>>,
}

impl Schedule {
    pub fn new(app_slug: String, cron: String, environment: String, id: String) -> Schedule {
        Schedule {
            app_slug,
            app_version: None,
            cron,
            environment,
            id,
            parameters: None,
        }
    }
}

