/*
 * Tower API
 *
 * REST API to interact with Tower Services.
 *
 * The version of the OpenAPI document: v0.6.19
 * Contact: hello@tower.dev
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct StatisticsSettings {
    /// The end time for the statistics period.
    #[serde(rename = "end_at")]
    pub end_at: String,
    /// The interval for the statistics period.
    #[serde(rename = "interval")]
    pub interval: Interval,
    /// The start time for the statistics period.
    #[serde(rename = "start_at")]
    pub start_at: String,
    /// The time zone for the statistics period.
    #[serde(rename = "timezone")]
    pub timezone: String,
}

impl StatisticsSettings {
    pub fn new(end_at: String, interval: Interval, start_at: String, timezone: String) -> StatisticsSettings {
        StatisticsSettings {
            end_at,
            interval,
            start_at,
            timezone,
        }
    }
}
/// The interval for the statistics period.
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Interval {
    #[serde(rename = "daily")]
    Daily,
    #[serde(rename = "hourly")]
    Hourly,
}

impl Default for Interval {
    fn default() -> Interval {
        Self::Daily
    }
}

