/*
 * Tower API
 *
 * REST API to interact with Tower Services.
 *
 * The version of the OpenAPI document: v0.6.19
 * Contact: hello@tower.dev
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct UnverifiedAuthenticator {
    /// The issuer of the unverified authenticator.
    #[serde(rename = "issuer")]
    pub issuer: String,
    /// The key of the unverified authenticator.
    #[serde(rename = "key")]
    pub key: String,
    /// The label that is used for this unverified authenticator.
    #[serde(rename = "label")]
    pub label: String,
    /// The full URL of the authenticator.
    #[serde(rename = "url")]
    pub url: String,
}

impl UnverifiedAuthenticator {
    pub fn new(issuer: String, key: String, label: String, url: String) -> UnverifiedAuthenticator {
        UnverifiedAuthenticator {
            issuer,
            key,
            label,
            url,
        }
    }
}

