/*
 * Tower API
 *
 * REST API to interact with Tower Services.
 *
 * The version of the OpenAPI document: v0.6.19
 * Contact: hello@tower.dev
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct UpdateCatalogParams {
    /// A URL to the JSON Schema for this object.
    #[serde(rename = "$schema", skip_serializing_if = "Option::is_none")]
    pub schema: Option<String>,
    /// New environment for the catalog
    #[serde(rename = "environment")]
    pub environment: String,
    /// New name for the catalog
    #[serde(rename = "name")]
    pub name: String,
    #[serde(rename = "properties")]
    pub properties: Vec<models::EncryptedCatalogProperty>,
}

impl UpdateCatalogParams {
    pub fn new(environment: String, name: String, properties: Vec<models::EncryptedCatalogProperty>) -> UpdateCatalogParams {
        UpdateCatalogParams {
            schema: None,
            environment,
            name,
            properties,
        }
    }
}

