/*
 * Tower API
 *
 * REST API to interact with Tower Services.
 *
 * The version of the OpenAPI document: v0.6.19
 * Contact: hello@tower.dev
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct UpdateScheduleParams {
    /// A URL to the JSON Schema for this object.
    #[serde(rename = "$schema", skip_serializing_if = "Option::is_none")]
    pub schema: Option<String>,
    /// The slug of the app that this schedule runs
    #[serde(rename = "app_slug")]
    pub app_slug: String,
    /// The specific app version to run (if omitted, will use the app's default version)
    #[serde(rename = "app_version", default, with = "::serde_with::rust::double_option", skip_serializing_if = "Option::is_none")]
    pub app_version: Option<Option<String>>,
    /// The cron expression defining when the app should run
    #[serde(rename = "cron", skip_serializing_if = "Option::is_none")]
    pub cron: Option<String>,
    /// The environment to run the app in
    #[serde(rename = "environment", skip_serializing_if = "Option::is_none")]
    pub environment: Option<String>,
    /// Parameters to pass when running the app
    #[serde(rename = "parameters", skip_serializing_if = "Option::is_none")]
    pub parameters: Option<Vec<models::RunParameter>>,
}

impl UpdateScheduleParams {
    pub fn new(app_slug: String) -> UpdateScheduleParams {
        UpdateScheduleParams {
            schema: None,
            app_slug,
            app_version: None,
            cron: None,
            environment: None,
            parameters: None,
        }
    }
}

