from collections.abc import Mapping
from typing import Any, TypeVar, Union

from attrs import define as _attrs_define

from ..types import UNSET, Unset

T = TypeVar("T", bound="UpdateSecretParams")


@_attrs_define
class UpdateSecretParams:
    """
    Attributes:
        encrypted_value (str):
        environment (str):
        preview (str):
        schema (Union[Unset, str]): A URL to the JSON Schema for this object. Example:
            https://api.tower.dev/v1/schemas/UpdateSecretParams.json.
    """

    encrypted_value: str
    environment: str
    preview: str
    schema: Union[Unset, str] = UNSET

    def to_dict(self) -> dict[str, Any]:
        encrypted_value = self.encrypted_value

        environment = self.environment

        preview = self.preview

        schema = self.schema

        field_dict: dict[str, Any] = {}
        field_dict.update(
            {
                "encrypted_value": encrypted_value,
                "environment": environment,
                "preview": preview,
            }
        )
        if schema is not UNSET:
            field_dict["$schema"] = schema

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        d = dict(src_dict)
        encrypted_value = d.pop("encrypted_value")

        environment = d.pop("environment")

        preview = d.pop("preview")

        schema = d.pop("$schema", UNSET)

        update_secret_params = cls(
            encrypted_value=encrypted_value,
            environment=environment,
            preview=preview,
            schema=schema,
        )

        return update_secret_params
