# Generated by Django 3.1.2 on 2020-11-23 15:03

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Collection",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("title", models.CharField(max_length=256, verbose_name="titre")),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "owner",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "parent",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="resources.collection",
                    ),
                ),
            ],
            options={
                "verbose_name": "collection",
                "verbose_name_plural": "collections",
            },
        ),
        migrations.CreateModel(
            name="CollectionMembership",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("rank", models.IntegerField(default=0, verbose_name="ordre")),
                (
                    "collection",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="resources.collection",
                    ),
                ),
            ],
            options={
                "verbose_name": "ressource <-> collection",
                "verbose_name_plural": "ressources <-> collections",
            },
        ),
        migrations.CreateModel(
            name="FileExtension",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "label",
                    models.CharField(
                        max_length=32, unique=True, verbose_name="extension"
                    ),
                ),
            ],
            options={
                "verbose_name": "extension de fichier",
                "verbose_name_plural": "extensions de fichier",
            },
        ),
        migrations.CreateModel(
            name="Metadata",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("title", models.CharField(max_length=128, verbose_name="titre")),
                ("rank", models.IntegerField(default=0, verbose_name="ordre")),
                (
                    "owner",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "meta-donnée",
                "verbose_name_plural": "meta-données",
            },
        ),
        migrations.CreateModel(
            name="MetadataSet",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("title", models.CharField(max_length=128, verbose_name="titre")),
                (
                    "owner",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "Groupe de meta-données",
                "verbose_name_plural": "Groupes de meta-données",
                "unique_together": {("title", "owner")},
            },
        ),
        migrations.CreateModel(
            name="ResourceClass",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("title", models.CharField(max_length=64, verbose_name="titre")),
                (
                    "verbose_title",
                    models.CharField(max_length=128, verbose_name="titre long"),
                ),
                ("description", models.TextField(verbose_name="Description")),
                (
                    "set",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="resources.metadataset",
                    ),
                ),
            ],
            options={
                "verbose_name": "classe de ressource",
                "verbose_name_plural": "classes de ressources",
            },
        ),
        migrations.CreateModel(
            name="Resource",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("title", models.CharField(max_length=128, verbose_name="titre")),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "collections",
                    models.ManyToManyField(
                        through="resources.CollectionMembership",
                        to="resources.Collection",
                    ),
                ),
                (
                    "resource_class",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="resources.resourceclass",
                    ),
                ),
            ],
            options={
                "verbose_name": "ressource",
                "verbose_name_plural": "ressources",
            },
        ),
        migrations.CreateModel(
            name="MetadataResourceValue",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("value", models.TextField()),
                ("sha1digest", models.CharField(max_length=40, unique=True)),
                (
                    "metadata",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="resources.metadata",
                    ),
                ),
                (
                    "resource",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="resources.resource",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="MetadataCollectionValue",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("value", models.TextField()),
                ("sha1digest", models.CharField(max_length=40, unique=True)),
                (
                    "collection",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="resources.collection",
                    ),
                ),
                (
                    "metadata",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="resources.metadata",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="metadata",
            name="set",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="resources.metadataset"
            ),
        ),
        migrations.CreateModel(
            name="FileType",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("title", models.CharField(max_length=128, verbose_name="titre")),
                (
                    "mime",
                    models.CharField(
                        max_length=128, unique=True, verbose_name="type MIME"
                    ),
                ),
                (
                    "serve_with_iiif",
                    models.BooleanField(default=False, verbose_name="Servir par IIIF"),
                ),
                ("extensions", models.ManyToManyField(to="resources.FileExtension")),
            ],
            options={
                "verbose_name": "type de fichier",
                "verbose_name_plural": "types de fichier",
            },
        ),
        migrations.AddField(
            model_name="collectionmembership",
            name="resource",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="resources.resource"
            ),
        ),
        migrations.AddField(
            model_name="collection",
            name="resources",
            field=models.ManyToManyField(
                through="resources.CollectionMembership", to="resources.Resource"
            ),
        ),
        migrations.AlterUniqueTogether(
            name="metadata",
            unique_together={("title", "set", "owner")},
        ),
        migrations.AlterUniqueTogether(
            name="collectionmembership",
            unique_together={("resource", "collection")},
        ),
        migrations.AlterUniqueTogether(
            name="collection",
            unique_together={("title", "owner", "parent")},
        ),
        migrations.CreateModel(
            name="APIKey",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "key",
                    models.CharField(max_length=40, unique=True, verbose_name="clef"),
                ),
                ("active", models.BooleanField(default=False, verbose_name="actif")),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "clef d'API",
                "verbose_name_plural": "clefs d'API",
                "unique_together": {("key", "user")},
            },
        ),
        migrations.CreateModel(
            name="File",
            fields=[
                (
                    "resource_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="resources.resource",
                    ),
                ),
                (
                    "original_name",
                    models.CharField(max_length=256, verbose_name="nom d'origine"),
                ),
                ("hash", models.CharField(max_length=64, verbose_name="hachage")),
                ("size", models.BigIntegerField(verbose_name="taille")),
                (
                    "file_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.RESTRICT,
                        to="resources.filetype",
                    ),
                ),
                (
                    "owner",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "fichier",
                "verbose_name_plural": "fichiers",
                "unique_together": {("owner", "hash")},
            },
            bases=("resources.resource",),
        ),
    ]
