# Generated by Django 3.1.1 on 2021-02-10 05:59
from django.conf import settings
from django.db import migrations

if settings.JAMA_SQLITE_DB_PATH:
    CREATE_SQL = ""
    DROP_SQL = ""
else:
    CREATE_SQL = """
    CREATE OR REPLACE FUNCTION get_all_collection_descendants_array(use_parent INT4) RETURNS INT4[] as $$
    DECLARE
        process_parents INT4[] := ARRAY[ use_parent ];
        children INT4[] := '{}';
        new_children INT4[];
    BEGIN
        WHILE ( array_upper( process_parents, 1 ) IS NOT NULL ) LOOP
            new_children := ARRAY( SELECT id FROM resources_collection WHERE parent_id = ANY( process_parents ) AND id <> ALL( children ) );
            children := children || new_children;
            process_parents := new_children;
        END LOOP;
        RETURN children;
    END;
    $$ LANGUAGE plpgsql;
    """

    DROP_SQL = """
    DROP FUNCTION IF EXISTS get_all_collection_descendants_array(INT4);
    """


class Migration(migrations.Migration):
    dependencies = [
        ("resources", "0004_auto_20210128_1046"),
    ]

    operations = [migrations.RunSQL(CREATE_SQL, DROP_SQL)]
