# Generated by Django 4.0 on 2022-01-21 10:25

from django.db import migrations

# from resources import models


def add_fixtures(apps, schema_editor):
    Permission = apps.get_model("resources", "Permission")
    Project = apps.get_model("resources", "Project")
    Role = apps.get_model("resources", "Project")
    create_right, _ = Permission.objects.get_or_create(label="project_property.create")
    read_right, _ = Permission.objects.get_or_create(label="project_property.read")
    update_right, _ = Permission.objects.get_or_create(label="project_property.update")
    delete_right, _ = Permission.objects.get_or_create(label="project_property.delete")
    for project in Project.objects.all():
        admin_role = Role.objects.filter(project=project, label="admin").first()
        if admin_role:
            admin_role.permissions.add(create_right)
            admin_role.permissions.add(read_right)
            admin_role.permissions.add(update_right)
            admin_role.permissions.add(delete_right)


class Migration(migrations.Migration):
    dependencies = [
        ("resources", "0025_projectproperty"),
    ]

    operations = [migrations.RunPython(add_fixtures)]
