# Generated by Django 4.0 on 2022-01-31 16:36

from django.db import migrations

# from resources.models import MetadataSet, Metadata, Project


def add_fixtures(apps, schema_editor):
    """
    Adds region and rotation to iiif metadataset
    """
    Project = apps.get_model("resources", "Project")
    MetadataSet = apps.get_model("resources", "MetadataSet")
    Metadata = apps.get_model("resources", "Metadata")
    for project_instance in Project.objects.all():
        m_set, _ = MetadataSet.objects.get_or_create(
            project=project_instance, title="IIIF"
        )
        meta_region, _ = Metadata.objects.get_or_create(
            set=m_set, title="region", project=project_instance
        )
        meta_rotation, _ = Metadata.objects.get_or_create(
            set=m_set, title="rotation", project=project_instance
        )


class Migration(migrations.Migration):
    dependencies = [
        ("resources", "0026_project_props_fixtures"),
    ]

    # operations = [migrations.RunPython(add_fixtures)]
