# -*- coding: utf-8 -*-
###############################################################################
# Copyright (c), Forschungszentrum Jülich GmbH, IAS-1/PGI-1, Germany.         #
#                All rights reserved.                                         #
# This file is part of the AiiDA-FLEUR package.                               #
#                                                                             #
# The code is hosted on GitHub at https://github.com/JuDFTteam/aiida-fleur    #
# For further information on the license, see the LICENSE.txt file            #
# For further information please visit http://www.flapw.de or                 #
# http://aiida-fleur.readthedocs.io/en/develop/                               #
###############################################################################
"""
You find the usual binding_energy for all elements in the periodic table.
"""
from __future__ import absolute_import
from __future__ import print_function
from aiida.common.constants import elements as PeriodicTableElements
import six
import json
atomic_numbers = {data['symbol']: num for num, data in six.iteritems(PeriodicTableElements)}

# TODO
# FLEUR econfig=[core states|valence states]
# general comments to the econfiguration.
# the electron configuration is important for the atomic generated start density. Sometimes in some cases an other (valence)electron config might be a better choice and lead to different results.
# ie if electrons are put in the s or the fs. or s and d.
# because the starting point matters, especially in the magnetic case.

econfiguration = {
    0: {  # This is for empty spheres etc.
        'mass': 1.00000,
        'name': 'Unknown',
        'symbol': 'X'
    },
    1: {
        'mass': 1.00794,
        'name': 'Hydrogen',
        'symbol': 'H',
        'econfig': '1s1',
        'fleur_default_econfig': '| 1s1',
        'lo': '',
        'rmt': 0.65,
        'lmax': '',
        'jri': 981,
        'soc': False,
        'mag': False
    },
    2: {
        'mass': 4.002602,
        'name': 'Helium',
        'symbol': 'He',
        'econfig': '1s2',
        'fleur_default_econfig': '| 1s2',
        'lo': '',
        'rmt': 1.2,
        'lmax': '',
        'jri': 981
    },
    3: {
        'mass': 6.941,
        'name': 'Lithium',
        'symbol': 'Li',
        'econfig': '1s2 | 2s1',
        'fleur_default_econfig': '1s2 | 2s1',
        'lo': '',
        'rmt': 2.13,
        'lmax': '',
        'jri': 981
    },
    4: {
        'mass': 9.012182,
        'name': 'Beryllium',
        'symbol': 'Be',
        'econfig': '1s2 | 2s2',
        'fleur_default_econfig': '1s2 | 2s2',
        'lo': '',
        'rmt': 1.87,
        'lmax': '',
        'jri': 981
    },
    5: {
        'mass': 10.811,
        'name': 'Boron',
        'symbol': 'B',
        'econfig': '1s2 | 2s2 2p1',
        'fleur_default_econfig': '1s2 | 2s2 2p1',
        'lo': '',
        'rmt': 1.4,
        'lmax': '',
        'jri': 981
    },
    6: {
        'mass': 12.0107,
        'name': 'Carbon',
        'symbol': 'C',
        'econfig': '[He] 2s2 | 2p2',
        'fleur_default_econfig': '[He] 2s2 | 2p2',
        'lo': '',
        'rmt': 1.2,
        'lmax': '',
        'jri': 981
    },
    7: {
        'mass': 14.0067,
        'name': 'Nitrogen',
        'symbol': 'N',
        'econfig': '[He] 2s2 | 2p3',
        'fleur_default_econfig': '[He] 2s2 | 2p3',
        'lo': '',
        'rmt': 1.0,
        'lmax': '',
        'jri': 981
    },
    8: {
        'mass': 15.9994,
        'name': 'Oxygen',
        'symbol': 'O',
        'econfig': '[He] 2s2 | 2p4',
        'fleur_default_econfig': '[He] 2s2 | 2p4',
        'lo': '',
        'rmt': 1.1,
        'lmax': '',
        'jri': 981
    },
    9: {
        'mass': 18.9984032,
        'name': 'Fluorine',
        'symbol': 'F',
        'econfig': '[He] 2s2 | 2p5',
        'fleur_default_econfig': '[He] 2s2 | 2p5',
        'lo': '',
        'rmt': 1.2,
        'lmax': '',
        'jri': 981
    },
    10: {
        'mass': 20.1797,
        'name': 'Neon',
        'symbol': 'Ne',
        'econfig': '[He] 2s2 | 2p6',
        'fleur_default_econfig': '[He] 2s2 | 2p6',
        'lo': '',
        'rmt': 2.1,
        'lmax': '',
        'jri': 981
    },
    11: {
        'mass': 22.98977,
        'name': 'Sodium',
        'symbol': 'Na',
        'econfig': '[He] 2s2 | 2p6 3s1',
        'fleur_default_econfig': '[He] | 2s2 2p6 3s1',
        'lo': '2s 2p',
        'rmt': 2.1,
        'lmax': '',
        'jri': 981
    },
    12: {
        'mass': 24.305,
        'name': 'Magnesium',
        'symbol': 'Mg',
        'econfig': '[He] 2s2 | 2p6 3s2',
        'fleur_default_econfig': '[He] 2s2 | 2p6 3s2',
        'lo': '2p',
        'rmt': 2.3,
        'lmax': '',
        'jri': 981
    },
    13: {
        'mass': 26.981538,
        'name': 'Aluminium',
        'symbol': 'Al',
        'econfig': '[He] 2s2 2p6 | 3s2 3p1',
        'fleur_default_econfig': '[He] 2s2 2p6 | 3s2 3p1',
        'lo': '',
        'rmt': 2.1,
        'lmax': '',
        'jri': 981
    },
    14: {
        'mass': 28.0855,
        'name': 'Silicon',
        'symbol': 'Si',
        'econfig': '[He] 2s2 2p6 | 3s2 3p2',
        'fleur_default_econfig': '[He] 2s2 2p6 | 3s2 3p2',
        'lo': '',
        'rmt': 2.0,
        'lmax': '',
        'jri': 981
    },
    15: {
        'mass': 30.973761,
        'name': 'Phosphorus',
        'symbol': 'P',
        'econfig': '[He] 2s2 2p6 | 3s2 3p3',
        'fleur_default_econfig': '[He] 2s2 2p6 | 3s2 3p3',
        'lo': '',
        'rmt': 1.9,
        'lmax': '',
        'jri': 981
    },
    16: {
        'mass': 32.065,
        'name': 'Sulfur',
        'symbol': 'S',
        'econfig': '[He] 2s2 2p6 | 3s2 3p4',
        'fleur_default_econfig': '[He] 2s2 2p6 | 3s2 3p4',
        'lo': '',
        'rmt': 1.7,
        'lmax': '',
        'jri': 981
    },
    17: {
        'mass': 35.453,
        'name': 'Chlorine',
        'symbol': 'Cl',
        'econfig': '[He] 2s2 2p6 | 3s2 3p5',
        'fleur_default_econfig': '[He] 2s2 2p6 | 3s2 3p5',
        'lo': '',
        'rmt': 1.7,
        'lmax': '',
        'jri': 981
    },
    18: {
        'mass': 39.948,
        'name': 'Argon',
        'symbol': 'Ar',
        'econfig': '[He] 2s2 2p6 | 3s2 3p6',
        'fleur_default_econfig': '[He] 2s2 2p6 | 3s2 3p6',
        'lo': '',
        'rmt': 1.8,
        'lmax': '',
        'jri': 981
    },
    19: {
        'mass': 39.0983,
        'name': 'Potassium',
        'symbol': 'K',
        'econfig': '[Ne] 3s2 | 3p6 4s1',
        'fleur_default_econfig': '[Ne] | 3s2 3p6 4s1',
        'lo': '3s 3p',
        'rmt': 2.0,
        'lmax': '',
        'jri': 981
    },
    20: {
        'mass': 40.078,
        'name': 'Calcium',
        'symbol': 'Ca',
        'econfig': '[Ne] 3s2 | 3p6 4s2',
        'fleur_default_econfig': '[Ne] | 3s2 3p6 4s2',
        'lo': '3s 3p',
        'rmt': 2.3,
        'lmax': '',
        'jri': 981
    },
    21: {
        'mass': 44.955912,
        'name': 'Scandium',
        'symbol': 'Sc',
        'econfig': '[Ne] 3s2 3p6 | 4s2 3d1',
        'fleur_default_econfig': '[Ne] | 3s2 3p6 4s2 3d1',
        'lo': '3s 3p',
        'rmt': 2.2,
        'lmax': '',
        'jri': 981
    },
    22: {
        'mass': 47.867,
        'name': 'Titanium',
        'symbol': 'Ti',
        'econfig': '[Ne] | 3s2 3p6 4s2 3d2',
        'fleur_default_econfig': '[Ne] | 3s2 3p6 4s2 3d2',
        'lo': '3s 3p',
        'rmt': 2.1,
        'lmax': '',
        'jri': 981
    },
    23: {
        'mass': 50.9415,
        'name': 'Vanadium',
        'symbol': 'V',
        'econfig': '[Ne] 3s2 3p6 | 4s2 3d3',
        'fleur_default_econfig': '[Ne] | 3s2 3p6 4s2 3d3',
        'lo': '3s 3p',
        'rmt': 1.9,
        'lmax': '',
        'jri': 981
    },
    24: {
        'mass': 51.9961,
        'name': 'Chromium',
        'symbol': 'Cr',
        'econfig': '[Ne] 3s2 3p6 | 4s1 3d5',
        'fleur_default_econfig': '[Ne] | 3s2 3p6 4s1 3d5',
        'lo': '3s 3p',
        'rmt': 1.8,
        'lmax': '',
        'jri': 981
    },
    25: {
        'mass': 54.938045,
        'name': 'Manganese',
        'symbol': 'Mn',
        'econfig': '[Ne] 3s2 3p6 | 4s2 3d5',
        'fleur_default_econfig': '[Ne] | 3s2 3p6 4s2 3d5',
        'lo': '3s 3p',
        'rmt': 2.0,
        'lmax': '',
        'jri': 981
    },
    26: {
        'mass': 55.845,
        'name': 'Iron',
        'symbol': 'Fe',
        'econfig': '[Ne] 3s2 3p6 | 4s2 3d6',
        'fleur_default_econfig': '[Ne] | 3s2 3p6 4s2 3d6',
        'lo': '3s 3p',
        'rmt': 2.00,
        'lmax': '',
        'jri': 981
    },
    27: {
        'mass': 58.933195,
        'name': 'Cobalt',
        'symbol': 'Co',
        'econfig': '[Ne] 3s2 3p6 | 4s2 3d7',
        'fleur_default_econfig': '[Ne] 3s2 | 3p6 4s2 3d7',
        'lo': '3p',
        'rmt': 1.9,
        'lmax': '',
        'jri': 981
    },
    28: {
        'mass': 58.6934,
        'name': 'Nickel',
        'symbol': 'Ni',
        'econfig': '[Ne] 3s2 3p6 | 4s2 3d8',
        'fleur_default_econfig': '[Ne] 3s2 | 3p6 4s2 3d8',
        'lo': '3p',
        'rmt': 1.9,
        'lmax': '',
        'jri': 981
    },
    29: {
        'mass': 63.546,
        'name': 'Copper',
        'symbol': 'Cu',
        'econfig': '[Ne] 3s2 3p6 |4s1 3d10',
        'fleur_default_econfig': '[Ne] 3s2 | 3p6 4s1 3d10',
        'lo': '3p',
        'rmt': 2.1,
        'lmax': '',
        'jri': 981
    },
    30: {
        'mass': 65.38,
        'name': 'Zinc',
        'symbol': 'Zn',
        'econfig': '[Ne] 3s2 3p6 | 3d10 4s2',
        'fleur_default_econfig': '[Ne] 3s2 3p6 | 3d10 4s2',
        'lo': '3d',
        'rmt': 2.2,
        'lmax': '',
        'jri': 981
    },
    31: {
        'mass': 69.723,
        'name': 'Gallium',
        'symbol': 'Ga',
        'econfig': '[Ne] 3s2 3p6 | 3d10 4s2 4p1',
        'fleur_default_econfig': '[Ne] 3s2 3p6 | 3d10 4s2 4p1',
        'lo': '3d',
        'rmt': 2.1,
        'lmax': '',
        'jri': 981
    },
    32: {
        'mass': 72.64,
        'name': 'Germanium',
        'symbol': 'Ge',
        'econfig': '[Ne] 3s2 3p6 | 3d10 4s2 4p2',
        'fleur_default_econfig': '[Ne] 3s2 3p6 | 3d10 4s2 4p2',
        'lo': '3d',
        'rmt': 2.1,
        'lmax': '',
        'jri': 981
    },
    33: {
        'mass': 74.9216,
        'name': 'Arsenic',
        'symbol': 'As',
        'econfig': '[Ne] 3s2 3p6 | 3d10 4s2 4p3',
        'fleur_default_econfig': '[Ne] 3s2 3p6 | 3d10 4s2 4p3',
        'lo': '3d',
        'rmt': 2.0,
        'lmax': '',
        'jri': 981
    },
    34: {
        'mass': 78.96,
        'name': 'Selenium',
        'symbol': 'Se',
        'econfig': '[Ne] 3s2 3p6 | 3d10 4s2 4p4',
        'fleur_default_econfig': '[Ne] 3s2 3p6 | 3d10 4s2 4p4',
        'lo': '3d',
        'rmt': 2.0,
        'lmax': '',
        'jri': 981
    },
    35: {
        'mass': 79.904,
        'name': 'Bromine',
        'symbol': 'Br',
        'econfig': '[Ne] 3s2 3p6 | 3d10 4s2 4p5',
        'fleur_default_econfig': '[Ne] 3s2 3p6 | 3d10 4s2 4p5',
        'lo': '3d',
        'rmt': 2.1,
        'lmax': '',
        'jri': 981
    },
    36: {
        'mass': 83.798,
        'name': 'Krypton',
        'symbol': 'Kr',
        'econfig': '[Ne] 3s2 3p6 | 3d10 4s2 4p6',
        'fleur_default_econfig': '[Ne] 3s2 3p6 | 3d10 4s2 4p6',
        'lo': '3d',
        'rmt': 2.2,
        'lmax': '',
        'jri': 981
    },
    37: {
        'mass': 85.4678,
        'name': 'Rubidium',
        'symbol': 'Rb',
        'econfig': '[Ar] 3d10 4s2 | 4p6 5s1',
        'fleur_default_econfig': '[Ar] 3d10 | 4s2 4p6 5s1',
        'lo': '4s 4p',
        'rmt': 2.4,
        'lmax': '',
        'jri': 981
    },
    38: {
        'mass': 87.62,
        'name': 'Strontium',
        'symbol': 'Sr',
        'econfig': '[Ar] 3d10 4s2 | 4p6 5s2',
        'fleur_default_econfig': '[Ar] 3d10 | 4s2 4p6 5s2',
        'lo': '4s 4p',
        'rmt': 2.4,
        'lmax': '',
        'jri': 981
    },
    39: {
        'mass': 88.90585,
        'name': 'Yttrium',
        'symbol': 'Y',
        'econfig': '[Ar] 4s2 3d10 4p6 | 5s2 4d1',
        'fleur_default_econfig': '[Ar] 3d10 | 4s2 4p6 5s2 4d1',
        'lo': '4s 4p',
        'rmt': 2.4,
        'lmax': '',
        'jri': 981
    },
    40: {
        'mass': 91.224,
        'name': 'Zirconium',
        'symbol': 'Zr',
        'econfig': '[Ar] 4s2 3d10 4p6 | 5s2 4d2',
        'fleur_default_econfig': '[Ar] 3d10 | 4s2 4p6 5s2 4d2',
        'lo': '4s 4p',
        'rmt': 2.3,
        'lmax': '',
        'jri': 981
    },
    41: {
        'mass': 92.90638,
        'name': 'Niobium',
        'symbol': 'Nb',
        'econfig': '[Ar] 4s2 3d10 4p6 | 5s1 4d4',
        'fleur_default_econfig': '[Ar] 3d10 | 4s2 4p6 5s1 4d4',
        'lo': '4s 4p',
        'rmt': 2.1,
        'lmax': '',
        'jri': 981
    },
    42: {
        'mass': 95.96,
        'name': 'Molybdenum',
        'symbol': 'Mo',
        'econfig': '[Ar] 4s2 3d10 4p6 | 5s1 4d5',
        'fleur_default_econfig': '[Ar] 3d10 | 4s2 4p6 5s1 4d5',
        'lo': '4s 4p',
        'rmt': 2.0,
        'lmax': '',
        'jri': 981
    },
    43: {
        'mass': 98.0,
        'name': 'Technetium',
        'symbol': 'Tc',
        'econfig': '[Ar] 4s2 3d10 4p6 | 5s2 4d5',
        'fleur_default_econfig': '[Ar] 3d10 | 4s2 4p6 5s2 4d5',
        'lo': '4s 4p',
        'rmt': 2.1,
        'lmax': '',
        'jri': 981
    },
    44: {
        'mass': 101.07,
        'name': 'Ruthenium',
        'symbol': 'Ru',
        'econfig': '[Ar] 4s2 3d10 4p6 | 5s1 4d7',
        'fleur_default_econfig': '[Ar] 4s2 3d10 | 4p6 5s1 4d7',
        'lo': '4p',
        'rmt': 2.1,
        'lmax': '',
        'jri': 981
    },
    45: {
        'mass': 102.9055,
        'name': 'Rhodium',
        'symbol': 'Rh',
        'econfig': '[Ar] 4s2 3d10 4p6 | 5s1 4d8',
        'fleur_default_econfig': '[Ar] 4s2 3d10 | 4p6 5s1 4d8',
        'lo': '4p',
        'rmt': 2.1,
        'lmax': '',
        'jri': 981
    },
    46: {
        'mass': 106.42,
        'name': 'Palladium',
        'symbol': 'Pd',
        'econfig': '[Ar] 4s2 3d10 4p6 | 4d10',
        'fleur_default_econfig': '[Ar] 4s2 3d10 | 4p6 4d10',
        'lo': '4p',
        'rmt': 2.1,
        'lmax': '',
        'jri': 981
    },
    47: {
        'mass': 107.8682,
        'name': 'Silver',
        'symbol': 'Ag',
        'econfig': '[Ar] 4s2 3d10 4p6 | 5s1 4d10',
        'fleur_default_econfig': '[Ar] 3d10 | 4s2 4p6 5s1 4d10',
        'lo': '4s 4p',
        'rmt': 2.3,
        'lmax': '',
        'jri': 981
    },
    48: {
        'mass': 112.411,
        'name': 'Cadmium',
        'symbol': 'Cd',
        'econfig': '[Ar] 4s2 3d10 4p6 | 4d10 5s2',
        'fleur_default_econfig': '[Ar] 4s2 3d10 4p6 | 4d10 5s2',
        'lo': '4d',
        'rmt': 2.4,
        'lmax': '',
        'jri': 981
    },
    49: {
        'mass': 114.818,
        'name': 'Indium',
        'symbol': 'In',
        'econfig': '[Ar] 4s2 3d10 4p6 | 4d10 5s2 5p1',
        'fleur_default_econfig': '[Ar] 4s2 3d10 4p6 | 4d10 5s2 5p1',
        'lo': '4d',
        'rmt': 2.2,
        'lmax': '',
        'jri': 981
    },
    50: {
        'mass': 118.71,
        'name': 'Tin',
        'symbol': 'Sn',
        'econfig': '[Kr] 4d10 | 5s2 5p2',
        'fleur_default_econfig': '[Kr] | 4d10 5s2 5p2',
        'lo': '4d',
        'rmt': 2.3,
        'lmax': '',
        'jri': 981
    },
    51: {
        'mass': 121.76,
        'name': 'Antimony',
        'symbol': 'Sb',
        'econfig': '[Kr] 4d10 | 5s2 5p3',
        'fleur_default_econfig': '[Kr] | 4d10 5s2 5p3',
        'lo': '4d',
        'rmt': 2.3,
        'lmax': '',
        'jri': 981
    },
    52: {
        'mass': 127.6,
        'name': 'Tellurium',
        'symbol': 'Te',
        'econfig': '[Kr] 4d10 | 5s2 5p4',
        'fleur_default_econfig': '[Kr] | 4d10 5s2 5p4',
        'lo': '4d',
        'rmt': 2.3,
        'lmax': '',
        'jri': 981
    },
    53: {
        'mass': 126.90447,
        'name': 'Iodine',
        'symbol': 'I',
        'econfig': '[Kr] 4d10 | 5s2 5p5',
        'fleur_default_econfig': '[Kr] | 4d10 5s2 5p5',
        'lo': '4d',
        'rmt': 2.2,
        'lmax': '',
        'jri': 981
    },
    54: {
        'mass': 131.293,
        'name': 'Xenon',
        'symbol': 'Xe',
        'econfig': '[Kr] 4d10 | 5s2 5p6',
        'fleur_default_econfig': '[Kr] | 4d10 5s2 5p6',
        'lo': '4d',
        'rmt': 2.2,
        'lmax': '',
        'jri': 981
    },
    55: {
        'mass': 132.9054519,
        'name': 'Caesium',
        'symbol': 'Cs',
        'econfig': '[Kr] 4d10 5s2 | 5p6 6s1',
        'fleur_default_econfig': '[Kr] 4d10 | 5s2 5p6 6s1',
        'lo': '5s 5p',
        'rmt': 2.4,
        'lmax': '',
        'jri': 981
    },
    56: {
        'mass': 137.327,
        'name': 'Barium',
        'symbol': 'Ba',
        'econfig': '[Kr] 4d10 5s2 | 5p6 6s2',
        'fleur_default_econfig': '[Kr] 4d10 | 5s2 5p6 6s2',
        'lo': '5s 5p',
        'rmt': 2.4,
        'lmax': '',
        'jri': 981
    },
    57: {
        'mass': 138.90547,
        'name': 'Lanthanum',
        'symbol': 'La',
        'econfig': '[Kr] 4d10 5s2 | 5p6 6s2 5d1',
        'fleur_default_econfig': '[Kr] 4d10 | 5s2 5p6 6s2 5d1',
        'lo': '5s 5p',
        'rmt': 2.2,
        'lmax': '',
        'jri': 981
    },
    58: {
        'mass': 140.116,
        'name': 'Cerium',
        'symbol': 'Ce',
        'econfig': '[Kr] 4d10 5s2 5p6 | 6s2 4f1 5d1',
        'fleur_default_econfig': '[Kr] 4d10 | 5s2 5p6 6s2 4f1 5d1',
        'lo': '5s 5p',
        'rmt': 2.2,
        'lmax': '',
        'jri': 981
    },
    59: {
        'mass': 140.90765,
        'name': 'Praseodymium',
        'symbol': 'Pr',
        'econfig': '[Kr] 4d10 5s2 5p6 | 6s2 4f3',
        'fleur_default_econfig': '[Kr] 4d10 | 5s2 5p6  6s2 4f3',
        'lo': '5s 5p',
        'rmt': 2.4,
        'lmax': '',
        'jri': 981
    },
    60: {
        'mass': 144.242,
        'name': 'Neodymium',
        'symbol': 'Nd',
        'econfig': '[Kr] 4d10 5s2 5p6 | 6s2 4f4',
        'fleur_default_econfig': '[Kr] 4d10 | 5s2 5p6 6s2 4f4',
        'lo': '5s 5p',
        'rmt': 2.1,
        'lmax': '',
        'jri': 981
    },
    61: {
        'mass': 145.0,
        'name': 'Promethium',
        'symbol': 'Pm',
        'econfig': '[Kr] 4d10 5s2 5p6 | 6s2 4f5',
        'fleur_default_econfig': '[Kr] 4d10 | 5s2 5p6 6s2 4f5',
        'lo': '5s 5p',
        'rmt': 2.4,
        'lmax': '',
        'jri': 981
    },
    62: {
        'mass': 150.36,
        'name': 'Samarium',
        'symbol': 'Sm',
        'econfig': '[Kr] 4d10 5s2 5p6 | 6s2 4f6',
        'fleur_default_econfig': '[Kr] 4d10 | 5s2 5p6 6s2 4f6',
        'lo': '5s 5p',
        'rmt': 2.1,
        'lmax': '',
        'jri': 981
    },
    63: {
        'mass': 151.964,
        'name': 'Europium',
        'symbol': 'Eu',
        'econfig': '[Kr] 4d10 | 4f7 5s2 5p6 6s2',
        'fleur_default_econfig': '[Kr] 4d10 | 5s2 5p6 4f7 6s2',
        'lo': '5s 5p',
        'rmt': 2.4,
        'lmax': '',
        'jri': 981
    },
    64: {
        'mass': 157.25,
        'name': 'Gadolinium',
        'symbol': 'Gd',
        'econfig': '[Kr] 4d10 5s2 5p6 | 6s2 4f7 5d1',
        'fleur_default_econfig': '[Kr] 4d10 | 5s2 5p6 6s2 4f7 5d1',
        'lo': '5s 5p',
        'rmt': 2.2,
        'lmax': '',
        'jri': 981
    },
    65: {
        'mass': 158.92535,
        'name': 'Terbium',
        'symbol': 'Tb',
        'econfig': '[Kr] 4d10 5s2 5p6 | 6s2 4f9',
        'fleur_default_econfig': '[Kr] 4d10 | 5s2 5p6 6s2 4f8 5d1',
        'lo': '5s 5p',
        'rmt': 2.1,
        'lmax': '',
        'jri': 981
    },
    66: {
        'mass': 162.5,
        'name': 'Dysprosium',
        'symbol': 'Dy',
        'econfig': '[Kr] 4d10 5s2 5p6 | 6s2 4f10',
        'fleur_default_econfig': '[Kr] 4d10 | 5s2 5p6 6s2 4f9 5d1',
        'lo': '5s 5p',
        'rmt': 2.4,
        'lmax': '',
        'jri': 981
    },
    67: {
        'mass': 164.93032,
        'name': 'Holmium',
        'symbol': 'Ho',
        'econfig': '[Kr] 4d10 5s2 5p6 | 6s2 4f11',
        'fleur_default_econfig': '[Kr] 4d10 | 5s2 5p6 6s2 4f10 5d1',
        'lo': '5s 5p',
        'rmt': 2.4,
        'lmax': '',
        'jri': 981
    },
    68: {
        'mass': 167.259,
        'name': 'Erbium',
        'symbol': 'Er',
        'econfig': '[Kr] 4d10 5s2 5p6 | 6s2 4f12',
        'fleur_default_econfig': '[Kr] 4d10 | 5s2 5p6 6s2 4f11 5d1',
        'lo': '5s 5p',
        'rmt': 2.5,
        'lmax': '',
        'jri': 981
    },
    69: {
        'mass': 168.93421,
        'name': 'Thulium',
        'symbol': 'Tm',
        'econfig': '[Kr] 4d10 5s2 5p6 | 6s2 4f13',
        'fleur_default_econfig': '[Kr] 4d10 | 5s2 5p6 6s2 4f12 5d1',
        'lo': '5s 5p',
        'rmt': 2.4,
        'lmax': '',
        'jri': 981
    },
    70: {
        'mass': 173.054,
        'name': 'Ytterbium',
        'symbol': 'Yb',
        'econfig': '[Kr] 4d10 5s2 5p6 | 6s2 4f14',
        'fleur_default_econfig': '[Kr] 4d10 | 5s2 5p6 6s2 4f13 5d1',
        'lo': '5s 5p',
        'rmt': 2.6,
        'lmax': '',
        'jri': 981
    },
    71: {
        'mass': 174.9668,
        'name': 'Lutetium',
        'symbol': 'Lu',
        'econfig': '[Kr] 4d10 | 4f14 5s2 5p6 5d1 6s2',
        'fleur_default_econfig': '[Kr] 4d10 | 5s2 5p6 4f14 6s2 5d1',
        'lo': '5s 5p',
        'rmt': 2.5,
        'lmax': '',
        'jri': 981
    },
    72: {
        'mass': 178.49,
        'name': 'Hafnium',
        'symbol': 'Hf',
        'econfig': '[Kr] 4d10 | 4f14 5s2 5p6 5d2 6s2',
        'fleur_default_econfig': '[Kr] 4d10 4f14 | 5s2 5p6 6s2 5d2',
        'lo': '5s 5p',
        'rmt': 2.3,
        'lmax': '',
        'jri': 981
    },
    73: {
        'mass': 180.94788,
        'name': 'Tantalum',
        'symbol': 'Ta',
        'econfig': '[Kr] 4d10 4f14 | 5s2 5p6 5d3 6s2',
        'fleur_default_econfig': '[Kr] 4d10 4f14 | 5s2 5p6 6s2 5d3',
        'lo': '5s 5p',
        'rmt': 2.2,
        'lmax': '',
        'jri': 981
    },
    74: {
        'mass': 183.84,
        'name': 'Tungsten',
        'symbol': 'W',
        'econfig': '[Kr] 5s2 4d10 4f14 | 5p6 6s2 5d4',
        'fleur_default_econfig': '[Kr] 4d10 4f14 | 5s2 5p6 6s2 5d4',
        'lo': '5s 5p',
        'rmt': 2.1,
        'lmax': '',
        'jri': 981
    },
    75: {
        'mass': 186.207,
        'name': 'Rhenium',
        'symbol': 'Re',
        'econfig': '[Kr] 4d10 4f14 5p6 | 5s2 6s2 5d5',
        'fleur_default_econfig': '[Kr] 4d10 4f14 | 5s2 5p6 6s2 5d5',
        'lo': '5s 5p',
        'rmt': 2.1,
        'lmax': '',
        'jri': 981
    },
    76: {
        'mass': 190.23,
        'name': 'Osmium',
        'symbol': 'Os',
        'econfig': '[Kr] 4d10 4f14 5p6 | 5s2 6s2 5d6',
        'fleur_default_econfig': '[Kr] 5s2 4d10 4f14 | 5p6 6s2 5d6',
        'lo': '5p',
        'rmt': 2.1,
        'lmax': '',
        'jri': 981
    },
    77: {
        'mass': 192.217,
        'name': 'Iridium',
        'symbol': 'Ir',
        'econfig': '[Kr] 4d10 4f14 5p6 | 5s2 6s2 5d7',
        'fleur_default_econfig': '[Kr] 5s2 4d10 4f14 | 5p6 6s2 5d7',
        'lo': '5p',
        'rmt': 2.1,
        'lmax': '',
        'jri': 981
    },
    78: {
        'mass': 195.084,
        'name': 'Platinum',
        'symbol': 'Pt',
        'econfig': '[Kr] 4d10 4f14 5p6 | 5s2 6s2 5d8',
        'fleur_default_econfig': '[Kr] 5s2 4d10 4f14 | 5p6 6s2 5d8',
        'lo': '5p',
        'rmt': 2.1,
        'lmax': '',
        'jri': 981
    },
    79: {
        'mass': 196.966569,
        'name': 'Gold',
        'symbol': 'Au',
        'econfig': '[Kr] 4d10 4f14 5p6 | 5s2 6s2 5d9',
        'fleur_default_econfig': '[Kr] 4d10 4f14 | 5s2 5p6 6s2 5d9',
        'lo': '5s 5p',
        'rmt': 2.2,
        'lmax': '',
        'jri': 981
    },
    80: {
        'mass': 200.59,
        'name': 'Mercury',
        'symbol': 'Hg',
        'econfig': '[Kr] 5s2 4d10 4f14 | 5p6 5d10 6s2',
        'fleur_default_econfig': '[Kr] 5s2 4d10 4f14 5p6 | 5d10 6s2',
        'lo': '5d',
        'rmt': 2.4,
        'lmax': '',
        'jri': 981
    },
    81: {
        'mass': 204.3833,
        'name': 'Thallium',
        'symbol': 'Tl',
        'econfig': '[Xe] 4f14 | 5d10 6s2 6p1',
        'fleur_default_econfig': '[Xe] 4f14 | 5d10 6s2 6p1',
        'lo': '5d',
        'rmt': 2.4,
        'lmax': '',
        'jri': 981
    },
    82: {
        'mass': 207.2,
        'name': 'Lead',
        'symbol': 'Pb',
        'econfig': '[Xe] 4f14 | 5d10 6s2 6p2',
        'fleur_default_econfig': '[Xe] 4f14 | 5d10 6s2 6p2',
        'lo': '5d',
        'rmt': 2.4,
        'lmax': '',
        'jri': 981
    },
    83: {
        'mass': 208.9804,
        'name': 'Bismuth',
        'symbol': 'Bi',
        'econfig': '[Xe] 4f14 | 5d10 6s2 6p3',
        'fleur_default_econfig': '[Xe] 4f14 | 5d10 6s2 6p3',
        'lo': '5d',
        'rmt': 2.4,
        'lmax': '',
        'jri': 981
    },
    84: {
        'mass': 209.0,
        'name': 'Polonium',
        'symbol': 'Po',
        'econfig': '[Xe] 4f14 | 5d10 6s2 6p4',
        'fleur_default_econfig': '[Xe] 4f14 | 5d10 6s2 6p4',
        'lo': '5d',
        'rmt': 2.2,
        'lmax': '',
        'jri': 981
    },
    85: {
        'mass': 210.0,
        'name': 'Astatine',
        'symbol': 'At',
        'econfig': '[Xe] 4f14 | 5d10 6s2 6p5',
        'fleur_default_econfig': '[Xe] 4f14 | 5d10 6s2 6p5',
        'lo': '5d',
        'rmt': 2.2,
        'lmax': '',
        'jri': 981
    },
    86: {
        'mass': 222.0,
        'name': 'Radon',
        'symbol': 'Rn',
        'econfig': '[Xe] 4f14 | 5d10 6s2 6p6',
        'fleur_default_econfig': '[Xe] 4f14 | 5d10 6s2 6p6',
        'lo': '5d',
        'rmt': 2.2,
        'lmax': '',
        'jri': 981
    },  # TODO: after wards not rigth
    87: {
        'mass': 223.0,
        'name': 'Francium',
        'symbol': 'Fr',
        'econfig': '[Xe] 4f14 5d10 6s2 | 6p6 7s1',
        'fleur_default_econfig': '[Xe] 4f14 5d10 | 6s2 6p6 7s1',
        'lo': '6s 6p',
        'rmt': 2.2,
        'lmax': '',
        'jri': 981
    },
    88: {
        'mass': 226.0,
        'name': 'Radium',
        'symbol': 'Ra',
        'econfig': '[Xe] 4f14 5d10 6s2 | 6p6 7s2',
        'fleur_default_econfig': '[Xe] 4f14 5d10 | 6s2 6p6 7s2',
        'lo': '6s 6p',
        'rmt': 2.2,
        'lmax': '',
        'jri': 981
    },
    89: {
        'mass': 227.0,
        'name': 'Actinium',
        'symbol': 'Ac',
        'econfig': '[Xe] 4f14 5d10 6s2 | 6p6 7s2 6d1',
        'fleur_default_econfig': '[Xe] 4f14 5d10 | 6s2 6p6 7s2 6d1',
        'lo': '6s 6p',
        'rmt': 2.2,
        'lmax': '',
        'jri': 981
    },
    90: {
        'mass': 232.03806,
        'name': 'Thorium',
        'symbol': 'Th',
        'econfig': '[Xe] 4f14 5d10 6s2 | 6p6 7s2 6d1 5f1',
        'fleur_default_econfig': '[Xe] 4f14 5d10 | 6s2 6p6 7s2 6d1 5f1',
        'lo': '6s 6p',
        'rmt': 2.2,
        'lmax': '',
        'jri': 981
    },
    91: {
        'mass': 231.03588,
        'name': 'Protactinium',
        'symbol': 'Pa',
        'econfig': '[Xe] 4f14  5d10 6s2 | 6p6 7s2 6d1 5f2',
        'fleur_default_econfig': '[Xe] 4f14 5d10 | 6s2 6p6 7s2 6d1 5f2',
        'lo': '6s 6p',
        'rmt': 2.2,
        'lmax': '',
        'jri': 981
    },
    92: {
        'mass': 238.02891,
        'name': 'Uranium',
        'symbol': 'U',
        'econfig': '[Xe] 4f14 5d10 6s2 6p6| 7s2 5f4',
        'fleur_default_econfig': '[Xe] 4f14 5d10 | 6s2 6p6 7s2 5f4',
        'lo': '6s 6p',
        'rmt': 2.3,
        'lmax': '',
        'jri': 981
    },
    93: {
        'mass': 237.0,
        'name': 'Neptunium',
        'symbol': 'Np',
        'econfig': '[Xe] 4f14 5d10 6s2 6p6 | 7s2 5f5',
        'fleur_default_econfig': '[Xe] 4f14 5d10 | 6s2 6p6 7s2 5f5',
        'lo': '6s 6p',
        'rmt': 2.1,
        'lmax': '',
        'jri': 981
    },
    94: {
        'mass': 244.0,
        'name': 'Plutonium',
        'symbol': 'Pu',
        'econfig': '[Xe] 4f14 5d10 6s2 6p6 | 7s2 5f6',
        'fleur_default_econfig': '[Xe] 4f14 5d10 | 6s2 6p6 7s2 5f6',
        'lo': '6s 6p',
        'rmt': 2.2,
        'lmax': '',
        'jri': 981
    },
    95: {
        'mass': 243.0,
        'name': 'Americium',
        'symbol': 'Am',
        'econfig': '[Xe] 4f14 5d10 6s2 6p6 | 7s2 5f7',
        'fleur_default_econfig': '[Xe] 4f14 5d10 | 6s2 6p6 7s2 5f7',
        'lo': '6s 6p',
        'rmt': 2.4,
        'lmax': '',
        'jri': 981
    },
    96: {
        'mass': 247.0,
        'name': 'Curium',
        'symbol': 'Cm',
        'econfig': '[Xe] 4f14 5d10 6s2 6p6 | 7s2 5f8',
        'fleur_default_econfig': '[Xe] 4f14 5d10 | 6s2 6p6 7s2 5f8',
        'lo': '6s 6p',
        'rmt': 2.4,
        'lmax': '',
        'jri': 981
    },
    97: {
        'mass': 247.0,
        'name': 'Berkelium',
        'symbol': 'Bk',
        'econfig': '[Xe] 4f14 5d10 6s2 6p6 | 7s2 5f9',
        'fleur_default_econfig': '[Xe] 4f14 5d10 | 6s2 6p6 7s2 5f9',
        'lo': '6s 6p',
        'rmt': 2.4,
        'lmax': '',
        'jri': 981
    },
    98: {
        'mass': 251.0,
        'name': 'Californium',
        'symbol': 'Cf',
        'econfig': '[Xe] 4f14 5d10 6s2 6p6 | 7s2 5f10',
        'fleur_default_econfig': '[Xe] 4f14 5d10 | 6s2 6p6 7s2 5f10',
        'lo': '6s 6p',
        'rmt': 2.4,
        'lmax': '',
        'jri': 981
    },
    99: {
        'mass': 252.0,
        'name': 'Einsteinium',
        'symbol': 'Es',
        'econfig': '[Xe] 4f14 5d10 6s2 6p6 | 7s2 5f11',
        'fleur_default_econfig': '[Xe] 4f14 5d10 | 6s2 6p6 7s2 5f11',
        'lo': '6s 6p',
        'rmt': 2.4,
        'lmax': '',
        'jri': 981
    },
    100: {
        'mass': 257.0,
        'name': 'Fermium',
        'symbol': 'Fm',
        'econfig': '[Xe] 4f14 5d10 6s2 6p6 | 7s2 5f12',
        'fleur_default_econfig': '[Xe] 4f14 5d10 | 6s2 6p6 7s2 5f12',
        'lo': '6s 6p',
        'rmt': 2.4,
        'lmax': '',
        'jri': 981
    },
    101: {
        'mass': 258.0,
        'name': 'Mendelevium',
        'symbol': 'Md',
        'econfig': '[Xe] 4f14 5d10 6s2 6p6 | 7s2 5f13',
        'fleur_default_econfig': '[Xe] 4f14 5d10 | 6s2 6p6 7s2 5f13',
        'lo': '6s 6p',
        'rmt': 2.4,
        'lmax': '',
        'jri': 981
    },
    102: {
        'mass': 259.0,
        'name': 'Nobelium',
        'symbol': 'No',
        'econfig': '[Xe] 4f14 5d10 6s2 6p6 | 7s2 5f14',
        'fleur_default_econfig': '[Xe] 4f14 5d10 | 6s2 6p6 7s2 5f14',
        'lo': '6s 6p',
        'rmt': 2.4,
        'lmax': '',
        'jri': 981
    },
    103: {
        'mass': 262.0,
        'name': 'Lawrencium',
        'symbol': 'Lr',
        'econfig': '[Xe] 4f14 5d10 6s2 6p6 | 7s2 5f14 6d1',
        'fleur_default_econfig': '[Xe] 4f14 5d10 | 6s2 6p6 7s2 5f14 6d1',
        'lo': '6s 6p 5f',
        'rmt': 2.4,
        'lmax': '',
        'jri': 981
    },
    104: {
        'mass': 267.0,
        'name': 'Rutherfordium',
        'symbol': 'Rf',
        'econfig': '[Xe] 4f14 5d10 6s2 6p6 | 7s2 5f14 6d2',
        'fleur_default_econfig': '[Xe] 4f14 5d10 6s2 6p6 | 7s2 5f14 6d2',
        'lo': '6p 5f',
        'rmt': 2.4,
        'lmax': '',
        'jri': 981
    },
    105: {
        'mass': 268.0,
        'name': 'Dubnium',
        'symbol': 'Db',
        'econfig': '[Xe] 4f14 5d10 6s2 6p6 | 7s2 5f14 6d3',
        'fleur_default_econfig': '[Xe] 4f14 5d10 6s2 | 6p6 7s2 5f14 6d3',
        'lo': '6p 5f',
        'rmt': 2.4,
        'lmax': '',
        'jri': 981
    },
    106: {
        'mass': 271.0,
        'name': 'Seaborgium',
        'symbol': 'Sg',
        'econfig': '[Xe] 4f14 5d10 6s2 6p6 | 7s2 5f14 6d4',
        'fleur_default_econfig': '[Xe] 4f14 5d10 6s2 | 6p6 7s2 5f14 6d4',
        'lo': '6p 5f',
        'rmt': 2.4,
        'lmax': '',
        'jri': 981
    },
    107: {
        'mass': 272.0,
        'name': 'Bohrium',
        'symbol': 'Bh',
        'econfig': '[Rn] 7s2 5f14 | 6d5',
        'fleur_default_econfig': '[Xe] 4f14 5d10 6s2 6p6 5f14 | 7s2 6d5',
        'lo': '',
        'rmt': 2.4,
        'lmax': '',
        'jri': 981
    },
    108: {
        'mass': 270.0,
        'name': 'Hassium',
        'symbol': 'Hs',
        'econfig': '[Rn] 7s2 5f14 | 6d6',
        'fleur_default_econfig': '[Rn] 5f14 | 7s2 6d6',
        'lo': '',
        'rmt': 2.4,
        'lmax': '',
        'jri': 981
    },
    109: {
        'mass': 276.0,
        'name': 'Meitnerium',
        'symbol': 'Mt',
        'econfig': '[Rn] 7s2 5f14 | 6d7',
        'fleur_default_econfig': '[Rn] 5f14 | 7s2 6d7',
        'lo': '',
        'rmt': 2.4,
        'lmax': '',
        'jri': 981
    },
    110: {
        'mass': 281.0,
        'name': 'Darmstadtium',
        'symbol': 'Ds',
        'econfig': '[Rn] 7s2 5f14 | 6d8',
        'fleur_default_econfig': '[Rn] 5f14 | 7s2 6d8',
        'lo': '',
        'rmt': 2.4,
        'lmax': '',
        'jri': 981
    },
    111: {
        'mass': 280.0,
        'name': 'Roentgenium',
        'symbol': 'Rg',
        'econfig': '[Rn] 7s2 5f14 | 6d9',
        'fleur_default_econfig': '[Rn] 5f14 | 7s2 6d9',
        'lo': '',
        'rmt': 2.4,
        'lmax': '',
        'jri': 981
    },
    112: {
        'mass': 285.0,
        'name': 'Copernicium',
        'symbol': 'Cn',
        'econfig': '[Rn] 7s2 5f14 | 6d10',
        'fleur_default_econfig': '[Rn] 5f14 | 7s2 6d10',
        'lo': '6d',
        'rmt': 2.4,
        'lmax': '',
        'jri': 981
    },
    113: {
        'mass': 285.0,
        'name': 'Nihomium',
        'symbol': 'Nh',
        'econfig': '[Rn] 7s2 5f14 | 6d10 7p1',
        'fleur_default_econfig': '[Rn] 7s2 5f14 | 6d10 7p1',
        'lo': '6d',
        'rmt': 2.4,
        'lmax': '',
        'jri': 981
    },
    114: {
        'mass': 289.0,
        'name': 'Flerovium',
        'symbol': 'Fl',
        'econfig': '[Rn] 7s2 5f14 | 6d10 7p2',
        'fleur_default_econfig': '[Rn] 7s2 5f14 | 6d10 7p2',
        'lo': '6d',
        'rmt': 2.4,
        'lmax': '',
        'jri': 981
    },
    115: {
        'mass': 0.0,
        'name': 'Mascovium',
        'symbol': 'Mc',
        'econfig': '[Rn] 7s2 5f14 | 6d10 7p3',
        'fleur_default_econfig': '[Rn] 7s2 5f14 | 6d10 7p3',
        'lo': '6d',
        'rmt': 2.4,
        'lmax': '',
        'jri': 981
    },
    116: {
        'mass': 293.0,
        'name': 'Livermorium',
        'symbol': 'Lv',
        'econfig': '[Rn] 7s2 5f14 | 6d10 7p4',
        'fleur_default_econfig': '[Rn] 7s2 5f14 | 6d10 7p4',
        'lo': '6d',
        'rmt': 2.4,
        'lmax': '',
        'jri': 981
    },
    117: {
        'mass': 0.0,
        'name': 'Tennessine',
        'symbol': 'Ts',
        'econfig': '[Rn] 7s2 5f14 | 6d10 7p5',
        'fleur_default_econfig': '[Rn] 7s2 5f14 | 6d10 7p5',
        'lo': '6d',
        'rmt': 2.4,
        'lmax': '',
        'jri': 981
    },
    118: {
        'mass': 0.0,
        'name': 'Oganesson',
        'symbol': 'Og',
        'econfig': '[Rn] 7s2 5f14 | 6d10 7p6',
        'fleur_default_econfig': '[Rn] 7s2 5f14 | 6d10 7p6',
        'lo': '6d',
        'rmt': 2.4,
        'lmax': '',
        'jri': 981
    }
}

all_econfig = [
    '1s2', '2s2', '2p6', '3s2', '3p6', '4s2', '3d10', '4p6', '5s2', '4d10', '5p6', '6s2', '4f14', '5d10', '6p6', '7s2',
    '5f14', '6d10', '7p6', '8s2', '6f14'
]
states_spin = {'s': ['1/2'], 'p': ['1/2', '3/2'], 'd': ['3/2', '5/2'], 'f': ['5/2', '7/2']}
max_state_occ = {'s': 2., 'p': 6., 'd': 10., 'f': 14.}
max_state_occ_spin = {'1/2': 2., '3/2': 4., '5/2': 6., '7/2': 8.}
shell_map = {0: 's', 1: 'p', 2: 'd', 3: 'f'}
element_delta_defaults = {}  # for workflow purposes

element_max_para = {}  # for workflow purposes


def get_econfig(element, full=False):
    """
    returns the econfiguration as a string of an element.

    :params element: element string
    :params full: a bool (econfig without [He]...)
    :returns: a econfig string
    """
    if isinstance(element, int):
        econ = econfiguration.get(element, {}).get('econfig', None)
        if full:
            econ = rek_econ(econ)
            return econ
        else:
            return econ
    elif isinstance(element, six.string_types):  # str):
        atomic_names = {data['symbol']: num for num, data in six.iteritems(econfiguration)}
        element_num = atomic_names.get(element, None)
        econ = econfiguration.get(element_num, {}).get('econfig', None)
        if full:
            econ = rek_econ(econ)
            return econ
        else:
            return econ
    else:
        print('INPUTERROR: element has to be and int or string')
        return None


def get_coreconfig(element, full=False):
    """
    returns the econfiguration as a string of an element.

    :param: element string
    :param: full, bool (econfig without [He]...)
    :return: string
    :note: Be careful with base strings...
    """
    if isinstance(element, int):
        econ = econfiguration.get(element, {}).get('econfig', None)
        if full:
            econ = rek_econ(econ)
            return econ.split('|')[0].rstrip()
        else:
            return econ.split('|')[0].rstrip()
    elif isinstance(element, str):
        atomic_names = {data['symbol']: num for num, data in six.iteritems(econfiguration)}
        element_num = atomic_names.get(element, None)
        econ = econfiguration.get(element_num, {}).get('econfig', None)
        if full:
            econ = rek_econ(econ)
            return econ.split('|')[0].rstrip()
        else:
            return econ.split('|')[0].rstrip()
    else:
        print('INPUTERROR: element has to be and int or string')
        return None


def rek_econ(econfigstr):
    """
    recursive routine to return a full econfig
    '[Xe] 4f14 | 5d10 6s2 6p4' -> '1s 2s ... 4f14 | 5d10 6s2 6p4'
    """
    split_econ = econfigstr.strip('[')
    split_econ = split_econ.split(']')
    if len(split_econ) == 1:
        return econfigstr
    else:
        rest = split_econ[1]
        elem = split_econ[0]
        econfig = get_econfig(elem)
        econ = econfig.replace(' |', '')
        econfigstr = rek_econ(econ + rest)
        return econfigstr  # for now


def convert_fleur_config_to_econfig(fleurconf_str, keep_spin=False):
    """
    '[Kr] (4d3/2) (4d5/2) (4f5/2) (4f7/2)' -> '[Kr] 4d10 4f14', or '[Kr] 4d3/2 4d5/2 4f5/2 4f7/2'

    # for now only use for coreconfig, it will fill all orbitals, since it has no information on the filling.
    """

    econfstring = fleurconf_str.replace('(', '').replace(')', '')

    if keep_spin:
        econfstring.split()
    else:
        elist = econfstring.split()
        econfstring_new = ''
        for state in elist:
            if '/' in state:
                # check if nl was added before if not add it with full occ
                base = state[:2]
                spin = state[2:]
                occ = max_state_occ_spin.get(spin)
                if base not in econfstring_new:
                    econfstring_new = '{}{}{} '.format(econfstring_new, base, int(occ))
                else:
                    max_occ = max_state_occ.get(base[1])
                    econfstring_new = econfstring_new.split(base)[0] + '{}{} '.format(base, int(max_occ))
                    # we assume here that the two states come behind each other, ... rather bad
                    #econfstring_new.replace('{}'.format(base)
            else:
                econfstring_new = econfstring_new + state + ' '
        econfstring = econfstring_new

    return econfstring.strip()


#test convert_fleur_config_to_econfig(config, keep_spin+true/False)
#config = '[Kr] (4d3/2) (4d5/2) (4f5/2) (4f7/2)'
#config = '[Kr]'
#config = '[Kr] 4d3/2 4d5/2 4f5/2'# 4f7/2'


def highest_unocc_valence(econfigstr):
    """
    returns the highest not full valence orbital. If all are full, it returns ''
    #maybe should be advanced to give back the next highest unocc
    """

    val_orb = ''
    econ = econfigstr.split('|')
    econ_val = econ[-1]
    econ_val_list = econ_val.split()
    for state in econ_val_list[::-1]:
        state_l = state[1]
        occ = int(state.split(state_l)[-1])
        max_occ = max_state_occ.get(state_l, 100)
        if occ < max_occ:
            val_orb = state
            return val_orb
    # everything was full return next empty orbital
    hightest_orb = econ_val_list[-1]
    #print hightest_orb
    index = all_econfig.index(hightest_orb)
    if index:
        next_orb_full = all_econfig[all_econfig.index(hightest_orb) + 1]
        next_orb_empty = next_orb_full[0:2] + '0'
        return next_orb_empty  # ''  # everythin is full
    else:
        return val_orb  #None


def get_spin_econfig(fulleconfigstr):
    """
    converts and econfig string to a full spin econfig
    1s2 2s2 2p6' - > '1s1/2 2s1/2 2p1/2 2p3/2'
    """

    econ_list = fulleconfigstr.split()
    spin_econfig_string = ''

    # check if autocomplete needed
    if '[' in fulleconfigstr:
        completion = rek_econ(econ_list[0])
        econ_list.remove(econ_list[0])
        econ_list = completion.split() + econ_list

    for state in econ_list:
        if '/' in state:
            spin_econfig_string = spin_econfig_string + state + ' '
            continue
        state_l = state[1]
        #occ = int(state.split(state_l)[-1])
        spinstates = states_spin.get(state_l, [])
        for spin in spinstates:
            spin_econfig_string = spin_econfig_string + '{}{} '.format(state[:2], spin)

    return spin_econfig_string.rstrip()


# test get_spin_econfig('1s2 2s2 2p6'), '1s1/2 2s1/2 2p1/2 2p3/2'

# test get_spin_econfig('[Kr] 4d10 4f14') '1s1/2 2s1/2 2p1/2 2p3/2 3s1/2 3p1/2 3p3/2 3d3/2 3d5/2 4s1/2 4p1/2 4p3/2 4d3/2 4d5/2 4f5/2 4f7/2'
# test get_spin_econfig('[Kr] 4d3/2 4d5/2 4f5/2 4f7/2')'1s1/2 2s1/2 2p1/2 2p3/2 3s1/2 3p1/2 3p3/2 3d3/2 3d5/2 4s1/2 4p1/2 4p3/2 4d3/2 4d5/2 4f5/2 4f7/2'


def econfigstr_hole(econfigstr, corelevel, highesunoccp, htype='valence'):
    """
    # '1s2 | 2s2' , '1s2' , '2p0' -> '1s1 | 2s2 2p1'

    :param: string
    :param: string
    :param: string

    :return: string
    """
    corestates = econfigstr.split()

    hoc = int(highesunoccp[2:])
    if htype == 'valence':
        new_highocc = str(hoc + 1)
    else:  # charged corehole, removed from system, keep occ
        if hoc == 0:  # do not add orbital to econfig
            highesunoccp = ''
            new_highocc = ''
        else:
            new_highocc = str(hoc)
    new_econfig = ''
    added = False
    for state in corestates:
        if state == corelevel:
            occ = int(state[2:])
            new_occ = occ - 1
            state = state[:2] + str(new_occ)
        if state == highesunoccp:
            added = True
            state = highesunoccp[:2] + str(new_highocc)
        new_econfig = new_econfig + state + ' '
    if not added:
        new_econfig = new_econfig + highesunoccp[:2] + str(new_highocc)

    return new_econfig.rstrip(' ')


def get_state_occ(econfigstr, corehole='', valence='', ch_occ=1.0):
    """
    finds out all not full occupied states and returns a dictionary of them
    return a dict
    i.e corehole '4f 5/2'
    ch_occ full or fractional corehole occupation?
    valence: orbital sting '5d', is to adjust the charges for fractional coreholes
    To that orbital occupation ch_occ - 1 will be added.
    """
    # get all not full occ states
    # get how are are filled spin up down
    state_occ_dict_list = []

    corehole1 = corehole.replace(' ', '')  # get rid of spaces
    corehole_blank = corehole1[:2] + corehole1[-3:]  # get rid of occupation
    econ = econfigstr.replace('| ', '')
    econ_list = econ.split()
    for state in econ_list[::-1]:
        state_l = state[1]
        occ = int(state.split(state_l)[-1])
        max_occ = max_state_occ.get(state_l, 100)
        if occ < max_occ:
            spinstates = states_spin.get(state_l, [])
            #print(spinstates)
            statename = state[:2]
            spinupocc = 0
            spindownocc = 0
            occ_spin = occ
            is_valence = bool(statename == valence)
            for i, spins in enumerate(spinstates):
                spin_mac_occ = max_state_occ_spin[spins]
                occ_spin = occ_spin - spin_mac_occ
                #print occ_spin
                name = statename + spins
                if name == corehole_blank:
                    # use this state
                    # assume it is without the corehole fully filled.
                    nelec = spin_mac_occ
                    max_spin_up_occ = spin_mac_occ / 2.
                    spinupocc = max_spin_up_occ
                    spindownocc = max_spin_up_occ - ch_occ
                    fleur_name = '(' + name + ')'
                    state_dict = {'state': fleur_name, 'spinUp': spinupocc, 'spinDown': spindownocc}
                    state_occ_dict_list.append(state_dict)
                    occ_spin = occ_spin + 1  # because the electron left here and not in the other state
                    continue
                if occ_spin < 0:  # this one state is not full
                    if is_valence:
                        #print('is_valence')
                        nelec = occ_spin + spin_mac_occ - 1 + ch_occ
                    else:
                        nelec = occ_spin + spin_mac_occ
                    max_spin_up_occ = spin_mac_occ / 2.
                    if 0 <= nelec <= max_spin_up_occ:
                        spinupocc = nelec
                        spindownocc = 0.00000
                    elif nelec >= 0:
                        spinupocc = max_spin_up_occ
                        spindownocc = nelec - max_spin_up_occ
                    else:  # do not append
                        continue
                    fleur_name = '(' + name + ')'
                    state_dict = {'state': fleur_name, 'spinUp': spinupocc, 'spinDown': spindownocc}
                    state_occ_dict_list.append(state_dict)

    return state_occ_dict_list


# Reference Binding energies of simple bulk materials:
# TODO: Should be replaced by a 'read' from the NIST database,
# TODO: Also for alloys...
# or the whole nist Database for the elemental shall be parsed here...
# in eV
# TODO maybe use a panda file format or something for this...
# export to json, read in here.
import aiida_fleur
import os
aiida_path = os.path.dirname(aiida_fleur.__file__)
EXP_BINDENERGIES_PATH = os.path.join(aiida_path, 'tools/exp_bindingenergies.json')
with open(EXP_BINDENERGIES_PATH, 'r') as fn:
    exp_bindingenergies = json.load(fn)
"""
exp_bindingenergies = {
 1 : {'binding_energy': {'1s1/2': []}, 'name': 'Hydrogen', 'symbol': 'H'},
 2: {'binding_energy': {'1s1/2': []}, 'name': 'Helium', 'symbol': 'He'},
 3: {'binding_energy': {'1s1/2': [56], '2s1/2': []},
     'name': 'Lithium',
     'symbol': 'Li'},
 4: {'binding_energy': {'1s1/2': [111.82], '2s1/2': []},#111.82
     'name': 'Beryllium',
     'symbol': 'Be'},
 5: {'binding_energy': {'1s1/2': [189], '2p1/2': [], '2p3/2': [], '2s1/2': []},
     'name': 'Boron',
     'symbol': 'B'},
 6: {'binding_energy': {'1s1/2': [285], '2p1/2': [], '2p3/2': [], '2s1/2': []},
     'name': 'Carbon',
     'symbol': 'C'},
 7: {'binding_energy': {'1s1/2': [398], '2p1/2': [], '2p3/2': [], '2s1/2': []},
     'name': 'Nitrogen',
     'symbol': 'N'},
 8: {'binding_energy': {'1s1/2': [531], '2p1/2': [], '2p3/2': [], '2s1/2': []},
     'name': 'Oxygen',
     'symbol': 'O'},
 9: {'binding_energy': {'1s1/2': [685], '2p1/2': [], '2p3/2': [], '2s1/2': []},
     'name': 'Fluorine',
     'symbol': 'F'},
 10: {'binding_energy': {'1s1/2': [863], '2p1/2': [], '2p3/2': [], '2s1/2': []},
      'name': 'Neon',
      'symbol': 'Ne'},
 11: {'binding_energy': {'1s1/2': [1072],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3s1/2': []},
      'name': 'Sodium',
      'symbol': 'Na'},
 12: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [50],
                         '2p3/2': [50],
                         '2s1/2': [],
                         '3s1/2': []},
      'name': 'Magnesium',
      'symbol': 'Mg'},
 13: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [73],
                         '2p3/2': [73],
                         '2s1/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': []},
      'name': 'Aluminium',
      'symbol': 'Al'},
 14: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [99],
                         '2p3/2': [99],
                         '2s1/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': []},
      'name': 'Silicon',
      'symbol': 'Si'},
 15: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [130],
                         '2s1/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': []},
      'name': 'Phosphorus',
      'symbol': 'P'},
 16: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [164],
                         '2s1/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': []},
      'name': 'Sulfur',
      'symbol': 'S'},
 17: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [199],
                         '2s1/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': []},
      'name': 'Chlorine',
      'symbol': 'Cl'},
 18: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [242],
                         '2s1/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': []},
      'name': 'Argon',
      'symbol': 'Ar'},
 19: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4s1/2': []},
      'name': 'Potassium',
      'symbol': 'K'},
 20: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4s1/2': []},
      'name': 'Calcium',
      'symbol': 'Ca'},
 21: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4s1/2': []},
      'name': 'Scandium',
      'symbol': 'Sc'},
 22: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [460.00],
                         '2p3/2': [454.00],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4s1/2': []},
      'name': 'Titanium',
      'symbol': 'Ti'},
 23: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4s1/2': []},
      'name': 'Vanadium',
      'symbol': 'V'},
 24: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4s1/2': []},
      'name': 'Chromium',
      'symbol': 'Cr'},
 25: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4s1/2': []},
      'name': 'Manganese',
      'symbol': 'Mn'},
 26: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4s1/2': []},
      'name': 'Iron',
      'symbol': 'Fe'},
 27: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4s1/2': []},
      'name': 'Cobalt',
      'symbol': 'Co'},
 28: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4s1/2': []},
      'name': 'Nickel',
      'symbol': 'Ni'},
 29: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': []},
      'name': 'Copper',
      'symbol': 'Cu'},
 30: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4s1/2': []},
      'name': 'Zinc',
      'symbol': 'Zn'},
 31: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': []},
      'name': 'Gallium',
      'symbol': 'Ga'},
 32: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': []},
      'name': 'Germanium',
      'symbol': 'Ge'},
 33: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': []},
      'name': 'Arsenic',
      'symbol': 'As'},
 34: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': []},
      'name': 'Selenium',
      'symbol': 'Se'},
 35: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': []},
      'name': 'Bromine',
      'symbol': 'Br'},
 36: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': []},
      'name': 'Krypton',
      'symbol': 'Kr'},
 37: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5s1/2': []},
      'name': 'Rubidium',
      'symbol': 'Rb'},
 38: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5s1/2': []},
      'name': 'Strontium',
      'symbol': 'Sr'},
 39: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5s1/2': []},
      'name': 'Yttrium',
      'symbol': 'Y'},
 40: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5s1/2': []},
      'name': 'Zirconium',
      'symbol': 'Zr'},
 41: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5s1/2': []},
      'name': 'Niobium',
      'symbol': 'Nb'},
 42: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5s1/2': []},
      'name': 'Molybdenum',
      'symbol': 'Mo'},
 43: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5s1/2': []},
      'name': 'Technetium',
      'symbol': 'Tc'},
 44: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5s1/2': []},
      'name': 'Ruthenium',
      'symbol': 'Ru'},
 45: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5s1/2': []},
      'name': 'Rhodium',
      'symbol': 'Rh'},
 46: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': []},
      'name': 'Palladium',
      'symbol': 'Pd'},
 47: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5s1/2': []},
      'name': 'Silver',
      'symbol': 'Ag'},
 48: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5s1/2': []},
      'name': 'Cadmium',
      'symbol': 'Cd'},
 49: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': []},
      'name': 'Indium',
      'symbol': 'In'},
 50: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': []},
      'name': 'Tin',
      'symbol': 'Sn'},
 51: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': []},
      'name': 'Antimony',
      'symbol': 'Sb'},
 52: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': []},
      'name': 'Tellurium',
      'symbol': 'Te'},
 53: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': []},
      'name': 'Iodine',
      'symbol': 'I'},
 54: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': []},
      'name': 'Xenon',
      'symbol': 'Xe'},
 55: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6s1/2': []},
      'name': 'Caesium',
      'symbol': 'Cs'},
 56: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6s1/2': []},
      'name': 'Barium',
      'symbol': 'Ba'},
 57: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5d3/2': [],
                         '5d5/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6s1/2': []},
      'name': 'Lanthanum',
      'symbol': 'La'},
 58: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4f5/2': [],
                         '4f7/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5d3/2': [],
                         '5d5/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6s1/2': []},
      'name': 'Cerium',
      'symbol': 'Ce'},
 59: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4f5/2': [],
                         '4f7/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6s1/2': []},
      'name': 'Praseodymium',
      'symbol': 'Pr'},
 60: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4f5/2': [],
                         '4f7/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6s1/2': []},
      'name': 'Neodymium',
      'symbol': 'Nd'},
 61: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4f5/2': [],
                         '4f7/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6s1/2': []},
      'name': 'Promethium',
      'symbol': 'Pm'},
 62: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4f5/2': [],
                         '4f7/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6s1/2': []},
      'name': 'Samarium',
      'symbol': 'Sm'},
 63: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4f5/2': [],
                         '4f7/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6s1/2': []},
      'name': 'Europium',
      'symbol': 'Eu'},
 64: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4f5/2': [],
                         '4f7/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5d3/2': [],
                         '5d5/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6s1/2': []},
      'name': 'Gadolinium',
      'symbol': 'Gd'},
 65: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4f5/2': [],
                         '4f7/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6s1/2': []},
      'name': 'Terbium',
      'symbol': 'Tb'},
 66: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4f5/2': [],
                         '4f7/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6s1/2': []},
      'name': 'Dysprosium',
      'symbol': 'Dy'},
 67: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4f5/2': [],
                         '4f7/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6s1/2': []},
      'name': 'Holmium',
      'symbol': 'Ho'},
 68: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4f5/2': [],
                         '4f7/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6s1/2': []},
      'name': 'Erbium',
      'symbol': 'Er'},
 69: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4f5/2': [],
                         '4f7/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6s1/2': []},
      'name': 'Thulium',
      'symbol': 'Tm'},
 70: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4f5/2': [],
                         '4f7/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6s1/2': []},
      'name': 'Ytterbium',
      'symbol': 'Yb'},
 71: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4f5/2': [],
                         '4f7/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5d3/2': [],
                         '5d5/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6s1/2': []},
      'name': 'Lutetium',
      'symbol': 'Lu'},
 72: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4f5/2': [],
                         '4f7/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5d3/2': [],
                         '5d5/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6s1/2': []},
      'name': 'Hafnium',
      'symbol': 'Hf'},
 73: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [226.30],
                         '4f5/2': [23.70],
                         '4f7/2': [21.60],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5d3/2': [],
                         '5d5/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6s1/2': []},
      'name': 'Tantalum',
      'symbol': 'Ta'},
 74: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [1806.90],
                         '3p1/2': [2571.10],
                         '3p3/2': [2278.40],
                         '3s1/2': [],
                         '4d3/2': [260.40],
                         '4d5/2': [246.5],#243.50],# 244.0
                         '4f5/2': [33.6],
                         '4f7/2': [31.31],
                         '4p1/2': [],
                         '4p3/2': [423.70],
                         '4s1/2': [594.30],
                         '5d3/2': [],
                         '5d5/2': [],
                         '5p1/2': [],
                         '5p3/2': [37.20],# 36.70
                         '5s1/2': [75.50],
                         '6s1/2': []},
      'name': 'Tungsten',
      'symbol': 'W'},
 75: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4f5/2': [],
                         '4f7/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5d3/2': [],
                         '5d5/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6s1/2': []},
      'name': 'Rhenium',
      'symbol': 'Re'},
 76: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4f5/2': [],
                         '4f7/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5d3/2': [],
                         '5d5/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6s1/2': []},
      'name': 'Osmium',
      'symbol': 'Os'},
 77: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4f5/2': [],
                         '4f7/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5d3/2': [],
                         '5d5/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6s1/2': []},
      'name': 'Iridium',
      'symbol': 'Ir'},
 78: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4f5/2': [],
                         '4f7/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5d3/2': [],
                         '5d5/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6s1/2': []},
      'name': 'Platinum',
      'symbol': 'Pt'},
 79: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4f5/2': [],
                         '4f7/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5d3/2': [],
                         '5d5/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6s1/2': []},
      'name': 'Gold',
      'symbol': 'Au'},
 80: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4f5/2': [],
                         '4f7/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5d3/2': [],
                         '5d5/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6s1/2': []},
      'name': 'Mercury',
      'symbol': 'Hg'},
 81: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4f5/2': [],
                         '4f7/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5d3/2': [],
                         '5d5/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6p1/2': [],
                         '6p3/2': [],
                         '6s1/2': []},
      'name': 'Thallium',
      'symbol': 'Tl'},
 82: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4f5/2': [],
                         '4f7/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5d3/2': [],
                         '5d5/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6p1/2': [],
                         '6p3/2': [],
                         '6s1/2': []},
      'name': 'Lead',
      'symbol': 'Pb'},
 83: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4f5/2': [],
                         '4f7/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5d3/2': [],
                         '5d5/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6p1/2': [],
                         '6p3/2': [],
                         '6s1/2': []},
      'name': 'Bismuth',
      'symbol': 'Bi'},
 84: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4f5/2': [],
                         '4f7/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5d3/2': [],
                         '5d5/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6p1/2': [],
                         '6p3/2': [],
                         '6s1/2': []},
      'name': 'Polonium',
      'symbol': 'Po'},
 85: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4f5/2': [],
                         '4f7/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5d3/2': [],
                         '5d5/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6p1/2': [],
                         '6p3/2': [],
                         '6s1/2': []},
      'name': 'Astatine',
      'symbol': 'At'},
 86: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4f5/2': [],
                         '4f7/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5d3/2': [],
                         '5d5/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6p1/2': [],
                         '6p3/2': [],
                         '6s1/2': []},
      'name': 'Radon',
      'symbol': 'Rn'},
 87: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4f5/2': [],
                         '4f7/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5d3/2': [],
                         '5d5/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6p1/2': [],
                         '6p3/2': [],
                         '6s1/2': [],
                         '7s1/2': []},
      'name': 'Francium',
      'symbol': 'Fr'},
 88: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4f5/2': [],
                         '4f7/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5d3/2': [],
                         '5d5/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6p1/2': [],
                         '6p3/2': [],
                         '6s1/2': [],
                         '7s1/2': []},
      'name': 'Radium',
      'symbol': 'Ra'},
 89: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4f5/2': [],
                         '4f7/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5d3/2': [],
                         '5d5/2': [],
                         '5f5/2': [],
                         '5f7/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6p1/2': [],
                         '6p3/2': [],
                         '6s1/2': [],
                         '7s1/2': []},
      'name': 'Actinium',
      'symbol': 'Ac'},
 90: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4f5/2': [],
                         '4f7/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5d3/2': [],
                         '5d5/2': [],
                         '5f5/2': [],
                         '5f7/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6p1/2': [],
                         '6p3/2': [],
                         '6s1/2': [],
                         '7s1/2': []},
      'name': 'Thorium',
      'symbol': 'Th'},
 91: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4f5/2': [],
                         '4f7/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5d3/2': [],
                         '5d5/2': [],
                         '5f5/2': [],
                         '5f7/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6p1/2': [],
                         '6p3/2': [],
                         '6s1/2': [],
                         '7s1/2': []},
      'name': 'Protactinium',
      'symbol': 'Pa'},
 92: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4f5/2': [],
                         '4f7/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5d3/2': [],
                         '5d5/2': [],
                         '5f5/2': [],
                         '5f7/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6p1/2': [],
                         '6p3/2': [],
                         '6s1/2': [],
                         '7s1/2': []},
      'name': 'Uranium',
      'symbol': 'U'},
 93: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4f5/2': [],
                         '4f7/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5d3/2': [],
                         '5d5/2': [],
                         '5f5/2': [],
                         '5f7/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6p1/2': [],
                         '6p3/2': [],
                         '6s1/2': [],
                         '7s1/2': []},
      'name': 'Neptunium',
      'symbol': 'Np'},
 94: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4f5/2': [],
                         '4f7/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5d3/2': [],
                         '5d5/2': [],
                         '5f5/2': [],
                         '5f7/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6p1/2': [],
                         '6p3/2': [],
                         '6s1/2': [],
                         '7s1/2': []},
      'name': 'Plutonium',
      'symbol': 'Pu'},
 95: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4f5/2': [],
                         '4f7/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5d3/2': [],
                         '5d5/2': [],
                         '5f5/2': [],
                         '5f7/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6p1/2': [],
                         '6p3/2': [],
                         '6s1/2': [],
                         '7s1/2': []},
      'name': 'Americium',
      'symbol': 'Am'},
 96: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4f5/2': [],
                         '4f7/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5d3/2': [],
                         '5d5/2': [],
                         '5f5/2': [],
                         '5f7/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6p1/2': [],
                         '6p3/2': [],
                         '6s1/2': [],
                         '7s1/2': []},
      'name': 'Curium',
      'symbol': 'Cm'},
 97: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4f5/2': [],
                         '4f7/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5d3/2': [],
                         '5d5/2': [],
                         '5f5/2': [],
                         '5f7/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6p1/2': [],
                         '6p3/2': [],
                         '6s1/2': [],
                         '7s1/2': []},
      'name': 'Berkelium',
      'symbol': 'Bk'},
 98: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4f5/2': [],
                         '4f7/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5d3/2': [],
                         '5d5/2': [],
                         '5f5/2': [],
                         '5f7/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6p1/2': [],
                         '6p3/2': [],
                         '6s1/2': [],
                         '7s1/2': []},
      'name': 'Californium',
      'symbol': 'Cf'},
 99: {'binding_energy': {'1s1/2': [],
                         '2p1/2': [],
                         '2p3/2': [],
                         '2s1/2': [],
                         '3d3/2': [],
                         '3d5/2': [],
                         '3p1/2': [],
                         '3p3/2': [],
                         '3s1/2': [],
                         '4d3/2': [],
                         '4d5/2': [],
                         '4f5/2': [],
                         '4f7/2': [],
                         '4p1/2': [],
                         '4p3/2': [],
                         '4s1/2': [],
                         '5d3/2': [],
                         '5d5/2': [],
                         '5f5/2': [],
                         '5f7/2': [],
                         '5p1/2': [],
                         '5p3/2': [],
                         '5s1/2': [],
                         '6p1/2': [],
                         '6p3/2': [],
                         '6s1/2': [],
                         '7s1/2': []},
      'name': 'Einsteinium',
      'symbol': 'Es'},
 100: {'binding_energy': {'1s1/2': [],
                          '2p1/2': [],
                          '2p3/2': [],
                          '2s1/2': [],
                          '3d3/2': [],
                          '3d5/2': [],
                          '3p1/2': [],
                          '3p3/2': [],
                          '3s1/2': [],
                          '4d3/2': [],
                          '4d5/2': [],
                          '4f5/2': [],
                          '4f7/2': [],
                          '4p1/2': [],
                          '4p3/2': [],
                          '4s1/2': [],
                          '5d3/2': [],
                          '5d5/2': [],
                          '5f5/2': [],
                          '5f7/2': [],
                          '5p1/2': [],
                          '5p3/2': [],
                          '5s1/2': [],
                          '6p1/2': [],
                          '6p3/2': [],
                          '6s1/2': [],
                          '7s1/2': []},
       'name': 'Fermium',
       'symbol': 'Fm'},
 101: {'binding_energy': {'1s1/2': [],
                          '2p1/2': [],
                          '2p3/2': [],
                          '2s1/2': [],
                          '3d3/2': [],
                          '3d5/2': [],
                          '3p1/2': [],
                          '3p3/2': [],
                          '3s1/2': [],
                          '4d3/2': [],
                          '4d5/2': [],
                          '4f5/2': [],
                          '4f7/2': [],
                          '4p1/2': [],
                          '4p3/2': [],
                          '4s1/2': [],
                          '5d3/2': [],
                          '5d5/2': [],
                          '5f5/2': [],
                          '5f7/2': [],
                          '5p1/2': [],
                          '5p3/2': [],
                          '5s1/2': [],
                          '6p1/2': [],
                          '6p3/2': [],
                          '6s1/2': [],
                          '7s1/2': []},
       'name': 'Mendelevium',
       'symbol': 'Md'},
 102: {'binding_energy': {'1s1/2': [],
                          '2p1/2': [],
                          '2p3/2': [],
                          '2s1/2': [],
                          '3d3/2': [],
                          '3d5/2': [],
                          '3p1/2': [],
                          '3p3/2': [],
                          '3s1/2': [],
                          '4d3/2': [],
                          '4d5/2': [],
                          '4f5/2': [],
                          '4f7/2': [],
                          '4p1/2': [],
                          '4p3/2': [],
                          '4s1/2': [],
                          '5d3/2': [],
                          '5d5/2': [],
                          '5f5/2': [],
                          '5f7/2': [],
                          '5p1/2': [],
                          '5p3/2': [],
                          '5s1/2': [],
                          '6p1/2': [],
                          '6p3/2': [],
                          '6s1/2': [],
                          '7s1/2': []},
       'name': 'Nobelium',
       'symbol': 'No'},
 103: {'binding_energy': {'1s1/2': [],
                          '2p1/2': [],
                          '2p3/2': [],
                          '2s1/2': [],
                          '3d3/2': [],
                          '3d5/2': [],
                          '3p1/2': [],
                          '3p3/2': [],
                          '3s1/2': [],
                          '4d3/2': [],
                          '4d5/2': [],
                          '4f5/2': [],
                          '4f7/2': [],
                          '4p1/2': [],
                          '4p3/2': [],
                          '4s1/2': [],
                          '5d3/2': [],
                          '5d5/2': [],
                          '5f5/2': [],
                          '5f7/2': [],
                          '5p1/2': [],
                          '5p3/2': [],
                          '5s1/2': [],
                          '6p1/2': [],
                          '6p3/2': [],
                          '6s1/2': [],
                          '7s1/2': []},
       'name': 'Lawrencium',
       'symbol': 'Lr'},
 104: {'binding_energy': {'1s1/2': [],
                          '2p1/2': [],
                          '2p3/2': [],
                          '2s1/2': [],
                          '3d3/2': [],
                          '3d5/2': [],
                          '3p1/2': [],
                          '3p3/2': [],
                          '3s1/2': [],
                          '4d3/2': [],
                          '4d5/2': [],
                          '4f5/2': [],
                          '4f7/2': [],
                          '4p1/2': [],
                          '4p3/2': [],
                          '4s1/2': [],
                          '5d3/2': [],
                          '5d5/2': [],
                          '5f5/2': [],
                          '5f7/2': [],
                          '5p1/2': [],
                          '5p3/2': [],
                          '5s1/2': [],
                          '6d3/2': [],
                          '6d5/2': [],
                          '6p1/2': [],
                          '6p3/2': [],
                          '6s1/2': [],
                          '7s1/2': []},
       'name': 'Rutherfordium',
       'symbol': 'Rf'},
 105: {'binding_energy': {'1s1/2': [],
                          '2p1/2': [],
                          '2p3/2': [],
                          '2s1/2': [],
                          '3d3/2': [],
                          '3d5/2': [],
                          '3p1/2': [],
                          '3p3/2': [],
                          '3s1/2': [],
                          '4d3/2': [],
                          '4d5/2': [],
                          '4f5/2': [],
                          '4f7/2': [],
                          '4p1/2': [],
                          '4p3/2': [],
                          '4s1/2': [],
                          '5d3/2': [],
                          '5d5/2': [],
                          '5f5/2': [],
                          '5f7/2': [],
                          '5p1/2': [],
                          '5p3/2': [],
                          '5s1/2': [],
                          '6d3/2': [],
                          '6d5/2': [],
                          '6p1/2': [],
                          '6p3/2': [],
                          '6s1/2': [],
                          '7s1/2': []},
       'name': 'Dubnium',
       'symbol': 'Db'},
 106: {'binding_energy': {'1s1/2': [],
                          '2p1/2': [],
                          '2p3/2': [],
                          '2s1/2': [],
                          '3d3/2': [],
                          '3d5/2': [],
                          '3p1/2': [],
                          '3p3/2': [],
                          '3s1/2': [],
                          '4d3/2': [],
                          '4d5/2': [],
                          '4f5/2': [],
                          '4f7/2': [],
                          '4p1/2': [],
                          '4p3/2': [],
                          '4s1/2': [],
                          '5d3/2': [],
                          '5d5/2': [],
                          '5f5/2': [],
                          '5f7/2': [],
                          '5p1/2': [],
                          '5p3/2': [],
                          '5s1/2': [],
                          '6d3/2': [],
                          '6d5/2': [],
                          '6p1/2': [],
                          '6p3/2': [],
                          '6s1/2': [],
                          '7s1/2': []},
       'name': 'Seaborgium',
       'symbol': 'Sg'},
 107: {'binding_energy': {'1s1/2': [],
                          '2p1/2': [],
                          '2p3/2': [],
                          '2s1/2': [],
                          '3d3/2': [],
                          '3d5/2': [],
                          '3p1/2': [],
                          '3p3/2': [],
                          '3s1/2': [],
                          '4d3/2': [],
                          '4d5/2': [],
                          '4f5/2': [],
                          '4f7/2': [],
                          '4p1/2': [],
                          '4p3/2': [],
                          '4s1/2': [],
                          '5d3/2': [],
                          '5d5/2': [],
                          '5f5/2': [],
                          '5f7/2': [],
                          '5p1/2': [],
                          '5p3/2': [],
                          '5s1/2': [],
                          '6d3/2': [],
                          '6d5/2': [],
                          '6p1/2': [],
                          '6p3/2': [],
                          '6s1/2': [],
                          '7s1/2': []},
       'name': 'Bohrium',
       'symbol': 'Bh'},
 108: {'binding_energy': {'1s1/2': [],
                          '2p1/2': [],
                          '2p3/2': [],
                          '2s1/2': [],
                          '3d3/2': [],
                          '3d5/2': [],
                          '3p1/2': [],
                          '3p3/2': [],
                          '3s1/2': [],
                          '4d3/2': [],
                          '4d5/2': [],
                          '4f5/2': [],
                          '4f7/2': [],
                          '4p1/2': [],
                          '4p3/2': [],
                          '4s1/2': [],
                          '5d3/2': [],
                          '5d5/2': [],
                          '5f5/2': [],
                          '5f7/2': [],
                          '5p1/2': [],
                          '5p3/2': [],
                          '5s1/2': [],
                          '6d3/2': [],
                          '6d5/2': [],
                          '6p1/2': [],
                          '6p3/2': [],
                          '6s1/2': [],
                          '7s1/2': []},
       'name': 'Hassium',
       'symbol': 'Hs'},
 109: {'binding_energy': {'1s1/2': [],
                          '2p1/2': [],
                          '2p3/2': [],
                          '2s1/2': [],
                          '3d3/2': [],
                          '3d5/2': [],
                          '3p1/2': [],
                          '3p3/2': [],
                          '3s1/2': [],
                          '4d3/2': [],
                          '4d5/2': [],
                          '4f5/2': [],
                          '4f7/2': [],
                          '4p1/2': [],
                          '4p3/2': [],
                          '4s1/2': [],
                          '5d3/2': [],
                          '5d5/2': [],
                          '5f5/2': [],
                          '5f7/2': [],
                          '5p1/2': [],
                          '5p3/2': [],
                          '5s1/2': [],
                          '6d3/2': [],
                          '6d5/2': [],
                          '6p1/2': [],
                          '6p3/2': [],
                          '6s1/2': [],
                          '7s1/2': []},
       'name': 'Meitnerium',
       'symbol': 'Mt'},
 110: {'binding_energy': {'1s1/2': [],
                          '2p1/2': [],
                          '2p3/2': [],
                          '2s1/2': [],
                          '3d3/2': [],
                          '3d5/2': [],
                          '3p1/2': [],
                          '3p3/2': [],
                          '3s1/2': [],
                          '4d3/2': [],
                          '4d5/2': [],
                          '4f5/2': [],
                          '4f7/2': [],
                          '4p1/2': [],
                          '4p3/2': [],
                          '4s1/2': [],
                          '5d3/2': [],
                          '5d5/2': [],
                          '5f5/2': [],
                          '5f7/2': [],
                          '5p1/2': [],
                          '5p3/2': [],
                          '5s1/2': [],
                          '6d3/2': [],
                          '6d5/2': [],
                          '6p1/2': [],
                          '6p3/2': [],
                          '6s1/2': [],
                          '7s1/2': []},
       'name': 'Darmstadtium',
       'symbol': 'Ds'},
 111: {'binding_energy': {'1s1/2': [],
                          '2p1/2': [],
                          '2p3/2': [],
                          '2s1/2': [],
                          '3d3/2': [],
                          '3d5/2': [],
                          '3p1/2': [],
                          '3p3/2': [],
                          '3s1/2': [],
                          '4d3/2': [],
                          '4d5/2': [],
                          '4f5/2': [],
                          '4f7/2': [],
                          '4p1/2': [],
                          '4p3/2': [],
                          '4s1/2': [],
                          '5d3/2': [],
                          '5d5/2': [],
                          '5f5/2': [],
                          '5f7/2': [],
                          '5p1/2': [],
                          '5p3/2': [],
                          '5s1/2': [],
                          '6d3/2': [],
                          '6d5/2': [],
                          '6p1/2': [],
                          '6p3/2': [],
                          '6s1/2': [],
                          '7s1/2': []},
       'name': 'Roentgenium',
       'symbol': 'Rg'},
 112: {'binding_energy': {'1s1/2': [],
                          '2p1/2': [],
                          '2p3/2': [],
                          '2s1/2': [],
                          '3d3/2': [],
                          '3d5/2': [],
                          '3p1/2': [],
                          '3p3/2': [],
                          '3s1/2': [],
                          '4d3/2': [],
                          '4d5/2': [],
                          '4f5/2': [],
                          '4f7/2': [],
                          '4p1/2': [],
                          '4p3/2': [],
                          '4s1/2': [],
                          '5d3/2': [],
                          '5d5/2': [],
                          '5f5/2': [],
                          '5f7/2': [],
                          '5p1/2': [],
                          '5p3/2': [],
                          '5s1/2': [],
                          '6d3/2': [],
                          '6d5/2': [],
                          '6p1/2': [],
                          '6p3/2': [],
                          '6s1/2': [],
                          '7s1/2': []},
       'name': 'Copernicium',
       'symbol': 'Cn'},
 114: {'binding_energy': {'1s1/2': [],
                          '2p1/2': [],
                          '2p3/2': [],
                          '2s1/2': [],
                          '3d3/2': [],
                          '3d5/2': [],
                          '3p1/2': [],
                          '3p3/2': [],
                          '3s1/2': [],
                          '4d3/2': [],
                          '4d5/2': [],
                          '4f5/2': [],
                          '4f7/2': [],
                          '4p1/2': [],
                          '4p3/2': [],
                          '4s1/2': [],
                          '5d3/2': [],
                          '5d5/2': [],
                          '5f5/2': [],
                          '5f7/2': [],
                          '5p1/2': [],
                          '5p3/2': [],
                          '5s1/2': [],
                          '6d3/2': [],
                          '6d5/2': [],
                          '6p1/2': [],
                          '6p3/2': [],
                          '6s1/2': [],
                          '7s1/2': []},
       'name': 'Flerovium',
       'symbol': 'Fl'},
 116: {'binding_energy': {'1s1/2': [],
                          '2p1/2': [],
                          '2p3/2': [],
                          '2s1/2': [],
                          '3d3/2': [],
                          '3d5/2': [],
                          '3p1/2': [],
                          '3p3/2': [],
                          '3s1/2': [],
                          '4d3/2': [],
                          '4d5/2': [],
                          '4f5/2': [],
                          '4f7/2': [],
                          '4p1/2': [],
                          '4p3/2': [],
                          '4s1/2': [],
                          '5d3/2': [],
                          '5d5/2': [],
                          '5f5/2': [],
                          '5f7/2': [],
                          '5p1/2': [],
                          '5p3/2': [],
                          '5s1/2': [],
                          '6d3/2': [],
                          '6d5/2': [],
                          '6p1/2': [],
                          '6p3/2': [],
                          '6s1/2': [],
                          '7p1/2': [],
                          '7p3/2': [],
                          '7s1/2': []},
       'name': 'Livermorium',
       'symbol': 'Lv'}}
"""
