# DO NOT EDIT
# This file is automatically generated by autobean_refactor.modelgen.

from typing import Optional, Type, TypeVar, final
from .. import base, internal
from ..block_comment import BlockComment
from ..ignored import Ignored
from ..punctuation import Eol
from ..spacing import Newline

_Self = TypeVar('_Self', bound='IgnoredLine')


@internal.tree_model
class IgnoredLine(internal.SurroundingCommentsMixin, base.RawTreeModel, internal.SpacingAccessorsMixin):
    RULE = 'ignored_line'

    _ignored = internal.required_field[Ignored]()
    _eol = internal.required_field[Eol]()

    @internal.custom_property
    def _leading_comment_pivot(self) -> base.RawTokenModel:
        return self._ignored.first_token

    @internal.custom_property
    def _trailing_comment_pivot(self) -> base.RawTokenModel:
        return self._eol.last_token

    raw_leading_comment = internal.optional_node_property(internal.SurroundingCommentsMixin._leading_comment, _leading_comment_pivot)
    raw_ignored = internal.required_node_property(_ignored)
    raw_trailing_comment = internal.optional_node_property(internal.SurroundingCommentsMixin._trailing_comment, _trailing_comment_pivot)

    leading_comment = internal.optional_string_property(raw_leading_comment, BlockComment)
    trailing_comment = internal.optional_string_property(raw_trailing_comment, BlockComment)

    @final
    def __init__(
            self,
            token_store: base.TokenStore,
            leading_comment: Optional[BlockComment],
            ignored: Ignored,
            eol: Eol,
            trailing_comment: Optional[BlockComment],
    ):
        super().__init__(token_store)
        self._leading_comment = leading_comment
        self._ignored = ignored
        self._eol = eol
        self._trailing_comment = trailing_comment

    @property
    def first_token(self) -> base.RawTokenModel:
        return (self._leading_comment and self._leading_comment.first_token) or self._ignored.first_token

    @property
    def last_token(self) -> base.RawTokenModel:
        return (self._trailing_comment and self._trailing_comment.last_token) or self._eol.last_token

    def clone(self: _Self, token_store: base.TokenStore, token_transformer: base.TokenTransformer) -> _Self:
        return type(self)(
            token_store,
            type(self)._leading_comment.clone(self._leading_comment, token_store, token_transformer),
            type(self)._ignored.clone(self._ignored, token_store, token_transformer),
            type(self)._eol.clone(self._eol, token_store, token_transformer),
            type(self)._trailing_comment.clone(self._trailing_comment, token_store, token_transformer),
        )

    def _reattach(self, token_store: base.TokenStore, token_transformer: base.TokenTransformer) -> None:
        self._token_store = token_store
        self._leading_comment = type(self)._leading_comment.reattach(self._leading_comment, token_store, token_transformer)
        self._ignored = type(self)._ignored.reattach(self._ignored, token_store, token_transformer)
        self._eol = type(self)._eol.reattach(self._eol, token_store, token_transformer)
        self._trailing_comment = type(self)._trailing_comment.reattach(self._trailing_comment, token_store, token_transformer)

    def _eq(self, other: base.RawTreeModel) -> bool:
        return (
            isinstance(other, IgnoredLine)
            and self._leading_comment == other._leading_comment
            and self._ignored == other._ignored
            and self._eol == other._eol
            and self._trailing_comment == other._trailing_comment
        )

    @classmethod
    def from_children(
            cls: Type[_Self],
            ignored: Ignored,
            *,
            leading_comment: Optional[BlockComment] = None,
            trailing_comment: Optional[BlockComment] = None,
    ) -> _Self:
        eol = Eol.from_default()
        tokens = [
            *cls._leading_comment.detach_with_separators(leading_comment),
            *ignored.detach(),
            *eol.detach(),
            *cls._trailing_comment.detach_with_separators(trailing_comment),
        ]
        token_store = base.TokenStore.from_tokens(tokens)
        cls._leading_comment.reattach(leading_comment, token_store)
        cls._ignored.reattach(ignored, token_store)
        cls._eol.reattach(eol, token_store)
        cls._trailing_comment.reattach(trailing_comment, token_store)
        return cls(token_store, leading_comment, ignored, eol, trailing_comment)

    def auto_claim_comments(self) -> None:
        self.claim_leading_comment(ignore_if_already_claimed=True)
        self.claim_trailing_comment(ignore_if_already_claimed=True)
        type(self)._trailing_comment.auto_claim_comments(self._trailing_comment)
        type(self)._ignored.auto_claim_comments(self._ignored)
        type(self)._leading_comment.auto_claim_comments(self._leading_comment)
