# DO NOT EDIT
# This file is automatically generated by autobean_refactor.modelgen.

from typing import Iterable, Optional, Type, TypeVar, final
from .. import base, internal, meta_item_internal
from ..block_comment import BlockComment
from ..date import Date
from ..escaped_string import EscapedString
from ..inline_comment import InlineComment
from ..link import Link
from ..meta_item import MetaItem
from ..posting import Posting
from ..punctuation import DedentMark, Eol
from ..spacing import Newline, Whitespace
from ..tag import Tag
from ..transaction_flag import TransactionFlag

_Self = TypeVar('_Self', bound='Transaction')


@internal.tree_model
class Transaction(internal.SurroundingCommentsMixin, base.RawTreeModel, internal.SpacingAccessorsMixin):
    RULE = 'transaction'

    _date = internal.required_field[Date]()
    _flag = internal.required_field[TransactionFlag]()
    _string0 = internal.optional_left_field[EscapedString](separators=(Whitespace.from_default(),))
    _string1 = internal.optional_left_field[EscapedString](separators=(Whitespace.from_default(),))
    _string2 = internal.optional_left_field[EscapedString](separators=(Whitespace.from_default(),))
    _tags_links = internal.repeated_field[Link | Tag](separators=(Whitespace.from_default(),))
    _inline_comment = internal.optional_left_field[InlineComment](separators=(Whitespace.from_default(),))
    _eol = internal.required_field[Eol]()
    _meta = internal.repeated_field[MetaItem | BlockComment](separators=(Newline.from_default(),), default_indent='    ')
    _postings = internal.repeated_field[Posting | BlockComment](separators=(Newline.from_default(),), default_indent='    ')
    _dedent_mark = internal.optional_left_field[DedentMark](separators=())

    @internal.custom_property
    def _leading_comment_pivot(self) -> base.RawTokenModel:
        return self._date.first_token

    @internal.custom_property
    def _string0_pivot(self) -> base.RawTokenModel:
        return self._flag.last_token

    @internal.custom_property
    def _string1_pivot(self) -> base.RawTokenModel:
        return (self._string0 and self._string0.last_token) or self._flag.last_token

    @internal.custom_property
    def _string2_pivot(self) -> base.RawTokenModel:
        return (self._string1 and self._string1.last_token) or (self._string0 and self._string0.last_token) or self._flag.last_token

    @internal.custom_property
    def _inline_comment_pivot(self) -> base.RawTokenModel:
        return self._tags_links.last_token or (self._string2 and self._string2.last_token) or (self._string1 and self._string1.last_token) or (self._string0 and self._string0.last_token) or self._flag.last_token

    @internal.custom_property
    def _dedent_mark_pivot(self) -> base.RawTokenModel:
        return self._postings.last_token or self._meta.last_token or self._eol.last_token

    @internal.custom_property
    def _trailing_comment_pivot(self) -> base.RawTokenModel:
        return (self._dedent_mark and self._dedent_mark.last_token) or self._postings.last_token or self._meta.last_token or self._eol.last_token

    raw_leading_comment = internal.optional_node_property(internal.SurroundingCommentsMixin._leading_comment, _leading_comment_pivot)
    raw_date = internal.required_node_property(_date)
    raw_flag = internal.required_node_property(_flag)
    raw_string0 = internal.optional_node_property(_string0, _string0_pivot)
    raw_string1 = internal.optional_node_property(_string1, _string1_pivot)
    raw_string2 = internal.optional_node_property(_string2, _string2_pivot)
    raw_tags_links = internal.repeated_node_property[Link | Tag](_tags_links)
    raw_inline_comment = internal.optional_node_property(_inline_comment, _inline_comment_pivot)
    raw_meta_with_comments = internal.repeated_node_with_interleaving_comments_property(_meta)
    raw_meta = meta_item_internal.repeated_raw_meta_item_property(raw_meta_with_comments)
    raw_postings_with_comments = internal.repeated_node_with_interleaving_comments_property(_postings)
    raw_postings = internal.repeated_filtered_node_property(raw_postings_with_comments, Posting)
    raw_trailing_comment = internal.optional_node_property(internal.SurroundingCommentsMixin._trailing_comment, _trailing_comment_pivot)

    leading_comment = internal.optional_string_property(raw_leading_comment, BlockComment)
    date = internal.required_value_property(raw_date)
    flag = internal.required_value_property(raw_flag)
    string0 = internal.optional_string_property(raw_string0, EscapedString)
    string1 = internal.optional_string_property(raw_string1, EscapedString)
    string2 = internal.optional_string_property(raw_string2, EscapedString)
    inline_comment = internal.optional_string_property(raw_inline_comment, InlineComment)
    meta = meta_item_internal.repeated_meta_item_property(raw_meta_with_comments)
    postings = raw_postings
    trailing_comment = internal.optional_string_property(raw_trailing_comment, BlockComment)

    @final
    def __init__(
            self,
            token_store: base.TokenStore,
            leading_comment: Optional[BlockComment],
            date: Date,
            flag: TransactionFlag,
            string0: Optional[EscapedString],
            string1: Optional[EscapedString],
            string2: Optional[EscapedString],
            repeated_tags_links: internal.Repeated[Link | Tag],
            inline_comment: Optional[InlineComment],
            eol: Eol,
            repeated_meta: internal.Repeated[MetaItem | BlockComment],
            repeated_postings: internal.Repeated[Posting | BlockComment],
            dedent_mark: Optional[DedentMark],
            trailing_comment: Optional[BlockComment],
    ):
        super().__init__(token_store)
        self._leading_comment = leading_comment
        self._date = date
        self._flag = flag
        self._string0 = string0
        self._string1 = string1
        self._string2 = string2
        self._tags_links = repeated_tags_links
        self._inline_comment = inline_comment
        self._eol = eol
        self._meta = repeated_meta
        self._postings = repeated_postings
        self._dedent_mark = dedent_mark
        self._trailing_comment = trailing_comment

    @property
    def first_token(self) -> base.RawTokenModel:
        return (self._leading_comment and self._leading_comment.first_token) or self._date.first_token

    @property
    def last_token(self) -> base.RawTokenModel:
        return (self._trailing_comment and self._trailing_comment.last_token) or (self._dedent_mark and self._dedent_mark.last_token) or self._postings.last_token or self._meta.last_token or self._eol.last_token

    def clone(self: _Self, token_store: base.TokenStore, token_transformer: base.TokenTransformer) -> _Self:
        return type(self)(
            token_store,
            type(self)._leading_comment.clone(self._leading_comment, token_store, token_transformer),
            type(self)._date.clone(self._date, token_store, token_transformer),
            type(self)._flag.clone(self._flag, token_store, token_transformer),
            type(self)._string0.clone(self._string0, token_store, token_transformer),
            type(self)._string1.clone(self._string1, token_store, token_transformer),
            type(self)._string2.clone(self._string2, token_store, token_transformer),
            type(self)._tags_links.clone(self._tags_links, token_store, token_transformer),
            type(self)._inline_comment.clone(self._inline_comment, token_store, token_transformer),
            type(self)._eol.clone(self._eol, token_store, token_transformer),
            type(self)._meta.clone(self._meta, token_store, token_transformer),
            type(self)._postings.clone(self._postings, token_store, token_transformer),
            type(self)._dedent_mark.clone(self._dedent_mark, token_store, token_transformer),
            type(self)._trailing_comment.clone(self._trailing_comment, token_store, token_transformer),
        )

    def _reattach(self, token_store: base.TokenStore, token_transformer: base.TokenTransformer) -> None:
        self._token_store = token_store
        self._leading_comment = type(self)._leading_comment.reattach(self._leading_comment, token_store, token_transformer)
        self._date = type(self)._date.reattach(self._date, token_store, token_transformer)
        self._flag = type(self)._flag.reattach(self._flag, token_store, token_transformer)
        self._string0 = type(self)._string0.reattach(self._string0, token_store, token_transformer)
        self._string1 = type(self)._string1.reattach(self._string1, token_store, token_transformer)
        self._string2 = type(self)._string2.reattach(self._string2, token_store, token_transformer)
        self._tags_links = type(self)._tags_links.reattach(self._tags_links, token_store, token_transformer)
        self._inline_comment = type(self)._inline_comment.reattach(self._inline_comment, token_store, token_transformer)
        self._eol = type(self)._eol.reattach(self._eol, token_store, token_transformer)
        self._meta = type(self)._meta.reattach(self._meta, token_store, token_transformer)
        self._postings = type(self)._postings.reattach(self._postings, token_store, token_transformer)
        self._dedent_mark = type(self)._dedent_mark.reattach(self._dedent_mark, token_store, token_transformer)
        self._trailing_comment = type(self)._trailing_comment.reattach(self._trailing_comment, token_store, token_transformer)

    def _eq(self, other: base.RawTreeModel) -> bool:
        return (
            isinstance(other, Transaction)
            and self._leading_comment == other._leading_comment
            and self._date == other._date
            and self._flag == other._flag
            and self._string0 == other._string0
            and self._string1 == other._string1
            and self._string2 == other._string2
            and self._tags_links == other._tags_links
            and self._inline_comment == other._inline_comment
            and self._eol == other._eol
            and self._meta == other._meta
            and self._postings == other._postings
            and self._dedent_mark == other._dedent_mark
            and self._trailing_comment == other._trailing_comment
        )

    @classmethod
    def from_children(
            cls: Type[_Self],
            date: Date,
            flag: TransactionFlag,
            string0: Optional[EscapedString],
            string1: Optional[EscapedString],
            string2: Optional[EscapedString],
            postings: Iterable[Posting | BlockComment],
            *,
            leading_comment: Optional[BlockComment] = None,
            tags_links: Iterable[Link | Tag] = (),
            inline_comment: Optional[InlineComment] = None,
            meta: Iterable[MetaItem | BlockComment] = (),
            trailing_comment: Optional[BlockComment] = None,
    ) -> _Self:
        repeated_tags_links = cls._tags_links.create_repeated(tags_links)
        eol = Eol.from_default()
        repeated_meta = cls._meta.create_repeated(meta)
        repeated_postings = cls._postings.create_repeated(postings)
        dedent_mark = None
        tokens = [
            *cls._leading_comment.detach_with_separators(leading_comment),
            *date.detach(),
            Whitespace.from_default(),
            *flag.detach(),
            *cls._string0.detach_with_separators(string0),
            *cls._string1.detach_with_separators(string1),
            *cls._string2.detach_with_separators(string2),
            *cls._tags_links.detach_with_separators(repeated_tags_links),
            *cls._inline_comment.detach_with_separators(inline_comment),
            *eol.detach(),
            *cls._meta.detach_with_separators(repeated_meta),
            *cls._postings.detach_with_separators(repeated_postings),
            *cls._dedent_mark.detach_with_separators(dedent_mark),
            *cls._trailing_comment.detach_with_separators(trailing_comment),
        ]
        token_store = base.TokenStore.from_tokens(tokens)
        cls._leading_comment.reattach(leading_comment, token_store)
        cls._date.reattach(date, token_store)
        cls._flag.reattach(flag, token_store)
        cls._string0.reattach(string0, token_store)
        cls._string1.reattach(string1, token_store)
        cls._string2.reattach(string2, token_store)
        cls._tags_links.reattach(repeated_tags_links, token_store)
        cls._inline_comment.reattach(inline_comment, token_store)
        cls._eol.reattach(eol, token_store)
        cls._meta.reattach(repeated_meta, token_store)
        cls._postings.reattach(repeated_postings, token_store)
        cls._dedent_mark.reattach(dedent_mark, token_store)
        cls._trailing_comment.reattach(trailing_comment, token_store)
        return cls(token_store, leading_comment, date, flag, string0, string1, string2, repeated_tags_links, inline_comment, eol, repeated_meta, repeated_postings, dedent_mark, trailing_comment)

    def auto_claim_comments(self) -> None:
        self.claim_leading_comment(ignore_if_already_claimed=True)
        self.claim_trailing_comment(ignore_if_already_claimed=True)
        type(self)._trailing_comment.auto_claim_comments(self._trailing_comment)
        self.raw_postings_with_comments.auto_claim_comments()
        self.raw_meta_with_comments.auto_claim_comments()
        type(self)._inline_comment.auto_claim_comments(self._inline_comment)
        self.raw_tags_links.auto_claim_comments()
        type(self)._string2.auto_claim_comments(self._string2)
        type(self)._string1.auto_claim_comments(self._string1)
        type(self)._string0.auto_claim_comments(self._string0)
        type(self)._flag.auto_claim_comments(self._flag)
        type(self)._date.auto_claim_comments(self._date)
        type(self)._leading_comment.auto_claim_comments(self._leading_comment)
