# mypy-boto3-appmesh

[![PyPI - mypy-boto3-appmesh](https://img.shields.io/pypi/v/mypy-boto3-appmesh.svg?color=blue)](https://pypi.org/project/mypy-boto3-appmesh)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-appmesh.svg?color=blue)](https://pypi.org/project/mypy-boto3-appmesh)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.AppMesh 1.17.19](https://boto3.amazonaws.com/v1/documentation/api/1.17.19/reference/services/appmesh.html#AppMesh) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 4.4.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-appmesh](#mypy-boto3-appmesh)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `AppMesh` service.

```bash
python -m pip install boto3-stubs[appmesh]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[appmesh]` in your environment: `python -m pip install 'boto3-stubs[appmesh]'`

Both type checking and auto-complete should work for `AppMesh` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[appmesh]` in your environment: `python -m pip install 'boto3-stubs[appmesh]'`

Both type checking and auto-complete should work for `AppMesh` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[appmesh]` in your environment: `python -m pip install 'boto3-stubs[appmesh]'`
- Run `mypy` as usual

Type checking should work for `AppMesh` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[appmesh]` in your environment: `python -m pip install 'boto3-stubs[appmesh]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `AppMesh` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`AppMeshClient` provides annotations for `boto3.client("appmesh")`.

```python
import boto3

from mypy_boto3_appmesh import AppMeshClient

client: AppMeshClient = boto3.client("appmesh")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: AppMeshClient = session.client("appmesh")
```

### Paginators annotations

`mypy_boto3_appmesh.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_appmesh import AppMeshClient
from mypy_boto3_appmesh.paginator import (
    ListGatewayRoutesPaginator,
    ListMeshesPaginator,
    ListRoutesPaginator,
    ListTagsForResourcePaginator,
    ListVirtualGatewaysPaginator,
    ListVirtualNodesPaginator,
    ListVirtualRoutersPaginator,
    ListVirtualServicesPaginator,
)

client: AppMeshClient = boto3.client("appmesh")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_gateway_routes_paginator: ListGatewayRoutesPaginator = client.get_paginator("list_gateway_routes")
list_meshes_paginator: ListMeshesPaginator = client.get_paginator("list_meshes")
list_routes_paginator: ListRoutesPaginator = client.get_paginator("list_routes")
list_tags_for_resource_paginator: ListTagsForResourcePaginator = client.get_paginator("list_tags_for_resource")
list_virtual_gateways_paginator: ListVirtualGatewaysPaginator = client.get_paginator("list_virtual_gateways")
list_virtual_nodes_paginator: ListVirtualNodesPaginator = client.get_paginator("list_virtual_nodes")
list_virtual_routers_paginator: ListVirtualRoutersPaginator = client.get_paginator("list_virtual_routers")
list_virtual_services_paginator: ListVirtualServicesPaginator = client.get_paginator("list_virtual_services")
```







### Typed dictionations

`mypy_boto3_appmesh.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_appmesh.type_defs import (
    AccessLogTypeDef,
    AwsCloudMapInstanceAttributeTypeDef,
    AwsCloudMapServiceDiscoveryTypeDef,
    BackendDefaultsTypeDef,
    BackendTypeDef,
    ClientPolicyTlsTypeDef,
    ClientPolicyTypeDef,
    ClientTlsCertificateTypeDef,
    DnsServiceDiscoveryTypeDef,
    DurationTypeDef,
    EgressFilterTypeDef,
    FileAccessLogTypeDef,
    GatewayRouteDataTypeDef,
    GatewayRouteRefTypeDef,
    GatewayRouteSpecTypeDef,
    GatewayRouteStatusTypeDef,
    GatewayRouteTargetTypeDef,
    GatewayRouteVirtualServiceTypeDef,
    GrpcGatewayRouteActionTypeDef,
    GrpcGatewayRouteMatchTypeDef,
    GrpcGatewayRouteTypeDef,
    GrpcRetryPolicyTypeDef,
    GrpcRouteActionTypeDef,
    GrpcRouteMatchTypeDef,
    GrpcRouteMetadataMatchMethodTypeDef,
    GrpcRouteMetadataTypeDef,
    GrpcRouteTypeDef,
    GrpcTimeoutTypeDef,
    HeaderMatchMethodTypeDef,
    HealthCheckPolicyTypeDef,
    HttpGatewayRouteActionTypeDef,
    HttpGatewayRouteMatchTypeDef,
    HttpGatewayRouteTypeDef,
    HttpRetryPolicyTypeDef,
    HttpRouteActionTypeDef,
    HttpRouteHeaderTypeDef,
    HttpRouteMatchTypeDef,
    HttpRouteTypeDef,
    HttpTimeoutTypeDef,
    ListenerTimeoutTypeDef,
    ListenerTlsAcmCertificateTypeDef,
    ListenerTlsCertificateTypeDef,
    ListenerTlsFileCertificateTypeDef,
    ListenerTlsSdsCertificateTypeDef,
    ListenerTlsTypeDef,
    ListenerTlsValidationContextTrustTypeDef,
    ListenerTlsValidationContextTypeDef,
    ListenerTypeDef,
    LoggingTypeDef,
    MatchRangeTypeDef,
    MeshDataTypeDef,
    MeshRefTypeDef,
    MeshSpecTypeDef,
    MeshStatusTypeDef,
    OutlierDetectionTypeDef,
    PortMappingTypeDef,
    ResourceMetadataTypeDef,
    ResponseMetadata,
    RouteDataTypeDef,
    RouteRefTypeDef,
    RouteSpecTypeDef,
    RouteStatusTypeDef,
    ServiceDiscoveryTypeDef,
    SubjectAlternativeNameMatchersTypeDef,
    SubjectAlternativeNamesTypeDef,
    TagRefTypeDef,
    TcpRouteActionTypeDef,
    TcpRouteTypeDef,
    TcpTimeoutTypeDef,
    TlsValidationContextAcmTrustTypeDef,
    TlsValidationContextFileTrustTypeDef,
    TlsValidationContextSdsTrustTypeDef,
    TlsValidationContextTrustTypeDef,
    TlsValidationContextTypeDef,
    VirtualGatewayAccessLogTypeDef,
    VirtualGatewayBackendDefaultsTypeDef,
    VirtualGatewayClientPolicyTlsTypeDef,
    VirtualGatewayClientPolicyTypeDef,
    VirtualGatewayClientTlsCertificateTypeDef,
    VirtualGatewayConnectionPoolTypeDef,
    VirtualGatewayDataTypeDef,
    VirtualGatewayFileAccessLogTypeDef,
    VirtualGatewayGrpcConnectionPoolTypeDef,
    VirtualGatewayHealthCheckPolicyTypeDef,
    VirtualGatewayHttp2ConnectionPoolTypeDef,
    VirtualGatewayHttpConnectionPoolTypeDef,
    VirtualGatewayListenerTlsAcmCertificateTypeDef,
    VirtualGatewayListenerTlsCertificateTypeDef,
    VirtualGatewayListenerTlsFileCertificateTypeDef,
    VirtualGatewayListenerTlsSdsCertificateTypeDef,
    VirtualGatewayListenerTlsTypeDef,
    VirtualGatewayListenerTlsValidationContextTrustTypeDef,
    VirtualGatewayListenerTlsValidationContextTypeDef,
    VirtualGatewayListenerTypeDef,
    VirtualGatewayLoggingTypeDef,
    VirtualGatewayPortMappingTypeDef,
    VirtualGatewayRefTypeDef,
    VirtualGatewaySpecTypeDef,
    VirtualGatewayStatusTypeDef,
    VirtualGatewayTlsValidationContextAcmTrustTypeDef,
    VirtualGatewayTlsValidationContextFileTrustTypeDef,
    VirtualGatewayTlsValidationContextSdsTrustTypeDef,
    VirtualGatewayTlsValidationContextTrustTypeDef,
    VirtualGatewayTlsValidationContextTypeDef,
    VirtualNodeConnectionPoolTypeDef,
    VirtualNodeDataTypeDef,
    VirtualNodeGrpcConnectionPoolTypeDef,
    VirtualNodeHttp2ConnectionPoolTypeDef,
    VirtualNodeHttpConnectionPoolTypeDef,
    VirtualNodeRefTypeDef,
    VirtualNodeServiceProviderTypeDef,
    VirtualNodeSpecTypeDef,
    VirtualNodeStatusTypeDef,
    VirtualNodeTcpConnectionPoolTypeDef,
    VirtualRouterDataTypeDef,
    VirtualRouterListenerTypeDef,
    VirtualRouterRefTypeDef,
    VirtualRouterServiceProviderTypeDef,
    VirtualRouterSpecTypeDef,
    VirtualRouterStatusTypeDef,
    VirtualServiceBackendTypeDef,
    VirtualServiceDataTypeDef,
    VirtualServiceProviderTypeDef,
    VirtualServiceRefTypeDef,
    VirtualServiceSpecTypeDef,
    VirtualServiceStatusTypeDef,
    WeightedTargetTypeDef,
    CreateGatewayRouteOutputTypeDef,
    CreateMeshOutputTypeDef,
    CreateRouteOutputTypeDef,
    CreateVirtualGatewayOutputTypeDef,
    CreateVirtualNodeOutputTypeDef,
    CreateVirtualRouterOutputTypeDef,
    CreateVirtualServiceOutputTypeDef,
    DeleteGatewayRouteOutputTypeDef,
    DeleteMeshOutputTypeDef,
    DeleteRouteOutputTypeDef,
    DeleteVirtualGatewayOutputTypeDef,
    DeleteVirtualNodeOutputTypeDef,
    DeleteVirtualRouterOutputTypeDef,
    DeleteVirtualServiceOutputTypeDef,
    DescribeGatewayRouteOutputTypeDef,
    DescribeMeshOutputTypeDef,
    DescribeRouteOutputTypeDef,
    DescribeVirtualGatewayOutputTypeDef,
    DescribeVirtualNodeOutputTypeDef,
    DescribeVirtualRouterOutputTypeDef,
    DescribeVirtualServiceOutputTypeDef,
    ListGatewayRoutesOutputTypeDef,
    ListMeshesOutputTypeDef,
    ListRoutesOutputTypeDef,
    ListTagsForResourceOutputTypeDef,
    ListVirtualGatewaysOutputTypeDef,
    ListVirtualNodesOutputTypeDef,
    ListVirtualRoutersOutputTypeDef,
    ListVirtualServicesOutputTypeDef,
    PaginatorConfigTypeDef,
    UpdateGatewayRouteOutputTypeDef,
    UpdateMeshOutputTypeDef,
    UpdateRouteOutputTypeDef,
    UpdateVirtualGatewayOutputTypeDef,
    UpdateVirtualNodeOutputTypeDef,
    UpdateVirtualRouterOutputTypeDef,
    UpdateVirtualServiceOutputTypeDef,
)

def get_structure() -> AccessLogTypeDef:
    return {
      ...
    }
```
