# urban_planning_prompts.py

# Architecture Analysis Prompt
ARCHITECTURE_ANALYSIS_PROMPT = """
Analyze the architectural styles, building designs, and construction materials visible in the urban area image provided. Provide insights on the historical influences, modern trends, and architectural diversity observed.
"""

# Infrastructure Evaluation Prompt
INFRASTRUCTURE_EVALUATION_PROMPT = """
Evaluate the infrastructure in the urban area image, focusing on roads, bridges, public transport, utilities, and communication networks. Assess their condition, capacity, and how they meet the needs of the urban population.
"""

# Traffic Flow Analysis Prompt
TRAFFIC_FLOW_ANALYSIS_PROMPT = """
Analyze the traffic flow and transportation systems visible in the urban area image. Identify key traffic routes, congestion points, and the effectiveness of public transportation in addressing urban mobility.
"""

# Environmental Impact Assessment Prompt
ENVIRONMENTAL_IMPACT_ASSESSMENT_PROMPT = """
Assess the environmental impact of the urban area shown in the image. Look for green spaces, pollution sources, and sustainability practices. Provide insights into the balance between urban development and environmental conservation.
"""

# Public Space Utilization Prompt
PUBLIC_SPACE_UTILIZATION_PROMPT = """
Evaluate the public spaces in the urban area, such as parks, squares, and recreational areas, as shown in the image. Assess their accessibility, condition, and how they contribute to the community's quality of life.
"""

# Socioeconomic Impact Analysis Prompt
SOCIOECONOMIC_IMPACT_ANALYSIS_PROMPT = """
Analyze the socioeconomic impact of the urban environment as depicted in the image. Consider factors such as housing, employment opportunities, commercial activities, and social disparities.
"""

# Final Urban Improvement Plan Prompt
FINAL_URBAN_IMPROVEMENT_PLAN_PROMPT = """
Based on the architecture analysis, infrastructure evaluation, traffic flow analysis, environmental impact assessment, public space utilization, and socioeconomic impact analysis provided by the previous agents, develop a comprehensive urban improvement plan. The plan should address key issues identified, propose practical solutions, and outline strategies to enhance the overall quality of life, sustainability, and efficiency of the urban area.
"""


# Additional or custom prompts can be added below as needed.
