use hexlit::hex;
use lakers_shared::BytesP256ElemLen;

// inputs
// U
pub const ID_U_TV: &[u8] = &hex!("a104412b");
pub const ID_U_ENCODED_TV: &[u8] = &hex!("44a104412b");
pub const X_TV: BytesP256ElemLen =
    hex!("368ec1f69aeb659ba37d5a8d45b21bdc0299dceaa8ef235f3ca42ce3530f9525");
pub const G_X_TV: &[u8] = &hex!("8af6f430ebe18d34184017a9a11bf511c8dff8f834730b96c1b7c8dbca2fc3b6");

// V
pub const CRED_V_TV: &[u8] = &hex!("a2026b6578616d706c652e65647508a101a501020241322001215820bbc34960526ea4d32e940cad2a234148ddc21791a12afbcbac93622046dd44f02258204519e257236b2a0ce2023f0931f1f386ca7afda64fcde0108c224c51eabf6072");

// W
pub const W_TV: &[u8] = &hex!("4E5E15AB35008C15B89E91F9F329164D4AACD53D9923672CE0019F9ACD98573F");
pub const G_W_TV: &[u8] = &hex!("FFA4F102134029B3B156890B88C9D9619501196574174DCB68A07DB0588E4D41");
pub const LOC_W_TV: &[u8] = &hex!("636F61703A2F2F656E726F6C6C6D656E742E736572766572"); // coap://enrollment.server

pub const ACL_TV: &[u8] = &hex!("2b"); // kid from ID_U_TV
pub const ACL_INVALID_TV: &[u8] = &hex!("fe"); // random invalid kid

// computed artifacts
// EAD_1
pub const SS_TV: u8 = 2;
pub const ENC_ID_TV: &[u8] = &hex!("da9784962883c96ed01ff122c3");
pub const G_XW_TV: &[u8] =
    &hex!("03a658e9628c79c3f1e59239ca5e604953d11e01c2a442823c944da6682d0b6c");
pub const PRK_TV: &[u8] = &hex!("d40f1601b577dbe7827bb3a20e0d16f7231c3a25225c1ed733f9094050d59666");
pub const K_1_TV: &[u8] = &hex!("6f2a9112801a5011aa33576b5c7862ad");
pub const IV_1_TV: &[u8] = &hex!("d31bc0d128349f290e79f0bde3");
pub const EAD1_VALUE_TV: &[u8] =
    &hex!("7818636f61703a2f2f656e726f6c6c6d656e742e7365727665724dda9784962883c96ed01ff122c3");
pub const MESSAGE_1_WITH_EAD_TV: &[u8] = &hex!("0382060258208af6f430ebe18d34184017a9a11bf511c8dff8f834730b96c1b7c8dbca2fc3b6370158287818636f61703a2f2f656e726f6c6c6d656e742e7365727665724dda9784962883c96ed01ff122c3");

// VREQ
pub const VOUCHER_REQUEST_TV: &[u8] = &hex!("8158520382060258208af6f430ebe18d34184017a9a11bf511c8dff8f834730b96c1b7c8dbca2fc3b6370158287818636f61703a2f2f656e726f6c6c6d656e742e7365727665724dda9784962883c96ed01ff122c3");

// VRES
pub const VOUCHER_RESPONSE_TV: &[u8] = &hex!("8258520382060258208af6f430ebe18d34184017a9a11bf511c8dff8f834730b96c1b7c8dbca2fc3b6370158287818636f61703a2f2f656e726f6c6c6d656e742e7365727665724dda9784962883c96ed01ff122c34948c783671337f75bd5");
pub const H_MESSAGE_1_TV: &[u8] =
    &hex!("a1004dfd2c64777980d9c84f100f93a9cac511ae38f56b2210530c945d186c24");
pub const VOUCHER_INPUT_TV: &[u8] = &hex!("5820a1004dfd2c64777980d9c84f100f93a9cac511ae38f56b2210530c945d186c24585fa2026b6578616d706c652e65647508a101a501020241322001215820bbc34960526ea4d32e940cad2a234148ddc21791a12afbcbac93622046dd44f02258204519e257236b2a0ce2023f0931f1f386ca7afda64fcde0108c224c51eabf6072");
pub const VOUCHER_MAC_TV: [u8; lakers_shared::MAC_LENGTH] = hex!("c783671337f75bd5");

// EAD_2
pub const EAD2_VALUE_TV: &[u8] = &hex!("c783671337f75bd5");

// ---- Traces for stateless operation (prefixed with SLO)
// VREQ
pub const SLO_OPAQUE_STATE_TV: &[u8] =
    &hex!("827819666538303a3a623833343a643630623a373936663a38646530198bed");
pub const SLO_VOUCHER_REQUEST_TV: &[u8] = &hex!("8258520382060258208af6f430ebe18d34184017a9a11bf511c8dff8f834730b96c1b7c8dbca2fc3b6370158287818636f61703a2f2f656e726f6c6c6d656e742e7365727665724dda9784962883c96ed01ff122c3581f827819666538303a3a623833343a643630623a373936663a38646530198bed");

// VRES
pub const SLO_VOUCHER_RESPONSE_TV: &[u8] = &hex!("8358520382060258208af6f430ebe18d34184017a9a11bf511c8dff8f834730b96c1b7c8dbca2fc3b6370158287818636f61703a2f2f656e726f6c6c6d656e742e7365727665724dda9784962883c96ed01ff122c34948c783671337f75bd5581f827819666538303a3a623833343a643630623a373936663a38646530198bed");
