# Generated by Django 2.2.17 on 2021-01-28 13:40

from django.db import migrations


def update_disabled_accounts_aliases(apps, schema_editor):
    User = apps.get_model("core", "User")
    Alias = apps.get_model("admin", "Alias")

    disabled_accounts = User.objects.filter(mailbox__isnull=False, is_active=False)

    Alias.objects.filter(
        address__in=list(disabled_accounts.values_list("email", flat=True)),
        enabled=True,
    ).update(enabled=False)


class Migration(migrations.Migration):

    dependencies = [
        ("admin", "0018_auto_20201204_0935"),
        ("core", "0022_user_tfa_enabled"),
    ]

    operations = [
        migrations.RunPython(update_disabled_accounts_aliases),
    ]
