# Generated by Django 4.2.22 on 2025-07-01 09:21

from django.db import migrations


APPS_MAP = {
    "modoboa_radicale": "calendars",
    "modoboa_webmail": "webmail",
    "modoboa_rspamd": "rspamd",
    "modoboa_sievefilters": "sievefilters",
    "modoboa_postfix_autoreply": "autoreply",
}


def rename_param_apps(apps, schema_editor):
    LocalConfig = apps.get_model("core", "LocalConfig")
    lc = LocalConfig.objects.first()
    if not lc:
        return
    for old_name, new_name in APPS_MAP.items():
        if old_name not in lc._parameters:
            continue
        lc._parameters[new_name] = lc._parameters[old_name]
        del lc._parameters[old_name]
    lc.save()


class Migration(migrations.Migration):

    dependencies = [
        ("lib", "0006_auto_20161104_2206"),
    ]

    operations = [
        migrations.RunPython(rename_param_apps, migrations.RunPython.noop),
    ]
