# Generated by Django 1.10.5 on 2017-02-16 10:12
from django.db import migrations


def create_quota_limits(apps, schema_editor):
    """Create quota limits."""
    User = apps.get_model("core", "User")
    if not User.objects.exists():
        return
    ContentType = apps.get_model("contenttypes", "ContentType")
    UserObjectLimit = apps.get_model("limits", "UserObjectLimit")
    to_create = []
    ct = ContentType.objects.get(app_label="admin", model="domain")
    for u in User.objects.all():
        to_create.append(
            UserObjectLimit(user=u, name="quota", max_value=0, content_type=ct)
        )
    UserObjectLimit.objects.bulk_create(to_create)


class Migration(migrations.Migration):

    dependencies = [
        ("limits", "0005_auto_20160415_1654"),
    ]

    operations = [migrations.RunPython(create_quota_limits)]
