#ifndef HAM_MATHUTILS_H
#define HAM_MATHUTILS_H

#include <math.h>
#include <iostream>
#include <vector>
#include <limits>
#include <stdint.h>
#include <algorithm>

using namespace std;

namespace ham {

//FIXME: Need to generate dynamically once upon initialization of HMM. System differences between (int,long,...);
//Or just leave it. It may work well enough;

// POWER[b][a-1] = a**b
#if __LP64__
const uint64_t POWER[32][128] = {
  {1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL},
  {1ULL, 2ULL, 3ULL, 4ULL, 5ULL, 6ULL, 7ULL, 8ULL, 9ULL, 10ULL, 11ULL, 12ULL, 13ULL, 14ULL, 15ULL, 16ULL, 17ULL, 18ULL, 19ULL, 20ULL, 21ULL, 22ULL, 23ULL, 24ULL, 25ULL, 26ULL, 27ULL, 28ULL, 29ULL, 30ULL, 31ULL, 32ULL, 33ULL, 34ULL, 35ULL, 36ULL, 37ULL, 38ULL, 39ULL, 40ULL, 41ULL, 42ULL, 43ULL, 44ULL, 45ULL, 46ULL, 47ULL, 48ULL, 49ULL, 50ULL, 51ULL, 52ULL, 53ULL, 54ULL, 55ULL, 56ULL, 57ULL, 58ULL, 59ULL, 60ULL, 61ULL, 62ULL, 63ULL, 64ULL, 65ULL, 66ULL, 67ULL, 68ULL, 69ULL, 70ULL, 71ULL, 72ULL, 73ULL, 74ULL, 75ULL, 76ULL, 77ULL, 78ULL, 79ULL, 80ULL, 81ULL, 82ULL, 83ULL, 84ULL, 85ULL, 86ULL, 87ULL, 88ULL, 89ULL, 90ULL, 91ULL, 92ULL, 93ULL, 94ULL, 95ULL, 96ULL, 97ULL, 98ULL, 99ULL, 100ULL, 101ULL, 102ULL, 103ULL, 104ULL, 105ULL, 106ULL, 107ULL, 108ULL, 109ULL, 110ULL, 111ULL, 112ULL, 113ULL, 114ULL, 115ULL, 116ULL, 117ULL, 118ULL, 119ULL, 120ULL, 121ULL, 122ULL, 123ULL, 124ULL, 125ULL, 126ULL, 127ULL, 128ULL},
  {1ULL, 4ULL, 9ULL, 16ULL, 25ULL, 36ULL, 49ULL, 64ULL, 81ULL, 100ULL, 121ULL, 144ULL, 169ULL, 196ULL, 225ULL, 256ULL, 289ULL, 324ULL, 361ULL, 400ULL, 441ULL, 484ULL, 529ULL, 576ULL, 625ULL, 676ULL, 729ULL, 784ULL, 841ULL, 900ULL, 961ULL, 1024ULL, 1089ULL, 1156ULL, 1225ULL, 1296ULL, 1369ULL, 1444ULL, 1521ULL, 1600ULL, 1681ULL, 1764ULL, 1849ULL, 1936ULL, 2025ULL, 2116ULL, 2209ULL, 2304ULL, 2401ULL, 2500ULL, 2601ULL, 2704ULL, 2809ULL, 2916ULL, 3025ULL, 3136ULL, 3249ULL, 3364ULL, 3481ULL, 3600ULL, 3721ULL, 3844ULL, 3969ULL, 4096ULL, 4225ULL, 4356ULL, 4489ULL, 4624ULL, 4761ULL, 4900ULL, 5041ULL, 5184ULL, 5329ULL, 5476ULL, 5625ULL, 5776ULL, 5929ULL, 6084ULL, 6241ULL, 6400ULL, 6561ULL, 6724ULL, 6889ULL, 7056ULL, 7225ULL, 7396ULL, 7569ULL, 7744ULL, 7921ULL, 8100ULL, 8281ULL, 8464ULL, 8649ULL, 8836ULL, 9025ULL, 9216ULL, 9409ULL, 9604ULL, 9801ULL, 10000ULL, 10201ULL, 10404ULL, 10609ULL, 10816ULL, 11025ULL, 11236ULL, 11449ULL, 11664ULL, 11881ULL, 12100ULL, 12321ULL, 12544ULL, 12769ULL, 12996ULL, 13225ULL, 13456ULL, 13689ULL, 13924ULL, 14161ULL, 14400ULL, 14641ULL, 14884ULL, 15129ULL, 15376ULL, 15625ULL, 15876ULL, 16129ULL, 16384ULL},
  {1ULL, 8ULL, 27ULL, 64ULL, 125ULL, 216ULL, 343ULL, 512ULL, 729ULL, 1000ULL, 1331ULL, 1728ULL, 2197ULL, 2744ULL, 3375ULL, 4096ULL, 4913ULL, 5832ULL, 6859ULL, 8000ULL, 9261ULL, 10648ULL, 12167ULL, 13824ULL, 15625ULL, 17576ULL, 19683ULL, 21952ULL, 24389ULL, 27000ULL, 29791ULL, 32768ULL, 35937ULL, 39304ULL, 42875ULL, 46656ULL, 50653ULL, 54872ULL, 59319ULL, 64000ULL, 68921ULL, 74088ULL, 79507ULL, 85184ULL, 91125ULL, 97336ULL, 103823ULL, 110592ULL, 117649ULL, 125000ULL, 132651ULL, 140608ULL, 148877ULL, 157464ULL, 166375ULL, 175616ULL, 185193ULL, 195112ULL, 205379ULL, 216000ULL, 226981ULL, 238328ULL, 250047ULL, 262144ULL, 274625ULL, 287496ULL, 300763ULL, 314432ULL, 328509ULL, 343000ULL, 357911ULL, 373248ULL, 389017ULL, 405224ULL, 421875ULL, 438976ULL, 456533ULL, 474552ULL, 493039ULL, 512000ULL, 531441ULL, 551368ULL, 571787ULL, 592704ULL, 614125ULL, 636056ULL, 658503ULL, 681472ULL, 704969ULL, 729000ULL, 753571ULL, 778688ULL, 804357ULL, 830584ULL, 857375ULL, 884736ULL, 912673ULL, 941192ULL, 970299ULL, 1000000ULL, 1030301ULL, 1061208ULL, 1092727ULL, 1124864ULL, 1157625ULL, 1191016ULL, 1225043ULL, 1259712ULL, 1295029ULL, 1331000ULL, 1367631ULL, 1404928ULL, 1442897ULL, 1481544ULL, 1520875ULL, 1560896ULL, 1601613ULL, 1643032ULL, 1685159ULL, 1728000ULL, 1771561ULL, 1815848ULL, 1860867ULL, 1906624ULL, 1953125ULL, 2000376ULL, 2048383ULL, 2097152ULL},
  {1ULL, 16ULL, 81ULL, 256ULL, 625ULL, 1296ULL, 2401ULL, 4096ULL, 6561ULL, 10000ULL, 14641ULL, 20736ULL, 28561ULL, 38416ULL, 50625ULL, 65536ULL, 83521ULL, 104976ULL, 130321ULL, 160000ULL, 194481ULL, 234256ULL, 279841ULL, 331776ULL, 390625ULL, 456976ULL, 531441ULL, 614656ULL, 707281ULL, 810000ULL, 923521ULL, 1048576ULL, 1185921ULL, 1336336ULL, 1500625ULL, 1679616ULL, 1874161ULL, 2085136ULL, 2313441ULL, 2560000ULL, 2825761ULL, 3111696ULL, 3418801ULL, 3748096ULL, 4100625ULL, 4477456ULL, 4879681ULL, 5308416ULL, 5764801ULL, 6250000ULL, 6765201ULL, 7311616ULL, 7890481ULL, 8503056ULL, 9150625ULL, 9834496ULL, 10556001ULL, 11316496ULL, 12117361ULL, 12960000ULL, 13845841ULL, 14776336ULL, 15752961ULL, 16777216ULL, 17850625ULL, 18974736ULL, 20151121ULL, 21381376ULL, 22667121ULL, 24010000ULL, 25411681ULL, 26873856ULL, 28398241ULL, 29986576ULL, 31640625ULL, 33362176ULL, 35153041ULL, 37015056ULL, 38950081ULL, 40960000ULL, 43046721ULL, 45212176ULL, 47458321ULL, 49787136ULL, 52200625ULL, 54700816ULL, 57289761ULL, 59969536ULL, 62742241ULL, 65610000ULL, 68574961ULL, 71639296ULL, 74805201ULL, 78074896ULL, 81450625ULL, 84934656ULL, 88529281ULL, 92236816ULL, 96059601ULL, 100000000ULL, 104060401ULL, 108243216ULL, 112550881ULL, 116985856ULL, 121550625ULL, 126247696ULL, 131079601ULL, 136048896ULL, 141158161ULL, 146410000ULL, 151807041ULL, 157351936ULL, 163047361ULL, 168896016ULL, 174900625ULL, 181063936ULL, 187388721ULL, 193877776ULL, 200533921ULL, 207360000ULL, 214358881ULL, 221533456ULL, 228886641ULL, 236421376ULL, 244140625ULL, 252047376ULL, 260144641ULL, 268435456ULL},
  {1ULL, 32ULL, 243ULL, 1024ULL, 3125ULL, 7776ULL, 16807ULL, 32768ULL, 59049ULL, 100000ULL, 161051ULL, 248832ULL, 371293ULL, 537824ULL, 759375ULL, 1048576ULL, 1419857ULL, 1889568ULL, 2476099ULL, 3200000ULL, 4084101ULL, 5153632ULL, 6436343ULL, 7962624ULL, 9765625ULL, 11881376ULL, 14348907ULL, 17210368ULL, 20511149ULL, 24300000ULL, 28629151ULL, 33554432ULL, 39135393ULL, 45435424ULL, 52521875ULL, 60466176ULL, 69343957ULL, 79235168ULL, 90224199ULL, 102400000ULL, 115856201ULL, 130691232ULL, 147008443ULL, 164916224ULL, 184528125ULL, 205962976ULL, 229345007ULL, 254803968ULL, 282475249ULL, 312500000ULL, 345025251ULL, 380204032ULL, 418195493ULL, 459165024ULL, 503284375ULL, 550731776ULL, 601692057ULL, 656356768ULL, 714924299ULL, 777600000ULL, 844596301ULL, 916132832ULL, 992436543ULL, 1073741824ULL, 1160290625ULL, 1252332576ULL, 1350125107ULL, 1453933568ULL, 1564031349ULL, 1680700000ULL, 1804229351ULL, 1934917632ULL, 2073071593ULL, 2219006624ULL, 2373046875ULL, 2535525376ULL, 2706784157ULL, 2887174368ULL, 3077056399ULL, 3276800000ULL, 3486784401ULL, 3707398432ULL, 3939040643ULL, 4182119424ULL, 4437053125ULL, 4704270176ULL, 4984209207ULL, 5277319168ULL, 5584059449ULL, 5904900000ULL, 6240321451ULL, 6590815232ULL, 6956883693ULL, 7339040224ULL, 7737809375ULL, 8153726976ULL, 8587340257ULL, 9039207968ULL, 9509900499ULL, 10000000000ULL, 10510100501ULL, 11040808032ULL, 11592740743ULL, 12166529024ULL, 12762815625ULL, 13382255776ULL, 14025517307ULL, 14693280768ULL, 15386239549ULL, 16105100000ULL, 16850581551ULL, 17623416832ULL, 18424351793ULL, 19254145824ULL, 20113571875ULL, 21003416576ULL, 21924480357ULL, 22877577568ULL, 23863536599ULL, 24883200000ULL, 25937424601ULL, 27027081632ULL, 28153056843ULL, 29316250624ULL, 30517578125ULL, 31757969376ULL, 33038369407ULL, 34359738368ULL},
  {1ULL, 64ULL, 729ULL, 4096ULL, 15625ULL, 46656ULL, 117649ULL, 262144ULL, 531441ULL, 1000000ULL, 1771561ULL, 2985984ULL, 4826809ULL, 7529536ULL, 11390625ULL, 16777216ULL, 24137569ULL, 34012224ULL, 47045881ULL, 64000000ULL, 85766121ULL, 113379904ULL, 148035889ULL, 191102976ULL, 244140625ULL, 308915776ULL, 387420489ULL, 481890304ULL, 594823321ULL, 729000000ULL, 887503681ULL, 1073741824ULL, 1291467969ULL, 1544804416ULL, 1838265625ULL, 2176782336ULL, 2565726409ULL, 3010936384ULL, 3518743761ULL, 4096000000ULL, 4750104241ULL, 5489031744ULL, 6321363049ULL, 7256313856ULL, 8303765625ULL, 9474296896ULL, 10779215329ULL, 12230590464ULL, 13841287201ULL, 15625000000ULL, 17596287801ULL, 19770609664ULL, 22164361129ULL, 24794911296ULL, 27680640625ULL, 30840979456ULL, 34296447249ULL, 38068692544ULL, 42180533641ULL, 46656000000ULL, 51520374361ULL, 56800235584ULL, 62523502209ULL, 68719476736ULL, 75418890625ULL, 82653950016ULL, 90458382169ULL, 98867482624ULL, 107918163081ULL, 117649000000ULL, 128100283921ULL, 139314069504ULL, 151334226289ULL, 164206490176ULL, 177978515625ULL, 192699928576ULL, 208422380089ULL, 225199600704ULL, 243087455521ULL, 262144000000ULL, 282429536481ULL, 304006671424ULL, 326940373369ULL, 351298031616ULL, 377149515625ULL, 404567235136ULL, 433626201009ULL, 464404086784ULL, 496981290961ULL, 531441000000ULL, 567869252041ULL, 606355001344ULL, 646990183449ULL, 689869781056ULL, 735091890625ULL, 782757789696ULL, 832972004929ULL, 885842380864ULL, 941480149401ULL, 1000000000000ULL, 1061520150601ULL, 1126162419264ULL, 1194052296529ULL, 1265319018496ULL, 1340095640625ULL, 1418519112256ULL, 1500730351849ULL, 1586874322944ULL, 1677100110841ULL, 1771561000000ULL, 1870414552161ULL, 1973822685184ULL, 2081951752609ULL, 2194972623936ULL, 2313060765625ULL, 2436396322816ULL, 2565164201769ULL, 2699554153024ULL, 2839760855281ULL, 2985984000000ULL, 3138428376721ULL, 3297303959104ULL, 3462825991689ULL, 3635215077376ULL, 3814697265625ULL, 4001504141376ULL, 4195872914689ULL, 4398046511104ULL},
  {1ULL, 128ULL, 2187ULL, 16384ULL, 78125ULL, 279936ULL, 823543ULL, 2097152ULL, 4782969ULL, 10000000ULL, 19487171ULL, 35831808ULL, 62748517ULL, 105413504ULL, 170859375ULL, 268435456ULL, 410338673ULL, 612220032ULL, 893871739ULL, 1280000000ULL, 1801088541ULL, 2494357888ULL, 3404825447ULL, 4586471424ULL, 6103515625ULL, 8031810176ULL, 10460353203ULL, 13492928512ULL, 17249876309ULL, 21870000000ULL, 27512614111ULL, 34359738368ULL, 42618442977ULL, 52523350144ULL, 64339296875ULL, 78364164096ULL, 94931877133ULL, 114415582592ULL, 137231006679ULL, 163840000000ULL, 194754273881ULL, 230539333248ULL, 271818611107ULL, 319277809664ULL, 373669453125ULL, 435817657216ULL, 506623120463ULL, 587068342272ULL, 678223072849ULL, 781250000000ULL, 897410677851ULL, 1028071702528ULL, 1174711139837ULL, 1338925209984ULL, 1522435234375ULL, 1727094849536ULL, 1954897493193ULL, 2207984167552ULL, 2488651484819ULL, 2799360000000ULL, 3142742836021ULL, 3521614606208ULL, 3938980639167ULL, 4398046511104ULL, 4902227890625ULL, 5455160701056ULL, 6060711605323ULL, 6722988818432ULL, 7446353252589ULL, 8235430000000ULL, 9095120158391ULL, 10030613004288ULL, 11047398519097ULL, 12151280273024ULL, 13348388671875ULL, 14645194571776ULL, 16048523266853ULL, 17565568854912ULL, 19203908986159ULL, 20971520000000ULL, 22876792454961ULL, 24928547056768ULL, 27136050989627ULL, 29509034655744ULL, 32057708828125ULL, 34792782221696ULL, 37725479487783ULL, 40867559636992ULL, 44231334895529ULL, 47829690000000ULL, 51676101935731ULL, 55784660123648ULL, 60170087060757ULL, 64847759419264ULL, 69833729609375ULL, 75144747810816ULL, 80798284478113ULL, 86812553324672ULL, 93206534790699ULL, 100000000000000ULL, 107213535210701ULL, 114868566764928ULL, 122987386542487ULL, 131593177923584ULL, 140710042265625ULL, 150363025899136ULL, 160578147647843ULL, 171382426877952ULL, 182803912081669ULL, 194871710000000ULL, 207616015289871ULL, 221068140740608ULL, 235260548044817ULL, 250226879128704ULL, 266001988046875ULL, 282621973446656ULL, 300124211606973ULL, 318547390056832ULL, 337931541778439ULL, 358318080000000ULL, 379749833583241ULL, 402271083010688ULL, 425927596977747ULL, 450766669594624ULL, 476837158203125ULL, 504189521813376ULL, 532875860165503ULL, 562949953421312ULL},
  {1ULL, 256ULL, 6561ULL, 65536ULL, 390625ULL, 1679616ULL, 5764801ULL, 16777216ULL, 43046721ULL, 100000000ULL, 214358881ULL, 429981696ULL, 815730721ULL, 1475789056ULL, 2562890625ULL, 4294967296ULL, 6975757441ULL, 11019960576ULL, 16983563041ULL, 25600000000ULL, 37822859361ULL, 54875873536ULL, 78310985281ULL, 110075314176ULL, 152587890625ULL, 208827064576ULL, 282429536481ULL, 377801998336ULL, 500246412961ULL, 656100000000ULL, 852891037441ULL, 1099511627776ULL, 1406408618241ULL, 1785793904896ULL, 2251875390625ULL, 2821109907456ULL, 3512479453921ULL, 4347792138496ULL, 5352009260481ULL, 6553600000000ULL, 7984925229121ULL, 9682651996416ULL, 11688200277601ULL, 14048223625216ULL, 16815125390625ULL, 20047612231936ULL, 23811286661761ULL, 28179280429056ULL, 33232930569601ULL, 39062500000000ULL, 45767944570401ULL, 53459728531456ULL, 62259690411361ULL, 72301961339136ULL, 83733937890625ULL, 96717311574016ULL, 111429157112001ULL, 128063081718016ULL, 146830437604321ULL, 167961600000000ULL, 191707312997281ULL, 218340105584896ULL, 248155780267521ULL, 281474976710656ULL, 318644812890625ULL, 360040606269696ULL, 406067677556641ULL, 457163239653376ULL, 513798374428641ULL, 576480100000000ULL, 645753531245761ULL, 722204136308736ULL, 806460091894081ULL, 899194740203776ULL, 1001129150390625ULL, 1113034787454976ULL, 1235736291547681ULL, 1370114370683136ULL, 1517108809906561ULL, 1677721600000000ULL, 1853020188851841ULL, 2044140858654976ULL, 2252292232139041ULL, 2478758911082496ULL, 2724905250390625ULL, 2992179271065856ULL, 3282116715437121ULL, 3596345248055296ULL, 3936588805702081ULL, 4304672100000000ULL, 4702525276151521ULL, 5132188731375616ULL, 5595818096650401ULL, 6095689385410816ULL, 6634204312890625ULL, 7213895789838336ULL, 7837433594376961ULL, 8507630225817856ULL, 9227446944279201ULL, 10000000000000000ULL, 10828567056280801ULL, 11716593810022656ULL, 12667700813876161ULL, 13685690504052736ULL, 14774554437890625ULL, 15938480745308416ULL, 17181861798319201ULL, 18509302102818816ULL, 19925626416901921ULL, 21435888100000000ULL, 23045377697175681ULL, 24759631762948096ULL, 26584441929064321ULL, 28525864220672256ULL, 30590228625390625ULL, 32784148919812096ULL, 35114532758015841ULL, 37588592026706176ULL, 40213853471634241ULL, 42998169600000000ULL, 45949729863572161ULL, 49077072127303936ULL, 52389094428262881ULL, 55895067029733376ULL, 59604644775390625ULL, 63527879748485376ULL, 67675234241018881ULL, 72057594037927936ULL},
  {1ULL, 512ULL, 19683ULL, 262144ULL, 1953125ULL, 10077696ULL, 40353607ULL, 134217728ULL, 387420489ULL, 1000000000ULL, 2357947691ULL, 5159780352ULL, 10604499373ULL, 20661046784ULL, 38443359375ULL, 68719476736ULL, 118587876497ULL, 198359290368ULL, 322687697779ULL, 512000000000ULL, 794280046581ULL, 1207269217792ULL, 1801152661463ULL, 2641807540224ULL, 3814697265625ULL, 5429503678976ULL, 7625597484987ULL, 10578455953408ULL, 14507145975869ULL, 19683000000000ULL, 26439622160671ULL, 35184372088832ULL, 46411484401953ULL, 60716992766464ULL, 78815638671875ULL, 101559956668416ULL, 129961739795077ULL, 165216101262848ULL, 208728361158759ULL, 262144000000000ULL, 327381934393961ULL, 406671383849472ULL, 502592611936843ULL, 618121839509504ULL, 756680642578125ULL, 922190162669056ULL, 1119130473102767ULL, 1352605460594688ULL, 1628413597910449ULL, 1953125000000000ULL, 2334165173090451ULL, 2779905883635712ULL, 3299763591802133ULL, 3904305912313344ULL, 4605366583984375ULL, 5416169448144896ULL, 6351461955384057ULL, 7427658739644928ULL, 8662995818654939ULL, 10077696000000000ULL, 11694146092834141ULL, 13537086546263552ULL, 15633814156853823ULL, 18014398509481984ULL, 20711912837890625ULL, 23762680013799936ULL, 27206534396294947ULL, 31087100296429568ULL, 35452087835576229ULL, 40353607000000000ULL, 45848500718449031ULL, 51998697814228992ULL, 58871586708267913ULL, 66540410775079424ULL, 75084686279296875ULL, 84590643846578176ULL, 95151694449171437ULL, 106868920913284608ULL, 119851595982618319ULL, 134217728000000000ULL, 150094635296999121ULL, 167619550409708032ULL, 186940255267540403ULL, 208215748530929664ULL, 231616946283203125ULL, 257327417311663616ULL, 285544154243029527ULL, 316478381828866048ULL, 350356403707485209ULL, 387420489000000000ULL, 427929800129788411ULL, 472161363286556672ULL, 520411082988487293ULL, 572994802228616704ULL, 630249409724609375ULL, 692533995824480256ULL, 760231058654565217ULL, 833747762130149888ULL, 913517247483640899ULL, 1000000000000000000ULL, 1093685272684360901ULL, 1195092568622310912ULL, 1304773183829244583ULL, 1423311812421484544ULL, 1551328215978515625ULL, 1689478959002692096ULL, 1838459212420154507ULL, 1999004627104432128ULL, 2171893279442309389ULL, 2357947691000000000ULL, 2558036924386500591ULL, 2773078757450186752ULL, 3004041937984268273ULL, 3251948521156637184ULL, 3517876291919921875ULL, 3802961274698203136ULL, 4108400332687853397ULL, 4435453859151328768ULL, 4785448563124474679ULL, 5159780352000000000ULL, 5559917313492231481ULL, 5987402799531080192ULL, 6443858614676334363ULL, 6930988311686938624ULL, 7450580596923828125ULL, 8004512848309157376ULL, 8594754748609397887ULL, 9223372036854775808ULL},
  {1ULL, 1024ULL, 59049ULL, 1048576ULL, 9765625ULL, 60466176ULL, 282475249ULL, 1073741824ULL, 3486784401ULL, 10000000000ULL, 25937424601ULL, 61917364224ULL, 137858491849ULL, 289254654976ULL, 576650390625ULL, 1099511627776ULL, 2015993900449ULL, 3570467226624ULL, 6131066257801ULL, 10240000000000ULL, 16679880978201ULL, 26559922791424ULL, 41426511213649ULL, 63403380965376ULL, 95367431640625ULL, 141167095653376ULL, 205891132094649ULL, 296196766695424ULL, 420707233300201ULL, 590490000000000ULL, 819628286980801ULL, 1125899906842624ULL, 1531578985264449ULL, 2064377754059776ULL, 2758547353515625ULL, 3656158440062976ULL, 4808584372417849ULL, 6278211847988224ULL, 8140406085191601ULL, 10485760000000000ULL, 13422659310152401ULL, 17080198121677824ULL, 21611482313284249ULL, 27197360938418176ULL, 34050628916015625ULL, 42420747482776576ULL, 52599132235830049ULL, 64925062108545024ULL, 79792266297612001ULL, 97656250000000000ULL, 119042423827613001ULL, 144555105949057024ULL, 174887470365513049ULL, 210832519264920576ULL, 253295162119140625ULL, 303305489096114176ULL, 362033331456891249ULL, 430804206899405824ULL, 511116753300641401ULL, 604661760000000000ULL, 713342911662882601ULL, 839299365868340224ULL, 984930291881790849ULL, 1152921504606846976ULL, 1346274334462890625ULL, 1568336880910795776ULL, 1822837804551761449ULL, 2113922820157210624ULL, 2446194060654759801ULL, 2824752490000000000ULL, 3255243551009881201ULL, 3743906242624487424ULL, 4297625829703557649ULL, 4923990397355877376ULL, 5631351470947265625ULL, 6428888932339941376ULL, 7326680472586200649ULL, 8335775831236199424ULL, 9468276082626847201ULL, 10737418240000000000ULL, 12157665459056928801ULL, 13744803133596058624ULL, 15516041187205853449ULL, 17490122876598091776ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL},
  {1ULL, 2048ULL, 177147ULL, 4194304ULL, 48828125ULL, 362797056ULL, 1977326743ULL, 8589934592ULL, 31381059609ULL, 100000000000ULL, 285311670611ULL, 743008370688ULL, 1792160394037ULL, 4049565169664ULL, 8649755859375ULL, 17592186044416ULL, 34271896307633ULL, 64268410079232ULL, 116490258898219ULL, 204800000000000ULL, 350277500542221ULL, 584318301411328ULL, 952809757913927ULL, 1521681143169024ULL, 2384185791015625ULL, 3670344486987776ULL, 5559060566555523ULL, 8293509467471872ULL, 12200509765705829ULL, 17714700000000000ULL, 25408476896404831ULL, 36028797018963968ULL, 50542106513726817ULL, 70188843638032384ULL, 96549157373046875ULL, 131621703842267136ULL, 177917621779460413ULL, 238572050223552512ULL, 317475837322472439ULL, 419430400000000000ULL, 550329031716248441ULL, 717368321110468608ULL, 929293739471222707ULL, 1196683881290399744ULL, 1532278301220703125ULL, 1951354384207722496ULL, 2472159215084012303ULL, 3116402981210161152ULL, 3909821048582988049ULL, 4882812500000000000ULL, 6071163615208263051ULL, 7516865509350965248ULL, 9269035929372191597ULL, 11384956040305711104ULL, 13931233916552734375ULL, 16985107389382393856ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL},
  {1ULL, 4096ULL, 531441ULL, 16777216ULL, 244140625ULL, 2176782336ULL, 13841287201ULL, 68719476736ULL, 282429536481ULL, 1000000000000ULL, 3138428376721ULL, 8916100448256ULL, 23298085122481ULL, 56693912375296ULL, 129746337890625ULL, 281474976710656ULL, 582622237229761ULL, 1156831381426176ULL, 2213314919066161ULL, 4096000000000000ULL, 7355827511386641ULL, 12855002631049216ULL, 21914624432020321ULL, 36520347436056576ULL, 59604644775390625ULL, 95428956661682176ULL, 150094635296999121ULL, 232218265089212416ULL, 353814783205469041ULL, 531441000000000000ULL, 787662783788549761ULL, 1152921504606846976ULL, 1667889514952984961ULL, 2386420683693101056ULL, 3379220508056640625ULL, 4738381338321616896ULL, 6582952005840035281ULL, 9065737908494995456ULL, 12381557655576425121ULL, 16777216000000000000ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL},
  {1ULL, 8192ULL, 1594323ULL, 67108864ULL, 1220703125ULL, 13060694016ULL, 96889010407ULL, 549755813888ULL, 2541865828329ULL, 10000000000000ULL, 34522712143931ULL, 106993205379072ULL, 302875106592253ULL, 793714773254144ULL, 1946195068359375ULL, 4503599627370496ULL, 9904578032905937ULL, 20822964865671168ULL, 42052983462257059ULL, 81920000000000000ULL, 154472377739119461ULL, 282810057883082752ULL, 504036361936467383ULL, 876488338465357824ULL, 1490116119384765625ULL, 2481152873203736576ULL, 4052555153018976267ULL, 6502111422497947648ULL, 10260628712958602189ULL, 15943230000000000000ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL},
  {1ULL, 16384ULL, 4782969ULL, 268435456ULL, 6103515625ULL, 78364164096ULL, 678223072849ULL, 4398046511104ULL, 22876792454961ULL, 100000000000000ULL, 379749833583241ULL, 1283918464548864ULL, 3937376385699289ULL, 11112006825558016ULL, 29192926025390625ULL, 72057594037927936ULL, 168377826559400929ULL, 374813367582081024ULL, 799006685782884121ULL, 1638400000000000000ULL, 3243919932521508681ULL, 6221821273427820544ULL, 11592836324538749809ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL},
  {1ULL, 32768ULL, 14348907ULL, 1073741824ULL, 30517578125ULL, 470184984576ULL, 4747561509943ULL, 35184372088832ULL, 205891132094649ULL, 1000000000000000ULL, 4177248169415651ULL, 15407021574586368ULL, 51185893014090757ULL, 155568095557812224ULL, 437893890380859375ULL, 1152921504606846976ULL, 2862423051509815793ULL, 6746640616477458432ULL, 15181127029874798299ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL},
  {1ULL, 65536ULL, 43046721ULL, 4294967296ULL, 152587890625ULL, 2821109907456ULL, 33232930569601ULL, 281474976710656ULL, 1853020188851841ULL, 10000000000000000ULL, 45949729863572161ULL, 184884258895036416ULL, 665416609183179841ULL, 2177953337809371136ULL, 6568408355712890625ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL},
  {1ULL, 131072ULL, 129140163ULL, 17179869184ULL, 762939453125ULL, 16926659444736ULL, 232630513987207ULL, 2251799813685248ULL, 16677181699666569ULL, 100000000000000000ULL, 505447028499293771ULL, 2218611106740436992ULL, 8650415919381337933ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL},
  {1ULL, 262144ULL, 387420489ULL, 68719476736ULL, 3814697265625ULL, 101559956668416ULL, 1628413597910449ULL, 18014398509481984ULL, 150094635296999121ULL, 1000000000000000000ULL, 5559917313492231481ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL},
  {1ULL, 524288ULL, 1162261467ULL, 274877906944ULL, 19073486328125ULL, 609359740010496ULL, 11398895185373143ULL, 144115188075855872ULL, 1350851717672992089ULL, 10000000000000000000ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL},
  {1ULL, 1048576ULL, 3486784401ULL, 1099511627776ULL, 95367431640625ULL, 3656158440062976ULL, 79792266297612001ULL, 1152921504606846976ULL, 12157665459056928801ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL},
  {1ULL, 2097152ULL, 10460353203ULL, 4398046511104ULL, 476837158203125ULL, 21936950640377856ULL, 558545864083284007ULL, 9223372036854775808ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL},
  {1ULL, 4194304ULL, 31381059609ULL, 17592186044416ULL, 2384185791015625ULL, 131621703842267136ULL, 3909821048582988049ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL},
  {1ULL, 8388608ULL, 94143178827ULL, 70368744177664ULL, 11920928955078125ULL, 789730223053602816ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL},
  {1ULL, 16777216ULL, 282429536481ULL, 281474976710656ULL, 59604644775390625ULL, 4738381338321616896ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL},
  {1ULL, 33554432ULL, 847288609443ULL, 1125899906842624ULL, 298023223876953125ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL},
  {1ULL, 67108864ULL, 2541865828329ULL, 4503599627370496ULL, 1490116119384765625ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL},
  {1ULL, 134217728ULL, 7625597484987ULL, 18014398509481984ULL, 7450580596923828125ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL},
  {1ULL, 268435456ULL, 22876792454961ULL, 72057594037927936ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL},
  {1ULL, 536870912ULL, 68630377364883ULL, 288230376151711744ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL},
  {1ULL, 1073741824ULL, 205891132094649ULL, 1152921504606846976ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL},
  {1ULL, 2147483648ULL, 617673396283947ULL, 4611686018427387904ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL, 0ULL}
};
#else

const uint32_t POWER[32][128] = {
  {1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL, 1UL},
  {1UL, 2UL, 3UL, 4UL, 5UL, 6UL, 7UL, 8UL, 9UL, 10UL, 11UL, 12UL, 13UL, 14UL, 15UL, 16UL, 17UL, 18UL, 19UL, 20UL, 21UL, 22UL, 23UL, 24UL, 25UL, 26UL, 27UL, 28UL, 29UL, 30UL, 31UL, 32UL, 33UL, 34UL, 35UL, 36UL, 37UL, 38UL, 39UL, 40UL, 41UL, 42UL, 43UL, 44UL, 45UL, 46UL, 47UL, 48UL, 49UL, 50UL, 51UL, 52UL, 53UL, 54UL, 55UL, 56UL, 57UL, 58UL, 59UL, 60UL, 61UL, 62UL, 63UL, 64UL, 65UL, 66UL, 67UL, 68UL, 69UL, 70UL, 71UL, 72UL, 73UL, 74UL, 75UL, 76UL, 77UL, 78UL, 79UL, 80UL, 81UL, 82UL, 83UL, 84UL, 85UL, 86UL, 87UL, 88UL, 89UL, 90UL, 91UL, 92UL, 93UL, 94UL, 95UL, 96UL, 97UL, 98UL, 99UL, 100UL, 101UL, 102UL, 103UL, 104UL, 105UL, 106UL, 107UL, 108UL, 109UL, 110UL, 111UL, 112UL, 113UL, 114UL, 115UL, 116UL, 117UL, 118UL, 119UL, 120UL, 121UL, 122UL, 123UL, 124UL, 125UL, 126UL, 127UL, 128UL},
  {1UL, 4UL, 9UL, 16UL, 25UL, 36UL, 49UL, 64UL, 81UL, 100UL, 121UL, 144UL, 169UL, 196UL, 225UL, 256UL, 289UL, 324UL, 361UL, 400UL, 441UL, 484UL, 529UL, 576UL, 625UL, 676UL, 729UL, 784UL, 841UL, 900UL, 961UL, 1024UL, 1089UL, 1156UL, 1225UL, 1296UL, 1369UL, 1444UL, 1521UL, 1600UL, 1681UL, 1764UL, 1849UL, 1936UL, 2025UL, 2116UL, 2209UL, 2304UL, 2401UL, 2500UL, 2601UL, 2704UL, 2809UL, 2916UL, 3025UL, 3136UL, 3249UL, 3364UL, 3481UL, 3600UL, 3721UL, 3844UL, 3969UL, 4096UL, 4225UL, 4356UL, 4489UL, 4624UL, 4761UL, 4900UL, 5041UL, 5184UL, 5329UL, 5476UL, 5625UL, 5776UL, 5929UL, 6084UL, 6241UL, 6400UL, 6561UL, 6724UL, 6889UL, 7056UL, 7225UL, 7396UL, 7569UL, 7744UL, 7921UL, 8100UL, 8281UL, 8464UL, 8649UL, 8836UL, 9025UL, 9216UL, 9409UL, 9604UL, 9801UL, 10000UL, 10201UL, 10404UL, 10609UL, 10816UL, 11025UL, 11236UL, 11449UL, 11664UL, 11881UL, 12100UL, 12321UL, 12544UL, 12769UL, 12996UL, 13225UL, 13456UL, 13689UL, 13924UL, 14161UL, 14400UL, 14641UL, 14884UL, 15129UL, 15376UL, 15625UL, 15876UL, 16129UL, 16384UL},
  {1UL, 8UL, 27UL, 64UL, 125UL, 216UL, 343UL, 512UL, 729UL, 1000UL, 1331UL, 1728UL, 2197UL, 2744UL, 3375UL, 4096UL, 4913UL, 5832UL, 6859UL, 8000UL, 9261UL, 10648UL, 12167UL, 13824UL, 15625UL, 17576UL, 19683UL, 21952UL, 24389UL, 27000UL, 29791UL, 32768UL, 35937UL, 39304UL, 42875UL, 46656UL, 50653UL, 54872UL, 59319UL, 64000UL, 68921UL, 74088UL, 79507UL, 85184UL, 91125UL, 97336UL, 103823UL, 110592UL, 117649UL, 125000UL, 132651UL, 140608UL, 148877UL, 157464UL, 166375UL, 175616UL, 185193UL, 195112UL, 205379UL, 216000UL, 226981UL, 238328UL, 250047UL, 262144UL, 274625UL, 287496UL, 300763UL, 314432UL, 328509UL, 343000UL, 357911UL, 373248UL, 389017UL, 405224UL, 421875UL, 438976UL, 456533UL, 474552UL, 493039UL, 512000UL, 531441UL, 551368UL, 571787UL, 592704UL, 614125UL, 636056UL, 658503UL, 681472UL, 704969UL, 729000UL, 753571UL, 778688UL, 804357UL, 830584UL, 857375UL, 884736UL, 912673UL, 941192UL, 970299UL, 1000000UL, 1030301UL, 1061208UL, 1092727UL, 1124864UL, 1157625UL, 1191016UL, 1225043UL, 1259712UL, 1295029UL, 1331000UL, 1367631UL, 1404928UL, 1442897UL, 1481544UL, 1520875UL, 1560896UL, 1601613UL, 1643032UL, 1685159UL, 1728000UL, 1771561UL, 1815848UL, 1860867UL, 1906624UL, 1953125UL, 2000376UL, 2048383UL, 2097152UL},
  {1UL, 16UL, 81UL, 256UL, 625UL, 1296UL, 2401UL, 4096UL, 6561UL, 10000UL, 14641UL, 20736UL, 28561UL, 38416UL, 50625UL, 65536UL, 83521UL, 104976UL, 130321UL, 160000UL, 194481UL, 234256UL, 279841UL, 331776UL, 390625UL, 456976UL, 531441UL, 614656UL, 707281UL, 810000UL, 923521UL, 1048576UL, 1185921UL, 1336336UL, 1500625UL, 1679616UL, 1874161UL, 2085136UL, 2313441UL, 2560000UL, 2825761UL, 3111696UL, 3418801UL, 3748096UL, 4100625UL, 4477456UL, 4879681UL, 5308416UL, 5764801UL, 6250000UL, 6765201UL, 7311616UL, 7890481UL, 8503056UL, 9150625UL, 9834496UL, 10556001UL, 11316496UL, 12117361UL, 12960000UL, 13845841UL, 14776336UL, 15752961UL, 16777216UL, 17850625UL, 18974736UL, 20151121UL, 21381376UL, 22667121UL, 24010000UL, 25411681UL, 26873856UL, 28398241UL, 29986576UL, 31640625UL, 33362176UL, 35153041UL, 37015056UL, 38950081UL, 40960000UL, 43046721UL, 45212176UL, 47458321UL, 49787136UL, 52200625UL, 54700816UL, 57289761UL, 59969536UL, 62742241UL, 65610000UL, 68574961UL, 71639296UL, 74805201UL, 78074896UL, 81450625UL, 84934656UL, 88529281UL, 92236816UL, 96059601UL, 100000000UL, 104060401UL, 108243216UL, 112550881UL, 116985856UL, 121550625UL, 126247696UL, 131079601UL, 136048896UL, 141158161UL, 146410000UL, 151807041UL, 157351936UL, 163047361UL, 168896016UL, 174900625UL, 181063936UL, 187388721UL, 193877776UL, 200533921UL, 207360000UL, 214358881UL, 221533456UL, 228886641UL, 236421376UL, 244140625UL, 252047376UL, 260144641UL, 268435456UL},
  {1UL, 32UL, 243UL, 1024UL, 3125UL, 7776UL, 16807UL, 32768UL, 59049UL, 100000UL, 161051UL, 248832UL, 371293UL, 537824UL, 759375UL, 1048576UL, 1419857UL, 1889568UL, 2476099UL, 3200000UL, 4084101UL, 5153632UL, 6436343UL, 7962624UL, 9765625UL, 11881376UL, 14348907UL, 17210368UL, 20511149UL, 24300000UL, 28629151UL, 33554432UL, 39135393UL, 45435424UL, 52521875UL, 60466176UL, 69343957UL, 79235168UL, 90224199UL, 102400000UL, 115856201UL, 130691232UL, 147008443UL, 164916224UL, 184528125UL, 205962976UL, 229345007UL, 254803968UL, 282475249UL, 312500000UL, 345025251UL, 380204032UL, 418195493UL, 459165024UL, 503284375UL, 550731776UL, 601692057UL, 656356768UL, 714924299UL, 777600000UL, 844596301UL, 916132832UL, 992436543UL, 1073741824UL, 1160290625UL, 1252332576UL, 1350125107UL, 1453933568UL, 1564031349UL, 1680700000UL, 1804229351UL, 1934917632UL, 2073071593UL, 2219006624UL, 2373046875UL, 2535525376UL, 2706784157UL, 2887174368UL, 3077056399UL, 3276800000UL, 3486784401UL, 3707398432UL, 3939040643UL, 4182119424UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL},
  {1UL, 64UL, 729UL, 4096UL, 15625UL, 46656UL, 117649UL, 262144UL, 531441UL, 1000000UL, 1771561UL, 2985984UL, 4826809UL, 7529536UL, 11390625UL, 16777216UL, 24137569UL, 34012224UL, 47045881UL, 64000000UL, 85766121UL, 113379904UL, 148035889UL, 191102976UL, 244140625UL, 308915776UL, 387420489UL, 481890304UL, 594823321UL, 729000000UL, 887503681UL, 1073741824UL, 1291467969UL, 1544804416UL, 1838265625UL, 2176782336UL, 2565726409UL, 3010936384UL, 3518743761UL, 4096000000UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL},
  {1UL, 128UL, 2187UL, 16384UL, 78125UL, 279936UL, 823543UL, 2097152UL, 4782969UL, 10000000UL, 19487171UL, 35831808UL, 62748517UL, 105413504UL, 170859375UL, 268435456UL, 410338673UL, 612220032UL, 893871739UL, 1280000000UL, 1801088541UL, 2494357888UL, 3404825447UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL},
  {1UL, 256UL, 6561UL, 65536UL, 390625UL, 1679616UL, 5764801UL, 16777216UL, 43046721UL, 100000000UL, 214358881UL, 429981696UL, 815730721UL, 1475789056UL, 2562890625UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL},
  {1UL, 512UL, 19683UL, 262144UL, 1953125UL, 10077696UL, 40353607UL, 134217728UL, 387420489UL, 1000000000UL, 2357947691UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL},
  {1UL, 1024UL, 59049UL, 1048576UL, 9765625UL, 60466176UL, 282475249UL, 1073741824UL, 3486784401UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL},
  {1UL, 2048UL, 177147UL, 4194304UL, 48828125UL, 362797056UL, 1977326743UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL},
  {1UL, 4096UL, 531441UL, 16777216UL, 244140625UL, 2176782336UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL},
  {1UL, 8192UL, 1594323UL, 67108864UL, 1220703125UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL},
  {1UL, 16384UL, 4782969UL, 268435456UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL},
  {1UL, 32768UL, 14348907UL, 1073741824UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL},
  {1UL, 65536UL, 43046721UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL},
  {1UL, 131072UL, 129140163UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL},
  {1UL, 262144UL, 387420489UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL},
  {1UL, 524288UL, 1162261467UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL},
  {1UL, 1048576UL, 3486784401UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL},
  {1UL, 2097152UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL},
  {1UL, 4194304UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL},
  {1UL, 8388608UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL},
  {1UL, 16777216UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL},
  {1UL, 33554432UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL},
  {1UL, 67108864UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL},
  {1UL, 134217728UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL},
  {1UL, 268435456UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL},
  {1UL, 536870912UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL},
  {1UL, 1073741824UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL},
  {1UL, 2147483648UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL},
};
#endif

//! Takes two logd values and adds them together, i.e. takes (log a, log b) --> log a+b
//! i.e. a *or* b
//! \param first  log'd Double value
//! \param second log'd Double value
//! \return Log'd sum of two values
template<typename T>
T AddInLogSpace(T first, T second) {
  if(first == -INFINITY) {
    return second;
  } else if(second == -INFINITY) {
    return first;
  } else if(first > second) {
    return first + log(1 + exp(second - first));
  } else {
    return second + log(1 + exp(first - second));
  }
}



/*! \fn T sumVector(vector<T>& data)
  \brief Sum the vector and return the sum
  \param data Vector of doubles
*/
template<class T>
T sumVector(vector<T>& data) {
  double sum = 0;
  for(size_t i = 0; i < data.size(); i++) {
    sum += data[i];
  }
  return sum;
}

/*! \fn T sumVector(vector<T>& data)
  \brief Sum the vector and return the sum
  \param data Vector of doubles
*/
template<class T>
T sumVector(const vector<T>& data) {
  double sum = 0;
  for(size_t i = 0; i < data.size(); i++) {
    sum += data[i];
  }
  return sum;
}

/*! \fn T productVector(vector<T>& data)
  \brief Multiply terms in vector and return the product
  \param data Vector of T
*/
template<class T>
T productVector(vector<T>& data) {
  double product = data[0];
  for(size_t i = 1; i < data.size(); ++i) {
    product *= data[i];
  }
  return product;
}


/*! \fn double minVector(vector<double>& data)
  \brief Get Minimum of the vector
  \param data Vector of doubles
*/
template<typename T>
T minVector(vector<T>& data) {
  return *min_element(data.begin(), data.end());
}

/*! \fn double maxVector(vector<doubles>& data)
  \brief Get the Maximum of the vector
  \param data Vector of doubles
*/
template<typename T>
T maxVector(vector<T>& data) {
  return *max_element(data.begin(), data.end());
}

/*! \fn T avgVector(vector<double>& data)
  \brief Get the average of the vector
  \param data Vector of doubles
*/
template<typename T>
T avgVector(vector<T>& data) {
  return sumVector(data) / T(data.size());
}


/*! \fn void logVector(vector<double>& data)
  \brief Take log of each element in vector
  \param data Vector of doubles
*/
template<typename T>
void logVector(vector<T>& data) {
  for(size_t i = 0; i < data.size(); i++) {
    data[i] = log(data[i]);
  }
  return;
}

template<typename T>
vector<double> get_exp_vector(vector<T> data) {
  vector<double> newvec;
  for(size_t i = 0; i < data.size(); i++)
    newvec.push_back(exp(data[i]));
  return newvec;
}

/*! \fn void probVector(vector<double>& data)
  \brief Convert the vector to probilities.  Divide each indice by the sum of the vector
  \param data Vecor of doubles
*/
template<typename T>
void probVector(vector<T>& data) {
  T sum = sumVector(data);
  for(size_t iter = 0; iter < data.size(); iter++) {
    if(sum == 0) {
      data[iter] = 0;
    } else {
      data[iter] /= sum;
    }
  }
  return;
}

template <typename T>
void addVector(vector<T>& lhs, vector<T>& rhs) {
  transform(lhs.begin(), lhs.end(), rhs.begin(), lhs.begin(), plus<T>());
  return;
}

// ----------------------------------------------------------------------------------------
double AddWithMinusInfinities(double first, double second);

}

#endif
