# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    The version of the OpenAPI document: 0.11.4940
    Contact: info@finbourne.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from lusid.api_client import ApiClient
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.models.access_metadata_value import AccessMetadataValue
from lusid.models.deleted_entity_response import DeletedEntityResponse
from lusid.models.lusid_problem_details import LusidProblemDetails
from lusid.models.lusid_validation_problem_details import LusidValidationProblemDetails
from lusid.models.resource_list_of_access_metadata_value_of import ResourceListOfAccessMetadataValueOf
from lusid.models.resource_list_of_relationship import ResourceListOfRelationship
from lusid.models.upsert_person_access_metadata_request import UpsertPersonAccessMetadataRequest


class PersonsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_person_access_metadata(self, id_type_scope, id_type_code, code, metadata_key, **kwargs):  # noqa: E501
        """[EARLY ACCESS] DeletePersonAccessMetadata: Delete a Person Access Metadata entry  # noqa: E501

        Deletes the Person Access Metadata entry that exactly matches the provided identifier parts.    It is important to always check to verify success (or failure).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_person_access_metadata(id_type_scope, id_type_code, code, metadata_key, async_req=True)
        >>> result = thread.get()

        :param id_type_scope: Scope of the person identifier. (required)
        :type id_type_scope: str
        :param id_type_code: Code of the person identifier. (required)
        :type id_type_code: str
        :param code: Code of the person under specified identifier type's scope and code. (required)
        :type code: str
        :param metadata_key: Key of the metadata entry to retrieve (required)
        :type metadata_key: str
        :param effective_at: The effective date to delete at, if this is not supplied, it will delete all data found
        :type effective_at: str
        :param effective_until: The effective date until which the delete is valid. If not supplied this will be valid indefinitely, or until the next 'effectiveAt' date of the Access Metadata
        :type effective_until: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeletedEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_person_access_metadata_with_http_info(id_type_scope, id_type_code, code, metadata_key, **kwargs)  # noqa: E501

    def delete_person_access_metadata_with_http_info(self, id_type_scope, id_type_code, code, metadata_key, **kwargs):  # noqa: E501
        """[EARLY ACCESS] DeletePersonAccessMetadata: Delete a Person Access Metadata entry  # noqa: E501

        Deletes the Person Access Metadata entry that exactly matches the provided identifier parts.    It is important to always check to verify success (or failure).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_person_access_metadata_with_http_info(id_type_scope, id_type_code, code, metadata_key, async_req=True)
        >>> result = thread.get()

        :param id_type_scope: Scope of the person identifier. (required)
        :type id_type_scope: str
        :param id_type_code: Code of the person identifier. (required)
        :type id_type_code: str
        :param code: Code of the person under specified identifier type's scope and code. (required)
        :type code: str
        :param metadata_key: Key of the metadata entry to retrieve (required)
        :type metadata_key: str
        :param effective_at: The effective date to delete at, if this is not supplied, it will delete all data found
        :type effective_at: str
        :param effective_until: The effective date until which the delete is valid. If not supplied this will be valid indefinitely, or until the next 'effectiveAt' date of the Access Metadata
        :type effective_until: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (DeletedEntityResponse, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'id_type_scope',
            'id_type_code',
            'code',
            'metadata_key',
            'effective_at',
            'effective_until'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_person_access_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id_type_scope' is set
        if self.api_client.client_side_validation and ('id_type_scope' not in local_var_params or  # noqa: E501
                                                        local_var_params['id_type_scope'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id_type_scope` when calling `delete_person_access_metadata`")  # noqa: E501
        # verify the required parameter 'id_type_code' is set
        if self.api_client.client_side_validation and ('id_type_code' not in local_var_params or  # noqa: E501
                                                        local_var_params['id_type_code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id_type_code` when calling `delete_person_access_metadata`")  # noqa: E501
        # verify the required parameter 'code' is set
        if self.api_client.client_side_validation and ('code' not in local_var_params or  # noqa: E501
                                                        local_var_params['code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `code` when calling `delete_person_access_metadata`")  # noqa: E501
        # verify the required parameter 'metadata_key' is set
        if self.api_client.client_side_validation and ('metadata_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['metadata_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `metadata_key` when calling `delete_person_access_metadata`")  # noqa: E501

        if self.api_client.client_side_validation and ('code' in local_var_params and  # noqa: E501
                                                        len(local_var_params['code']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `delete_person_access_metadata`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('code' in local_var_params and  # noqa: E501
                                                        len(local_var_params['code']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `delete_person_access_metadata`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `delete_person_access_metadata`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('metadata_key' in local_var_params and  # noqa: E501
                                                        len(local_var_params['metadata_key']) > 256):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `metadata_key` when calling `delete_person_access_metadata`, length must be less than or equal to `256`")  # noqa: E501
        if self.api_client.client_side_validation and ('metadata_key' in local_var_params and  # noqa: E501
                                                        len(local_var_params['metadata_key']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `metadata_key` when calling `delete_person_access_metadata`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'metadata_key' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['metadata_key']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `metadata_key` when calling `delete_person_access_metadata`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id_type_scope' in local_var_params:
            path_params['idTypeScope'] = local_var_params['id_type_scope']  # noqa: E501
        if 'id_type_code' in local_var_params:
            path_params['idTypeCode'] = local_var_params['id_type_code']  # noqa: E501
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501
        if 'metadata_key' in local_var_params:
            path_params['metadataKey'] = local_var_params['metadata_key']  # noqa: E501

        query_params = []
        if 'effective_at' in local_var_params and local_var_params['effective_at'] is not None:  # noqa: E501
            query_params.append(('effectiveAt', local_var_params['effective_at']))  # noqa: E501
        if 'effective_until' in local_var_params and local_var_params['effective_until'] is not None:  # noqa: E501
            query_params.append(('effectiveUntil', local_var_params['effective_until']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.11.4940'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "DeletedEntityResponse",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/persons/{idTypeScope}/{idTypeCode}/{code}/metadata/{metadataKey}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_all_person_access_metadata(self, id_type_scope, id_type_code, code, **kwargs):  # noqa: E501
        """[EARLY ACCESS] GetAllPersonAccessMetadata: Get Access Metadata rules for a Person  # noqa: E501

        Pass the Scope and Code of the Person identifier along with the person code parameter to retrieve the associated Access Metadata  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_person_access_metadata(id_type_scope, id_type_code, code, async_req=True)
        >>> result = thread.get()

        :param id_type_scope: Scope of the person identifier. (required)
        :type id_type_scope: str
        :param id_type_code: Code of the person identifier. (required)
        :type id_type_code: str
        :param code: Code of the person under specified identifier type's scope and code. (required)
        :type code: str
        :param effective_at: The effectiveAt datetime at which to retrieve the Access Metadata
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the Access Metadata
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: dict(str, list[AccessMetadataValue])
        """
        kwargs['_return_http_data_only'] = True
        return self.get_all_person_access_metadata_with_http_info(id_type_scope, id_type_code, code, **kwargs)  # noqa: E501

    def get_all_person_access_metadata_with_http_info(self, id_type_scope, id_type_code, code, **kwargs):  # noqa: E501
        """[EARLY ACCESS] GetAllPersonAccessMetadata: Get Access Metadata rules for a Person  # noqa: E501

        Pass the Scope and Code of the Person identifier along with the person code parameter to retrieve the associated Access Metadata  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_person_access_metadata_with_http_info(id_type_scope, id_type_code, code, async_req=True)
        >>> result = thread.get()

        :param id_type_scope: Scope of the person identifier. (required)
        :type id_type_scope: str
        :param id_type_code: Code of the person identifier. (required)
        :type id_type_code: str
        :param code: Code of the person under specified identifier type's scope and code. (required)
        :type code: str
        :param effective_at: The effectiveAt datetime at which to retrieve the Access Metadata
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the Access Metadata
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (dict(str, list[AccessMetadataValue]), int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'id_type_scope',
            'id_type_code',
            'code',
            'effective_at',
            'as_at'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_person_access_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id_type_scope' is set
        if self.api_client.client_side_validation and ('id_type_scope' not in local_var_params or  # noqa: E501
                                                        local_var_params['id_type_scope'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id_type_scope` when calling `get_all_person_access_metadata`")  # noqa: E501
        # verify the required parameter 'id_type_code' is set
        if self.api_client.client_side_validation and ('id_type_code' not in local_var_params or  # noqa: E501
                                                        local_var_params['id_type_code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id_type_code` when calling `get_all_person_access_metadata`")  # noqa: E501
        # verify the required parameter 'code' is set
        if self.api_client.client_side_validation and ('code' not in local_var_params or  # noqa: E501
                                                        local_var_params['code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `code` when calling `get_all_person_access_metadata`")  # noqa: E501

        if self.api_client.client_side_validation and ('code' in local_var_params and  # noqa: E501
                                                        len(local_var_params['code']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `get_all_person_access_metadata`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('code' in local_var_params and  # noqa: E501
                                                        len(local_var_params['code']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `get_all_person_access_metadata`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `get_all_person_access_metadata`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id_type_scope' in local_var_params:
            path_params['idTypeScope'] = local_var_params['id_type_scope']  # noqa: E501
        if 'id_type_code' in local_var_params:
            path_params['idTypeCode'] = local_var_params['id_type_code']  # noqa: E501
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501

        query_params = []
        if 'effective_at' in local_var_params and local_var_params['effective_at'] is not None:  # noqa: E501
            query_params.append(('effectiveAt', local_var_params['effective_at']))  # noqa: E501
        if 'as_at' in local_var_params and local_var_params['as_at'] is not None:  # noqa: E501
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.11.4940'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "dict(str, list[AccessMetadataValue])",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/persons/{idTypeScope}/{idTypeCode}/{code}/metadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_person_access_metadata_by_key(self, id_type_scope, id_type_code, code, metadata_key, **kwargs):  # noqa: E501
        """[EARLY ACCESS] GetPersonAccessMetadataByKey: Get an entry identified by a metadataKey in the Access Metadata of a Person  # noqa: E501

        Get a specific Person Access Metadata by specifying the corresponding identifier parts and Person code                No matching will be performed through this endpoint. To retrieve an entry, it is necessary to specify, exactly, the identifier of the entry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_person_access_metadata_by_key(id_type_scope, id_type_code, code, metadata_key, async_req=True)
        >>> result = thread.get()

        :param id_type_scope: Scope of the person identifier. (required)
        :type id_type_scope: str
        :param id_type_code: Code of the person identifier. (required)
        :type id_type_code: str
        :param code: Code of the person under specified identifier type's scope and code. (required)
        :type code: str
        :param metadata_key: Key of the metadata entry to retrieve (required)
        :type metadata_key: str
        :param effective_at: The effectiveAt datetime at which to retrieve the Access Metadata
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the Access Metadata
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[AccessMetadataValue]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_person_access_metadata_by_key_with_http_info(id_type_scope, id_type_code, code, metadata_key, **kwargs)  # noqa: E501

    def get_person_access_metadata_by_key_with_http_info(self, id_type_scope, id_type_code, code, metadata_key, **kwargs):  # noqa: E501
        """[EARLY ACCESS] GetPersonAccessMetadataByKey: Get an entry identified by a metadataKey in the Access Metadata of a Person  # noqa: E501

        Get a specific Person Access Metadata by specifying the corresponding identifier parts and Person code                No matching will be performed through this endpoint. To retrieve an entry, it is necessary to specify, exactly, the identifier of the entry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_person_access_metadata_by_key_with_http_info(id_type_scope, id_type_code, code, metadata_key, async_req=True)
        >>> result = thread.get()

        :param id_type_scope: Scope of the person identifier. (required)
        :type id_type_scope: str
        :param id_type_code: Code of the person identifier. (required)
        :type id_type_code: str
        :param code: Code of the person under specified identifier type's scope and code. (required)
        :type code: str
        :param metadata_key: Key of the metadata entry to retrieve (required)
        :type metadata_key: str
        :param effective_at: The effectiveAt datetime at which to retrieve the Access Metadata
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the Access Metadata
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (list[AccessMetadataValue], int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'id_type_scope',
            'id_type_code',
            'code',
            'metadata_key',
            'effective_at',
            'as_at'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_person_access_metadata_by_key" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id_type_scope' is set
        if self.api_client.client_side_validation and ('id_type_scope' not in local_var_params or  # noqa: E501
                                                        local_var_params['id_type_scope'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id_type_scope` when calling `get_person_access_metadata_by_key`")  # noqa: E501
        # verify the required parameter 'id_type_code' is set
        if self.api_client.client_side_validation and ('id_type_code' not in local_var_params or  # noqa: E501
                                                        local_var_params['id_type_code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id_type_code` when calling `get_person_access_metadata_by_key`")  # noqa: E501
        # verify the required parameter 'code' is set
        if self.api_client.client_side_validation and ('code' not in local_var_params or  # noqa: E501
                                                        local_var_params['code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `code` when calling `get_person_access_metadata_by_key`")  # noqa: E501
        # verify the required parameter 'metadata_key' is set
        if self.api_client.client_side_validation and ('metadata_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['metadata_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `metadata_key` when calling `get_person_access_metadata_by_key`")  # noqa: E501

        if self.api_client.client_side_validation and ('code' in local_var_params and  # noqa: E501
                                                        len(local_var_params['code']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `get_person_access_metadata_by_key`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('code' in local_var_params and  # noqa: E501
                                                        len(local_var_params['code']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `get_person_access_metadata_by_key`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `get_person_access_metadata_by_key`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'metadata_key' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['metadata_key']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `metadata_key` when calling `get_person_access_metadata_by_key`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id_type_scope' in local_var_params:
            path_params['idTypeScope'] = local_var_params['id_type_scope']  # noqa: E501
        if 'id_type_code' in local_var_params:
            path_params['idTypeCode'] = local_var_params['id_type_code']  # noqa: E501
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501
        if 'metadata_key' in local_var_params:
            path_params['metadataKey'] = local_var_params['metadata_key']  # noqa: E501

        query_params = []
        if 'effective_at' in local_var_params and local_var_params['effective_at'] is not None:  # noqa: E501
            query_params.append(('effectiveAt', local_var_params['effective_at']))  # noqa: E501
        if 'as_at' in local_var_params and local_var_params['as_at'] is not None:  # noqa: E501
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.11.4940'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "list[AccessMetadataValue]",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/persons/{idTypeScope}/{idTypeCode}/{code}/metadata/{metadataKey}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_person_relationships(self, id_type_scope, id_type_code, code, **kwargs):  # noqa: E501
        """[EARLY ACCESS] GetPersonRelationships: Get Relationships for Person  # noqa: E501

        Get relationships for the specified person.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_person_relationships(id_type_scope, id_type_code, code, async_req=True)
        >>> result = thread.get()

        :param id_type_scope: Scope of the person's identifier type. (required)
        :type id_type_scope: str
        :param id_type_code: Code of the person's identifier type. (required)
        :type id_type_code: str
        :param code: Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person. (required)
        :type code: str
        :param effective_at: The effective datetime or cut label at which to get relationships. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve relationships. Defaults to return the latest LUSID AsAt time if not specified.
        :type as_at: datetime
        :param filter: Expression to filter relationships. Users should provide null or empty string for this field until further notice.
        :type filter: str
        :param identifier_types: Identifier types (as property keys) used for referencing Persons or Legal Entities.              These can be specified from the 'Person' or 'LegalEntity' domains and have the format {domain}/{scope}/{code}, for example              'Person/CompanyDetails/Role'. An Empty array may be used to return all related Entities.
        :type identifier_types: list[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfRelationship
        """
        kwargs['_return_http_data_only'] = True
        return self.get_person_relationships_with_http_info(id_type_scope, id_type_code, code, **kwargs)  # noqa: E501

    def get_person_relationships_with_http_info(self, id_type_scope, id_type_code, code, **kwargs):  # noqa: E501
        """[EARLY ACCESS] GetPersonRelationships: Get Relationships for Person  # noqa: E501

        Get relationships for the specified person.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_person_relationships_with_http_info(id_type_scope, id_type_code, code, async_req=True)
        >>> result = thread.get()

        :param id_type_scope: Scope of the person's identifier type. (required)
        :type id_type_scope: str
        :param id_type_code: Code of the person's identifier type. (required)
        :type id_type_code: str
        :param code: Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person. (required)
        :type code: str
        :param effective_at: The effective datetime or cut label at which to get relationships. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve relationships. Defaults to return the latest LUSID AsAt time if not specified.
        :type as_at: datetime
        :param filter: Expression to filter relationships. Users should provide null or empty string for this field until further notice.
        :type filter: str
        :param identifier_types: Identifier types (as property keys) used for referencing Persons or Legal Entities.              These can be specified from the 'Person' or 'LegalEntity' domains and have the format {domain}/{scope}/{code}, for example              'Person/CompanyDetails/Role'. An Empty array may be used to return all related Entities.
        :type identifier_types: list[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (ResourceListOfRelationship, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'id_type_scope',
            'id_type_code',
            'code',
            'effective_at',
            'as_at',
            'filter',
            'identifier_types'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_person_relationships" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and ('id_type_scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['id_type_scope']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id_type_scope` when calling `get_person_relationships`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('id_type_scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['id_type_scope']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id_type_scope` when calling `get_person_relationships`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'id_type_scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['id_type_scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id_type_scope` when calling `get_person_relationships`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('id_type_code' in local_var_params and  # noqa: E501
                                                        len(local_var_params['id_type_code']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id_type_code` when calling `get_person_relationships`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('id_type_code' in local_var_params and  # noqa: E501
                                                        len(local_var_params['id_type_code']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id_type_code` when calling `get_person_relationships`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'id_type_code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['id_type_code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id_type_code` when calling `get_person_relationships`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('code' in local_var_params and  # noqa: E501
                                                        len(local_var_params['code']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `get_person_relationships`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('code' in local_var_params and  # noqa: E501
                                                        len(local_var_params['code']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `get_person_relationships`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `get_person_relationships`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('effective_at' in local_var_params and  # noqa: E501
                                                        len(local_var_params['effective_at']) > 256):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `effective_at` when calling `get_person_relationships`, length must be less than or equal to `256`")  # noqa: E501
        if self.api_client.client_side_validation and ('effective_at' in local_var_params and  # noqa: E501
                                                        len(local_var_params['effective_at']) < 0):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `effective_at` when calling `get_person_relationships`, length must be greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'effective_at' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_\+:\.]+$', local_var_params['effective_at']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `effective_at` when calling `get_person_relationships`, must conform to the pattern `/^[a-zA-Z0-9\-_\+:\.]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('filter' in local_var_params and  # noqa: E501
                                                        len(local_var_params['filter']) > 16384):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `get_person_relationships`, length must be less than or equal to `16384`")  # noqa: E501
        if self.api_client.client_side_validation and ('filter' in local_var_params and  # noqa: E501
                                                        len(local_var_params['filter']) < 0):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `get_person_relationships`, length must be greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'filter' in local_var_params and not re.search(r'^[\s\S]*$', local_var_params['filter']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `get_person_relationships`, must conform to the pattern `/^[\s\S]*$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id_type_scope' in local_var_params:
            path_params['idTypeScope'] = local_var_params['id_type_scope']  # noqa: E501
        if 'id_type_code' in local_var_params:
            path_params['idTypeCode'] = local_var_params['id_type_code']  # noqa: E501
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501

        query_params = []
        if 'effective_at' in local_var_params and local_var_params['effective_at'] is not None:  # noqa: E501
            query_params.append(('effectiveAt', local_var_params['effective_at']))  # noqa: E501
        if 'as_at' in local_var_params and local_var_params['as_at'] is not None:  # noqa: E501
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501
        if 'filter' in local_var_params and local_var_params['filter'] is not None:  # noqa: E501
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501
        if 'identifier_types' in local_var_params and local_var_params['identifier_types'] is not None:  # noqa: E501
            query_params.append(('identifierTypes', local_var_params['identifier_types']))  # noqa: E501
            collection_formats['identifierTypes'] = 'multi'  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.11.4940'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "ResourceListOfRelationship",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/persons/{idTypeScope}/{idTypeCode}/{code}/relationships', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def upsert_person_access_metadata(self, id_type_scope, id_type_code, code, metadata_key, upsert_person_access_metadata_request, **kwargs):  # noqa: E501
        """[EARLY ACCESS] UpsertPersonAccessMetadata: Upsert a Person Access Metadata entry associated with a specific metadataKey. This creates or updates the data in LUSID.  # noqa: E501

        Update or insert one Person Access Metadata entry in a single scope. An item will be updated if it already exists  and inserted if it does not.                The response will return the successfully updated or inserted Person Access Metadata rule or failure message if unsuccessful.                It is important to always check to verify success (or failure).                Multiple rules for a metadataKey can exist with different effective at dates, when resources are accessed the rule that is active for the current time will be fetched.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_person_access_metadata(id_type_scope, id_type_code, code, metadata_key, upsert_person_access_metadata_request, async_req=True)
        >>> result = thread.get()

        :param id_type_scope: Scope of the person identifier. (required)
        :type id_type_scope: str
        :param id_type_code: Code of the person identifier. (required)
        :type id_type_code: str
        :param code: Code of the person under specified identifier type's scope and code. (required)
        :type code: str
        :param metadata_key: Key of the metadata entry to retrieve (required)
        :type metadata_key: str
        :param upsert_person_access_metadata_request: The Person Access Metadata entry to upsert (required)
        :type upsert_person_access_metadata_request: UpsertPersonAccessMetadataRequest
        :param effective_at: The effectiveAt datetime at which to upsert the Access Metadata
        :type effective_at: str
        :param effective_until: The effective datetime until which the Access Metadata is valid. If not supplied this will be valid indefinitely, or until the next 'effectiveAt' datetime of the Access Metadata
        :type effective_until: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfAccessMetadataValueOf
        """
        kwargs['_return_http_data_only'] = True
        return self.upsert_person_access_metadata_with_http_info(id_type_scope, id_type_code, code, metadata_key, upsert_person_access_metadata_request, **kwargs)  # noqa: E501

    def upsert_person_access_metadata_with_http_info(self, id_type_scope, id_type_code, code, metadata_key, upsert_person_access_metadata_request, **kwargs):  # noqa: E501
        """[EARLY ACCESS] UpsertPersonAccessMetadata: Upsert a Person Access Metadata entry associated with a specific metadataKey. This creates or updates the data in LUSID.  # noqa: E501

        Update or insert one Person Access Metadata entry in a single scope. An item will be updated if it already exists  and inserted if it does not.                The response will return the successfully updated or inserted Person Access Metadata rule or failure message if unsuccessful.                It is important to always check to verify success (or failure).                Multiple rules for a metadataKey can exist with different effective at dates, when resources are accessed the rule that is active for the current time will be fetched.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_person_access_metadata_with_http_info(id_type_scope, id_type_code, code, metadata_key, upsert_person_access_metadata_request, async_req=True)
        >>> result = thread.get()

        :param id_type_scope: Scope of the person identifier. (required)
        :type id_type_scope: str
        :param id_type_code: Code of the person identifier. (required)
        :type id_type_code: str
        :param code: Code of the person under specified identifier type's scope and code. (required)
        :type code: str
        :param metadata_key: Key of the metadata entry to retrieve (required)
        :type metadata_key: str
        :param upsert_person_access_metadata_request: The Person Access Metadata entry to upsert (required)
        :type upsert_person_access_metadata_request: UpsertPersonAccessMetadataRequest
        :param effective_at: The effectiveAt datetime at which to upsert the Access Metadata
        :type effective_at: str
        :param effective_until: The effective datetime until which the Access Metadata is valid. If not supplied this will be valid indefinitely, or until the next 'effectiveAt' datetime of the Access Metadata
        :type effective_until: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (ResourceListOfAccessMetadataValueOf, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'id_type_scope',
            'id_type_code',
            'code',
            'metadata_key',
            'upsert_person_access_metadata_request',
            'effective_at',
            'effective_until'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_person_access_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id_type_scope' is set
        if self.api_client.client_side_validation and ('id_type_scope' not in local_var_params or  # noqa: E501
                                                        local_var_params['id_type_scope'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id_type_scope` when calling `upsert_person_access_metadata`")  # noqa: E501
        # verify the required parameter 'id_type_code' is set
        if self.api_client.client_side_validation and ('id_type_code' not in local_var_params or  # noqa: E501
                                                        local_var_params['id_type_code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id_type_code` when calling `upsert_person_access_metadata`")  # noqa: E501
        # verify the required parameter 'code' is set
        if self.api_client.client_side_validation and ('code' not in local_var_params or  # noqa: E501
                                                        local_var_params['code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `code` when calling `upsert_person_access_metadata`")  # noqa: E501
        # verify the required parameter 'metadata_key' is set
        if self.api_client.client_side_validation and ('metadata_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['metadata_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `metadata_key` when calling `upsert_person_access_metadata`")  # noqa: E501
        # verify the required parameter 'upsert_person_access_metadata_request' is set
        if self.api_client.client_side_validation and ('upsert_person_access_metadata_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['upsert_person_access_metadata_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `upsert_person_access_metadata_request` when calling `upsert_person_access_metadata`")  # noqa: E501

        if self.api_client.client_side_validation and ('code' in local_var_params and  # noqa: E501
                                                        len(local_var_params['code']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `upsert_person_access_metadata`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('code' in local_var_params and  # noqa: E501
                                                        len(local_var_params['code']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `upsert_person_access_metadata`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `upsert_person_access_metadata`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id_type_scope' in local_var_params:
            path_params['idTypeScope'] = local_var_params['id_type_scope']  # noqa: E501
        if 'id_type_code' in local_var_params:
            path_params['idTypeCode'] = local_var_params['id_type_code']  # noqa: E501
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501
        if 'metadata_key' in local_var_params:
            path_params['metadataKey'] = local_var_params['metadata_key']  # noqa: E501

        query_params = []
        if 'effective_at' in local_var_params and local_var_params['effective_at'] is not None:  # noqa: E501
            query_params.append(('effectiveAt', local_var_params['effective_at']))  # noqa: E501
        if 'effective_until' in local_var_params and local_var_params['effective_until'] is not None:  # noqa: E501
            query_params.append(('effectiveUntil', local_var_params['effective_until']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'upsert_person_access_metadata_request' in local_var_params:
            body_params = local_var_params['upsert_person_access_metadata_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.11.4940'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "ResourceListOfAccessMetadataValueOf",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/persons/{idTypeScope}/{idTypeCode}/{code}/metadata/{metadataKey}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
