# -*- coding: utf-8 -*-
# Generated by Django 1.11.6 on 2018-01-16 19:44


from django.conf import settings
import django.contrib.gis.db.models.fields
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import uuid
from arches.app.models.concept import Concept


def forwards_func(apps, schema_editor):
    pass


def reverse_func(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        ("models", "0009_4_0_1"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("auth", "0008_alter_user_username_max_length"),
    ]

    operations = [
        migrations.CreateModel(
            name="UserProfile",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("phone", models.CharField(blank=True, max_length=16)),
                (
                    "user",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "db_table": "user_profile",
                "managed": True,
            },
        ),
        migrations.RunPython(
            code=forwards_func,
            reverse_code=reverse_func,
        ),
        migrations.CreateModel(
            name="MobileSurveyModel",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid1, primary_key=True, serialize=False
                    ),
                ),
                ("name", models.TextField(null=True)),
                ("active", models.BooleanField(default=False)),
                ("startdate", models.DateField(blank=True, null=True)),
                ("enddate", models.DateField(blank=True, null=True)),
                ("description", models.TextField(null=True)),
            ],
            options={
                "db_table": "mobile_surveys",
                "managed": True,
            },
        ),
        migrations.CreateModel(
            name="MobileSurveyXCard",
            fields=[
                (
                    "mobile_survey_x_card_id",
                    models.UUIDField(
                        default=uuid.uuid1, primary_key=True, serialize=False
                    ),
                ),
                ("sortorder", models.IntegerField(default=0)),
                (
                    "card",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="models.CardModel",
                    ),
                ),
                (
                    "mobile_survey",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="models.MobileSurveyModel",
                    ),
                ),
            ],
            options={
                "db_table": "mobile_surveys_x_cards",
                "managed": True,
            },
        ),
        migrations.CreateModel(
            name="MobileSurveyXGroup",
            fields=[
                (
                    "mobile_survey_x_group_id",
                    models.UUIDField(
                        default=uuid.uuid1, primary_key=True, serialize=False
                    ),
                ),
                (
                    "group",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="auth.Group"
                    ),
                ),
                (
                    "mobile_survey",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="models.MobileSurveyModel",
                    ),
                ),
            ],
            options={
                "db_table": "mobile_surveys_x_groups",
                "managed": True,
            },
        ),
        migrations.CreateModel(
            name="MobileSurveyXUser",
            fields=[
                (
                    "mobile_survey_x_user_id",
                    models.UUIDField(
                        default=uuid.uuid1, primary_key=True, serialize=False
                    ),
                ),
                (
                    "mobile_survey",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="models.MobileSurveyModel",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "db_table": "mobile_surveys_x_users",
                "managed": True,
            },
        ),
        migrations.AddField(
            model_name="mobilesurveymodel",
            name="cards",
            field=models.ManyToManyField(
                through="models.MobileSurveyXCard", to="models.CardModel"
            ),
        ),
        migrations.AddField(
            model_name="mobilesurveymodel",
            name="createdby",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="createdby",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="mobilesurveymodel",
            name="groups",
            field=models.ManyToManyField(
                through="models.MobileSurveyXGroup", to="auth.Group"
            ),
        ),
        migrations.AddField(
            model_name="mobilesurveymodel",
            name="lasteditedby",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="lasteditedby",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="mobilesurveymodel",
            name="users",
            field=models.ManyToManyField(
                through="models.MobileSurveyXUser", to=settings.AUTH_USER_MODEL
            ),
        ),
        migrations.CreateModel(
            name="MobileSurvey",
            fields=[],
            options={
                "proxy": True,
                "indexes": [],
            },
            bases=("models.mobilesurveymodel",),
        ),
        migrations.AlterUniqueTogether(
            name="mobilesurveyxuser",
            unique_together={("mobile_survey", "user")},
        ),
        migrations.AlterUniqueTogether(
            name="mobilesurveyxgroup",
            unique_together={("mobile_survey", "group")},
        ),
        migrations.AlterUniqueTogether(
            name="mobilesurveyxcard",
            unique_together={("mobile_survey", "card")},
        ),
        migrations.RunSQL(
            sql="\n                    update widgets\n                    \tset defaultconfig = (SELECT defaultconfig || jsonb_build_object('defaultValue', '') FROM widgets WHERE name = 'text-widget')\n                    \tWHERE name = 'text-widget';\n                    update cards_x_nodes_x_widgets\n                    \tset config = (SELECT config || jsonb_build_object('defaultValue', '') FROM widgets WHERE name = 'text-widget')\n                    \tWHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'text-widget');\n\n\n                ",
            reverse_sql="\n                    update widgets\n                    \tset defaultconfig = defaultconfig - 'defaultValue'\n                    \tWHERE name = 'text-widget';\n                    update cards_x_nodes_x_widgets\n                    \tset config = config - 'defaultValue'\n                    \tWHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'text-widget');\n                ",
        ),
        migrations.RunSQL(
            sql="\n                    update widgets\n                    \tset defaultconfig = (SELECT defaultconfig || jsonb_build_object('defaultValue', '') FROM widgets WHERE name = 'number-widget')\n                    \tWHERE name = 'number-widget';\n                    update cards_x_nodes_x_widgets\n                    \tset config = (SELECT config || jsonb_build_object('defaultValue', '') FROM widgets WHERE name = 'number-widget')\n                    \tWHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'number-widget');\n\n\n                ",
            reverse_sql="\n                    update widgets\n                    \tset defaultconfig = defaultconfig - 'defaultValue'\n                    \tWHERE name = 'number-widget';\n                    update cards_x_nodes_x_widgets\n                    \tset config = config - 'defaultValue'\n                    \tWHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'number-widget');\n                ",
        ),
        migrations.RunSQL(
            sql="\n                    update widgets\n                    \tset defaultconfig = (SELECT defaultconfig || jsonb_build_object('defaultValue', '') FROM widgets WHERE name = 'radio-boolean-widget')\n                    \tWHERE name = 'radio-boolean-widget';\n                    update cards_x_nodes_x_widgets\n                    \tset config = (SELECT config || jsonb_build_object('defaultValue', '') FROM widgets WHERE name = 'radio-boolean-widget')\n                    \tWHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'radio-boolean-widget');\n\n\n                ",
            reverse_sql="\n                    update widgets\n                    \tset defaultconfig = defaultconfig - 'defaultValue'\n                    \tWHERE name = 'radio-boolean-widget';\n                    update cards_x_nodes_x_widgets\n                    \tset config = config - 'defaultValue'\n                    \tWHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'radio-boolean-widget');\n                ",
        ),
        migrations.RunSQL(
            sql="\n                    update widgets\n                        set defaultconfig = (SELECT defaultconfig || jsonb_build_object('defaultValue', '') FROM widgets WHERE name = 'switch-widget')\n                        WHERE name = 'switch-widget';\n                    update cards_x_nodes_x_widgets\n                        set config = (SELECT config || jsonb_build_object('defaultValue', '') FROM widgets WHERE name = 'switch-widget')\n                        WHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'switch-widget');\n\n\n                ",
            reverse_sql="\n                    update widgets\n                        set defaultconfig = defaultconfig - 'defaultValue'\n                        WHERE name = 'switch-widget';\n                    update cards_x_nodes_x_widgets\n                        set config = config - 'defaultValue'\n                        WHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'switch-widget');\n                ",
        ),
        migrations.RunSQL(
            sql="\n                    update widgets\n                    \tset defaultconfig = (SELECT defaultconfig || jsonb_build_object('defaultValue', '') FROM widgets WHERE name = 'domain-select-widget')\n                    \tWHERE name = 'domain-select-widget';\n                    update cards_x_nodes_x_widgets\n                    \tset config = (SELECT config || jsonb_build_object('defaultValue', '') FROM widgets WHERE name = 'domain-select-widget')\n                    \tWHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'domain-select-widget');\n\n\n                ",
            reverse_sql="\n                    update widgets\n                    \tset defaultconfig = defaultconfig - 'defaultValue'\n                    \tWHERE name = 'domain-select-widget';\n                    update cards_x_nodes_x_widgets\n                    \tset config = config - 'defaultValue'\n                    \tWHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'domain-select-widget');\n                ",
        ),
        migrations.RunSQL(
            sql="\n                    update widgets\n                        set defaultconfig = (SELECT defaultconfig || jsonb_build_object('defaultValue', '') FROM widgets WHERE name = 'domain-radio-widget')\n                        WHERE name = 'domain-radio-widget';\n                    update cards_x_nodes_x_widgets\n                        set config = (SELECT config || jsonb_build_object('defaultValue', '') FROM widgets WHERE name = 'domain-radio-widget')\n                        WHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'domain-radio-widget');\n\n\n                ",
            reverse_sql="\n                    update widgets\n                        set defaultconfig = defaultconfig - 'defaultValue'\n                        WHERE name = 'domain-radio-widget';\n                    update cards_x_nodes_x_widgets\n                        set config = config - 'defaultValue'\n                        WHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'domain-radio-widget');\n                ",
        ),
        migrations.RunSQL(
            sql="\n                    update widgets\n                        set defaultconfig = (SELECT defaultconfig || jsonb_build_object('defaultValue', '') FROM widgets WHERE name = 'domain-multiselect-widget')\n                        WHERE name = 'domain-multiselect-widget';\n                    update cards_x_nodes_x_widgets\n                        set config = (SELECT config || jsonb_build_object('defaultValue', '') FROM widgets WHERE name = 'domain-multiselect-widget')\n                        WHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'domain-multiselect-widget');\n\n\n                ",
            reverse_sql="\n                    update widgets\n                        set defaultconfig = defaultconfig - 'defaultValue'\n                        WHERE name = 'domain-multiselect-widget';\n                    update cards_x_nodes_x_widgets\n                        set config = config - 'defaultValue'\n                        WHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'domain-multiselect-widget');\n                ",
        ),
        migrations.RunSQL(
            sql="\n                    update widgets\n                        set defaultconfig = (SELECT defaultconfig || jsonb_build_object('defaultValue', '') FROM widgets WHERE name = 'domain-checkbox-widget')\n                        WHERE name = 'domain-checkbox-widget';\n                    update cards_x_nodes_x_widgets\n                        set config = (SELECT config || jsonb_build_object('defaultValue', '') FROM widgets WHERE name = 'domain-checkbox-widget')\n                        WHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'domain-checkbox-widget');\n\n\n                ",
            reverse_sql="\n                    update widgets\n                        set defaultconfig = defaultconfig - 'defaultValue'\n                        WHERE name = 'domain-checkbox-widget';\n                    update cards_x_nodes_x_widgets\n                        set config = config - 'defaultValue'\n                        WHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'domain-checkbox-widget');\n                ",
        ),
        migrations.RunSQL(
            sql="\n                    update widgets\n                    \tset defaultconfig = (SELECT defaultconfig || jsonb_build_object('defaultValue', '') FROM widgets WHERE name = 'concept-select-widget')\n                    \tWHERE name = 'concept-select-widget';\n                    update cards_x_nodes_x_widgets\n                    \tset config = (SELECT config || jsonb_build_object('defaultValue', '') FROM widgets WHERE name = 'concept-select-widget')\n                    \tWHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'concept-select-widget');\n\n\n                ",
            reverse_sql="\n                    update widgets\n                    \tset defaultconfig = defaultconfig - 'defaultValue'\n                    \tWHERE name = 'concept-select-widget';\n                    update cards_x_nodes_x_widgets\n                    \tset config = config - 'defaultValue'\n                    \tWHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'concept-select-widget');\n                ",
        ),
        migrations.RunSQL(
            sql="\n                    update widgets\n                        set defaultconfig = (SELECT defaultconfig || jsonb_build_object('defaultValue', '') FROM widgets WHERE name = 'concept-radio-widget')\n                        WHERE name = 'concept-radio-widget';\n                    update cards_x_nodes_x_widgets\n                        set config = (SELECT config || jsonb_build_object('defaultValue', '') FROM widgets WHERE name = 'concept-radio-widget')\n                        WHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'concept-radio-widget');\n\n\n                ",
            reverse_sql="\n                    update widgets\n                        set defaultconfig = defaultconfig - 'defaultValue'\n                        WHERE name = 'concept-radio-widget';\n                    update cards_x_nodes_x_widgets\n                        set config = config - 'defaultValue'\n                        WHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'concept-radio-widget');\n                ",
        ),
        migrations.RunSQL(
            sql="\n                    update widgets\n                        set defaultconfig = (SELECT defaultconfig || jsonb_build_object('defaultValue', '') FROM widgets WHERE name = 'concept-multiselect-widget')\n                        WHERE name = 'concept-multiselect-widget';\n                    update cards_x_nodes_x_widgets\n                        set config = (SELECT config || jsonb_build_object('defaultValue', '') FROM widgets WHERE name = 'concept-multiselect-widget')\n                        WHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'concept-multiselect-widget');\n\n\n                ",
            reverse_sql="\n                    update widgets\n                        set defaultconfig = defaultconfig - 'defaultValue'\n                        WHERE name = 'concept-multiselect-widget';\n                    update cards_x_nodes_x_widgets\n                        set config = config - 'defaultValue'\n                        WHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'concept-multiselect-widget');\n                ",
        ),
        migrations.RunSQL(
            sql="\n                    update widgets\n                        set defaultconfig = (SELECT defaultconfig || jsonb_build_object('defaultValue', '') FROM widgets WHERE name = 'concept-checkbox-widget')\n                        WHERE name = 'concept-checkbox-widget';\n                    update cards_x_nodes_x_widgets\n                        set config = (SELECT config || jsonb_build_object('defaultValue', '') FROM widgets WHERE name = 'concept-checkbox-widget')\n                        WHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'concept-checkbox-widget');\n\n\n                ",
            reverse_sql="\n                    update widgets\n                        set defaultconfig = defaultconfig - 'defaultValue'\n                        WHERE name = 'concept-checkbox-widget';\n                    update cards_x_nodes_x_widgets\n                        set config = config - 'defaultValue'\n                        WHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'concept-checkbox-widget');\n                ",
        ),
        migrations.RunSQL(
            sql="\n                    update widgets\n                    \tset defaultconfig = (SELECT defaultconfig || jsonb_build_object('defaultValue', '') FROM widgets WHERE name = 'datepicker-widget')\n                    \tWHERE name = 'datepicker-widget';\n                    update cards_x_nodes_x_widgets\n                    \tset config = (SELECT config || jsonb_build_object('defaultValue', '') FROM widgets WHERE name = 'datepicker-widget')\n                    \tWHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'datepicker-widget');\n\n\n                ",
            reverse_sql="\n                    update widgets\n                    \tset defaultconfig = defaultconfig - 'defaultValue'\n                    \tWHERE name = 'datepicker-widget';\n                    update cards_x_nodes_x_widgets\n                    \tset config = config - 'defaultValue'\n                    \tWHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'datepicker-widget');\n                ",
        ),
        migrations.AddField(
            model_name="mobilesurveymodel",
            name="datadownload",
            field=models.BooleanField(default=False),
        ),
        migrations.RunSQL(
            sql="\n              update widgets set defaultconfig = '{\"max\":\"\",\"defaultValue\":\"\",\"placeholder\":\"Enter number\",\"width\":\"100%\",\"min\":\"\", \"step\":\"\", \"precision\":\"\", \"prefix\":\"\", \"suffix\":\"\"}'  where name = 'number-widget';\n\n              update cards_x_nodes_x_widgets\n                    set config = (SELECT config || jsonb_build_object('step', '') FROM widgets WHERE name = 'number-widget')\n                    WHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'number-widget');\n              update cards_x_nodes_x_widgets\n                    set config = (SELECT config || jsonb_build_object('precision', '') FROM widgets WHERE name = 'number-widget')\n                    WHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'number-widget');\n              update cards_x_nodes_x_widgets\n                    set config = (SELECT config || jsonb_build_object('prefix', '') FROM widgets WHERE name = 'number-widget')\n                    WHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'number-widget');\n              update cards_x_nodes_x_widgets\n                    set config = (SELECT config || jsonb_build_object('suffix', '') FROM widgets WHERE name = 'number-widget')\n                    WHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'number-widget');\n              ",
            reverse_sql="\n                  update widgets set defaultconfig = defaultconfig - 'step' WHERE name = 'number-widget';\n                  update widgets set defaultconfig = defaultconfig - 'precision' WHERE name = 'number-widget';\n                  update widgets set defaultconfig = defaultconfig - 'prefix' WHERE name = 'number-widget';\n                  update widgets set defaultconfig = defaultconfig - 'suffix' WHERE name = 'number-widget';\n                  update cards_x_nodes_x_widgets set config = config - 'step' WHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'number-widget');\n                  update cards_x_nodes_x_widgets set config = config - 'precision' WHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'number-widget');\n                  update cards_x_nodes_x_widgets set config = config - 'prefix' WHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'number-widget');\n                  update cards_x_nodes_x_widgets set config = config - 'suffix' WHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'number-widget');\n              ",
        ),
        migrations.RunSQL(
            sql="\n                    update widgets\n                    \tset defaultconfig = (SELECT defaultconfig || jsonb_build_object('defaultValue', '') FROM widgets WHERE name = 'map-widget')\n                    \tWHERE name = 'map-widget';\n                    update cards_x_nodes_x_widgets\n                    \tset config = (SELECT config || jsonb_build_object('defaultValue', '') FROM widgets WHERE name = 'map-widget')\n                    \tWHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'map-widget');\n\n                    update widgets\n                          set defaultconfig = (SELECT defaultconfig || jsonb_build_object('defaultValueType', '') FROM widgets WHERE name = 'map-widget')\n                          WHERE name = 'map-widget';\n                        update cards_x_nodes_x_widgets\n                          set config = (SELECT config || jsonb_build_object('defaultValueType', '') FROM widgets WHERE name = 'map-widget')\n                          WHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'map-widget');\n                ",
            reverse_sql="\n                    update widgets\n                    \tset defaultconfig = defaultconfig - 'defaultValue'\n                    \tWHERE name = 'map-widget';\n                    update widgets\n                    \tset defaultconfig = defaultconfig - 'defaultValueType'\n                    \tWHERE name = 'map-widget';\n                    update cards_x_nodes_x_widgets\n                    \tset config = config - 'defaultValue'\n                    \tWHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'map-widget');\n                    update cards_x_nodes_x_widgets\n                    \tset config = config - 'defaultValueType'\n                    \tWHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'map-widget');\n                ",
        ),
        migrations.RunSQL(
            sql="\n                    update widgets\n                    \tset defaultconfig = (SELECT defaultconfig || jsonb_build_object('defaultValue',null) FROM widgets WHERE name = 'radio-boolean-widget')\n                    \tWHERE name = 'radio-boolean-widget';\n                    update cards_x_nodes_x_widgets\n                    \tset config = (SELECT config || jsonb_build_object('defaultValue', null) FROM widgets WHERE name = 'radio-boolean-widget')\n                    \tWHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'radio-boolean-widget') and config @> '{\"defaultValue\":\"\"}';\n\n                ",
            reverse_sql="\n                    update widgets\n                    \tset defaultconfig = (SELECT defaultconfig || jsonb_build_object('defaultValue','') FROM widgets WHERE name = 'radio-boolean-widget')\n                    \tWHERE name = 'radio-boolean-widget';\n                    update cards_x_nodes_x_widgets\n                    \tset config = (SELECT config || jsonb_build_object('defaultValue', '') FROM widgets WHERE name = 'radio-boolean-widget')\n                    \tWHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'radio-boolean-widget') and config @> '{\"defaultValue\":null}';\n                ",
        ),
        migrations.RunSQL(
            sql="\n                    update widgets\n                    \tset defaultconfig = (SELECT defaultconfig || jsonb_build_object('defaultValue',null) FROM widgets WHERE name = 'switch-widget')\n                    \tWHERE name = 'switch-widget';\n                    update cards_x_nodes_x_widgets\n                    \tset config = (SELECT config || jsonb_build_object('defaultValue', null) FROM widgets WHERE name = 'switch-widget')\n                    \tWHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'switch-widget') and config @> '{\"defaultValue\":\"\"}';\n\n                ",
            reverse_sql="\n                    update widgets\n                    \tset defaultconfig = (SELECT defaultconfig || jsonb_build_object('defaultValue','') FROM widgets WHERE name = 'switch-widget')\n                    \tWHERE name = 'switch-widget';\n                    update cards_x_nodes_x_widgets\n                    \tset config = (SELECT config || jsonb_build_object('defaultValue', '') FROM widgets WHERE name = 'switch-widget')\n                    \tWHERE widgetid in (SELECT widgetid FROM widgets WHERE name = 'switch-widget') and config @> '{\"defaultValue\":null}';\n                ",
        ),
        migrations.AddField(
            model_name="mobilesurveymodel",
            name="bounds",
            field=django.contrib.gis.db.models.fields.MultiPolygonField(
                null=True, srid=4326
            ),
        ),
        migrations.AddField(
            model_name="mobilesurveymodel",
            name="tilecache",
            field=models.TextField(null=True),
        ),
        migrations.AddField(
            model_name="mobilesurveymodel",
            name="datadownloadconfig",
            field=django.contrib.postgres.fields.jsonb.JSONField(
                blank=True,
                default=lambda: dict(
                    download=False, count=1000, resources=[], custom=None
                ),
                null=True,
            ),
        ),
        migrations.RemoveField(
            model_name="mobilesurveymodel",
            name="datadownload",
        ),
        migrations.RunSQL(
            sql="\n                INSERT INTO d_data_types(\n                    datatype, iconclass, modulename,\n                    classname, defaultconfig, configcomponent,\n                    configname, isgeometric, defaultwidget,\n                    issearchable\n                ) VALUES (\n                    'node-value',\n                    'fa fa-external-link-square',\n                    'datatypes.py',\n                    'NodeValueDataType',\n                    '{\n                        \"nodeid\": null,\n                        \"property\": null\n                    }',\n                    'views/components/datatypes/node-value',\n                    'node-value-datatype-config',\n                    FALSE,\n                    'f5d6b190-bbf0-4dc9-b991-1debab8cb4a9',\n                    FALSE\n                );\n\n                INSERT INTO widgets(\n                    widgetid,\n                    name,\n                    component,\n                    datatype,\n                    defaultconfig\n                ) VALUES (\n                    'f5d6b190-bbf0-4dc9-b991-1debab8cb4a9',\n                    'node-value-select',\n                    'views/components/widgets/node-value-select',\n                    'node-value',\n                    '{\n                        \"placeholder\": \"\"\n                    }'\n                );\n                ",
            reverse_sql="\n                DELETE FROM d_data_types\n                    WHERE datatype = 'node-value';\n\n                DELETE from widgets\n                    WHERE widgetid = 'f5d6b190-bbf0-4dc9-b991-1debab8cb4a9';\n                ",
        ),
        migrations.RunSQL(
            sql="\n                UPDATE d_data_types\n                SET defaultconfig = jsonb_build_object('trueLabel', 'Yes', 'falseLabel', 'No') || COALESCE(defaultconfig, '{}'::jsonb)\n                WHERE datatype = 'boolean';\n                --\n                UPDATE widgets\n                SET defaultconfig = defaultconfig - 'falseLabel'\n                WHERE name = 'radio-boolean-widget';\n\n                UPDATE widgets\n                SET defaultconfig = defaultconfig - 'trueLabel'\n                WHERE name = 'radio-boolean-widget';\n                --\n                UPDATE nodes AS n\n                SET config = COALESCE(n.config, '{}'::jsonb) || jsonb_build_object('trueLabel', c.config->>'trueLabel', 'falseLabel', c.config->>'falseLabel')\n                FROM cards_x_nodes_x_widgets AS c\n                WHERE n.nodeid = c.nodeid\n                AND n.datatype = 'boolean';\n                --\n                UPDATE cards_x_nodes_x_widgets\n                SET config = config - 'falseLabel'\n                WHERE nodeid in (SELECT nodeid from nodes WHERE datatype = 'boolean');\n\n                UPDATE cards_x_nodes_x_widgets\n                SET config = config - 'trueLabel'\n                WHERE nodeid in (SELECT nodeid from nodes WHERE datatype = 'boolean');\n\n                ",
            reverse_sql="\n                UPDATE d_data_types\n                SET defaultconfig = defaultconfig - 'trueLabel'\n                WHERE datatype = 'boolean';\n\n                UPDATE d_data_types\n                SET defaultconfig = defaultconfig - 'falseLabel'\n                WHERE datatype = 'boolean';\n                --\n                UPDATE widgets\n                SET defaultconfig = COALESCE(defaultconfig, '{}'::jsonb) || jsonb_build_object('trueLabel', 'Yes', 'falseLabel', 'No')\n                WHERE name = 'radio-boolean-widget';\n                --\n                UPDATE nodes\n                SET config = config - 'trueLabel'\n                WHERE datatype = 'boolean';\n\n                UPDATE nodes\n                SET config = config - 'falseLabel'\n                WHERE datatype = 'boolean';\n                --\n                UPDATE cards_x_nodes_x_widgets AS n\n                SET config = COALESCE(n.config, '{}'::jsonb) || jsonb_build_object('trueLabel', c.config->>'trueLabel', 'falseLabel', c.config->>'falseLabel')\n                FROM nodes AS c\n                WHERE n.nodeid = c.nodeid\n                AND c.datatype = 'boolean';\n                ",
        ),
        migrations.RunSQL(
            sql="\n                update nodes n\n                \tset config = jsonb_set(config, '{graphid}', (\n                \t\tselect jsonb_agg(config->'graphid')\n                \t\tfrom nodes n1\n                \t\twhere n1.nodeid = n.nodeid\n                \t))\n                \twhere datatype in ('resource-instance', 'resource-instance-list')\n                \tand config->'graphid' is not null;\n                ",
            reverse_sql="\n                update nodes n\n                \tset config = jsonb_set(config, '{graphid}', config->'graphid'->0)\n                \twhere datatype in ('resource-instance', 'resource-instance-list')\n                \tand config->'graphid' is not null;\n                ",
        ),
        migrations.RunSQL(
            sql="\n            DELETE FROM public.geocoders WHERE geocoderid = '10000000-0000-0000-0000-010000000001';\n            DELETE FROM public.map_sources WHERE name = 'mapzen';\n            DELETE FROM public.map_layers WHERE name = 'mapzen';\n        ",
            reverse_sql='\n            INSERT INTO public.geocoders(geocoderid, name, component) VALUES (\'10000000-0000-0000-0000-010000000001\', \'Mapzen\', \'views/components/geocoders/mapzen\');\n            INSERT INTO map_sources(name, source)\n               VALUES (\'mapzen\', \'{\n                           "type": "vector",\n                           "tiles": ["https://vector.mapzen.com/osm/all/{z}/{x}/{y}.mvt?api_key=vector-tiles-LM25tq4"]\n                   }\');\n            INSERT INTO map_layers(maplayerid, name, layerdefinitions, isoverlay, icon, activated, addtomap)\n               VALUES (public.uuid_generate_v1mc(), \'mapzen\', \'\n                 [\n                 {\n                     "id": "background",\n                     "type": "background",\n                     "paint": {\n                       "background-color": "#ededed"\n                     }\n                   }, {\n                     "id": "water-line",\n                     "source": "mapzen",\n                     "source-layer": "water",\n                     "type": "line",\n                     "filter": ["==", "$type", "LineString"],\n                     "paint": {\n                       "line-color": "#7acad0",\n                       "line-width": {\n                         "base": 1.2,\n                         "stops": [[8, 0.5], [20, 15]]\n                       }\n                     }\n                   }, {\n                     "id": "water-polygon",\n                     "source": "mapzen",\n                     "source-layer": "water",\n                     "type": "fill",\n                     "filter": ["==", "$type", "Polygon"],\n                     "paint": {\n                       "fill-color": "#7acad0"\n                     }\n                   }, {\n                     "id": "park",\n                     "type": "fill",\n                     "source": "mapzen",\n                     "source-layer": "landuse",\n                     "minzoom": 6,\n                     "filter": ["in", "kind", "park", "forest", "garden", "grass", "farm", "meadow", "playground", "golf_course", "nature_reserve", "wetland", "wood", "cemetery"],\n                     "paint": {\n                       "fill-color": "#c2cd44"\n                     }\n                   }, {\n                     "id": "river",\n                     "source": "mapzen",\n                     "source-layer": "water",\n                     "type": "line",\n                     "minzoom": 6,\n                     "filter": ["all", ["==", "$type", "LineString"], ["==", "kind", "river"]],\n                     "layout": {\n                         "line-cap": "round",\n                         "line-join": "round"\n                       },\n                     "paint": {\n                       "line-color": "#7acad0",\n                       "line-width": {\n                         "base": 1.2,\n                         "stops": [[8, 0.75], [20, 15]]\n                       }\n                     }\n                   }, {\n                     "id": "stream-etc",\n                     "source": "mapzen",\n                     "source-layer": "water",\n                     "type": "line",\n                     "minzoom": 11,\n                     "filter": ["all", ["==", "$type", "LineString"], ["==", "kind", "stream"]],\n                     "layout": {\n                         "line-cap": "round",\n                         "line-join": "round"\n                       },\n                     "paint": {\n                       "line-color": "#7acad0",\n                       "line-width": {\n                         "base": 1.4,\n                         "stops": [[10, 0.5], [20, 15]]\n                       }\n                     }\n                   }, {\n                       "id": "country-boundary",\n                       "source": "mapzen",\n                       "source-layer": "places",\n                       "type": "line",\n                       "filter": ["==", "admin_level", "2"],\n                       "maxzoom": 4,\n                       "layout": {\n                         "line-cap": "round",\n                         "line-join": "round"\n                       },\n                       "paint": {\n                         "line-color": "#afd3d3",\n                       "line-width": {\n                         "base": 2,\n                         "stops": [[1, 0.5], [7, 3]]\n                         }\n                       }\n                     }, {\n                       "id": "state-boundary",\n                       "source": "mapzen",\n                       "source-layer": "places",\n                       "type": "fill",\n                       "filter": ["==", "admin_level", "4"],\n                       "maxzoom": 10,\n                       "paint": {\n                         "fill-color": "#ededed",\n                         "fill-outline-color": "#cacecc"\n                       }\n                     }, {\n                     "id": "subways",\n                     "source": "mapzen",\n                     "source-layer": "roads",\n                     "type": "line",\n                     "paint": {\n                       "line-color": "#ef7369",\n                       "line-dasharray": [2, 1]\n                     },\n                     "filter": ["==", "railway", "subway"]\n                   }, {\n                     "id": "link-tunnel",\n                     "source": "mapzen",\n                     "source-layer": "roads",\n                     "type": "line",\n                     "filter": ["any",["==", "is_tunnel", "yes"]],\n                     "layout": {\n                       "line-join": "round",\n                       "line-cap": "round"\n                     },\n                     "paint": {\n                       "line-color": "#afd3d3",\n                       "line-width": {\n                         "base": 1.55,\n                         "stops": [[4, 0.25], [20, 30]]\n                       },\n                       "line-dasharray": [1, 2]\n                     }\n                   }, {\n                     "id": "buildings",\n                     "type": "fill",\n                     "source": "mapzen",\n                     "source-layer": "buildings",\n                     "paint": {\n                     "fill-outline-color": "#afd3d3",\n                     "fill-color": "#ededed"\n                     }\n                   }, {\n                     "id": "road",\n                     "source": "mapzen",\n                     "source-layer": "roads",\n                     "type": "line",\n                     "filter": ["any",["==", "kind", "minor_road"],["==", "kind", "major_road"]],\n                     "layout": {\n                       "line-join": "round",\n                       "line-cap": "round"\n                     },\n                     "paint": {\n                       "line-color": "#c0c4c2",\n                       "line-width": {\n                         "base": 1.55,\n                         "stops": [[4, 0.25], [20, 30]]\n                       }\n                     }\n                   }, {\n                     "id": "link-bridge",\n                     "source": "mapzen",\n                     "source-layer": "roads",\n                     "type": "line",\n                     "filter": ["any",["==", "is_link", "yes"], ["==", "is_bridge", "yes"]],\n                     "layout": {\n                       "line-join": "round",\n                       "line-cap": "round"\n                     },\n                     "paint": {\n                       "line-color": "#c0c4c2",\n                       "line-width": {\n                         "base": 1.55,\n                         "stops": [[4, 0.5], [8, 1.5], [20, 40]]\n                       }\n                     }\n                   }, {\n                     "id": "highway",\n                     "source": "mapzen",\n                     "source-layer": "roads",\n                     "type": "line",\n                     "filter": ["==", "kind", "highway"],\n                     "layout": {\n                       "line-join": "round",\n                       "line-cap": "round"\n                     },\n                     "paint": {\n                       "line-color": "#5d6765",\n                       "line-width": {\n                         "base": 1.55,\n                         "stops": [[4, 0.5], [8, 1.5], [20, 40]]\n                       }\n                     }\n                   }, {\n                     "id": "path",\n                     "source": "mapzen",\n                     "source-layer": "roads",\n                     "type": "line",\n                     "filter": ["==", "kind", "path"],\n                     "layout": {\n                       "line-join": "round",\n                       "line-cap": "round"\n                     },\n                     "minzoom": 12,\n                     "paint": {\n                       "line-color": "#5d6765",\n                       "line-width": {\n                         "base": 1.8,\n                         "stops": [[10, 0.15], [20, 15]]\n                       },\n                       "line-dasharray": [2, 2]\n                     }\n                   }, {\n                     "id": "ocean-label",\n                     "source": "mapzen",\n                     "source-layer": "places",\n                     "type": "symbol",\n                     "minzoom": 2,\n                     "maxzoom": 6,\n                     "filter": ["==", "kind", "ocean"],\n                     "layout": {\n                         "text-field": "{name}",\n                         "text-font": ["Open Sans Italic", "Arial Unicode MS Regular"],\n                         "text-max-width": 14,\n                         "text-letter-spacing": 0.1\n                       },\n                     "paint": {\n                       "text-color": "#ededed",\n                       "text-halo-color": "rgba(0,0,0,0.2)"\n                     }\n                   }, {\n                       "id": "other-label",\n                       "source": "mapzen",\n                       "source-layer": "places",\n                       "filter": ["all", ["==", "$type", "Point"], ["==", "kind", "neighbourhood"]],\n                       "minzoom": 12,\n                       "type": "symbol",\n                       "layout": {\n                         "text-field": "{name}",\n                         "text-font": ["Open Sans Semibold", "Arial Unicode MS Bold"],\n                         "text-max-width": 10\n                       },\n                       "paint": {\n                         "text-color": "#cb4b49",\n                         "text-halo-color": "rgba(255,255,255,0.5)"\n                       }\n                     }, {\n                       "id": "city-label",\n                       "source": "mapzen",\n                       "source-layer": "places",\n                       "filter": ["all", ["==", "$type", "Point"], ["==", "kind", "city"]],\n                       "minzoom": 10,\n                       "maxzoom": 14,\n                       "type": "symbol",\n                       "layout": {\n                         "text-field": "{name}",\n                         "text-font": ["Open Sans Semibold", "Arial Unicode MS Bold"],\n                         "text-max-width": 10,\n                         "text-letter-spacing": 0.1\n                       },\n                       "paint": {\n                         "text-color": "#384646",\n                         "text-halo-color": "rgba(255,255,255,0.5)"\n                       }\n                     }, {\n                       "id": "state-label",\n                       "source": "mapzen",\n                       "source-layer": "places",\n                       "filter": ["all", ["==", "$type", "Point"], ["==", "kind", "state"]],\n                       "minzoom": 6,\n                       "maxzoom": 12,\n                       "type": "symbol",\n                       "layout": {\n                         "text-field": "{name}",\n                         "text-font": ["Open Sans Regular", "Arial Unicode MS Regular"],\n                         "text-max-width": 8\n                       },\n                       "paint": {\n                         "text-color": "#f27a87",\n                         "text-halo-color": "rgba(255,255,255,0.5)"\n                       }\n                     }, {\n                       "id": "country-label",\n                       "source": "mapzen",\n                       "source-layer": "places",\n                       "filter": ["all", ["==", "$type", "Point"], ["==", "kind", "country"]],\n                       "maxzoom": 7,\n                       "type": "symbol",\n                       "layout": {\n                         "text-field": "{name}",\n                         "text-font": ["Open Sans Semibold", "Arial Unicode MS Bold"],\n                         "text-max-width": 4\n                       },\n                       "paint": {\n                         "text-color": "#cb4b49",\n                         "text-halo-color": "rgba(255,255,255,0.5)"\n                       }\n                     }\n                   ]\n\n                 \', FALSE, \'\', TRUE, FALSE);\n        ',
        ),
        migrations.RunSQL(
            sql="\n        DELETE FROM functions_x_graphs WHERE functionid = '60000000-0000-0000-0000-000000000000';\n        DELETE FROM functions WHERE functionid = '60000000-0000-0000-0000-000000000000';\n        ",
            reverse_sql="\n        INSERT INTO functions(functionid, modulename, classname, functiontype, name, description, defaultconfig, component)\n            VALUES ('60000000-0000-0000-0000-000000000000', 'local_file_storage.py', 'LocalFileStorageFunction', 'node', 'Local File Upload', 'Sets the default storage mechanism for uploaded files', '{}', 'views/components/functions/local-file-storage');\n        ",
        ),
        migrations.RunSQL(
            sql='\n            update cards_x_nodes_x_widgets SET config = jsonb_set(config, \'{geocodeProvider}\', \'"10000000-0000-0000-0000-010000000000"\') where config @> \'{"geocodeProvider": "10000000-0000-0000-0000-010000000001"}\' or config  @> \'{"geocodeProvider": "MapzenGeocoder"}\';\n        ',
            reverse_sql="\n            update cards_x_nodes_x_widgets SET config = jsonb_set(config, '{geocodeProvider}', '\"10000000-0000-0000-0000-010000000001\"') where config @> '{\"geocodeProvider\": \"10000000-0000-0000-0000-010000000000\"}';\n        ",
        ),
    ]
