# Generated by Django 5.1.2 on 2024-11-01 15:08

from django.db import migrations, models

# Not standard to import a model that's not a *historical* model,
# but we need to access functionality trapped on create_node_alias().
from arches.app.models.graph import Graph


class Migration(migrations.Migration):

    dependencies = [
        ("models", "11042_update__arches_staging_to_tile"),
    ]

    def create_node_aliases(apps, schema_editor):
        Node = apps.get_model("models", "Node")
        GraphModel = apps.get_model("models", "GraphModel")
        nodes_needing_alias = Node.objects.filter(alias__isnull=True)
        for node in nodes_needing_alias:
            # We didn't fetch Graph from get_model(), so we can't use it
            # to fetch data. Use the vanilla model to fetch data, and place
            # the only relevant data (dict of nodes) on a dummy instance.
            graph = GraphModel.objects.get(pk=node.graph_id)
            dummy = Graph()
            dummy.nodes = graph.node_set.in_bulk()
            dummy.create_node_alias(node)
        Node.objects.bulk_update(nodes_needing_alias, ["alias"])

    operations = [
        migrations.RunPython(create_node_aliases, migrations.RunPython.noop),
        migrations.AlterField(
            model_name="node",
            name="alias",
            field=models.TextField(blank=True),
        ),
    ]
