# Generated by Django 5.2a1 on 2025-02-12 10:28

import django.db.models.functions.text
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("models", "11725_make_tiledata_not_nullable"),
    ]

    operations = [
        migrations.RunSQL(
            """
            DROP RULE relations_check_insert ON relations;
            DROP RULE relations_check_update ON relations;

            DROP FUNCTION public.__arches_check_dup_relations(
            p_conceptid1 uuid,
            p_conceptid2 uuid,
            p_relationtype text);
            """,
            """
            CREATE OR REPLACE FUNCTION public.__arches_check_dup_relations(
                p_conceptid1 uuid,
                p_conceptid2 uuid,
                p_relationtype text)
                RETURNS text
                LANGUAGE 'plpgsql'

                COST 100
                VOLATILE

            AS $BODY$

            declare
            v_return text;

            BEGIN
                IF
                    (	SELECT count(*) from relations
                        WHERE 1=1
                            AND conceptidfrom = p_conceptid1
                            AND conceptidto = p_conceptid2
                            AND relationtype = p_relationtype ) > 0
                        THEN v_return = 'duplicate';

                    ELSIF
                    (	SELECT count(*) from relations
                        WHERE 1=1
                            AND conceptidfrom = p_conceptid2
                            AND conceptidto = p_conceptid1
                            AND relationtype = p_relationtype ) > 0
                        THEN v_return = 'duplicate';

                    ELSE v_return = 'unique';

                END IF;

            RETURN v_return;

            END;

            $BODY$;


            CREATE OR REPLACE RULE relations_check_insert AS ON INSERT TO relations
                WHERE (select * from __arches_check_dup_relations(new.conceptidfrom,new.conceptidto,new.relationtype)) = 'duplicate'
                DO INSTEAD NOTHING;

            CREATE OR REPLACE RULE relations_check_update AS ON UPDATE TO relations
                WHERE (select * from __arches_check_dup_relations(new.conceptidfrom,new.conceptidto,new.relationtype)) = 'duplicate'
                DO INSTEAD NOTHING;
            """,
        ),
        migrations.AlterUniqueTogether(
            name="relation",
            unique_together=set(),
        ),
        migrations.AddConstraint(
            model_name="relation",
            constraint=models.UniqueConstraint(
                models.Case(
                    models.When(
                        django.db.models.expressions.CombinedExpression(
                            models.F("conceptfrom"),
                            "<",
                            models.F("conceptto"),
                            output_field=models.BooleanField(),
                        ),
                        then=django.db.models.functions.text.Concat(
                            models.F("conceptfrom"),
                            models.Value(","),
                            models.F("conceptto"),
                            output_field=models.TextField(),
                        ),
                    ),
                    default=django.db.models.functions.text.Concat(
                        models.F("conceptto"),
                        models.Value(","),
                        models.F("conceptfrom"),
                        output_field=models.TextField(),
                    ),
                ),
                models.F("relationtype"),
                name="unique_relation_bidirectional",
            ),
        ),
    ]
