# Generated by Django 5.2b1 on 2025-03-19 11:14

import django.core.validators
import re
from slugify import slugify
from django.db import migrations, models
from arches.app.models.utils import make_name_unique


class Migration(migrations.Migration):

    dependencies = [
        ("models", "12008_alter_file_path"),
    ]

    def add_missing_graph_slug(apps, schema_editor):
        Graph = apps.get_model("models", "Graph")
        graphs_missing_slug = Graph.objects.filter(slug__isnull=True)
        for graph in graphs_missing_slug:
            existing_graph_slugs = Graph.objects.all().values_list("slug", flat=True)
            slug = slugify(str(graph.name) or "new_graph", separator="_")
            graph.slug = make_name_unique(slug, existing_graph_slugs)
            graph.save()

    operations = [
        migrations.RunPython(
            add_missing_graph_slug,
            migrations.RunPython.noop,
        ),
        migrations.AlterField(
            model_name="graphmodel",
            name="slug",
            field=models.TextField(
                validators=[
                    django.core.validators.RegexValidator(
                        re.compile("^[-a-zA-Z0-9_]+\\Z"),
                        "Enter a valid “slug” consisting of letters, numbers, underscores or hyphens.",
                        "invalid",
                    )
                ],
            ),
        ),
    ]
