# Generated by Django 5.2b1 on 2025-04-09 15:33

import arches.app.models.query_expressions
import django.db.models.deletion
import django.db.models.functions.text
import uuid
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("models", "11966_resourceinstancelifecycle_xref_constraints"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="UserPreference",
            fields=[
                (
                    "userpreferenceid",
                    models.UUIDField(
                        db_default=arches.app.models.query_expressions.UUID4(),
                        default=uuid.uuid4,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("preferencename", models.CharField(max_length=255)),
                ("appname", models.CharField(default="arches", max_length=255)),
                ("config", models.JSONField()),
                (
                    "username",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="preferences",
                        related_query_name="preference",
                        to=settings.AUTH_USER_MODEL,
                        to_field="username",
                    ),
                ),
            ],
            options={
                "db_table": "user_preferences",
                "managed": True,
                "constraints": [
                    models.UniqueConstraint(
                        models.F("username"),
                        django.db.models.functions.text.Lower("preferencename"),
                        django.db.models.functions.text.Lower("appname"),
                        name="unique_preference_name_user",
                    )
                ],
            },
        ),
    ]
