# Generated by Django 5.2.3 on 2025-06-12 14:33

import pgtrigger.compiler
import pgtrigger.migrations
from django.db import migrations


class Migration(migrations.Migration):

    dependencies = [
        ("models", "7853_add_timestamp_index"),
    ]

    operations = [
        pgtrigger.migrations.RemoveTrigger(
            model_name="spatialview",
            name="arches_update_spatial_views",
        ),
        pgtrigger.migrations.AddTrigger(
            model_name="spatialview",
            trigger=pgtrigger.compiler.Trigger(
                name="arches_update_spatial_views",
                sql=pgtrigger.compiler.UpsertTriggerSql(
                    constraint="CONSTRAINT",
                    declare="DECLARE sv_perform text; valid_geom_nodeid boolean; has_att_nodes integer; valid_att_nodeids boolean; valid_language_count integer;",
                    func="\nsv_perform := '';\nvalid_geom_nodeid := false;\nhas_att_nodes := 0;\nvalid_att_nodeids := false;\nvalid_language_count := 0;\n\nif tg_op = 'INSERT' or tg_op = 'UPDATE' then\n    valid_geom_nodeid := (select count(*) from nodes where nodeid = new.geometrynodeid and datatype = 'geojson-feature-collection') > 0;\n    if valid_geom_nodeid is false then\n        raise exception 'geometrynodeid is not a valid nodeid';\n    end if;\n\n\n    if jsonb_typeof(new.attributenodes::jsonb) = 'array' then\n        has_att_nodes := jsonb_array_length(new.attributenodes);\n        if has_att_nodes = 0 then\n            raise exception 'attributenodes needs at least one attribute dict';\n        else\n            valid_att_nodeids := (\n                with attribute_nodes as (\n                    select * from jsonb_to_recordset(new.attributenodes) as x(nodeid uuid, description text)\n                )\n                select count(*) from attribute_nodes att join nodes n1 on att.nodeid = n1.nodeid\n                ) > 0;\n\n            if valid_att_nodeids is false then\n                raise exception 'attributenodes contains an invalid nodeid';\n            end if;\n        end if;\n    else\n        raise exception 'attributenodes needs to be an array';\n    end if;\nend if;\n\n\nif tg_op = 'DELETE' then\n    sv_perform := sv_perform || format(\n        'select __arches_delete_spatial_view(%L,%L);'\n        , old.slug\n        , old.schema);\n\n    if sv_perform <> '' then\n        execute sv_perform;\n    end if;\n\n    return old;\n\nelsif tg_op = 'INSERT' then\n    if new.isactive = true then\n        sv_perform := sv_perform || format(\n            'select __arches_create_spatial_view(%L, %L::uuid, %L::jsonb, %L, %L, %L, %L);'\n            , new.slug\n            , new.geometrynodeid\n            , new.attributenodes\n            , new.schema\n            , new.description\n            , new.ismixedgeometrytypes\n            , new.languageid);\n    end if;\n\n    if sv_perform <> '' then\n        execute sv_perform;\n    end if;\n\n    return new;\n\nelsif tg_op = 'UPDATE' then\n\n    if new.isactive = true then\n        sv_perform := sv_perform || format(\n            'select __arches_update_spatial_view(%L, %L, %L, %L::uuid, %L::jsonb, %L, %L, %L);'\n            , old.slug\n            , old.schema\n            , new.slug\n            , new.geometrynodeid\n            , new.attributenodes\n            , new.schema\n            , new.description\n            , new.ismixedgeometrytypes\n            , new.languageid);\n    else\n        sv_perform := sv_perform || format(\n            'select __arches_delete_spatial_view(%L,%L);'\n            , old.slug\n            , old.schema);\n    end if;\n\n    if sv_perform <> '' then\n        execute sv_perform;\n    end if;\n\n    return new;\nend if;\n",
                    hash="eada8219b2403623e7dc5ba97f56ad2af4e66ef8",
                    operation="UPDATE OR DELETE OR INSERT",
                    pgid="pgtrigger_arches_update_spatial_views_ebfdd",
                    table="spatial_views",
                    timing="DEFERRABLE INITIALLY DEFERRED",
                    when="AFTER",
                ),
            ),
        ),
    ]
