# Generated by Django 5.2.5 on 2025-08-11 07:44

import django_migrate_sql.operations
from django.db import migrations


class Migration(migrations.Migration):

    dependencies = [
        ("models", "12009_language_single_default_language"),
    ]

    operations = [
        migrations.operations.special.SeparateDatabaseAndState(
            state_operations=[
                django_migrate_sql.operations.CreateSQL(
                    name="__arches_instance_view_update",
                    sql="\nCREATE OR REPLACE FUNCTION public.__arches_instance_view_update()\n RETURNS trigger\n LANGUAGE plpgsql\nAS $function$\n                declare\n                    view_namespace text;\n                    model_id uuid;\n                    instance_id uuid;\n                    transaction_id uuid;\n                    edit_type text;\n                begin\n                    view_namespace = format('%s.%s', tg_table_schema, tg_table_name);\n                    select obj_description(view_namespace::regclass, 'pg_class') into model_id;\n                    if (TG_OP = 'DELETE') then\n                        delete from public.resource_instances where resourceinstanceid = old.resourceinstanceid;\n                        insert into bulk_index_queue (resourceinstanceid, createddate)\n                            values (old.resourceinstanceid, current_timestamp) on conflict do nothing;\n                        insert into edit_log (\n                            resourceclassid,\n                            resourceinstanceid,\n                            edittype,\n                            timestamp,\n                            note,\n                            transactionid\n                        ) values (\n                            model_id,\n                            old.resourceinstanceid,\n                            'delete',\n                            now(),\n                            'loaded via SQL backend',\n                            public.uuid_generate_v1mc()\n                        );\n                        return old;\n                    else\n                        instance_id = new.resourceinstanceid;\n                        if instance_id is null then\n                            instance_id = public.uuid_generate_v1mc();\n                        end if;\n\n                        if (new.transactionid is null) then\n                            transaction_id = public.uuid_generate_v1mc();\n                        else\n                            transaction_id = new.transactionid;\n                        end if;\n\n                        if (TG_OP = 'UPDATE') then\n                            edit_type = 'edit';\n                            if (transaction_id = old.transactionid) then\n                                transaction_id = public.uuid_generate_v1mc();\n                            end if;\n                            update public.resource_instances\n                            set createdtime = new.createdtime,\n                                legacyid = new.legacyid\n                            where resourceinstanceid = instance_id;\n                        elsif (TG_OP = 'INSERT') then\n                            edit_type = 'create';\n                            insert into public.resource_instances(\n                                resourceinstanceid,\n                                graphid,\n                                legacyid,\n                                createdtime\n                            ) values (\n                                instance_id,\n                                model_id,\n                                new.legacyid,\n                                now()\n                            );\n                        end if;\n                        insert into bulk_index_queue (resourceinstanceid, createddate)\n                            values (instance_id, current_timestamp) on conflict do nothing;\n                        insert into edit_log (\n                            resourceclassid,\n                            resourceinstanceid,\n                            edittype,\n                            timestamp,\n                            note,\n                            transactionid\n                        ) values (\n                            model_id,\n                            instance_id,\n                            edit_type,\n                            now(),\n                            'loaded via SQL backend',\n                            transaction_id\n                        );\n                        return new;\n                    end if;\n                end;\n            $function$\n",
                    reverse_sql="drop function __arches_instance_view_update;",
                ),
            ],
        ),
        django_migrate_sql.operations.AlterSQL(
            name="__arches_instance_view_update",
            sql="\ncreate or replace function __arches_instance_view_update() returns trigger as\n$$\ndeclare\n    view_namespace                       text;\n    model_id                             uuid;\n    instance_id                          uuid;\n    transaction_id                       uuid;\n    resource_instance_lifecycle_state_id uuid;\n    edit_type                            text;\nbegin\n    view_namespace = format('%s.%s', tg_table_schema, tg_table_name);\n    select obj_description(view_namespace::regclass, 'pg_class') into model_id;\n    if (TG_OP = 'DELETE') then\n        delete from public.resource_instances where resourceinstanceid = old.resourceinstanceid;\n        insert into bulk_index_queue (resourceinstanceid, createddate)\n        values (old.resourceinstanceid, current_timestamp)\n        on conflict do nothing;\n        insert into edit_log (resourceclassid,\n                              resourceinstanceid,\n                              edittype,\n                              timestamp,\n                              note,\n                              transactionid)\n        values (model_id,\n                old.resourceinstanceid,\n                'delete',\n                now(),\n                'loaded via SQL backend',\n                public.uuid_generate_v1mc());\n        return old;\n    else\n        instance_id = new.resourceinstanceid;\n        resource_instance_lifecycle_state_id = new.resource_instance_lifecycle_state_id;\n        if instance_id is null then\n            instance_id = public.uuid_generate_v1mc();\n        end if;\n\n        if (new.transactionid is null) then\n            transaction_id = public.uuid_generate_v1mc();\n        else\n            transaction_id = new.transactionid;\n        end if;\n\n        if (TG_OP = 'UPDATE') then\n            edit_type = 'edit';\n            if (transaction_id = old.transactionid) then\n                transaction_id = public.uuid_generate_v1mc();\n            end if;\n            update public.resource_instances\n            set createdtime                          = new.createdtime,\n                legacyid                             = new.legacyid,\n                resource_instance_lifecycle_state_id = new.resource_instance_lifecycle_state_id\n            where resourceinstanceid = instance_id;\n        elsif (TG_OP = 'INSERT') then\n            edit_type = 'create';\n            insert into public.resource_instances(resourceinstanceid,\n                                                  graphid,\n                                                  legacyid,\n                                                  createdtime,\n                                                  resource_instance_lifecycle_state_id)\n            values (instance_id,\n                    model_id,\n                    new.legacyid,\n                    now(),\n                    resource_instance_lifecycle_state_id);\n        end if;\n        insert into bulk_index_queue (resourceinstanceid, createddate)\n        values (instance_id, current_timestamp)\n        on conflict do nothing;\n        insert into edit_log (resourceclassid,\n                              resourceinstanceid,\n                              edittype,\n                              timestamp,\n                              note,\n                              transactionid)\n        values (model_id,\n                instance_id,\n                edit_type,\n                now(),\n                'loaded via SQL backend',\n                transaction_id);\n        return new;\n    end if;\nend;\n$$ language plpgsql;\n",
            reverse_sql="\nCREATE OR REPLACE FUNCTION public.__arches_instance_view_update()\n RETURNS trigger\n LANGUAGE plpgsql\nAS $function$\n                declare\n                    view_namespace text;\n                    model_id uuid;\n                    instance_id uuid;\n                    transaction_id uuid;\n                    edit_type text;\n                begin\n                    view_namespace = format('%s.%s', tg_table_schema, tg_table_name);\n                    select obj_description(view_namespace::regclass, 'pg_class') into model_id;\n                    if (TG_OP = 'DELETE') then\n                        delete from public.resource_instances where resourceinstanceid = old.resourceinstanceid;\n                        insert into bulk_index_queue (resourceinstanceid, createddate)\n                            values (old.resourceinstanceid, current_timestamp) on conflict do nothing;\n                        insert into edit_log (\n                            resourceclassid,\n                            resourceinstanceid,\n                            edittype,\n                            timestamp,\n                            note,\n                            transactionid\n                        ) values (\n                            model_id,\n                            old.resourceinstanceid,\n                            'delete',\n                            now(),\n                            'loaded via SQL backend',\n                            public.uuid_generate_v1mc()\n                        );\n                        return old;\n                    else\n                        instance_id = new.resourceinstanceid;\n                        if instance_id is null then\n                            instance_id = public.uuid_generate_v1mc();\n                        end if;\n\n                        if (new.transactionid is null) then\n                            transaction_id = public.uuid_generate_v1mc();\n                        else\n                            transaction_id = new.transactionid;\n                        end if;\n\n                        if (TG_OP = 'UPDATE') then\n                            edit_type = 'edit';\n                            if (transaction_id = old.transactionid) then\n                                transaction_id = public.uuid_generate_v1mc();\n                            end if;\n                            update public.resource_instances\n                            set createdtime = new.createdtime,\n                                legacyid = new.legacyid\n                            where resourceinstanceid = instance_id;\n                        elsif (TG_OP = 'INSERT') then\n                            edit_type = 'create';\n                            insert into public.resource_instances(\n                                resourceinstanceid,\n                                graphid,\n                                legacyid,\n                                createdtime\n                            ) values (\n                                instance_id,\n                                model_id,\n                                new.legacyid,\n                                now()\n                            );\n                        end if;\n                        insert into bulk_index_queue (resourceinstanceid, createddate)\n                            values (instance_id, current_timestamp) on conflict do nothing;\n                        insert into edit_log (\n                            resourceclassid,\n                            resourceinstanceid,\n                            edittype,\n                            timestamp,\n                            note,\n                            transactionid\n                        ) values (\n                            model_id,\n                            instance_id,\n                            edit_type,\n                            now(),\n                            'loaded via SQL backend',\n                            transaction_id\n                        );\n                        return new;\n                    end if;\n                end;\n            $function$\n",
            state_reverse_sql="drop function __arches_instance_view_update;",
        ),
    ]
