# Generated by Django 5.2.5 on 2025-08-09 22:47

import django_migrate_sql.operations
from django.db import migrations


class Migration(migrations.Migration):

    dependencies = [
        ("models", "12336_add_lifecycle_to_relational_view_logic"),
    ]

    operations = [
        django_migrate_sql.operations.CreateSQL(
            name="__arches_load_staging_get_tile_errors",
            sql="\n    CREATE OR REPLACE FUNCTION public.__arches_load_staging_get_tile_errors(json_obj jsonb)\n    RETURNS text\n    LANGUAGE plpgsql AS\n\n    $$\n    DECLARE\n        _key   text;\n        _value jsonb;\n        _result text;\n        _note text;\n\n    BEGIN\n        FOR _key, _value IN\n            SELECT * FROM jsonb_each_text($1)\n        LOOP\n            IF _value ->> 'valid' = 'false' THEN\n                IF _value ->> 'notes' IS NULL THEN\n                    _note = 'unspecified error';\n                END IF;\n                -- we could add the nodeid (_key), but let's not be verbose just yet\n                IF _result IS NULL THEN\n                _result := _value ->> 'notes';\n                ELSE\n                _result := '|' || (_value ->> 'notes');\n                END IF;\n            END IF;\n        END LOOP;\n        RETURN _result;\n    END;\n    $$;\n",
            reverse_sql=migrations.RunSQL.noop,
        ),
    ]
