# Generated by Django 5.2.5 on 2025-08-14 23:05

import django_migrate_sql.operations
from django.db import migrations


class Migration(migrations.Migration):

    dependencies = [
        ("models", "12337_fix_bulk_tile_errors"),
    ]

    operations = [
        migrations.operations.special.SeparateDatabaseAndState(
            state_operations=[
                django_migrate_sql.operations.CreateSQL(
                    name="__arches_get_json_data_for_view",
                    sql="\ncreate or replace function __arches_get_json_data_for_view(\n    view_row anyelement,\n    schema_name text,\n    view_name text\n) returns json as\n$$\ndeclare\n    column_info    record;\n    query          text;\n    result         jsonb;\n    geom           geometry;\n    geometry_type  text;\n    geometry_query text;\n    node           public.nodes;\n    tiledata       jsonb = '{}'::jsonb;\nbegin\n    for column_info in select a.attname as column_name,\n                              d.description\n                       from pg_class as c\n                                inner join pg_attribute as a on c.oid = a.attrelid\n                                left join pg_namespace n on n.oid = c.relnamespace\n                                left join pg_tablespace t on t.oid = c.reltablespace\n                                left join pg_description as d on (\n                           d.objoid = c.oid\n                               and d.objsubid = a.attnum\n                           )\n                       where c.relkind in ('r', 'v')\n                         and n.nspname = schema_name\n                         and c.relname = view_name\n                         and d.description is not null\n                         and d.description != 'parenttileid'\n        loop\n            select n.*\n            into node\n            from nodes n\n            where n.nodeid = column_info.description::uuid;\n            if node.datatype = 'geojson-feature-collection' then\n                query = format(\n                    'select st_geometrytype(\n                        ($1::text::%s.%s).%s\n                    )',\n                    schema_name,\n                    view_name,\n                    column_info.column_name\n                        );\n                execute query into geometry_type using view_row;\n                if geometry_type is null then\n                    query = E'select json_build_object(\n                                \\'type\\',\n                                \\'FeatureCollection\\',\n                                \\'features\\',\n                                json_build_array()\n                            )';\n                else\n                    if geometry_type = 'ST_GeometryCollection' or geometry_type like 'ST_Multi%' then\n                        geometry_query = E'from (\n                                    select st_asgeojson(\n                                        st_dump(\n                                            ($1::text::%s. %s).%s\n                                        )\n                                    )::json->\\'geometry\\' as geom\n                                ) as g';\n                    else\n                        geometry_query = 'from (\n                                    select st_asgeojson(\n                                        ($1::text::%s. %s).%s\n                                    ) as geom\n                                ) as g';\n                    end if;\n                    query = format(\n                        E'select json_build_object(\n                                \\'type\\',\n                                \\'FeatureCollection\\',\n                                \\'features\\',\n                                json_agg(\n                                    json_build_object(\n                                        \\'type\\',\n                                        \\'Feature\\',\n                                        \\'geometry\\',\n                                        g.geom::json,\n                                        \\'properties\\',\n                                        json_build_object()\n                                    )\n                                )\n                            )' || geometry_query,\n                        schema_name,\n                        view_name,\n                        column_info.column_name\n                            );\n                end if;\n            elsif node.datatype = 'date' then\n                query = format(\n                    'select to_json(\n                        to_char(\n                            ($1::text::%s.%s).%s,\n                            %L\n                        )\n                    )',\n                    schema_name,\n                    view_name,\n                    column_info.column_name,\n                    node.config ->> 'dateFormat'\n                        );\n            else\n                query = format(\n                    'select to_json(\n                        ($1::text::%s.%s).%s\n                    )',\n                    schema_name,\n                    view_name,\n                    column_info.column_name\n                        );\n            end if;\n            execute query into result using view_row;\n            if node.datatype in ('resource-instance-list', 'resource-instance') then\n                select jsonb_agg(\n                           case\n                               when e ->> 'resourceXresourceId' = '' then jsonb_set(\n                                   e,\n                                   '{resourceXresourceId}',\n                                   to_jsonb(public.uuid_generate_v1mc())\n                                                                          )\n                               else e\n                               end\n                       )\n                into result\n                from jsonb_array_elements(result) e(e);\n            end if;\n            tiledata = tiledata || jsonb_build_object(column_info.description, result);\n        end loop;\n\n    return tiledata::json;\nend\n$$ language plpgsql volatile;\n",
                    reverse_sql="drop function __arches_get_json_data_for_view;",
                ),
            ]
        ),
        django_migrate_sql.operations.AlterSQL(
            name="__arches_get_json_data_for_view",
            sql="\ncreate or replace function __arches_get_json_data_for_view(\n    view_row anyelement,\n    schema_name text,\n    view_name text\n) returns json as\n$$\ndeclare\n    column_info    record;\n    query          text;\n    result         jsonb;\n    geometry_type  text;\n    geometry_query text;\n    node           public.nodes;\n    tiledata       jsonb = '{}'::jsonb;\nbegin\n    for column_info in select a.attname as column_name,\n                              d.description\n                       from pg_class as c\n                                inner join pg_attribute as a on c.oid = a.attrelid\n                                left join pg_namespace n on n.oid = c.relnamespace\n                                left join pg_tablespace t on t.oid = c.reltablespace\n                                left join pg_description as d on (\n                           d.objoid = c.oid\n                               and d.objsubid = a.attnum\n                           )\n                       where c.relkind in ('r', 'v')\n                         and n.nspname = schema_name\n                         and c.relname = view_name\n                         and d.description is not null\n                         and d.description != 'parenttileid'\n        loop\n            select n.*\n            into node\n            from nodes n\n            where n.nodeid = column_info.description::uuid;\n            if node.datatype = 'geojson-feature-collection' then\n                query = format(\n                    'select st_geometrytype(\n                        ($1::text::%s.%s).%s\n                    )',\n                    schema_name,\n                    view_name,\n                    column_info.column_name\n                        );\n                execute query into geometry_type using view_row;\n                if geometry_type is null then\n                    query = E'select json_build_object(\n                                \\'type\\',\n                                \\'FeatureCollection\\',\n                                \\'features\\',\n                                json_build_array()\n                            )';\n                else\n                    if geometry_type = 'ST_GeometryCollection' or geometry_type like 'ST_Multi%' then\n                        geometry_query = E'from (\n                                    select st_asgeojson(\n                                        st_dump(\n                                            ($1::text::%s. %s).%s\n                                        )\n                                    )::json->\\'geometry\\' as geom\n                                ) as g';\n                    else\n                        geometry_query = 'from (\n                                    select st_asgeojson(\n                                        ($1::text::%s. %s).%s\n                                    ) as geom\n                                ) as g';\n                    end if;\n                    query = format(\n                        E'select json_build_object(\n                                \\'type\\',\n                                \\'FeatureCollection\\',\n                                \\'features\\',\n                                json_agg(\n                                    json_build_object(\n                                        \\'id\\',\n                                        uuid_generate_v4(),\n                                        \\'type\\',\n                                        \\'Feature\\',\n                                        \\'geometry\\',\n                                        g.geom::json,\n                                        \\'properties\\',\n                                        json_build_object()\n                                    )\n                                )\n                            )' || geometry_query,\n                        schema_name,\n                        view_name,\n                        column_info.column_name\n                            );\n                end if;\n            elsif node.datatype = 'date' then\n                query = format(\n                    'select to_json(\n                        to_char(\n                            ($1::text::%s.%s).%s,\n                            %L\n                        )\n                    )',\n                    schema_name,\n                    view_name,\n                    column_info.column_name,\n                    node.config ->> 'dateFormat'\n                        );\n            else\n                query = format(\n                    'select to_json(\n                        ($1::text::%s.%s).%s\n                    )',\n                    schema_name,\n                    view_name,\n                    column_info.column_name\n                        );\n            end if;\n            execute query into result using view_row;\n            if node.datatype in ('resource-instance-list', 'resource-instance') then\n                select jsonb_agg(\n                           case\n                               when e ->> 'resourceXresourceId' = '' then jsonb_set(\n                                   e,\n                                   '{resourceXresourceId}',\n                                   to_jsonb(public.uuid_generate_v1mc())\n                                                                          )\n                               else e\n                               end\n                       )\n                into result\n                from jsonb_array_elements(result) e(e);\n            end if;\n            tiledata = tiledata || jsonb_build_object(column_info.description, result);\n        end loop;\n\n    return tiledata::json;\nend\n$$ language plpgsql volatile;\n",
            reverse_sql="\ncreate or replace function __arches_get_json_data_for_view(\n    view_row anyelement,\n    schema_name text,\n    view_name text\n) returns json as\n$$\ndeclare\n    column_info    record;\n    query          text;\n    result         jsonb;\n    geom           geometry;\n    geometry_type  text;\n    geometry_query text;\n    node           public.nodes;\n    tiledata       jsonb = '{}'::jsonb;\nbegin\n    for column_info in select a.attname as column_name,\n                              d.description\n                       from pg_class as c\n                                inner join pg_attribute as a on c.oid = a.attrelid\n                                left join pg_namespace n on n.oid = c.relnamespace\n                                left join pg_tablespace t on t.oid = c.reltablespace\n                                left join pg_description as d on (\n                           d.objoid = c.oid\n                               and d.objsubid = a.attnum\n                           )\n                       where c.relkind in ('r', 'v')\n                         and n.nspname = schema_name\n                         and c.relname = view_name\n                         and d.description is not null\n                         and d.description != 'parenttileid'\n        loop\n            select n.*\n            into node\n            from nodes n\n            where n.nodeid = column_info.description::uuid;\n            if node.datatype = 'geojson-feature-collection' then\n                query = format(\n                    'select st_geometrytype(\n                        ($1::text::%s.%s).%s\n                    )',\n                    schema_name,\n                    view_name,\n                    column_info.column_name\n                        );\n                execute query into geometry_type using view_row;\n                if geometry_type is null then\n                    query = E'select json_build_object(\n                                \\'type\\',\n                                \\'FeatureCollection\\',\n                                \\'features\\',\n                                json_build_array()\n                            )';\n                else\n                    if geometry_type = 'ST_GeometryCollection' or geometry_type like 'ST_Multi%' then\n                        geometry_query = E'from (\n                                    select st_asgeojson(\n                                        st_dump(\n                                            ($1::text::%s. %s).%s\n                                        )\n                                    )::json->\\'geometry\\' as geom\n                                ) as g';\n                    else\n                        geometry_query = 'from (\n                                    select st_asgeojson(\n                                        ($1::text::%s. %s).%s\n                                    ) as geom\n                                ) as g';\n                    end if;\n                    query = format(\n                        E'select json_build_object(\n                                \\'type\\',\n                                \\'FeatureCollection\\',\n                                \\'features\\',\n                                json_agg(\n                                    json_build_object(\n                                        \\'type\\',\n                                        \\'Feature\\',\n                                        \\'geometry\\',\n                                        g.geom::json,\n                                        \\'properties\\',\n                                        json_build_object()\n                                    )\n                                )\n                            )' || geometry_query,\n                        schema_name,\n                        view_name,\n                        column_info.column_name\n                            );\n                end if;\n            elsif node.datatype = 'date' then\n                query = format(\n                    'select to_json(\n                        to_char(\n                            ($1::text::%s.%s).%s,\n                            %L\n                        )\n                    )',\n                    schema_name,\n                    view_name,\n                    column_info.column_name,\n                    node.config ->> 'dateFormat'\n                        );\n            else\n                query = format(\n                    'select to_json(\n                        ($1::text::%s.%s).%s\n                    )',\n                    schema_name,\n                    view_name,\n                    column_info.column_name\n                        );\n            end if;\n            execute query into result using view_row;\n            if node.datatype in ('resource-instance-list', 'resource-instance') then\n                select jsonb_agg(\n                           case\n                               when e ->> 'resourceXresourceId' = '' then jsonb_set(\n                                   e,\n                                   '{resourceXresourceId}',\n                                   to_jsonb(public.uuid_generate_v1mc())\n                                                                          )\n                               else e\n                               end\n                       )\n                into result\n                from jsonb_array_elements(result) e(e);\n            end if;\n            tiledata = tiledata || jsonb_build_object(column_info.description, result);\n        end loop;\n\n    return tiledata::json;\nend\n$$ language plpgsql volatile;\n",
            state_reverse_sql="drop function __arches_get_json_data_for_view;",
        ),
    ]
