# -*- coding: utf-8 -*-
# Generated by Django 1.11.10 on 2018-11-01 05:30


from django.db import migrations, models
from datetime import datetime
from arches.app.models.system_settings import settings
import pytz


class Migration(migrations.Migration):

    dependencies = [
        ("models", "4264_online_msm_basemap"),
    ]

    def forwards_func(apps, schema_editor):
        local = pytz.timezone(settings.TIME_ZONE)
        utc = pytz.utc
        local_date_format = "%Y-%m-%d %H:%M:%S.%f"
        utc_date_format = "%Y-%m-%dT%H:%M:%S.%fZ"
        TileModel = apps.get_model("models", "TileModel")
        tiles_w_provisional_edits = TileModel.objects.filter(
            provisionaledits__isnull=False
        )
        for tile in tiles_w_provisional_edits:
            for k, v in iter(list(tile.provisionaledits.items())):
                naive_timestamp = datetime.strptime(v["timestamp"], local_date_format)
                local_datetime = local.localize(naive_timestamp)
                utc_datetime = local_datetime.astimezone(utc)
                v["timestamp"] = utc_datetime.strftime(utc_date_format)
            tile.save()

    def reverse_func(apps, schema_editor):
        local = pytz.timezone(settings.TIME_ZONE)
        utc = pytz.utc
        local_date_format = "%Y-%m-%d %H:%M:%S.%f"
        utc_date_format = "%Y-%m-%dT%H:%M:%S.%fZ"
        TileModel = apps.get_model("models", "TileModel")
        tiles_w_provisional_edits = TileModel.objects.filter(
            provisionaledits__isnull=False
        )
        for tile in tiles_w_provisional_edits:
            for k, v in iter(list(tile.provisionaledits.items())):
                naive_timestamp = datetime.strptime(v["timestamp"], utc_date_format)
                utc_datetime = utc.localize(naive_timestamp)
                local_datetime = utc_datetime.astimezone(local)
                v["timestamp"] = local_datetime.strftime(local_date_format)
            tile.save()

    operations = [
        migrations.RunPython(forwards_func, reverse_func),
    ]
