# Generated by Django 3.2.18 on 2023-05-17 16:33

import arches.app.models.fields.i18n
import datetime
from django.conf import settings
from django.db import migrations, models, connection
import django.db.models.deletion
import re
import uuid


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("models", "9511_update_tile_nodegroup_reference"),
    ]

    def delete_draft_graphs(apps, schema_editor):
        with connection.cursor() as cursor:
            cursor.execute("ALTER TABLE graphs DISABLE TRIGGER ALL;")

            cursor.execute("DELETE FROM graphs WHERE source_identifier IS NOT NULL;")
            cursor.execute("DELETE FROM nodes WHERE source_identifier IS NOT NULL;")
            cursor.execute("DELETE FROM edges WHERE source_identifier IS NOT NULL;")
            cursor.execute("DELETE FROM cards WHERE source_identifier IS NOT NULL;")
            cursor.execute(
                "DELETE FROM cards_x_nodes_x_widgets WHERE source_identifier IS NOT NULL;"
            )
            cursor.execute(
                """
                DELETE FROM node_groups
                WHERE NOT EXISTS (
                    SELECT 1
                    FROM nodes
                    WHERE nodes.nodegroupid = node_groups.nodegroupid
                );
            """
            )

            cursor.execute("ALTER TABLE graphs ENABLE TRIGGER ALL;")

    def create_draft_graphs(apps, schema_editor):
        # the `create_draft_graph` function is not available when importing `Graph` via `apps.get_model()`
        pass

    operations = [
        migrations.CreateModel(
            name="PublishedGraphEdit",
            fields=[
                (
                    "edit_id",
                    models.UUIDField(
                        default=uuid.uuid1, primary_key=True, serialize=False
                    ),
                ),
                ("edit_time", models.DateTimeField(default=datetime.datetime.now)),
                ("notes", models.TextField(blank=True, null=True)),
            ],
            options={
                "db_table": "published_graph_edits",
                "managed": True,
            },
        ),
        migrations.AlterField(
            model_name="graphxpublishedgraph",
            name="user",
            field=models.ForeignKey(
                db_column="userid",
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="publishedgraphedit",
            name="publication",
            field=models.ForeignKey(
                db_column="publicationid",
                on_delete=django.db.models.deletion.CASCADE,
                to="models.graphxpublishedgraph",
            ),
        ),
        migrations.AddField(
            model_name="publishedgraphedit",
            name="user",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="graphxpublishedgraph",
            name="most_recent_edit",
            field=models.ForeignKey(
                blank=True,
                db_column="edit_id",
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                to="models.publishedgraphedit",
            ),
        ),
        migrations.AlterField(
            model_name="graphmodel",
            name="slug",
            field=models.TextField(
                null=True,
                validators=[
                    django.core.validators.RegexValidator(
                        re.compile("^[-a-zA-Z0-9_]+\\Z"),
                        "Enter a valid “slug” consisting of letters, numbers, underscores or hyphens.",
                        "invalid",
                    )
                ],
            ),
        ),
        migrations.RunPython(create_draft_graphs, delete_draft_graphs),
    ]
