<!--
SPDX-FileCopyrightText: PyPSA Contributors

SPDX-License-Identifier: CC-BY-4.0
-->

# Users

The following universities, research institutes, companies, governmental and non-governmental organisations are known to have either used PyPSA in the past, or to continue to use PyPSA. This list is necessarily incomplete, since we cannot track who uses PyPSA and we only find out who our users are when they contact the main developers of PyPSA.

!!! note "Research Publications"

    Research publications that cite the [PyPSA research paper](https://doi.org/10.5334/jors.188) can be found on [:fontawesome-brands-google-scholar: Google Scholar](https://scholar.google.com/scholar?oi=bibs&hl=en&cites=11241966939032736670&as_sdt=5).

!!! note "User Meetings on YouTube"

    The PyPSA user meeting recordings on [:material-youtube: YouTube](https://www.youtube.com/@pypsa-official) give further insight into applications in the energy sector.

## Universities

- **[:flag_de: Technische Universität Berlin (TUB)](https://www.ensys.tu-berlin.de/)**, where PyPSA development continues since 2021, published multiple research papers, for example:
[doi:10.1038/s41467-025-60652-1](https://doi.org/10.1038/s41467-025-60652-1), [doi:10.1016/j.eneco.2025.108483](https://doi.org/10.1016/j.eneco.2025.108483), [doi:10.1038/s41560-025-01752-6](https://doi.org/10.1038/s41560-025-01752-6), [doi:10.1038/s41597-025-04550-7](https://doi.org/10.1038/s41597-025-04550-7), [doi:10.1016/j.adapen.2024.100202](https://doi.org/10.1016/j.adapen.2024.100202), [doi:10.1088/1748-9326/ad2239](https://doi.org/10.1088/1748-9326/ad2239), [doi:10.1016/j.joule.2023.10.001](https://doi.org/10.1016/j.joule.2023.10.001), [doi:10.1016/j.joule.2023.06.016](https://doi.org/10.1016/j.joule.2023.06.016).

- **[:flag_de: Karlsruhe Institute of Technology (KIT)](https://www.kit.edu/)**, where PyPSA development took place between 2018 and 2021, published multiple research papers, for example: [doi:10.1016/j.energy.2018.06.222](https://doi.org/10.1016/j.energy.2018.06.222), [doi:10.1109/EEM.2019.8916411](https://www.doi.org/10.1109/EEM.2019.8916411), [doi:10.1016/j.esr.2018.08.012](https://doi.org/10.1016/j.esr.2018.08.012), [doi:10.1016/j.epsr.2020.106690](https://doi.org/10.1016/j.epsr.2020.106690), [doi:10.1145/3396851.3397688](https://doi.org/10.1145/3396851.3397688), [doi:10.1016/j.apenergy.2021.116726](https://doi.org/10.1016/j.apenergy.2021.116726), [doi:10.1186/s42162-022-00187-7](https://doi.org/10.1186/s42162-022-00187-7)

- **[:flag_dk: Aarhus University](https://www.au.dk/)** in Denmark published multiple research papers, for example: [doi:10.1016/j.apenergy.2019.02.009](https://doi.org/10.1016/j.apenergy.2019.02.009), [doi:10.1016/j.apenergy.2018.12.016](https://doi.org/10.1016/j.apenergy.2018.12.016), [doi:10.1002/pip.3198](https://doi.org/10.1002/pip.3198), [doi:10.1016/j.enconman.2019.111977](https://doi.org/10.1016/j.enconman.2019.111977), [doi:10.1038/s41467-020-20015-4](https://doi.org/10.1038/s41467-020-20015-4), [doi:10.1016/j.joule.2022.04.016](https://doi.org/10.1016/j.joule.2022.04.016)

- **[:flag_dk: Technical University of Denmark (DTU)](https://www.dtu.dk/)** in Denmark published multiple research papers, for example: [doi:10.1038/s41467-025-61492-9](https://doi.org/10.1038/s41467-025-61492-9) and [doi:10.1088/1748-9326/adc290](https://doi.org/10.1088/1748-9326/adc290).

- **[:flag_de: Frankfurt Institute of Advanced Studies (FIAS)](https://fias.science/)** (where PyPSA was initially developed) published multiple research papers, for example: [doi:10.1016/j.energy.2017.06.004](https://doi.org/10.1016/j.energy.2017.06.004), [doi:10.1109/EEM.2017.7982024](https://doi.org/10.1109/EEM.2017.7982024), [doi:10.1016/j.energy.2018.08.070](https://doi.org/10.1016/j.energy.2018.08.070), [doi:10.1016/j.apenergy.2018.09.084](https://doi.org/10.1016/j.apenergy.2018.09.084), [doi:10.1016/j.epsr.2017.12.034](https://doi.org/10.1016/j.epsr.2017.12.034)

- **[:flag_us: Stanford University](https://www.stanford.edu/)** in the United States published a research paper on PyPSA-USA: [doi:10.2139/ssrn.5029120](https://dx.doi.org/10.2139/ssrn.5029120)

- **[:flag_nl: TU Delft](https://www.tudelft.nl/)** in the Netherlands published multiple research papers: [doi:10.1016/j.eneco.2018.04.037](https://doi.org/10.1016/j.eneco.2018.04.037), [doi:10.1016/j.energy.2017.02.111](https://doi.org/10.1016/j.energy.2017.02.111)

- **[:flag_se: Chalmers University](https://www.chalmers.se/)** in Sweden published multiple research papers, for example: [doi.org:10.1016/j.apenergy.2022.120016](https://doi.org/10.1016/j.apenergy.2022.120016)

- **[:flag_no: UiT The Arctic University of Norway (UiT)](https://uit.no/)** and the **[:flag_no: University of Oslo (UiO)](https://www.uio.no/)** in Norway used PyPSA for studying near-optimal spaces in renewable electricity system planning: [doi.org:10.1016/j.eneco.2022.106496](https://doi.org/10.1016/j.eneco.2022.106496).

- **[:flag_jp: Kyoto University](https://www.kyoto-u.ac.jp/en)** in Japan uses PyPSA to model several high PV penetration scenarios in Kyushu, where PV capacity has been rapidly growing since 2012 and PV curtailment started in 2018: [doi:10.3390/en14092389](https://doi.org/10.3390/en14092389), [doi:10.3390/en14154496](https://doi.org/10.3390/en14154496)

- **[:flag_it: University of Pisa](https://www.unipi.it/index.php/english/)** uses PyPSA as part of the [PyPSA-meets-Earth initiative](https://pypsa-meets-earth.github.io/) in [doi:10.1016/j.apenergy.2023.121096](https://doi.org/10.1016/j.apenergy.2023.121096)

- **[:flag_ch: University of Geneva](https://www.unige.ch/)** in Switzerland published multiple research papers, for example: [doi:10.1038/s41467-020-18812-y](https://doi.org/10.1038/s41467-020-18812-y)

- **[:flag_gb: University of Oxford](https://www.ox.ac.uk/)** in a [study on green ammonia imports](https://iopscience.iop.org/article/10.1088/2753-3751/ad785d) as a supplement to long-duration energy storage in the UK and with the **[:flag_es: University of Sevilla](https://www.us.es/)** in a [study on the role of regionally resolved heat pump demand](https://doi.org/10.1016/j.apenergy.2023.122331) in power system design.

- **[:flag_de: Energiewirtschaftliches Institut zu Köln (EWI)](https://www.ewi.uni-koeln.de/de/)** pubished a working paper using PyPSA: [Working Paper, No 17/09](https://www.ewi.research-scenarios.de/cms/wp-content/uploads/2017/09/EWI_WP_17-09_Build_Wind_Capacities_at_Windy_Locations.pdf)

- **[:flag_de: University of Flensburg](https://www.znes-flensburg.de/)** in Flensburg, Germany as part of the [open-Ego](https://github.com/openego) project with multiple publications: [doi:10.3390/en12112091](https://doi.org/10.3390/en12112091), [doi:10.1088/1742-6596/977/1/012007](https://doi.org/10.1088/1742-6596/977/1/012007), [doi:10.1016/j.apenergy.2021.116936](https://doi.org/10.1016/j.apenergy.2021.116936)

- **[:flag_co: EIA University](https://www.eia.edu.co/)** in Medellin (Columbia) uses PyPSA for modelling the Columbian power system in a joint research project with South American transmission company [ISA](http://www.isa.co/)

- **[:flag_ie: Dublin City University](https://dcu.ie/)** and the **[:flag_ie: SFI Insight Centre for Data Analytics](https://www.insight-centre.org/)**: use PyPSA for the [OESM project](https://sites.google.com/a/dcu.ie/dcuecrn/projects/oesm-ie) modelling the Irish energy system.

- **[:flag_de: University of Freiburg](https://uni-freiburg.de/)** at [INATECH](https://www.inatech.uni-freiburg.de/en)

- **[:flag_de: Hochschule Offenburg](https://www.hs-offenburg.de/)** at [INES](https://www.ines.hs-offenburg.de/)

- **[:flag_de: Ostbayerische Technische Hochschule Regensburg](https://www.oth-regensburg.de/)** at the [Forschungsstelle für Energienetze und Energiespeicher (FENES)](https://www.fenes.net/)

- **[:flag_de: Technische Hochschule Köln](https://www.th-koeln.de/)** used PyPSA for [a study on the role of renewables, storage and sector-coupling flexibilities in Germany at varying carbon-dioxide emission levels](https://doi.org/10.3390/su141610379).

- **[:flag_nz: University of Canterbury](https://www.canterbury.ac.nz/)** at the [Sustainable Energy Research Group (SERG)](https://www.canterbury.ac.nz/research/about-uc-research/research-groups-and-centres/sustainable-energy-research-group) uses PyPSA for energy transition in New Zealand.

- **[:scotland: The University of Edinburgh](https://www.ed.ac.uk/)** introduced PyPSA-GB, an open-source model of Great Britain's power system for simulating future energy scenarios: [doi.org/10.1016/j.esr.2024.101375](https://doi.org/10.1016/j.esr.2024.101375)

- **[:flag_kr: Korea University](https://www.korea.ac.kr/sites/ko/index.do)** at the [Energy Innovation Lab](https://energyinnovation.korea.ac.kr/) uses PyPSA-Earth to support development of the country's long-term energy strategy.

- **[:flag_th: Asian Institute of Technology](https://ait.ac.th/)** in the [South and South-East Asia Multidisciplinary Applied Research Network on Transforming Societies of Global South (SMARTS)](https://ait.ac.th/centre/smartscenter/) and the **[:flag_bd: International University of Business Agriculture and Technology (IUBAT), Dhaka](https://eee.iubat.edu/)** developed an adaptation of PyPSA-Earth, called PyPSA-BD to support the energy transition in Bangladesh [<https://doi.org/10.1016/j.ref.2024.100655>](https://doi.org/10.1016/j.ref.2024.100655)


## Research Institutes

- **[:flag_eu: Joint Research Centre (JRC)](https://joint-research-centre.ec.europa.eu/index_en)** of the [European Commission](https://ec.europa.eu/info/index_en) converted METIS/PRIMES scenarios for the [Fit for 55 package to PyPSA networks](https://zenodo.org/record/7065568#.YygkDKRByMo) in 2022 and used PyPSA for further research: [doi:10.3390/en15124233](https://doi.org/10.3390/en15124233) in 2022. In 2023, JRC used PyPSA for the study ["MODECO – Modelling study on the role of energy communities in the energy transition"](https://publications.jrc.ec.europa.eu/repository/handle/JRC132896) and in 2024 for the study ["Redispatch and Congestion Management"](https://publications.jrc.ec.europa.eu/repository/handle/JRC137685)

* **[:flag_in: The Energy and Resources Institute (TERI)](https://www.teriin.org/)** in New Delhi (India) used PyPSA for several studies. In 2020 for a government-supported study of the Indian power system in 2030, see [Renewable Power Pathways Report](https://www.teriin.org/sites/default/files/2020-07/Renewable-Power-Pathways-Report.pdf), in 2021 for a study on [A Model-Based Assessment of Variable Renewable Grid Integration Costs in India](https://www.teriin.org/sites/default/files/2021-02/A_Modal-Based_Assessment_Report_0.pdf) and in 2024 for a study on [India's Electricity Transition Pathways to 2050: Scenarios and Insights](https://teriin.org/sites/default/files/2024-02/Power_Sector_2050_Report.pdf)

- **[:flag_za: Council for Scientific and Industrial Research (CSIR)](https://www.csir.co.za/)** in South Africa in a research publication [arXiv:1710.11199](https://arxiv.org/abs/1710.11199)

- **[:flag_de: Forschungsstelle für Energiewirtschaft (FfE)](https://www.ffe.de/)** uses PyPSA for their [HyPTraDe](https://www.ffe.de/tools/hyptrade-global-hydrogen-modellkette/) global hydrogen model chain.

- **[:flag_de: Reiner Lemoine Institute (RLI)](https://reiner-lemoine-institut.de/)** in Berlin, Germany within the consortial project [open-Ego](https://github.com/openego) with multiple publications: [doi:10.3390/en12112091](https://doi.org/10.3390/en12112091), [doi:10.1088/1742-6596/977/1/012007](https://doi.org/10.1088/1742-6596/977/1/012007), [doi:10.1016/j.apenergy.2021.116936](https://doi.org/10.1016/j.apenergy.2021.116936)

- **[:flag_de: DLR Institute of Networked Energy Systems](https://www.dlr.de/ve/desktopdefault.aspx/tabid-12472/21440_read-49440/)** in Oldenburg, Germany published a research paper [doi:10.1016/j.apenergy.2020.114523](https://doi.org/10.1016/j.apenergy.2020.114523) and a [dataset publication](https://doi.org/10.1038/s41597-023-01992-9) for the Brazilian power system.

- **[:flag_de: Fraunhofer Institute for Energy Infrastructures and Geothermal Systems (IEG)](https://www.ieg.fraunhofer.de/)**: uses PyPSA-Eur for infrastructure analysis in Europe, e.g. in the [European Hydrogen Infrastructure Planning report](https://www.wasserstoff-leitprojekte.de/lw_resource/datapool/systemfiles/elements/files/148FFEF003673B67E0637E695E8625E5/live/document/20240321_European_Hydrogen_Infrastructure_Planning.pdf) on European hydrogen infrastructure planning.

- **[:flag_de: Fraunhofer Institute for Solar Energy Systems (ISE)](https://www.ise.fraunhofer.de/)**: uses PyPSA for grid modelling, for example in a research paper: [doi:/10.1016/j.epsr.2020.106349](https://doi.org/10.1016/j.epsr.2020.106349)

- **[:flag_de: Fraunhofer-Institut für Energiewirtschaft und Energiesystemtechnik (IEE)](https://www.iee.fraunhofer.de/)** used PyPSA for an investigation of power-to-X in South Africa together with **[:flag_za: Stellenbosch University](http://www.sun.ac.za/english)** in [this project](https://www.iee.fraunhofer.de/en/research_projects/search/2023/ptx-south-africa.html).

- **[:flag_se: RISE Research Institutes of Sweden AB (RISE)](https://www.ri.se/)** for energy systems research in the [RESILIENT project](https://resilient-project.github.io/).

- **[:flag_de: Forschungszentrum Jülich (FZJ)](https://www.fz-juelich.de/)** used PyPSA for network calculations.

## Companies

* **[:flag_de: TransnetBW](https://www.transnetbw.de/)**, the electricity transmission system operator in southwest Germany, **[:flag_de: ONTRAS](https://www.ontras.com/)**, the gas transmission system operator in eastern Germany and **[:flag_de: d-fine](https://www.d-fine.com/)**, a consultancy firm, used PyPSA-Eur-Sec for a study in 2020 of the grid requirements in 2050 with a 90% reduction of carbon dioxide emissions in electricity, buildings and transport, see [Stromnetz 2050](https://www.transnetbw.de/de/stromnetz2050/), for an article in a 2021 issue of Energiewirtschaftliche Tagesfragen [Die Rolle von Wasserstoff in einem klimaneutralen europäischen Energiesystem – eine modellbasierte Analyse bis 2050](https://www.d-fine.com/fileadmin/user_upload/Wasserstoff_et_0102-2021.pdf), and for their 2022 study [Energy System 2050 - Towards a decarbonised Europe](https://www.energysystem2050.net/).

* **[:flag_eu: ENTSO-E (European Network of Transmission System Operators for Electricity)](https://www.entsoe.eu/)** launched a research and innovation project to develop a complementary open-source tool in PyPSA for [Scenario Building and Cost-Benefit Analysis within the TYNDP process](https://www.linkedin.com/posts/entso-e_energytransition-opensource-innovation-activity-7293296246813851649-2ynL).

* **[:flag_at: Austrian Power Grid (APG)](https://www.apg.at/)**, the Austrian TSO, uses PyPSA for its system vision of the Austrian energy system up to 2050, as shown in [this talk](https://www.tugraz.at/fileadmin/user_upload/tugrazExternal/738639ca-39a0-4129-b0f0-38b384c12b57/files/pr/Session_A3/132_PR_Spindler.pdf) and [this project description](https://www.apg.at/projekte/zusammen-2040/).

- **[:flag_at: Austrian Gas Grid Management AG (AGGM)](https://www.aggm.at/)** develops and maintains a high-resolution, sector-coupled energy system model based on PyPSA-DE and PyPSA-EUR. The model is used to analyse long-term energy system projections up to 2050 and serves as a supplementary tool for AGGM’s bi-annual report, the Langfristige Integrierte Planung (LFiP).

- **[:flag_nl: TenneT](https://www.tennet.eu/)**, the Dutch TSO, used PyPSA for [research](https://arxiv.org/abs/2104.13047) on ancillary services acquisition using agent-based modelling.

* **[:flag_za: Meridian Economics](https://meridianeconomics.co.za/)**, a consultancy based in South Africa, uses PyPSA ecosystem tools and PyPSA-Earth for South Africa. Studies published in June 2022 were on [load shedding in 2021](https://meridianeconomics.co.za/wp-content/uploads/2022/06/Resolving-Load-Shedding-Part-A-2021-analysis-01.pdf) and [a plan to resolve load shedding](https://meridianeconomics.co.za/wp-content/uploads/2022/06/Resolving-Load-Shedding-Part-B-The-Game-Plan-01.pdf)

* **[:flag_de: Energynautics GmbH](https://energynautics.com/)**, a grid integration consultancy in Germany, used PyPSA for a study of decentral electricity and heat integration in power grids in a study for the Rhineland-Palatinate state government in 2021: [Pilotprojekt Dezentralisierung: Stärkere Dezentralisierung des bundesdeutschen Strom-Wärme-Systems: Rechtliche und organisatorische Rahmenbedingungen sowie infrastrukturelle Folgen](https://mkuem.rlp.de/fileadmin/mulewf/Themen/Energie_und_Strahlenschutz/Energie/Endbericht_Pilotprojekt_Dezentralisierung_2021_v2.pdf) ([summary in English](https://energynautics.com/en/decentrality-study-for-rhineland-palatinate-completed/))

* **[:flag_nl: Witteveen+Bos](https://www.witteveenbos.com/about-us/)**, a Dutch engineering and consultancy company, used PyPSA in 2022 to consult the Ministry of Economic Affairs and Climate Policy in Netherlands: [Scenario study on nuclear energy](https://eriskgroup.com/wp-content/uploads/2022/10/Scenario-study-nuclear-energy-Conclusions-and-Summary.pdf)

* **[:flag_sa: Saudi Aramco](https://www.aramco.com/)** used PyPSA for an assessment of renewables integration in 2019, see [arXiv:1709.03761](https://arxiv.org/abs/1709.03761).

* **[:flag_gb: Shell](https://www.shell.com/)** uses PyPSA for electricity market simulations in Europe.

* **[:flag_co: ISA](http://www.isa.co/)**, a South American transmission company, uses PyPSA for modelling the Columbian power system in a joint research project with [EIA University](https://www.eia.edu.co/) in Medellin, Columbia.

* **[:flag_de: Energy Consulting Christian Meyer](http://www.energy-consulting-meyer.de/)**

* **[:flag_us: spire](https://www.spireenergy.com/)**


## Governmental Organisation

* **[:globe_with_meridians: International Energy Agency (IEA)](https://www.iea.org/)** uses PyPSA within their [Global Energy and Climate Model](https://www.iea.org/reports/global-energy-and-climate-model). A 2024 report [Managing the Seasonal Variability of Electricity Demand and Supply](https://www.iea.org/reports/managing-the-seasonal-variability-of-electricity-demand-and-supply) used PyPSA to explore how seasonal variations in both demand and supply affect electricity system operations in various world regions in 2050.

* **[:flag_eu: The EU Agency for the Cooperation of Energy Regulators (ACER)](https://www.acer.europa.eu/)** is building a PyPSA solution for the [EU-wide flexibility assessment platform](https://www.acer.europa.eu/sites/default/files/documents/en/The_agency/Organisation/Expert_Groups/EG_Flexibility/Flexibility_EG_Open_Letter_2025.pdf).

* **[:flag_de: GIZ](https://www.giz.de/en/html/index.html)**, the German Agency for International Cooperation (Deutsche Gesellschaft für Internationale Zusammenarbeit), published and supported several studies based on PyPSA for the [integration of renewables into the Vietnamese power system](http://gizenergy.org.vn/media/app/media/Research%20Cooperation%20Project%20Fact%20Sheet_final.pdf), [power sector analysis for Thailand](https://static.agora-energiewende.de/fileadmin/Partnerpublikationen/2021/CASE_Beyond_Net_Zero_Empowering_Climate_Mitigation/Towards_a_collective_vision_of_Thai_energy_transition_full_report.pdf) within the CASE programme, [the future of the Indonesian power system](https://energynautics.com/en/pypsa/) within the 1000 Islands programme, and the [Brazilian electricity system](https://www.energy-proceedings.org/wp-content/uploads/2022/03/Y.Deng_PyPSA-Brazil_ICAE2021_final_revised.pdf).

* **[:flag_ca: Canada Energy Regulator (CER)](https://www.cer-rec.gc.ca/en/)**, an agency of the Government of Canada, used PyPSA for its [Canada's Energy Future 2023 report](https://www.cer-rec.gc.ca/en/data-analysis/canada-energy-future/2023/appendix-3/).

## Non-Governmental and Non-Profit Organisations

* **[:flag_de: Open Energy Transition (OET)](https://openenergytransition.org/)**, a non-profit software company and environmental think tank, uses, develops and provides commercial support and training for PyPSA, see [list of projects](https://openenergytransition.org/projects.html).

* **[:flag_gb: TransitionZero](https://www.transitionzero.org)**, a non-profit climate tech company uses PyPSA for a model of the [ASEAN power grid](https://www.transitionzero.org/products/tz-asean-power-grid-model) and analysis of [24/7 CfE research in Asia](https://www.transitionzero.org/cfe).

* **[:flag_gb: Centre for Net Zero](https://www.centrefornetzero.org/)**, a research unit founded by [Octopus Energy](https://octopus.energy), used PyPSA in a [report](https://www.centrefornetzero.org/work/whole-system-modelling-of-future-energy-scenarios-domestic-gb-demand-flexibility/) to investigate the role of demand flexibility in future UK energy systems.

* **[:flag_gb: Ember](https://ember-climate.org/)**, a UK-based climate NGO, published a study in September 2022 on a [gas phase-out in the UK by 2030](https://ember-climate.org/insights/research/uk-gas-power-phase-out/) based on their open model [PyPSA-UK](https://github.com/ember-climate/pypsa-uk)

* **[:flag_de: Agora Energiewende](https://www.agora-energiewende.de/)**, a think tank and policy institute in Germany, uses PyPSA for energy system integration studies, see for example this study from 2020: [Minimizing the cost of integrating wind and solar power in Japan](https://www.agora-energiewende.de/en/publications/minimizing-the-cost-of-integrating-wind-and-solar-power-in-japan/)

* **[:flag_us: The Rocky Mountain Institute (RMI)](https://rmi.org/)**, a non-profit organization in the United States focused on a zero-carbon future, used PyPSA for analysing the levelised cost of hydrogen in different parts of the world in a study from 2021: [Fueling the Transition: Accelerating Cost-Competitive Green Hydrogen](https://rmi.org/insight/fueling-the-transition-accelerating-cost-competitive-green-hydrogen/)

* **[:flag_de: Climate Analytics](https://climateanalytics.org/)**, a non-profit climate science and policy institute, uses PyPSA for energy system studies, see for example a study on [Employment opportunities from a coal-to-renewables transition in South Korea](https://climateanalytics.org/publications/2021/employment-opportunities-from-a-coal-to-renewables-transition-in-south-korea/) and a [study on the Philippines](https://climateanalytics.org/publications/a-15c-future-is-possible-getting-fossil-fuels-out-of-the-philippine-power-sector).

* **[:flag_pl: Instrat](https://instrat.pl/en/)**, a think-tank focused on public policy in Poland, built PyPSA-PL and published reports in 2021 including [What's next after coal? RES potential in Poland](http://instrat.pl/wp-content/uploads/2021/06/Instrat-What-next-after-coal-v.1.2.pdf) and [Achieving the goal: Coal phase-out in the Polish power sector](https://instrat.pl/en/coal-phase-out/).

* **[:flag_eu:/:flag_us: RAND Europe](https://www.rand.org/randeurope.html)** used PyPSA in a 2024 report [The use of AI for improving energy security](https://www.rand.org/pubs/research_reports/RRA2907-2.html) to explore the extent to which different AI applications can improve energy security in Europe.

* **[:flag_gb: ClimateXChange](https://www.climatexchange.org.uk/)** commissioned a report for the Scottish Government on [Electricity system security of supply in Scotland](https://www.climatexchange.org.uk/projects/electricity-system-security-of-supply-in-scotland/) using PyPSA-GB.
