<!--
SPDX-FileCopyrightText: PyPSA Contributors

SPDX-License-Identifier: CC-BY-4.0
-->

This section provides an overview of PyPSA's, design principles, optimisation
problem formulations, power flow calculation features and usage tips for
specific functions and components.

<div class="grid cards" markdown>

-   :simple-instructure:{ .lg .middle } **Core Design**

    ---

    Description of design choices, conventions and components of PyPSA.

    [:material-notebook: Core Design](../user-guide/design.md)

    ---

-   :material-hub:{ .lg .middle } **Optimisation**

    ---

    Description of optimisation problems that can be solved with PyPSA.

    [:material-notebook: Optimisation](../user-guide/optimization/overview.md)

    ---

-   :material-cog:{ .lg .middle } **Simulation**

    ---

    Description of power flow calculations PyPSA can run on solved networks.

    [:material-notebook: Simulation](../user-guide/power-flow.md)

    ---

-   :material-run:{ .lg .middle } **Usage**

    ---

    Description of useful statistics, plotting and comparison functions.

    [:material-notebook: Usage](../user-guide/statistics.md)

    ---

</div>
