# Generated by Django 5.2 on 2024-11-15 15:48

import django.db.models.deletion
from django.db import migrations, models

import lamindb.base.fields
import lamindb.base.ids
import lamindb.base.users
import lamindb.models


class Migration(migrations.Migration):
    initial = True
    # replaces = [
    #     (
    #         "lamindb",
    #         "0037_rename_dataset_to_collection",
    #     ),
    #     (
    #         "lamindb",
    #         "0038_alter_collection_artifact_alter_collection_artifacts_and_more",
    #     ),
    #     (
    #         "lamindb",
    #         "0039_remove_collection_artifacts_collectionartifact_and_more",
    #     ),
    #     ("lamindb", "0040_alter_transform_type"),
    #     (
    #         "lamindb",
    #         "0041_remove_transform_short_name_transform_description_and_more",
    #     ),
    #     ("lamindb", "0042_rename_run_at_run_started_at_run_finished_at"),
    #     ("lamindb", "0043_run_json"),
    #     ("lamindb", "0044_run_replicated_outputs_transform_ulabels_and_more"),
    #     (
    #         "lamindb",
    #         "0045_rename_replicated_outputs_run_replicated_output_artifacts_and_more",
    #     ),
    #     ("lamindb", "0046_storage_instance_uid"),
    #     ("lamindb", "0047_featurevalue_artifactfeaturevalue_and_more"),
    #     ("lamindb", "0048_alter_artifactulabel_feature_and_more"),
    #     ("lamindb", "0049_rename_type_feature_dtype_and_more"),
    #     ("lamindb", "0050_artifactfeatureset_feature_ref_is_semantic_and_more"),
    #     (
    #         "lamindb",
    #         "0051_remove_feature_feature_sets_featuresetfeature_and_more",
    #     ),
    #     (
    #         "lamindb",
    #         "0052_rename_feature_value_artifactfeaturevalue_featurevalue_and_more",
    #     ),
    #     ("lamindb", "0052_squashed"),
    #     (
    #         "lamindb",
    #         "0053_alter_featureset_hash_alter_paramvalue_created_by_and_more",
    #     ),
    #     ("lamindb", "0054_alter_feature_previous_runs_and_more"),
    #     ("lamindb", "0055_artifact_type_artifactparamvalue_and_more"),
    #     (
    #         "lamindb",
    #         "0056_rename_ulabel_ref_is_name_artifactulabel_label_ref_is_name_and_more",
    #     ),
    #     ("lamindb", "0057_link_models_latest_report_and_others"),
    #     ("lamindb", "0058_artifact__actions_collection__actions"),
    #     (
    #         "lamindb",
    #         "0059_alter_artifact__accessor_alter_artifact__hash_type_and_more",
    #     ),
    #     ("lamindb", "0060_alter_artifact__actions"),
    #     (
    #         "lamindb",
    #         "0061_alter_collection_meta_artifact_alter_run_environment_and_more",
    #     ),
    #     ("lamindb", "0062_add_is_latest_field"),
    #     ("lamindb", "0063_populate_latest_field"),
    #     (
    #         "lamindb",
    #         "0064_alter_artifact_version_alter_collection_version_and_more",
    #     ),
    #     ("lamindb", "0065_remove_collection_feature_sets_and_more"),
    #     ("lamindb", "0066_alter_artifact__feature_values_and_more"),
    #     ("lamindb", "0067_alter_featurevalue_unique_together_and_more"),
    #     ("lamindb", "0068_alter_artifactulabel_unique_together_and_more"),
    #     (
    #         "lamindb",
    #         "0069_alter_artifact__accessor_alter_artifact__hash_type_and_more",
    #     ),
    # ]

    dependencies = []  # type: ignore
    operations = [
        migrations.CreateModel(
            name="Feature",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(auto_now_add=True, db_index=True),
                ),
                (
                    "updated_at",
                    lamindb.base.fields.DateTimeField(auto_now=True, db_index=True),
                ),
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=lamindb.base.ids.base62_12,
                        max_length=12,
                        unique=True,
                    ),
                ),
                (
                    "name",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=150,
                        unique=True,
                    ),
                ),
                (
                    "dtype",
                    lamindb.base.fields.CharField(
                        blank=True, db_index=True, default=None, max_length=64
                    ),
                ),
                (
                    "unit",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "description",
                    lamindb.base.fields.TextField(
                        blank=True, db_index=True, default=None, null=True
                    ),
                ),
                (
                    "synonyms",
                    lamindb.base.fields.TextField(blank=True, default=None, null=True),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(lamindb.models.CanCurate, models.Model),
        ),
        migrations.CreateModel(
            name="FeatureSet",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(auto_now_add=True, db_index=True),
                ),
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=20,
                        unique=True,
                    ),
                ),
                (
                    "name",
                    lamindb.base.fields.CharField(
                        blank=True, default=None, max_length=150, null=True
                    ),
                ),
                ("n", lamindb.base.fields.IntegerField(blank=True)),
                (
                    "dtype",
                    lamindb.base.fields.CharField(
                        blank=True, default=None, max_length=64, null=True
                    ),
                ),
                (
                    "registry",
                    lamindb.base.fields.CharField(
                        blank=True, db_index=True, default=None, max_length=120
                    ),
                ),
                (
                    "hash",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=22,
                        null=True,
                        unique=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Param",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(auto_now_add=True, db_index=True),
                ),
                (
                    "updated_at",
                    lamindb.base.fields.DateTimeField(auto_now=True, db_index=True),
                ),
                (
                    "name",
                    lamindb.base.fields.CharField(
                        blank=True, db_index=True, default=None, max_length=100
                    ),
                ),
                (
                    "dtype",
                    lamindb.base.fields.CharField(
                        blank=True, db_index=True, default=None, max_length=64
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(lamindb.models.CanCurate, models.Model),
        ),
        migrations.CreateModel(
            name="User",
            fields=[
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=8,
                        unique=True,
                    ),
                ),
                (
                    "handle",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=30,
                        unique=True,
                    ),
                ),
                (
                    "name",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=150,
                        null=True,
                    ),
                ),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(auto_now_add=True, db_index=True),
                ),
                (
                    "updated_at",
                    lamindb.base.fields.DateTimeField(auto_now=True, db_index=True),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model, lamindb.models.CanCurate),
        ),
        migrations.CreateModel(
            name="Artifact",
            fields=[
                (
                    "version",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "is_latest",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_index=True, default=True
                    ),
                ),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(auto_now_add=True, db_index=True),
                ),
                (
                    "updated_at",
                    lamindb.base.fields.DateTimeField(auto_now=True, db_index=True),
                ),
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=20,
                        unique=True,
                    ),
                ),
                (
                    "description",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "key",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "suffix",
                    lamindb.base.fields.CharField(
                        blank=True, db_index=True, default=None, max_length=30
                    ),
                ),
                (
                    "type",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=20,
                        null=True,
                    ),
                ),
                (
                    "size",
                    lamindb.base.fields.BigIntegerField(
                        blank=True, db_index=True, null=True
                    ),
                ),
                (
                    "hash",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=22,
                        null=True,
                    ),
                ),
                (
                    "n_objects",
                    lamindb.base.fields.BigIntegerField(
                        blank=True, db_index=True, default=None, null=True
                    ),
                ),
                (
                    "n_observations",
                    lamindb.base.fields.BigIntegerField(
                        blank=True, db_index=True, default=None, null=True
                    ),
                ),
                (
                    "_hash_type",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "_accessor",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=64,
                        null=True,
                    ),
                ),
                (
                    "visibility",
                    models.SmallIntegerField(
                        choices=[(1, "Default"), (0, "Hidden"), (-1, "Trash")],
                        db_index=True,
                        default=1,
                    ),
                ),
                (
                    "_key_is_virtual",
                    lamindb.base.fields.BooleanField(blank=True, default=None),
                ),
                (
                    "_actions",
                    models.ManyToManyField(
                        related_name="_action_targets", to="lamindb.artifact"
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Collection",
            fields=[
                (
                    "version",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "is_latest",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_index=True, default=True
                    ),
                ),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(auto_now_add=True, db_index=True),
                ),
                (
                    "updated_at",
                    lamindb.base.fields.DateTimeField(auto_now=True, db_index=True),
                ),
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=lamindb.base.ids.base62_20,
                        max_length=20,
                        unique=True,
                    ),
                ),
                (
                    "name",
                    lamindb.base.fields.CharField(
                        blank=True, db_index=True, default=None, max_length=150
                    ),
                ),
                (
                    "description",
                    lamindb.base.fields.TextField(blank=True, default=None, null=True),
                ),
                (
                    "hash",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=22,
                        null=True,
                    ),
                ),
                (
                    "reference",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "reference_type",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=25,
                        null=True,
                    ),
                ),
                (
                    "visibility",
                    models.SmallIntegerField(
                        choices=[(1, "Default"), (0, "Hidden"), (-1, "Trash")],
                        db_index=True,
                        default=1,
                    ),
                ),
                (
                    "_actions",
                    models.ManyToManyField(related_name="+", to="lamindb.artifact"),
                ),
                (
                    "meta_artifact",
                    lamindb.base.fields.OneToOneField(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="_meta_of_collection",
                        to="lamindb.artifact",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="CollectionArtifact",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(auto_now_add=True, db_index=True),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "artifact",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_collection",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "collection",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_artifact",
                        to="lamindb.collection",
                    ),
                ),
            ],
            bases=(lamindb.models.IsLink, models.Model),
        ),
        migrations.AddField(
            model_name="collection",
            name="artifacts",
            field=models.ManyToManyField(
                related_name="collections",
                through="lamindb.CollectionArtifact",
                to="lamindb.artifact",
            ),
        ),
        migrations.CreateModel(
            name="ArtifactFeatureSet",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(auto_now_add=True, db_index=True),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "slot",
                    lamindb.base.fields.CharField(
                        blank=True, default=None, max_length=40, null=True
                    ),
                ),
                (
                    "feature_ref_is_semantic",
                    lamindb.base.fields.BooleanField(
                        blank=True, default=None, null=True
                    ),
                ),
                (
                    "artifact",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_feature_set",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "featureset",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifact",
                        to="lamindb.featureset",
                    ),
                ),
            ],
            bases=(lamindb.models.IsLink, models.Model),
        ),
        migrations.AddField(
            model_name="artifact",
            name="feature_sets",
            field=models.ManyToManyField(
                related_name="artifacts",
                through="lamindb.ArtifactFeatureSet",
                to="lamindb.featureset",
            ),
        ),
        migrations.CreateModel(
            name="FeatureSetFeature",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "featureset",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="lamindb.featureset",
                    ),
                ),
            ],
            options={
                "unique_together": {("featureset", "feature")},
            },
            bases=(models.Model, lamindb.models.IsLink),
        ),
        migrations.AddField(
            model_name="feature",
            name="feature_sets",
            field=models.ManyToManyField(
                related_name="features",
                through="lamindb.FeatureSetFeature",
                to="lamindb.featureset",
            ),
        ),
        migrations.CreateModel(
            name="FeatureValue",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(auto_now_add=True, db_index=True),
                ),
                ("value", models.JSONField()),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="values",
                        to="lamindb.feature",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ArtifactFeatureValue",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(auto_now_add=True, db_index=True),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "artifact",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "featurevalue",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.featurevalue",
                    ),
                ),
            ],
            bases=(lamindb.models.IsLink, models.Model),
        ),
        migrations.AddField(
            model_name="artifact",
            name="_feature_values",
            field=models.ManyToManyField(
                related_name="artifacts",
                through="lamindb.ArtifactFeatureValue",
                to="lamindb.featurevalue",
            ),
        ),
        migrations.CreateModel(
            name="ParamValue",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("value", models.JSONField()),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(auto_now_add=True, db_index=True),
                ),
                (
                    "param",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="values",
                        to="lamindb.param",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ArtifactParamValue",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "artifact",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "paramvalue",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.paramvalue",
                    ),
                ),
            ],
            options={
                "unique_together": {("artifact", "paramvalue")},
            },
            bases=(models.Model, lamindb.models.IsLink),
        ),
        migrations.AddField(
            model_name="artifact",
            name="_param_values",
            field=models.ManyToManyField(
                related_name="artifacts",
                through="lamindb.ArtifactParamValue",
                to="lamindb.paramvalue",
            ),
        ),
        migrations.CreateModel(
            name="Run",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=lamindb.base.ids.base62_20,
                        max_length=20,
                        unique=True,
                    ),
                ),
                (
                    "started_at",
                    lamindb.base.fields.DateTimeField(auto_now_add=True, db_index=True),
                ),
                (
                    "finished_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True, db_index=True, default=None, null=True
                    ),
                ),
                (
                    "is_consecutive",
                    lamindb.base.fields.BooleanField(
                        blank=True, default=None, null=True
                    ),
                ),
                (
                    "reference",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "reference_type",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=25,
                        null=True,
                    ),
                ),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(auto_now_add=True, db_index=True),
                ),
                (
                    "environment",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="_environment_of",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "parent",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="children",
                        to="lamindb.run",
                    ),
                ),
                (
                    "report",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="_report_of",
                        to="lamindb.artifact",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="param",
            name="_previous_runs",
            field=models.ManyToManyField(related_name="+", to="lamindb.run"),
        ),
        migrations.AddField(
            model_name="param",
            name="run",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.models.current_run,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.run",
            ),
        ),
        migrations.AddField(
            model_name="featurevalue",
            name="run",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.models.current_run,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.run",
            ),
        ),
        migrations.AddField(
            model_name="featureset",
            name="run",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.models.current_run,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.run",
            ),
        ),
        migrations.AddField(
            model_name="feature",
            name="_previous_runs",
            field=models.ManyToManyField(related_name="+", to="lamindb.run"),
        ),
        migrations.AddField(
            model_name="feature",
            name="run",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.models.current_run,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.run",
            ),
        ),
        migrations.AddField(
            model_name="collectionartifact",
            name="run",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.models.current_run,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.run",
            ),
        ),
        migrations.AddField(
            model_name="collection",
            name="_previous_runs",
            field=models.ManyToManyField(
                related_name="_output_collections_with_later_updates",
                to="lamindb.run",
            ),
        ),
        migrations.AddField(
            model_name="collection",
            name="input_of_runs",
            field=models.ManyToManyField(
                related_name="input_collections", to="lamindb.run"
            ),
        ),
        migrations.AddField(
            model_name="collection",
            name="run",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=None,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="output_collections",
                to="lamindb.run",
            ),
        ),
        migrations.AddField(
            model_name="artifactfeaturevalue",
            name="run",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.models.current_run,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.run",
            ),
        ),
        migrations.AddField(
            model_name="artifactfeatureset",
            name="run",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.models.current_run,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.run",
            ),
        ),
        migrations.AddField(
            model_name="artifact",
            name="_previous_runs",
            field=models.ManyToManyField(
                related_name="_output_artifacts_with_later_updates",
                to="lamindb.run",
            ),
        ),
        migrations.AddField(
            model_name="artifact",
            name="input_of_runs",
            field=models.ManyToManyField(
                related_name="input_artifacts", to="lamindb.run"
            ),
        ),
        migrations.AddField(
            model_name="artifact",
            name="run",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=None,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="output_artifacts",
                to="lamindb.run",
            ),
        ),
        migrations.CreateModel(
            name="RunParamValue",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "paramvalue",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.paramvalue",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
            ],
            options={
                "unique_together": {("run", "paramvalue")},
            },
            bases=(models.Model, lamindb.models.IsLink),
        ),
        migrations.AddField(
            model_name="run",
            name="_param_values",
            field=models.ManyToManyField(
                related_name="runs",
                through="lamindb.RunParamValue",
                to="lamindb.paramvalue",
            ),
        ),
        migrations.CreateModel(
            name="Storage",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(auto_now_add=True, db_index=True),
                ),
                (
                    "updated_at",
                    lamindb.base.fields.DateTimeField(auto_now=True, db_index=True),
                ),
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=lamindb.base.ids.base62_12,
                        max_length=12,
                        unique=True,
                    ),
                ),
                (
                    "root",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=255,
                        unique=True,
                    ),
                ),
                (
                    "description",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "type",
                    lamindb.base.fields.CharField(
                        blank=True, db_index=True, default=None, max_length=30
                    ),
                ),
                (
                    "region",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=64,
                        null=True,
                    ),
                ),
                (
                    "instance_uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=12,
                        null=True,
                    ),
                ),
                (
                    "_previous_runs",
                    models.ManyToManyField(related_name="+", to="lamindb.run"),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="artifact",
            name="storage",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="artifacts",
                to="lamindb.storage",
            ),
        ),
        migrations.CreateModel(
            name="Transform",
            fields=[
                (
                    "version",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "is_latest",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_index=True, default=True
                    ),
                ),
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=16,
                        unique=True,
                    ),
                ),
                (
                    "name",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=150,
                        null=True,
                    ),
                ),
                (
                    "key",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=120,
                        null=True,
                    ),
                ),
                (
                    "description",
                    lamindb.base.fields.CharField(
                        blank=True, default=None, max_length=255, null=True
                    ),
                ),
                (
                    "type",
                    lamindb.base.fields.CharField(
                        blank=True, db_index=True, default="pipeline", max_length=20
                    ),
                ),
                (
                    "source_code",
                    lamindb.base.fields.TextField(blank=True, default=None, null=True),
                ),
                (
                    "hash",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=22,
                        null=True,
                    ),
                ),
                (
                    "reference",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "reference_type",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=25,
                        null=True,
                    ),
                ),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(auto_now_add=True, db_index=True),
                ),
                (
                    "updated_at",
                    lamindb.base.fields.DateTimeField(auto_now=True, db_index=True),
                ),
                (
                    "_source_code_artifact",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="_source_code_of",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "predecessors",
                    models.ManyToManyField(
                        related_name="successors", to="lamindb.transform"
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="run",
            name="transform",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="runs",
                to="lamindb.transform",
            ),
        ),
        migrations.AddField(
            model_name="collection",
            name="transform",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=None,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="output_collections",
                to="lamindb.transform",
            ),
        ),
        migrations.AddField(
            model_name="artifact",
            name="transform",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=None,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="output_artifacts",
                to="lamindb.transform",
            ),
        ),
        migrations.CreateModel(
            name="ULabel",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(auto_now_add=True, db_index=True),
                ),
                (
                    "updated_at",
                    lamindb.base.fields.DateTimeField(auto_now=True, db_index=True),
                ),
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=lamindb.base.ids.base62_8,
                        max_length=8,
                        unique=True,
                    ),
                ),
                (
                    "name",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=150,
                        unique=True,
                    ),
                ),
                (
                    "description",
                    lamindb.base.fields.TextField(blank=True, default=None, null=True),
                ),
                (
                    "reference",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "reference_type",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=25,
                        null=True,
                    ),
                ),
                (
                    "_previous_runs",
                    models.ManyToManyField(related_name="+", to="lamindb.run"),
                ),
                (
                    "parents",
                    models.ManyToManyField(
                        related_name="children", to="lamindb.ulabel"
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(
                lamindb.models.HasParents,
                lamindb.models.CanCurate,
                models.Model,
            ),
        ),
        migrations.AddField(
            model_name="transform",
            name="ulabels",
            field=models.ManyToManyField(
                related_name="transforms", to="lamindb.ulabel"
            ),
        ),
        migrations.CreateModel(
            name="CollectionULabel",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(auto_now_add=True, db_index=True),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "label_ref_is_name",
                    lamindb.base.fields.BooleanField(
                        blank=True, default=None, null=True
                    ),
                ),
                (
                    "feature_ref_is_name",
                    lamindb.base.fields.BooleanField(
                        blank=True, default=None, null=True
                    ),
                ),
                (
                    "collection",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_ulabel",
                        to="lamindb.collection",
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_collectionulabel",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "ulabel",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_collection",
                        to="lamindb.ulabel",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
            ],
            options={
                "unique_together": {("collection", "ulabel")},
            },
            bases=(lamindb.models.IsLink, models.Model),
        ),
        migrations.AddField(
            model_name="collection",
            name="ulabels",
            field=models.ManyToManyField(
                related_name="collections",
                through="lamindb.CollectionULabel",
                to="lamindb.ulabel",
            ),
        ),
        migrations.CreateModel(
            name="ArtifactULabel",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(auto_now_add=True, db_index=True),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "label_ref_is_name",
                    lamindb.base.fields.BooleanField(
                        blank=True, default=None, null=True
                    ),
                ),
                (
                    "feature_ref_is_name",
                    lamindb.base.fields.BooleanField(
                        blank=True, default=None, null=True
                    ),
                ),
                (
                    "artifact",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_ulabel",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifactulabel",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "ulabel",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifact",
                        to="lamindb.ulabel",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
            ],
            options={
                "unique_together": {("artifact", "ulabel", "feature")},
            },
            bases=(lamindb.models.IsLink, models.Model),
        ),
        migrations.AddField(
            model_name="artifact",
            name="ulabels",
            field=models.ManyToManyField(
                related_name="artifacts",
                through="lamindb.ArtifactULabel",
                to="lamindb.ulabel",
            ),
        ),
        migrations.AddField(
            model_name="transform",
            name="created_by",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.base.users.current_user_id,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="created_transforms",
                to="lamindb.user",
            ),
        ),
        migrations.AddField(
            model_name="run",
            name="created_by",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.base.users.current_user_id,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="created_runs",
                to="lamindb.user",
            ),
        ),
        migrations.AddField(
            model_name="param",
            name="created_by",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.base.users.current_user_id,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.user",
            ),
        ),
        migrations.AddField(
            model_name="featurevalue",
            name="created_by",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.base.users.current_user_id,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.user",
            ),
        ),
        migrations.AddField(
            model_name="featureset",
            name="created_by",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.base.users.current_user_id,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.user",
            ),
        ),
        migrations.AddField(
            model_name="feature",
            name="created_by",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.base.users.current_user_id,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.user",
            ),
        ),
        migrations.AddField(
            model_name="collectionartifact",
            name="created_by",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.base.users.current_user_id,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.user",
            ),
        ),
        migrations.AddField(
            model_name="collection",
            name="created_by",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.base.users.current_user_id,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.user",
            ),
        ),
        migrations.AddField(
            model_name="artifactfeaturevalue",
            name="created_by",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.base.users.current_user_id,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.user",
            ),
        ),
        migrations.AddField(
            model_name="artifactfeatureset",
            name="created_by",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.base.users.current_user_id,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.user",
            ),
        ),
        migrations.AddField(
            model_name="artifact",
            name="created_by",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.base.users.current_user_id,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="created_artifacts",
                to="lamindb.user",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="collectionartifact",
            unique_together={("collection", "artifact")},
        ),
        migrations.AlterUniqueTogether(
            name="artifactfeaturevalue",
            unique_together={("artifact", "featurevalue")},
        ),
        migrations.AlterUniqueTogether(
            name="artifactfeatureset",
            unique_together={("artifact", "featureset")},
        ),
    ]
